BEGIN;
CREATE TABLE "roads" (gid serial, "length" float8, "acad_layer" varchar, "dwg_name" varchar, "l_f_add" int4, "l_t_add" int4, "r_f_add" int4, "r_t_add" int4, "name" varchar, "type" varchar, "suffix" varchar, "fraddl" int8, "fraddr" int8, "toaddl" int8, "toaddr" int8, "even" varchar, "sourcethm" varchar, "miles" float8, "speedlimit" int8, "minutes" float8, "lot_width" float8, "direction" varchar, "namedd" int4, "pre_dir" varchar, "pre_type" varchar, "street_nam" varchar, "street_typ" varchar, "suf_dir" varchar);
SELECT AddGeometryColumn('','roads','the_geom','-1','MULTILINESTRING',2);
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('0','1818.483662','ROAD3','PL1997','1043','1375','1042','1374','B H DUNCAN RD',NULL,NULL,'1043','1042','1375','1374','Right','roadswest.dbf','0.34','40','0.5100','10.9548',NULL,'1',NULL,NULL,'B H DUNCAN','RD',NULL,'01050000000100000001020000002600000000000000804F324100000040DFA22D41000000007F4F324100000000E2A22D41000000A0554F32410000000036A32D41000000402A4F3241000000C086A32D41000000400D4F3241000000A0CCA32D4100000000EF4E3241000000200FA42D4100000020BC4E3241000000E058A42D4100000020844E32410000004093A42D4100000080624E324100000080AEA42D4100000040404E3241000000C0C6A42D41000000000D4E3241000000A0DDA42D4100000080DF4D3241000000A003A52D41000000C0CC4D3241000000C02FA52D4100000080BD4D32410000000063A52D4100000020AE4D324100000040B4A52D4100000040A44D3241000000E009A62D41000000C09C4D32410000004070A62D4100000060984D3241000000C0D7A62D4100000040964D3241000000C021A72D41000000A0934D3241000000806BA72D41000000408D4D324100000020DDA72D41000000E07E4D32410000006049A82D41000000A0664D32410000000096A82D41000000E04A4D324100000020E0A82D4100000020304D3241000000A039A92D4100000020154D32410000000093A92D4100000020F54C324100000020E9A92D4100000020D64C32410000004040AA2D41000000E0BC4C3241000000A0A4AA2D41000000A0A54C3241000000600BAB2D41000000A0914C3241000000C065AB2D41000000807A4C324100000000BCAB2D41000000605A4C3241000000C005AC2D4100000040384C3241000000204DAC2D41000000E00B4C324100000000C0AC2D41000000A0E44B3241000000003AAD2D4100000060CB4B3241000000409FAD2D41000000E0B34B3241000000A006AE2D41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('1','5390.735646','ROAD3','PL1997','2519','3527','2518','3526','WEST BRUSHY FORK RD',NULL,NULL,'2519','2518','3527','3526','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('2','3774.449166','ROAD3','PL1997','1813','2517','1812','2516','WEST BRUSHY FORK RD',NULL,NULL,'1813','1812','2517','2516','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('3','2216.209808','ROAD4','PL1997','0','0','0','0',NULL,NULL,NULL,'0','0','0','0','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('4','806.671726','ROAD4','PL1997','0','0','0','0',NULL,NULL,NULL,'0','0','0','0','Right','roadswest.dbf','0.15','40','0.2250','0',NULL,'0',NULL,NULL,NULL,NULL,NULL,'01050000000100000001020000001C000000000000C0F24932410000000040E82D4100000080F3493241000000603EE82D4100000060054A3241000000001BE82D41000000A0184A3241000000A0FAE72D4100000060314A3241000000A0DCE72D41000000204A4A3241000000A0BEE72D41000000605F4A3241000000609AE72D41000000A0734A32410000006073E72D41000000208D4A3241000000A03CE72D41000000A0A64A32410000000006E72D41000000A0B44A3241000000C0EBE62D41000000E0C24A324100000000D2E62D4100000060D54A324100000040B4E62D41000000E0E64A3241000000C094E62D41000000C0FB4A3241000000A04DE62D41000000C00C4B32410000000000E62D41000000201A4B3241000000A0CAE52D41000000E0274B32410000008095E52D4100000000374B32410000002062E52D41000000C0454B3241000000802EE52D4100000060584B324100000080E6E42D4100000000674B3241000000809BE42D41000000406B4B3241000000C06EE42D41000000606F4B3241000000C041E42D41000000807E4B3241000000E0EBE32D4100000080914B32410000008098E32D41000000A09E4B32410000006062E32D4100000020AC4B3241000000802CE32D41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('5','2083.139582','ROAD3','PL1998','1059','1457','1058','1456','BALDWIN GAP RD',NULL,NULL,'1059','1058','1457','1456','Right','roadswest.dbf','0.39','40','0.5850','10.4680',NULL,'1',NULL,NULL,'BALDWIN GAP','RD',NULL,'01050000000100000001020000003600000000000000804F3241000000801E002E4100000060734F3241000000804A002E4100000040624F3241000000409D002E4100000000564F3241000000A0DF002E41000000004D4F3241000000C022012E41000000A0484F3241000000807B012E4100000060484F324100000040D6012E41000000204B4F3241000000C045022E41000000204D4F3241000000A0B6022E4100000020494F3241000000200F032E4100000040444F3241000000C065032E4100000060414F324100000000DB042E41000000404C4F32410000004051062E4100000040504F324100000060B9062E41000000E0544F3241000000A021072E41000000C0564F32410000002045072E4100000060584F32410000000069072E41000000C0594F3241000000609E072E41000000605A4F324100000040D3072E41000000405B4F324100000060F4072E41000000C05A4F3241000000E016082E4100000040574F3241000000C037082E41000000E0504F32410000002057082E4100000060454F32410000008076082E4100000080364F32410000006090082E4100000000224F3241000000A0A2082E41000000A00D4F324100000040AF082E4100000040F84E324100000020C1082E4100000000E24E324100000040D2082E41000000C0CD4E3241000000C0DE082E4100000020B94E3241000000A0E8082E4100000000A84E324100000040ED082E41000000A0974E3241000000C0F1082E4100000040884E324100000080F9082E41000000E0774E32410000008002092E41000000C0564E3241000000A00A092E41000000C03A4E3241000000201B092E41000000E0244E3241000000E046092E4100000080074E3241000000E071092E41000000E0E94D32410000000099092E41000000C0C84D3241000000A0CA092E4100000060A74D3241000000A0FC092E41000000A0704D324100000000490A2E4100000020384D324100000040900A2E41000000801F4D324100000060AB0A2E4100000040074D3241000000C0C50A2E4100000060E44C3241000000E0F10A2E4100000000C04C3241000000C01B0B2E41000000E0A74C3241000000802F0B2E4100000000904C324100000060410B2E41000000E0534C324100000020730B2E41000000A0174C324100000020A50B2E4100000060ED4B324100000080C60B2E4100000040D14B3241000000E0DB0B2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('6','3743.029813','ROAD4','PL1998','0','0','0','0',NULL,NULL,NULL,'0','0','0','0','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('7','3033.322227','ROAD3','PL2000','101','725','100','724','RASH SCHOOL RD',NULL,NULL,'101','100','725','724','Right','roadswest.dbf','0.57','40','0.8550','9.7222',NULL,'1',NULL,NULL,'RASH SCHOOL','RD',NULL,'010500000001000000010200000064000000000000C03C6D3241000000C017CA2E4100000060526D324100000060C7C92E41000000205E6D324100000040ADC92E41000000A06A6D3241000000A092C92E41000000C07A6D32410000004076C92E41000000807E6D3241000000A04BC92E4100000000786D3241000000602EC92E4100000080636D32410000000003C92E4100000000506D3241000000C0DEC82E41000000C03B6D3241000000C0BBC82E4100000020256D3241000000C095C82E41000000400E6D3241000000C06FC82E4100000040F76C3241000000C048C82E4100000060E06C32410000000021C82E41000000E0CA6C3241000000A0F8C72E41000000E0B56C3241000000A0CEC72E4100000040996C3241000000A08FC72E41000000607D6C3241000000604FC72E41000000E0606C3241000000600FC72E4100000060446C324100000060CFC62E41000000202A6C3241000000C094C62E41000000C00F6C3241000000C059C62E4100000080F46B32410000006018C62E41000000A0D86B3241000000C0D9C52E4100000060C86B3241000000A0BCC52E41000000E0B76B3241000000A09CC52E41000000C0AA6B3241000000A078C52E41000000A09F6B3241000000C052C52E4100000020956B3241000000A024C52E41000000208C6B3241000000C0F5C42E4100000060866B3241000000A0D5C42E4100000040806B3241000000C0B7C42E4100000060756B3241000000C097C42E4100000060686B32410000004079C42E4100000000576B32410000006055C42E41000000E0446B32410000004031C42E4100000040366B32410000004010C42E41000000A0286B324100000040EDC32E41000000401C6B324100000040C3C32E4100000000126B32410000000097C32E4100000060096B3241000000A064C32E4100000000026B3241000000C031C32E4100000040FC6A3241000000C008C32E4100000040F56A3241000000A0E2C22E4100000060ED6A3241000000A0C7C22E4100000000E46A324100000040AEC22E4100000060D46A3241000000608EC22E4100000020C36A3241000000A06FC22E4100000060B46A3241000000A042C22E4100000080A76A3241000000A017C22E4100000080996A324100000060DFC12E41000000C08D6A324100000040A5C12E41000000C0826A3241000000A055C12E41000000A07B6A32410000006004C12E41000000E0776A3241000000A0B7C02E41000000A0766A3241000000A06AC02E4100000080766A32410000000031C02E4100000020786A324100000060F7BF2E41000000407D6A324100000040AFBF2E4100000000866A32410000000068BF2E4100000060926A32410000004027BF2E41000000A0A06A3241000000C0E8BE2E41000000C0B16A3241000000A0A1BE2E41000000A0C36A3241000000405BBE2E41000000C0CD6A32410000004036BE2E41000000E0D66A3241000000C011BE2E4100000080E06A324100000040DABD2E4100000080E66A324100000040A1BD2E4100000080E76A3241000000A059BD2E41000000E0E46A3241000000A00FBD2E41000000C0E36A3241000000A0D1BC2E4100000040DF6A32410000006098BC2E41000000A0D46A3241000000606EBC2E4100000000C86A32410000004041BC2E41000000C0BD6A32410000006006BC2E4100000020B66A3241000000A0CABB2E41000000A0B06A3241000000A08EBB2E41000000C0AC6A3241000000C051BB2E4100000040AA6A3241000000C007BB2E4100000040A86A324100000040BEBA2E41000000C0A46A3241000000C074BA2E4100000040A06A3241000000002CBA2E41000000E0996A324100000040ECB92E4100000080956A324100000040AAB92E41000000C0976A32410000004071B92E41000000809D6A3241000000A039B92E4100000000A76A3241000000C003B92E4100000080B06A3241000000A0D0B82E41000000E0B66A3241000000C08CB82E4100000080BB6A3241000000A046B82E41000000C0C26A3241000000C0E1B72E41000000E0C96A3241000000007DB72E4100000060CF6A32410000004033B72E4100000000D56A324100000060E9B62E4100000080DA6A3241000000609AB62E4100000000E16A3241000000004BB62E4100000040ED6A324100000040EBB52E4100000040FA6A3241000000008DB52E41000000C0006B32410000004042B52E4100000060066B32410000000018B52E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('8','1056.584743','ROAD3','PL2000','7837','8039','7836','8038','BIG LAUREL RD',NULL,NULL,'7837','7836','8039','8038','Right','roadswest.dbf','0.20','40','0.3000','10.4612',NULL,'1',NULL,NULL,'BIG LAUREL','RD',NULL,'010500000001000000010200000020000000000000C03C6D3241000000C017CA2E41000000601D6D324100000040F5C92E41000000A0FE6C324100000060CFC92E4100000040DB6C3241000000A09AC92E4100000040B96C3241000000A063C92E41000000A0976C3241000000602EC92E41000000A0756C324100000040FAC82E4100000020546C324100000060CAC82E4100000020326C3241000000409BC82E4100000080166C32410000006072C82E4100000000FB6B3241000000004EC82E41000000A0DA6B32410000006030C82E4100000000B86B32410000006015C82E41000000A0986B3241000000A0F8C72E41000000407A6B324100000000E2C72E41000000A05E6B3241000000A0DAC72E41000000E0406B324100000040D6C72E41000000001F6B324100000040CCC72E4100000020FE6A324100000040C5C72E41000000C0E26A3241000000C0C5C72E4100000060C66A3241000000A0C8C72E4100000080A46A324100000060CBC72E4100000080836A324100000040D1C72E4100000080656A324100000040DDC72E4100000080466A324100000060EBC72E41000000602E6A3241000000C0F3C72E4100000000176A324100000060FCC72E41000000A0F0693241000000C00FC82E4100000080C96932410000000024C82E4100000060AE693241000000602FC82E41000000A093693241000000C039C82E4100000020786932410000004045C82E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('9','1916.236363','ROAD3','PL2000','7469','7835','7468','7834','BIG LAUREL RD',NULL,NULL,'7469','7468','7835','7834','Right','roadswest.dbf','0.36','40','0.5400','10.4712',NULL,'1',NULL,NULL,'BIG LAUREL','RD',NULL,'01050000000100000001020000002A0000000000004088743241000000A027CC2E41000000E070743241000000C033CC2E410000002021743241000000C05DCC2E4100000020ED733241000000A07ACC2E41000000C0B77332410000006091CC2E41000000609B733241000000C095CC2E41000000E07F7332410000000099CC2E41000000C05C73324100000040A0CC2E41000000E038733241000000A0A8CC2E41000000201373324100000040AACC2E41000000C0ED72324100000040AACC2E41000000C0ED72324100000040AACC2E4100000000C3723241000000A0A6CC2E410000002098723241000000609ECC2E41000000406F723241000000A08FCC2E410000002047723241000000407FCC2E410000008012723241000000006ECC2E4100000060DD713241000000C05BCC2E4100000000A4713241000000A042CC2E41000000006B713241000000A026CC2E41000000803B713241000000400DCC2E41000000800C713241000000C0F4CB2E4100000020C770324100000000DACB2E410000002081703241000000C0C0CB2E41000000804870324100000060A8CB2E410000002010703241000000A08ECB2E41000000E0DC6F3241000000A074CB2E41000000E0A96F3241000000405BCB2E41000000A0786F3241000000C045CB2E4100000020476F32410000004032CB2E41000000601E6F32410000004024CB2E4100000000F56E3241000000C014CB2E4100000000CA6E324100000000FDCA2E4100000040A06E3241000000C0E6CA2E4100000080726E324100000060DBCA2E4100000040436E3241000000A0CFCA2E41000000C0106E3241000000C0B4CA2E41000000C0DF6D32410000004096CA2E4100000040B56D3241000000407ECA2E41000000A08A6D32410000006062CA2E4100000000636D3241000000403FCA2E41000000C03C6D3241000000C017CA2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('10','535.640342','ROAD3','PL2000','7371','7471','7370','7470','BIG LAUREL RD',NULL,NULL,'7371','7370','7471','7470','Right','roadswest.dbf','0.10','40','0.1500','10.7128',NULL,'1',NULL,NULL,'BIG LAUREL','RD',NULL,'01050000000100000001020000000800000000000000907632410000004025CB2E4100000080347632410000006058CB2E4100000080DD7532410000004084CB2E4100000080A175324100000040A0CB2E410000008065753241000000A0BBCB2E41000000001375324100000000E2CB2E41000000C0C0743241000000C009CC2E410000004088743241000000A027CC2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('11','1003.367834','ROAD3','PL2000','101','285','100','284','SOUTH FLATWOODS RD',NULL,NULL,'101','100','285','284','Right','roadswest.dbf','0.19','40','0.2850','10.9062',NULL,'1','S',NULL,'FLATWOODS','RD',NULL,'0105000000010000000102000000290000000000004088743241000000A027CC2E41000000A08B743241000000404DCC2E4100000040907432410000004072CC2E4100000080967432410000004096CC2E41000000C09A74324100000040C3CC2E41000000C09E74324100000000F0CC2E41000000C0A17432410000000013CD2E4100000040A37432410000004051CD2E41000000E0A1743241000000406FCD2E41000000E09E743241000000A0A8CD2E41000000C09874324100000000DECD2E41000000608C7432410000004013CE2E4100000060827432410000006032CE2E41000000E06B743241000000605ECE2E4100000020517432410000004084CE2E410000004036743241000000A0A2CE2E41000000001A743241000000A0BECE2E41000000C0F4733241000000A0E0CE2E4100000080CF7332410000000005CF2E4100000000B2733241000000A026CF2E410000008096733241000000A04ECF2E410000004085733241000000606FCF2E41000000A076733241000000A096CF2E41000000C06E733241000000A0C3CF2E41000000806A73324100000040F1CF2E410000006068733241000000C028D02E41000000C066733241000000605ED02E410000004062733241000000A094D02E41000000205B73324100000000C9D02E41000000405573324100000040E4D02E41000000C04E7332410000006002D12E4100000020487332410000004032D12E41000000E0447332410000006063D12E4100000000457332410000000085D12E41000000E04673324100000000A6D12E41000000404C73324100000040D3D12E41000000405473324100000060FFD12E410000000060733241000000602AD22E41000000806B7332410000004052D22E4100000060747332410000000079D22E41000000207C73324100000000A0D22E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('12','983.355064','ROAD3','PL2000','4871','5055','4870','5054','LITTLE LAUREL RD',NULL,NULL,'4871','4870','5055','5054','Right','roadswest.dbf','0.19','40','0.2850','10.6886',NULL,'1',NULL,NULL,'LITTLE LAUREL','RD',NULL,'01050000000100000001020000002D000000000000405D6F32410000000080842E41000000604F6F3241000000609F842E41000000E03F6F324100000040CB842E4100000000336F3241000000A0E2842E4100000040236F324100000060F3842E4100000040126F324100000060F5842E4100000040126F324100000060F5842E41000000E0016F324100000040F0842E41000000C0EE6E324100000040E4842E41000000A0DC6E324100000040D6842E41000000A0C46E3241000000C0C7842E41000000C0AC6E3241000000A0BF842E4100000060996E3241000000A0C1842E41000000C0856E3241000000C0C8842E41000000C0766E324100000040D2842E4100000040676E324100000000DD842E41000000E0536E324100000040E8842E4100000080406E3241000000C0F2842E41000000E0276E324100000040FE842E4100000000106E3241000000C00A852E4100000000F86D3241000000401B852E4100000040E26D3241000000C030852E4100000020D26D3241000000A04C852E4100000080C16D3241000000A06C852E4100000080A66D3241000000C094852E41000000008C6D324100000040BB852E4100000060706D3241000000C0EB852E41000000A0536D3241000000A01B862E41000000E0366D3241000000A045862E41000000A0166D32410000004062862E41000000A0056D3241000000A066862E41000000A0056D3241000000A066862E4100000080E76C32410000004059862E4100000040DB6C32410000000048862E4100000040D16C3241000000A01D862E41000000C0CD6C3241000000A0EF852E4100000040CB6C3241000000A0BF852E4100000020CF6C3241000000A082852E4100000000D86C3241000000C05C852E4100000080E36C3241000000003A852E4100000000F16C32410000004018852E4100000020FD6C3241000000C0F7842E4100000080056D3241000000C0D5842E41000000C00A6D3241000000A0B2842E41000000600A6D32410000000080842E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('13','1180.830131','ROAD3','PL2001','287','505','286','504','SOUTH FLATWOODS RD',NULL,NULL,'287','286','505','504','Right','roadswest.dbf','0.22','40','0.3300','10.8334',NULL,'1','S',NULL,'FLATWOODS','RD',NULL,'01050000000100000001020000002A000000000000207C73324100000000A0D22E41000000C08C733241000000407CD32E41000000C0957332410000004062D42E41000000009C733241000000C0A8D42E41000000C0A6733241000000A0ECD42E4100000040B07332410000004011D52E4100000020BF733241000000C030D52E41000000A0D7733241000000403BD52E4100000060E87332410000004040D52E41000000E0F97332410000004044D52E4100000000137432410000000046D52E410000002028743241000000404DD52E410000004036743241000000A05ED52E41000000E044743241000000A077D52E410000006059743241000000409ED52E41000000A06B74324100000040C8D52E41000000A07C74324100000000FAD52E41000000808B743241000000C02FD62E410000006095743241000000C055D62E41000000A09B743241000000C078D62E41000000209A743241000000A0AFD62E41000000C09274324100000040ECD62E41000000208B743241000000A028D72E41000000E0837432410000000066D72E41000000E080743241000000C08DD72E41000000207F74324100000040B6D72E41000000607F74324100000040E7D72E41000000A0827432410000000018D82E41000000E0867432410000004038D82E41000000C08F743241000000C068D82E41000000A09B7432410000000098D82E4100000000AD743241000000C0C5D82E4100000060BF74324100000000F0D82E41000000A0CE743241000000A012D92E4100000080DC743241000000A035D92E4100000040E8743241000000A05BD92E4100000040F17432410000004083D92E41000000E0F574324100000040AED92E4100000020F974324100000040DDD92E41000000A0F9743241000000C002DA2E41000000E0F8743241000000C034DA2E4100000040F6743241000000A068DA2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('14','903.182104','ROAD3','PL2001','101','267','100','266','NORTH FLATWOODS RD',NULL,NULL,'101','100','267','266','Right','roadswest.dbf','0.17','40','0.2550','10.8818',NULL,'1','N',NULL,'FLATWOODS','RD',NULL,'01050000000100000001020000001500000000000040F6743241000000A068DA2E4100000020F1743241000000608ADA2E41000000C0EA743241000000C0ABDA2E4100000020E974324100000000D2DA2E4100000000E774324100000060F6DA2E4100000040DC7432410000004047DB2E41000000A0CF743241000000A09ADB2E4100000060C9743241000000A0DFDB2E4100000080C27432410000004021DC2E4100000080B67432410000000065DC2E41000000E0A7743241000000A0A7DC2E41000000C09274324100000060F8DC2E41000000807B743241000000A047DD2E41000000C062743241000000C097DD2E410000004049743241000000C0E7DD2E410000006029743241000000A050DE2E41000000800874324100000040B6DE2E4100000000DC7332410000004028DF2E4100000020AD7332410000004098DF2E41000000207D733241000000400DE02E41000000604D733241000000C080E02E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('15','606.572170','ROAD3','PL2001','101','213','100','212','JOINES RD',NULL,NULL,'101','100','213','212','Right','roadswest.dbf','0.11','40','0.1650','10.8316',NULL,'1',NULL,NULL,'JOINES','RD',NULL,'01050000000100000001020000001100000000000040F6743241000000A068DA2E41000000A010753241000000A072DA2E410000006026753241000000C088DA2E41000000803A753241000000609BDA2E410000006059753241000000A0BBDA2E41000000C07775324100000000E7DA2E410000004094753241000000C018DB2E4100000040B27532410000000056DB2E4100000060CC753241000000C098DB2E4100000080DA753241000000A0C7DB2E4100000080E675324100000040F8DB2E41000000A0F0753241000000A039DC2E41000000A0FA753241000000607EDC2E41000000C00976324100000000C6DC2E41000000201E763241000000400ADD2E4100000080507632410000000058DD2E4100000000907632410000004098DD2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('16','5574.289315','ROAD3','PL2001','269','1309','268','1308','NORTH FLATWOODS RD',NULL,NULL,'269','268','1309','1308','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('17','3573.963256','ROAD3','PL2001','1311','1975','1310','1974','NORTH FLATWOODS RD',NULL,NULL,'1311','1310','1975','1974','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('18','659.444826','ROAD3','PL2001','101','223','100','222','FLATWOOD POST OFFICE RD',NULL,NULL,'101','100','223','222','Right','roadswest.dbf','0.12','40','0.1800','10.8106',NULL,'1',NULL,NULL,'FLATWOOD BOX','RD',NULL,'010500000001000000010200000017000000000000C03474324100000040CD1A2F41000000C049743241000000C0C41A2F41000000806B74324100000040BD1A2F41000000C08D74324100000040B91A2F41000000A0B074324100000060B61A2F41000000C0D174324100000040BB1A2F41000000C0FB74324100000060DC1A2F41000000602675324100000060081B2F410000006044753241000000001F1B2F410000000061753241000000A0361B2F41000000807A75324100000000541B2F41000000609475324100000060721B2F4100000040B075324100000000921B2F41000000E0CE75324100000000A31B2F41000000E0CE75324100000000A31B2F41000000E0E4753241000000A0951B2F4100000080F8753241000000C07F1B2F41000000C00D763241000000005E1B2F410000008021763241000000C03A1B2F41000000203276324100000000221B2F410000004043763241000000C00B1B2F410000004068763241000000C0EC1A2F41000000009076324100000040D21A2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('19','327.885615','ROAD3','PL2001','1977','2037','1976','2036','NORTH FLATWOODS RD',NULL,NULL,'1977','1976','2037','2036','Right','roadswest.dbf','0.06','40','0.0900','10.9296',NULL,'1','N',NULL,'FLATWOODS','RD',NULL,'01050000000100000001020000000C00000000000080F372324100000060461B2F41000000C012733241000000A0421B2F41000000E031733241000000003C1B2F41000000604C733241000000C02F1B2F41000000406673324100000040211B2F41000000E081733241000000A0101B2F41000000409D733241000000A0001B2F41000000A0BB733241000000A0F21A2F4100000060DA733241000000A0E71A2F4100000020F5733241000000C0E11A2F41000000A01074324100000000DC1A2F41000000C03474324100000040CD1A2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('20','993.470304','ROAD3','PL2001','101','269','100','268','CUT LAUREL GAP RD',NULL,NULL,'101','100','269','268','Right','roadswest.dbf','0.19','40','0.2850','11.8270',NULL,'1',NULL,NULL,'CUT LAUREL GAP','RD',NULL,'010500000001000000010200000024000000000000C03474324100000040CD1A2F41000000204574324100000040011B2F410000008055743241000000C0341B2F410000002066743241000000A05D1B2F41000000806F743241000000C0851B2F41000000806574324100000040A91B2F41000000C054743241000000A0CA1B2F41000000A039743241000000A0FA1B2F41000000201C74324100000060251C2F41000000E0FE733241000000004B1C2F4100000080E1733241000000A0701C2F4100000000C173324100000040A41C2F41000000E0A073324100000040D91C2F41000000608873324100000040FC1C2F41000000607073324100000060201D2F41000000405E733241000000603E1D2F41000000E04E73324100000040601D2F41000000804473324100000040871D2F410000000040733241000000C0B01D2F41000000204873324100000060E71D2F41000000C05773324100000000FD1D2F41000000406B733241000000400A1E2F410000000094733241000000C0111E2F410000000094733241000000C0111E2F4100000040BE733241000000A00C1E2F41000000C0E0733241000000400C1E2F410000006003743241000000A00B1E2F410000006019743241000000C0051E2F41000000C02B743241000000A00B1E2F410000006035743241000000A0341E2F41000000E037743241000000C0581E2F41000000C036743241000000407D1E2F41000000202B743241000000C0BE1E2F410000004017743241000000C0F81E2F41000000E0EB73324100000040381F2F41000000E0D9733241000000004B1F2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('21','227.364925','ROAD3','PL2001','271','309','270','308','CUT LAUREL GAP RD',NULL,NULL,'271','270','309','308','Right','roadswest.dbf','0.04','40','0.0600','11.9666',NULL,'1',NULL,NULL,'CUT LAUREL GAP','RD',NULL,'01050000000100000001020000000D000000000000E0D9733241000000004B1F2F41000000A0CF733241000000C07A1F2F41000000A0C6733241000000A0921F2F4100000080BE73324100000060AB1F2F4100000040B573324100000040CC1F2F41000000C0AE73324100000000EF1F2F41000000E0AC733241000000000E202F4100000000AD733241000000C02D202F4100000020AF7332410000000056202F41000000C0B47332410000000072202F4100000000C37332410000006093202F4100000000D373324100000040A8202F41000000C0E7733241000000C0C8202F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('22','138.432442','ROAD3','PL2002','311','333','310','332','CUT LAUREL GAP RD',NULL,NULL,'311','310','333','332','Right','roadswest.dbf','0.03','40','0.0450','12.5848',NULL,'1',NULL,NULL,'CUT LAUREL GAP','RD',NULL,'010500000001000000010200000006000000000000C0E7733241000000C0C8202F41000000A0FA733241000000A0ED202F41000000600C7432410000004012212F410000006019743241000000603B212F41000000601D743241000000C066212F41000000A021743241000000A0B6212F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('23','1573.976485','ROAD3','PL2002','335','601','334','600','CUT LAUREL GAP RD',NULL,NULL,'335','334','601','600','Right','roadswest.dbf','0.30','40','0.4500','11.8344',NULL,'1',NULL,NULL,'CUT LAUREL GAP','RD',NULL,'010500000001000000010200000036000000000000A021743241000000A0B6212F41000000000D74324100000040A1212F41000000E0F67332410000004093212F41000000C0BF733241000000A08E212F41000000C08673324100000040A1212F41000000C068733241000000C0AE212F41000000004A733241000000C0BB212F41000000A02B733241000000A0BE212F41000000C00D733241000000C0BE212F41000000C00D733241000000C0BE212F4100000060F572324100000000B4212F4100000040D1723241000000A0AB212F4100000040C0723241000000C0A9212F41000000C0AF72324100000000AA212F41000000209E723241000000C0AD212F41000000009072324100000060B7212F41000000208572324100000040CF212F41000000E07C723241000000C0EE212F4100000020777232410000004033222F410000002078723241000000A07E222F41000000207B723241000000C0F2222F41000000A0817232410000004067232F410000000087723241000000C0D9232F41000000E0907232410000000048242F41000000809D723241000000A07E242F4100000040A6723241000000A0BB242F41000000C09E723241000000A0EC242F4100000060947232410000000018252F410000000082723241000000C064252F410000002071723241000000C0B1252F41000000006872324100000040E9252F41000000E062723241000000001F262F41000000C068723241000000A067262F410000006072723241000000A0B5262F41000000C073723241000000A0E5262F41000000E0747232410000006013272F41000000C0777232410000004043272F41000000807A723241000000C074272F41000000A07A72324100000040AB272F41000000E07972324100000040E0272F41000000407B723241000000C025282F41000000807A723241000000C06B282F410000000079723241000000C09E282F41000000806F723241000000A0CD282F41000000A05E72324100000040DF282F41000000004C72324100000040E0282F41000000004C72324100000040E0282F41000000803F723241000000C0B8282F41000000803E723241000000A092282F41000000A041723241000000406E282F4100000020447232410000006050282F41000000C04472324100000000E8272F41000000803D723241000000409B272F41000000E037723241000000606E272F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('24','3447.261811','ROAD3','PL2002','603','1195','602','1194','CUT LAUREL GAP RD',NULL,NULL,'603','602','1195','1194','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('25','2808.662524','ROAD3','PL2010','343','869','342','868','BRYAN DAVIS RD',NULL,NULL,'343','342','869','868','Right','roadswest.dbf','0.53','40','0.7950','10.6794',NULL,'1',NULL,NULL,'BRYAN DAVIS','RD',NULL,'01050000000100000001020000003900000000000000A09D3241000000C0F8C62E4100000020849D3241000000401EC72E41000000E05F9D32410000000045C72E4100000000319D3241000000406AC72E41000000C0179D3241000000C07AC72E4100000040FC9C32410000004089C72E4100000060E09C32410000004095C72E41000000E0C59C3241000000409DC72E41000000C0AA9C3241000000C0A4C72E4100000000859C324100000000B4C72E41000000C05F9C324100000000C4C72E4100000080389C324100000040D4C72E4100000080119C3241000000C0E0C72E41000000A0F49B3241000000A0E5C72E4100000040D89B324100000040E6C72E4100000040D89B324100000040E6C72E4100000000BA9B3241000000C0DDC72E41000000C09A9B3241000000C0D1C72E41000000807C9B3241000000C0C7C72E41000000605E9B324100000040BEC72E41000000C03C9B324100000040B3C72E41000000201A9B324100000000ACC72E4100000040F59A3241000000C0AEC72E4100000000D19A3241000000A0B7C72E41000000A0B39A3241000000C0C1C72E4100000080969A324100000040CDC72E4100000080839A3241000000C0E2C72E41000000406F9A324100000060FDC72E41000000C0589A3241000000A02AC82E41000000A0449A3241000000405EC82E4100000080259A324100000060C3C82E41000000200A9A3241000000C02EC92E4100000000ED993241000000C0A6C92E4100000020CE993241000000A01ECA2E4100000080AE9932410000000081CA2E41000000608C99324100000060DFCA2E41000000006F993241000000A02ACB2E4100000040509932410000006073CB2E41000000C021993241000000A0D8CB2E4100000020F0983241000000A038CC2E4100000020BA983241000000C08CCC2E410000006085983241000000A0DFCC2E41000000C040983241000000A06DCD2E410000008000983241000000C005CE2E41000000E0CC973241000000C08ACE2E410000002098973241000000A00FCF2E410000004089973241000000402FCF2E41000000C05197324100000060A5CF2E4100000040079732410000006032D02E4100000020D0963241000000C093D02E410000004096963241000000A0EFD02E41000000802A9632410000004072D12E4100000040BA953241000000C0E4D12E410000008080953241000000C01AD22E41000000C049953241000000A056D22E41000000C0319532410000004078D22E41000000E01B95324100000000A0D22E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('26','3791.270964','ROAD3','PL2010','4105','4945','4104','4944','BIG LAUREL RD',NULL,NULL,'4105','4104','4945','4944','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('27','2588.684468','ROAD3','PL2010','101','587','100','586','SOUP BEAN BRANCH RD',NULL,NULL,'101','100','587','586','Right','roadswest.dbf','0.49','40','0.7350','10.6530',NULL,'1',NULL,NULL,'SOUP BEAN BRANCH','RD',NULL,'010500000001000000010200000043000000000000A0B08D3241000000605BAA2E41000000009E8D32410000004067AA2E41000000009E8D32410000004067AA2E41000000608C8D3241000000005DAA2E41000000207C8D3241000000A04BAA2E41000000004F8D3241000000C002AA2E41000000C03F8D3241000000C0E8A92E4100000000268D3241000000A0BDA92E4100000000168D3241000000C0A5A92E4100000000ED8C3241000000A062A92E4100000060C48C3241000000C01EA92E41000000A09D8C3241000000C0DAA82E41000000C0768C3241000000A096A82E41000000C05F8C3241000000A06EA82E41000000E0478C32410000000048A82E4100000080398C3241000000C033A82E4100000080298C3241000000A01DA82E4100000020098C324100000040F9A72E41000000A0EA8B3241000000A0E0A72E4100000000CB8B3241000000C0CDA72E41000000E0AB8B324100000040C1A72E41000000808C8B324100000040B8A72E41000000005B8B324100000060ACA72E4100000040298B324100000040A5A72E4100000000ED8A324100000040A3A72E41000000C0B08A324100000040A7A72E41000000C0878A3241000000C0ADA72E41000000205F8A324100000060B3A72E41000000205F8A324100000060B3A72E4100000060308A324100000060B2A72E4100000060018A3241000000C0AEA72E4100000000BD89324100000000AEA72E41000000207989324100000060A9A72E410000002044893241000000609BA72E41000000800E893241000000408EA72E4100000060E7883241000000008AA72E4100000020C0883241000000408CA72E41000000609C883241000000A09AA72E410000008079883241000000C0ABA72E410000002064883241000000A0B3A72E41000000C04E88324100000040BBA72E41000000402088324100000000C9A72E4100000000F2873241000000A0DDA72E41000000C0CB873241000000C003A82E41000000A0A68732410000000028A82E41000000A07E8732410000006039A82E4100000000558732410000000042A82E410000000025873241000000C044A82E410000000025873241000000C044A82E41000000C0F48632410000006041A82E4100000000CA863241000000003BA82E41000000609F8632410000004032A82E4100000060618632410000004021A82E41000000C0228632410000006013A82E4100000020E38532410000004017A82E41000000E0A48532410000004017A82E41000000E0A48532410000004017A82E41000000C068853241000000A000A82E41000000A02D85324100000060DCA72E41000000400F85324100000040C4A72E4100000040F1843241000000A0A9A72E4100000040BE8432410000004077A72E41000000408B843241000000A043A72E410000002077843241000000A030A72E41000000C062843241000000401EA72E41000000604F843241000000A00FA72E410000004035843241000000C0F0A62E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('28','2597.974677','ROAD3','PL2010','4943','5429','4942','5428','BIG LAUREL RD',NULL,NULL,'4943','4942','5429','5428','Right','roadswest.dbf','0.49','40','0.7350','10.6912',NULL,'1',NULL,NULL,'BIG LAUREL','RD',NULL,'01050000000100000001020000003A00000000000040D595324100000000A4A42E4100000060BE953241000000A000A52E41000000C09F9532410000004061A52E41000000807B95324100000060B9A52E410000004059953241000000C0F2A52E4100000040339532410000004021A62E410000008015953241000000C038A62E41000000A0F7943241000000404BA62E41000000E0DD943241000000605AA62E4100000040C3943241000000C066A62E410000004096943241000000C070A62E410000004096943241000000C070A62E410000002069943241000000C06FA62E41000000A047943241000000C068A62E410000004026943241000000405BA62E4100000040FA933241000000C038A62E4100000040D0933241000000600FA62E41000000E067933241000000A0A6A52E41000000400E9332410000006045A52E41000000E0009332410000000037A52E4100000000AB92324100000000D0A42E41000000A0539232410000004073A42E41000000802E9232410000000056A42E410000004008923241000000003DA42E4100000040F1913241000000C02FA42E41000000A0DA913241000000A027A42E4100000040C6913241000000C027A42E4100000000B1913241000000A02CA42E4100000020989132410000004035A42E4100000020809132410000000042A42E410000000069913241000000A054A42E41000000A052913241000000C06AA42E41000000801F913241000000A0ADA42E4100000080EE903241000000A0F9A42E4100000040AE903241000000C05DA52E41000000406E90324100000040C3A52E410000004035903241000000C018A62E4100000060FC8F3241000000A06DA62E41000000A0D38F324100000000ADA62E41000000E0A98F3241000000C0EAA62E41000000008C8F32410000004012A72E41000000606D8F32410000000037A72E4100000000438F3241000000A064A72E4100000040178F3241000000C08DA72E4100000060CC8E3241000000C0C3A72E4100000020818E324100000040F5A72E41000000204F8E32410000004018A82E41000000E01F8E3241000000C042A82E41000000200E8E32410000000059A82E41000000A0FD8D32410000000072A82E4100000080EC8D32410000004095A82E41000000C0DC8D324100000000BDA82E41000000C0CD8D3241000000A0E6A82E4100000040C28D3241000000C010A92E4100000080BA8D32410000000054A92E4100000000B78D3241000000009DA92E41000000A0B18D3241000000C01EAA2E41000000A0B08D3241000000605BAA2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('29','0.000000','ROAD3','PL2010','5431','5431','5430','5430','BIG LAUREL RD',NULL,NULL,'5431','5430','5431','5430','Right','roadswest.dbf','0.00','40','0.0000','0',NULL,'1',NULL,NULL,'BIG LAUREL','RD',NULL,'010500000001000000010200000002000000000000A0B08D3241000000605BAA2E41000000A0B08D3241000000605BAA2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('30','892.127654','ROAD3','PL2010','175','345','174','344','DALE OSBORNE RD',NULL,NULL,'175','174','345','344','Right','roadswest.dbf','0.17','40','0.2550','10.4956',NULL,'1',NULL,NULL,'DALE OSBORNE','RD',NULL,'010500000001000000010200000019000000000000C0FA7732410000000080842E4100000040F5773241000000A0B2842E4100000040F377324100000040DC842E4100000020F4773241000000A004852E41000000A0FA773241000000A034852E41000000E004783241000000C063852E410000004011783241000000C08F852E41000000C01E78324100000000BC852E4100000080257832410000004000862E41000000601F783241000000C029862E410000002018783241000000404E862E410000004010783241000000C070862E41000000C00478324100000040BB862E4100000020FB773241000000A007872E41000000E0EE773241000000A073872E4100000040E377324100000040E0872E4100000060D07732410000004077882E41000000A0C0773241000000400E892E41000000A0BB773241000000C07D892E41000000C0B777324100000000EF892E41000000A0B3773241000000403F8A2E41000000A0AE773241000000608F8A2E41000000E0A9773241000000C0CA8A2E41000000C0A4773241000000C0058B2E41000000C0A677324100000000438B2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('31','2975.479370','ROAD3','PL2010','101','639','100','638','ROARING FORK RD',NULL,NULL,'101','100','639','638','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('32','10301.287644','ROAD3','PL2010','5429','7367','5428','7366','BIG LAUREL RD',NULL,NULL,'5429','5428','7367','7366','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('33','5884.069486','ROAD3','PL2011','871','1977','870','1976','BRYAN DAVID RD',NULL,NULL,'871','870','1977','1976','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('34','5266.312794','ROAD3','PL2011','2367','3353','2366','3352','JOINES RD',NULL,NULL,'2367','2366','3353','3352','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('35','1241.292781','ROAD3','PL2011','225','455','224','454','FLATWOOD POST OFFICE RD',NULL,NULL,'225','224','455','454','Right','roadswest.dbf','0.24','40','0.3600','10.7938',NULL,'1',NULL,NULL,'FLATWOOD BOX','RD',NULL,'01050000000100000001020000002E000000000000009076324100000040D21A2F4100000020A576324100000040C41A2F41000000C0C7763241000000A0AD1A2F4100000000E1763241000000409A1A2F41000000C0F9763241000000A08A1A2F410000006015773241000000C0821A2F41000000C03177324100000060811A2F41000000404B77324100000060851A2F410000002065773241000000C08C1A2F41000000C07F773241000000A0941A2F41000000609877324100000000A11A2F4100000060B577324100000040BE1A2F4100000040CD77324100000040E81A2F4100000040D7773241000000A0061B2F41000000A0DE773241000000A0281B2F4100000060E3773241000000C0591B2F41000000C0E4773241000000608E1B2F4100000080E4773241000000C0D21B2F4100000020E477324100000060181C2F4100000020E677324100000040451C2F4100000040E8773241000000A0701C2F4100000000E977324100000000AF1C2F41000000E0EB77324100000040EF1C2F4100000060F7773241000000C02C1D2F41000000A00478324100000000671D2F41000000800F783241000000C0A41D2F41000000201A783241000000C0E31D2F410000002027783241000000C0271E2F410000002031783241000000406B1E2F410000008035783241000000C0B21E2F410000004033783241000000C0F91E2F41000000602D78324100000040271F2F410000008023783241000000604E1F2F41000000E01478324100000040681F2F41000000A0F777324100000000861F2F4100000080DA773241000000C0931F2F41000000E0BB773241000000009F1F2F41000000A09F77324100000000AF1F2F410000004084773241000000C0C31F2F41000000407377324100000040D31F2F410000004063773241000000C0E91F2F41000000A0587732410000000011202F410000002054773241000000403C202F41000000E054773241000000C05E202F410000002057773241000000007F202F41000000C05877324100000000C0202F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('36','11476.105172','ROAD3','PL2011','215','2365','214','2364','JOINES RD',NULL,NULL,'215','214','2365','2364','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('37','2468.538931','ROAD3','PL2012','4419','4879','4418','4878','JOINES RD',NULL,NULL,'4419','4418','4879','4878','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('38','6564.701784','ROAD3','PL2012','4881','6113','4880','6112','JOINES RD',NULL,NULL,'4881','4880','6113','6112','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('39','5664.331114','ROAD3','PL2012','101','1159','100','1158','FLATWOODS SCHOOL RD',NULL,NULL,'101','100','1159','1158','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('40','670.189915','ROAD3','PL2012','1475','1601','1474','1600','BURNT SCHOOL HOUSE RD',NULL,NULL,'1475','1474','1601','1600','Right','roadswest.dbf','0.13','40','0.1950','10.6380',NULL,'1',NULL,NULL,'BURNT SCHOOL HOUSE','RD',NULL,'010500000001000000010200000018000000000000E0C0813241000000A0575F2F4100000000CF813241000000005A5F2F4100000000DC813241000000405F5F2F4100000060EC813241000000C06E5F2F41000000C0FA813241000000C0855F2F410000000006823241000000409F5F2F41000000C00B82324100000040B95F2F41000000200A823241000000C0D05F2F41000000A00482324100000000EB5F2F41000000C0FA813241000000A005602F41000000E0EE813241000000A022602F4100000060E6813241000000A046602F4100000000DF8132410000000068602F41000000E0D3813241000000A087602F41000000A0C8813241000000A0AB602F41000000A0C381324100000060FC602F4100000060C6813241000000604D612F41000000E0C581324100000000A3612F4100000040C9813241000000C0F9612F4100000000DA813241000000A063622F41000000C0F281324100000060C7622F41000000E00C8232410000004018632F410000000029823241000000C065632F41000000604A823241000000A0C9632F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('41','260.480490','ROAD3','PL2012','1601','1649','1600','1648','BURNT SCHOOL HOUSE RD',NULL,NULL,'1601','1600','1649','1648','Right','roadswest.dbf','0.05','40','0.0750','10.8534',NULL,'1',NULL,NULL,'BURNT SCHOOL HOUSE','RD',NULL,'01050000000100000001020000000A000000000000604A823241000000A0C9632F4100000080398232410000004014642F41000000C021823241000000C061642F410000000017823241000000607D642F41000000A00E823241000000409A642F41000000800D823241000000A0B6642F41000000600E82324100000000D4642F41000000C015823241000000A035652F410000008018823241000000A095652F41000000E014823241000000A0AF652F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('42','1196.015043','ROAD3','PL2012','1651','1879','1650','1878','BURNT SCHOOL HOUSE RD',NULL,NULL,'1651','1650','1879','1878','Right','roadswest.dbf','0.23','40','0.3450','10.4914',NULL,'1',NULL,NULL,'BURNT SCHOOL HOUSE','RD',NULL,'010500000001000000010200000010000000000000E014823241000000A0AF652F41000000E0168232410000006032662F41000000C00E823241000000408B662F410000000008823241000000A041672F41000000C005823241000000A08F672F410000004001823241000000A01F682F41000000C002823241000000A094692F410000000003823241000000C02C6A2F41000000600382324100000040C46A2F410000002003823241000000C0636B2F41000000600182324100000040A16B2F41000000C001823241000000608D6C2F4100000060FE813241000000C0916C2F41000000C01582324100000040836D2F41000000E01F82324100000000B06D2F412D37EC365E82324100000000E06E2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('43','3586.930890','ROAD3','PL2012','1161','1831','1160','1830','FLATWOODS SCHOOL RD',NULL,NULL,'1161','1160','1831','1830','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('44','3100.384371','ROAD3','PL2012','101','683','100','682','DENNY RD',NULL,NULL,'101','100','683','682','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('45','3285.123291','ROAD3','PL2012','457','1073','456','1072','FLATWOOD POST OFFICE RD',NULL,NULL,'457','456','1073','1072','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('46','629.483111','ROAD3','PL2012','1183','1299','1182','1298','BURNT SCHOOL HOUSE RD',NULL,NULL,'1183','1182','1299','1298','Right','roadswest.dbf','0.12','40','0.1800','10.8532',NULL,'1',NULL,NULL,'BURNT SCHOOL HOUSE','RD',NULL,'0105000000010000000102000000170000000000006061803241000000C020542F410000000076803241000000A036542F410000000089803241000000004E542F410000006097803241000000C068542F4100000000A58032410000004087542F4100000080B4803241000000A0AC542F41000000A0C1803241000000C0D3542F4100000020CB80324100000040FF542F4100000040D2803241000000002D552F4100000080D88032410000006083552F4100000060DB80324100000000DD552F4100000080DF803241000000002E562F4100000080E4803241000000C07E562F41000000C0EB803241000000C0D4562F4100000080F5803241000000C029572F4100000020FF803241000000A06F572F41000000600D813241000000C0B2572F41000000001E813241000000C0DC572F41000000C02E813241000000C003582F410000006039813241000000601F582F410000000041813241000000A03A582F4100000020438132410000004059582F410000008043813241000000007C582F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('47','1076.253439','ROAD3','PL2012','981','1181','980','1180','BURNT SCHOOL HOUSE RD',NULL,NULL,'981','980','1181','1180','Right','roadswest.dbf','0.20','40','0.3000','10.7626',NULL,'1',NULL,NULL,'BURNT SCHOOL HOUSE','RD',NULL,'01050000000100000001020000002000000000000080B87E3241000000C02A4E2F41000000E0B07E3241000000C0524E2F41000000C0A97E3241000000407A4E2F4100000080A27E324100000000A14E2F4100000000957E324100000040E64E2F4100000060887E3241000000A02C4F2F4100000000807E324100000000684F2F41000000E0787E324100000060A34F2F41000000C06F7E3241000000A0EB4F2F4100000080697E3241000000C035502F4100000040697E32410000006068502F41000000006B7E3241000000C09A502F41000000C0727E324100000000EE502F41000000407A7E3241000000003F512F41000000607A7E32410000004066512F41000000A07B7E3241000000A090512F41000000C0817E3241000000A0B8512F4100000020897E3241000000C0DD512F4100000040927E3241000000A015522F41000000609D7E3241000000404D522F4100000040AE7E3241000000C084522F41000000A0C17E324100000000B8522F41000000C0D77E324100000000F0522F41000000E0F17E32410000000022532F41000000600A7F3241000000403E532F41000000C0237F32410000000055532F41000000E05E7F3241000000C082532F41000000009C7F3241000000A0A7532F41000000C0D67F3241000000A0BF532F41000000001080324100000040DA532F41000000E038803241000000A0FB532F410000006061803241000000C020542F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('48','4680.165437','ROAD3','PL2012','101','979','100','978','BURNT SCHOOL HOUSE RD',NULL,NULL,'101','100','979','978','Right','roadswest.dbf','0.89','40','1.3350','10.6610',NULL,'1',NULL,NULL,'BURNT SCHOOL HOUSE','RD',NULL,'0105000000010000000102000000A600000000000060217D324100000040662C2F41000000800A7D3241000000A0EA2C2F41000000C0057D3241000000A00A2D2F41000000C0007D3241000000602A2D2F41000000E0F97C3241000000C0532D2F41000000C0F27C3241000000A07D2D2F41000000C0E87C324100000040BC2D2F4100000060DE7C324100000040FA2D2F4100000020D57C3241000000C0292E2F4100000020CB7C3241000000A0592E2F4100000040C17C324100000060892E2F4100000060B67C3241000000C0B62E2F41000000A0AB7C3241000000A0D92E2F41000000A09F7C3241000000C0FA2E2F4100000060917C3241000000601B2F2F4100000000827C3241000000403A2F2F41000000C0747C3241000000C0512F2F4100000000677C324100000060692F2F41000000C0517C3241000000A08F2F2F41000000E0337C324100000000BD2F2F41000000A0227C3241000000C0DA2F2F41000000C0197C3241000000A0F62F2F41000000A0187C3241000000401F302F41000000001D7C32410000006046302F41000000E0247C32410000006070302F41000000802E7C3241000000C097302F41000000E0377C324100000040C4302F41000000E0417C3241000000C0F0302F4100000020557C3241000000403B312F4100000060687C32410000004084312F4100000020757C324100000060BF312F4100000060827C3241000000A0FB312F4100000020947C3241000000403A322F41000000C0A47C3241000000A077322F41000000C0B27C324100000040C7322F41000000A0BE7C3241000000001A332F4100000060CB7C32410000004070332F4100000020D87C324100000040C6332F4100000080E57C32410000000022342F4100000000F57C3241000000607D342F4100000000017D324100000040AF342F41000000C00B7D324100000040DF342F41000000A0157D32410000004028352F41000000601B7D32410000004074352F41000000E01D7D324100000040BA352F41000000001D7D32410000006000362F41000000E0197D32410000004036362F41000000E0147D3241000000C06B362F41000000200F7D3241000000C098362F4100000060087D3241000000C0C5362F4100000020FF7C3241000000A001372F4100000020F57C3241000000C03C372F4100000060EF7C3241000000C05D372F4100000000E97C3241000000C07C372F41000000E0E07C32410000000098372F4100000000D87C3241000000C0B4372F41000000C0CC7C3241000000A0E4372F4100000020C37C32410000000015382F4100000060BA7C3241000000A044382F41000000A0B27C3241000000C074382F41000000C0AC7C324100000040A1382F41000000C0A77C324100000040CE382F41000000A0A37C3241000000C0FD382F41000000A0A07C3241000000A02D392F41000000209F7C3241000000C04C392F41000000209E7C3241000000C06C392F41000000A09E7C3241000000A0A5392F41000000E09F7C324100000000DE392F41000000C0A07C324100000040083A2F41000000C0A07C3241000000A0313A2F41000000C09D7C3241000000406C3A2F41000000C0987C3241000000C0A63A2F41000000A0937C324100000060D63A2F41000000C08E7C3241000000C0063B2F41000000208B7C3241000000A0403B2F4100000020897C3241000000407A3B2F41000000C0887C3241000000A0BD3B2F41000000A0897C3241000000C0003C2F41000000408B7C3241000000605F3C2F41000000208E7C324100000000BE3C2F41000000C0917C3241000000601B3D2F4100000040977C3241000000A0783D2F41000000809D7C3241000000C0BA3D2F4100000000A47C324100000060FC3D2F4100000060A97C3241000000A0343E2F4100000080AD7C3241000000C06B3E2F41000000A0AE7C3241000000A0B63E2F4100000080AD7C3241000000A0023F2F4100000080AD7C3241000000A04D3F2F4100000020AB7C3241000000A0963F2F4100000060A67C3241000000A0C83F2F41000000C09F7C3241000000C0F93F2F41000000C0977C32410000006023402F41000000808F7C3241000000604E402F4100000040867C3241000000008B402F41000000E0807C3241000000C0C9402F4100000000817C3241000000C0EC402F41000000A0827C3241000000600F412F41000000C0867C3241000000603D412F41000000A08C7C3241000000A06A412F4100000040947C3241000000A097412F41000000409B7C3241000000C0C2412F41000000E09F7C3241000000600F422F41000000E0A17C3241000000405F422F4100000080A67C324100000060C9422F4100000020AB7C3241000000A033432F4100000040AF7C3241000000A085432F41000000C0B27C324100000060D7432F4100000080B47C3241000000600B442F4100000080B47C3241000000003E442F41000000E0B07C3241000000A069442F4100000000AC7C3241000000A096442F4100000060A87C3241000000C0C4442F41000000C0A47C324100000060F2442F4100000000A07C32410000004020452F41000000E09B7C3241000000A04F452F41000000809A7C3241000000007D452F41000000C09A7C324100000000AA452F41000000609C7C3241000000A0DD452F41000000C0A07C3241000000C010462F4100000080A77C3241000000C03B462F4100000020B17C32410000000065462F4100000040C77C3241000000009C462F4100000080D37C3241000000A0B7462F4100000000E17C324100000040DC462F41000000C0EE7C32410000000002472F4100000000FB7C3241000000A021472F4100000060067D32410000006040472F4100000060197D3241000000C08C472F4100000000297D3241000000C0DE472F4100000060347D3241000000C01A482F41000000803F7D32410000006057482F41000000404C7D32410000004098482F4100000000577D3241000000C0D8482F41000000205B7D32410000004000492F41000000205E7D3241000000C028492F4100000020607D3241000000C055492F4100000020617D32410000006083492F4100000000617D3241000000A0A5492F4100000000627D324100000040C9492F4100000020687D3241000000A0F9492F4100000060737D324100000040264A2F4100000040807D324100000040414A2F41000000608E7D3241000000C0574A2F41000000809E7D3241000000C06D4A2F4100000060AF7D3241000000C0814A2F4100000080CA7D3241000000409E4A2F4100000040E57D324100000060BA4A2F4100000080F87D3241000000A0D14A2F41000000A00A7E324100000060EB4A2F41000000E0187E324100000000054B2F4100000040267E324100000060214B2F4100000040317E3241000000403C4B2F41000000203B7E3241000000C0574B2F41000000604C7E3241000000A09A4B2F41000000A05B7E324100000060E14B2F4100000000757E3241000000404D4C2F41000000E08D7E324100000040B94C2F4100000020A17E324100000040084D2F41000000C0B17E3241000000C0574D2F4100000020B97E3241000000408B4D2F41000000E0BD7E3241000000A0BF4D2F41000000E0BE7E324100000060E24D2F41000000E0BD7E324100000040044E2F4100000080B87E3241000000C02A4E2F4100000080B87E3241000000C02A4E2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('49','5507.701132','ROAD3','PL2012','101','1121','100','1120','FLATWOODS RD',NULL,NULL,'101','100','1121','1120','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('50','928.500731','ROAD3','PL2012','1301','1475','1300','1474','BURNT SCHOOL HOUSE RD',NULL,NULL,'1301','1300','1475','1474','Right','roadswest.dbf','0.18','40','0.2700','10.6724',NULL,'1',NULL,NULL,'BURNT SCHOOL HOUSE','RD',NULL,'01050000000100000001020000001E0000000000008043813241000000007C582F410000006045813241000000C09A582F41000000C04B813241000000C0E5582F4100000020508132410000004027592F410000008052813241000000404C592F41000000205A813241000000A09D592F41000000E060813241000000A0EC592F410000008060813241000000A0475A2F41000000E060813241000000A0A55A2F41000000806D813241000000A0055B2F41000000C07981324100000040625B2F41000000607B81324100000040985B2F41000000207C81324100000040D05B2F41000000E07D813241000000A00E5C2F41000000A07F813241000000C04C5C2F41000000C08181324100000000945C2F41000000E08381324100000040DB5C2F410000006086813241000000A02F5D2F410000002086813241000000A0825D2F41000000408081324100000000C65D2F41000000C079813241000000A00B5E2F410000008076813241000000C0535E2F410000000077813241000000C09B5E2F41000000807A813241000000C0E85E2F410000000089813241000000402D5F2F41000000C09881324100000060455F2F4100000080AA81324100000060545F2F4100000040B6813241000000C0565F2F41000000E0C0813241000000A0575F2F41000000E0C0813241000000A0575F2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('51','246.065077','ROAD3','PL2013','1881','1927','1880','1926','BURNT SCHOOL HOUSE RD',NULL,NULL,'1881','1880','1927','1926','Right','roadswest.dbf','0.05','40','0.0750','10.6984',NULL,'1',NULL,NULL,'BURNT SCHOOL HOUSE','RD',NULL,'0105000000010000000102000000020000002D37EC365E82324100000000E06E2F41D631CF95BB8232414563E552A7702F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('52','4878.260916','ROAD3','PL2013','1795','2709','1794','2708','ROCK FENCE RD',NULL,NULL,'1795','1794','2709','2708','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('53','3207.944939','ROAD3','PL2013','685','1285','684','1284','DENNY RD',NULL,NULL,'685','684','1285','1284','Right','roadswest.dbf','0.61','40','0.9150','10.6932',NULL,'1',NULL,NULL,'DENNY','RD',NULL,'01050000000100000001020000003200000000000040948F324100000000E06E2F4100000080978F3241000000A0AA6F2F41000000E0A58F3241000000C0D0702F41000000A0A78F32410000004020712F4100000020A68F3241000000A06F712F4100000080A18F3241000000A0BE712F41000000209E8F324100000000E5712F41000000C0828F3241000000405E732F41000000C05F8F3241000000C05E752F41000000C05B8F3241000000404D762F41000000E0568F3241000000A0A3762F41000000E04E8F3241000000C0F8762F41000000E0438F3241000000C04C772F41000000E0358F3241000000409F772F41000000C0148F32410000004047782F41000000A0F98E324100000040E2782F4100000060E18E3241000000407F792F41000000E0CC8E3241000000C0187A2F41000000C0A98E3241000000405B7B2F41000000E0998E3241000000C04B7C2F4100000020908E3241000000C08F7C2F4100000040838E3241000000A0D27C2F41000000A0738E3241000000A0127D2F4100000040618E3241000000C04F7D2F4100000080588E324100000040697D2F41000000E0DC8D3241000000A0D87E2F4100000060BB8D3241000000002D7F2F41000000009C8D324100000000867F2F41000000607F8D3241000000A0E27F2F4100000040668D3241000000403F802F41000000C04D8D3241000000609A802F4100000080328D324100000000F2802F41000000C0148D32410000004046812F4100000080F48C3241000000A096812F4100000020E98C3241000000A0B0812F4100000040D38C3241000000C0E8812F41000000E0BF8C3241000000C024822F4100000040AF8C32410000004064822F41000000A0A18C324100000040A6822F41000000E0968C324100000060EA822F4100000040908C3241000000C025832F4100000000888C3241000000A066832F41000000C07C8C3241000000C0A4832F41000000A06E8C324100000000E1832F41000000C05D8C3241000000401A842F41000000404A8C32410000004050842F4100000060408C3241000000C067842F41000000E0F08B3241000000C026852F41000000E0BC8B3241000000C0B9852F4100000060B18B3241000000C0F9852F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('54','758.855841','ROAD3','PL2013','1833','1973','1832','1972','FLATWOODS SCHOOL RD',NULL,NULL,'1833','1832','1973','1972','Right','roadswest.dbf','0.14','40','0.2100','10.8408',NULL,'1',NULL,NULL,'FLATWOODS SCHOOL','RD',NULL,'01050000000100000001020000000C000000000000E0019C324100000000E06E2F41000000C00F9C324100000060F66E2F4100000080709C3241000000A0B86F2F41000000E0D39C32410000004089702F41000000800E9D3241000000A02B712F41000000E0419D324100000040EF712F4100000080549D3241000000602D722F41000000E0619D3241000000C066722F41000000606C9D3241000000C0A2722F4100000040749D324100000060E2722F41000000E0909D32410000004072732F4100000000A09D324100000000BB732F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('55','240.254723','ROAD3','PL2013','1287','1333','1286','1332','DENNY RD',NULL,NULL,'1287','1286','1333','1332','Right','roadswest.dbf','0.05','40','0.0750','10.4458',NULL,'1',NULL,NULL,'DENNY','RD',NULL,'01050000000100000001020000000700000000000060B18B3241000000C0F9852F41000000C0AC8B3241000000A019862F4100000020A78B3241000000C08E862F4100000080A78B3241000000A0ED862F41000000C0A28B3241000000C05C872F41000000009E8B3241000000C0A7872F4100000040918B324100000000D0872F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('56','3027.774446','ROAD3','PL2020','239','807','238','806','WILLIE WALKER RD',NULL,NULL,'239','238','807','806','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('57','2910.900515','ROAD3','PL2020','941','1467','940','1466','ROARING FORK RD',NULL,NULL,'941','940','1467','1466','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('58','1292.604678','ROAD3','PL2020','101','341','100','340','BRYAN DAVIS RD',NULL,NULL,'101','100','341','340','Right','roadswest.dbf','0.24','40','0.3600','10.7718',NULL,'1',NULL,NULL,'BRYAN DAVIS','RD',NULL,'0105000000010000000102000000200000000000004093A0324100000040F9BE2E410000008089A03241000000A031BF2E41000000607CA032410000006081BF2E41000000806FA0324100000040D1BF2E41000000A062A032410000004024C02E410000006054A03241000000A074C02E41000000A042A03241000000A0BEC02E41000000402EA032410000000007C12E41000000C018A03241000000A04CC12E41000000A001A03241000000A08EC12E4100000000E29F3241000000A0D6C12E4100000080C19F32410000000021C22E41000000A0AC9F32410000004060C22E41000000E0989F3241000000C09CC22E4100000020749F3241000000A0F4C22E41000000C04D9F3241000000404DC32E41000000602B9F3241000000C0A9C32E41000000800A9F32410000004008C42E41000000C0EC9E3241000000A065C42E4100000060CE9E324100000000C0C42E41000000E0BB9E324100000060EDC42E4100000060A89E3241000000401BC52E4100000060969E32410000000048C52E4100000000849E3241000000C072C52E41000000E06B9E3241000000C0A4C52E4100000080529E324100000040D3C52E41000000C0359E324100000040FEC52E41000000C0179E3241000000A029C62E4100000040FB9D3241000000C057C62E4100000080DF9D3241000000A087C62E41000000E0C29D324100000000BEC62E4100000000A09D3241000000C0F8C62E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('59','1648.796373','ROAD3','PL2020','641','939','640','938','ROARING FORK RD',NULL,NULL,'641','640','939','938','Right','roadswest.dbf','0.31','40','0.4650','11.0658',NULL,'1',NULL,NULL,'ROARING FORK','RD',NULL,'01050000000100000001020000003100000000000000A09D3241000000002EB52E4100000000A79D3241000000A053B52E4100000040B79D3241000000A0A8B52E4100000080C69D3241000000C0FDB52E4100000040D49D32410000006054B62E4100000080DF9D3241000000A0ABB62E41000000A0E59D3241000000C0EEB62E4100000000E99D3241000000A031B72E4100000040E79D3241000000C066B72E41000000C0E59D324100000060A0B72E4100000000E89D3241000000A0C9B72E41000000E0EA9D3241000000A0F0B72E4100000000F29D32410000004021B82E41000000E0FD9D32410000004055B82E41000000000D9E32410000004086B82E41000000401F9E324100000040B3B82E4100000040379E324100000000DEB82E4100000000519E3241000000A002B92E41000000C0679E3241000000401FB92E41000000807F9E32410000004039B92E41000000A09E9E3241000000A055B92E4100000080BE9E3241000000406EB92E4100000040ED9E3241000000408CB92E41000000E01B9F3241000000C0A7B92E41000000C0479F324100000040C5B92E41000000E0739F3241000000A0E2B92E41000000A0869F324100000040EEB92E41000000C0989F324100000040FAB92E4100000040BC9F32410000004017BA2E4100000020DD9F3241000000403BBA2E41000000A0F39F3241000000C05DBA2E410000008009A03241000000C084BA2E410000006025A03241000000A0B8BA2E41000000203FA0324100000000EFBA2E41000000E04EA032410000000016BB2E41000000605DA03241000000C03EBB2E41000000006EA032410000000078BB2E41000000207DA0324100000040B4BB2E41000000408DA03241000000A0F6BB2E41000000809AA032410000006039BC2E41000000A0A2A03241000000007DBC2E4100000060A8A0324100000060C3BC2E4100000060AEA03241000000401CBD2E4100000020B2A03241000000A075BD2E41000000C0B3A0324100000000BFBD2E41000000A0B2A03241000000C006BE2E4100000000ABA03241000000405CBE2E41000000209FA03241000000A0B1BE2E410000004093A0324100000040F9BE2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('60','624.386902','ROAD3','PL2020','1627','1743','1626','1742','RICH HILL RD',NULL,NULL,'1627','1626','1743','1742','Right','roadswest.dbf','0.12','40','0.1800','10.7652',NULL,'1',NULL,NULL,'RICH HILL','RD',NULL,'01050000000100000001020000000C00000000000000E9C332410000000080842E4100000040F1C33241000000C0B7842E410000006006C43241000000604C852E41000000A01BC43241000000C0E0852E41000000002DC432410000000056862E41000000003FC4324100000000CB862E41000000604EC432410000004029872E41000000C05DC43241000000C086872E41000000C070C432410000004006882E410000002081C43241000000C065882E410000008097C43241000000A0C2882E4100000060B1C43241000000001B892E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('61','1132.308917','ROAD3','PL2020','3501','3749','3500','3748','BIG LAUREL RD',NULL,NULL,'3501','3500','3749','3748','Right','roadswest.dbf','0.21','40','0.3150','9.1316',NULL,'1',NULL,NULL,'BIG LAUREL','RD',NULL,'01050000000100000001020000002600000000000020BBA532410000000080842E4100000020B0A53241000000C0AD842E4100000000A3A5324100000000EC842E410000000094A53241000000602A852E41000000E086A53241000000A050852E410000006078A53241000000C073852E410000000065A53241000000C099852E410000008050A53241000000C0BB852E41000000A043A53241000000A0D0852E41000000C034A53241000000C0E3852E41000000A023A53241000000A0EF852E410000006012A5324100000000F6852E410000004000A53241000000C0F7852E410000004000A53241000000C0F7852E41000000E0EEA4324100000000F7852E41000000A0DFA43241000000A0F6852E4100000040D0A4324100000060F5852E41000000C0B4A4324100000060F1852E41000000C098A4324100000040E9852E410000006077A4324100000000D5852E41000000A057A43241000000C0BD852E41000000E018A432410000004098852E4100000060D9A332410000000073852E410000008098A33241000000C048852E41000000C057A332410000006021852E41000000C03CA332410000006014852E41000000A023A332410000006008852E410000004008A33241000000C0F8842E4100000060F0A2324100000040ED842E4100000000D1A2324100000000E9842E41000000C0AFA23241000000C0E7842E410000008088A23241000000A0E0842E41000000A061A23241000000C0D6842E410000004045A23241000000C0CD842E410000002029A2324100000000C3842E410000006003A23241000000C0B1842E4100000020DEA13241000000009C842E4100000020C6A132410000004089842E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('62','3744.055624','ROAD3','PL2020','225','943','224','942','ARNOLD JONES RD',NULL,NULL,'225','224','943','942','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('63','12.124067','ROAD3','PL2020','3751','3753','3750','3752','BIG LAUREL RD',NULL,NULL,'3751','3750','3753','3752','Right','roadswest.dbf','0.00','40','0.0000','12.1240',NULL,'1',NULL,NULL,'BIG LAUREL','RD',NULL,'01050000000100000001020000000200000000000020C6A132410000004089842E41C5E6F1EABAA132410000000080842E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('64','1264.994658','ROAD3','PL2020','3825','4103','3824','4102','BIG LAUREL RD',NULL,NULL,'3825','3824','4103','4102','Right','roadswest.dbf','0.24','40','0.3600','9.1006',NULL,'1',NULL,NULL,'BIG LAUREL','RD',NULL,'010500000001000000010200000014000000000000408FA032410000000080842E41000000807AA03241000000C0AB842E410000002067A0324100000040DC842E410000008034A03241000000A05C852E41000000A002A0324100000000DF852E41000000C0AA9F324100000040B4862E4100000040539F32410000000089872E41000000C0279F324100000060F7872E41000000E0FD9E3241000000C067882E4100000000DE9E324100000000C7882E41000000C0BF9E32410000004028892E4100000000A19E3241000000C093892E41000000A0819E324100000040008A2E41000000A05D9E3241000000A06A8A2E41000000A0399E324100000000D38A2E41000000201D9E324100000060328B2E41000000E0FE9D3241000000C0918B2E4100000040DB9D3241000000A0EC8B2E4100000000B59D3241000000C0428C2E4100000000A09D3241000000606C8C2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('65','599.963495','ROAD3','PL2021','493','573','492','572','WEST CALHOUN RD',NULL,NULL,'493','492','573','572','Right','roadswest.dbf','0.11','40','0.1650','14.9990',NULL,'1','W',NULL,'CALHOUN','RD',NULL,'01050000000100000001020000001B00000000000000B0C4324100000000C8152F41000000A0ABC4324100000060CA152F410000004087C43241000000C0DC152F410000008070C4324100000040DF152F410000008059C4324100000040DE152F41000000403FC43241000000A0DC152F410000008025C4324100000060D4152F410000002015C4324100000060C8152F410000008005C43241000000C0B8152F4100000000F4C3324100000060A4152F41000000A0E4C33241000000408B152F4100000000DAC33241000000406B152F4100000020D0C33241000000A049152F4100000000B7C33241000000A017152F41000000C09DC33241000000C0E5142F41000000A092C3324100000060BE142F410000002086C33241000000A09A142F41000000606EC332410000006081142F410000004053C332410000000073142F41000000C02FC33241000000006B142F41000000A00BC33241000000C068142F41000000C0ECC232410000000066142F4100000040CEC23241000000A05F142F4100000000C3C23241000000005D142F4100000020BAC232410000004056142F4100000000B7C23241000000A041142F4100000020B9C23241000000A02C142F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('66','10266.911715','ROAD3','PL2021','1469','3331','1468','3330','ROARING FORK RD',NULL,NULL,'1469','1468','3331','3330','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('67','10027.008588','ROAD3','PL2021','813','2703','812','2702','WILLIE WALKER RD',NULL,NULL,'813','812','2703','2702','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('68','1735.936343','ROAD3','PL2021','2705','3033','2704','3032','WILLIE WALKER RD',NULL,NULL,'2705','2704','3033','3032','Right','roadswest.dbf','0.33','40','0.4950','10.5850',NULL,'1',NULL,NULL,'WILLIE WALKER','RD',NULL,'01050000000100000001020000004A0000000000002018BA3241000000A0D8002F41000000A01FBA3241000000C018012F410000006029BA32410000006055012F410000000038BA32410000006089012F41000000C043BA3241000000C0B5012F410000008047BA3241000000C0DD012F410000008045BA3241000000A004022F41000000A038BA3241000000A038022F410000004029BA3241000000C049022F41000000401ABA32410000004054022F41000000A000BA3241000000A06C022F41000000E0E5B932410000006084022F41000000A0D2B93241000000C091022F4100000080BFB93241000000C09E022F41000000E0AEB93241000000A0A8022F41000000E099B93241000000C0C6022F41000000208CB93241000000A0F7022F41000000807FB93241000000C02F032F41000000007AB93241000000604D032F410000008075B93241000000A072032F410000008074B932410000004097032F41000000E077B93241000000C0C8032F41000000C07FB93241000000C00D042F41000000808AB932410000004038042F410000006094B93241000000A052042F41000000E09FB93241000000406C042F4100000040ACB932410000000084042F4100000040B9B93241000000A09B042F41000000C0C8B93241000000C0B7042F4100000040D8B9324100000060D3042F4100000000E6B9324100000040E9042F4100000080F3B932410000000003052F41000000E0FDB93241000000C024052F41000000C005BA3241000000C04C052F41000000600DBA3241000000406A052F41000000A014BA3241000000408B052F410000004018BA3241000000C0C1052F41000000C018BA3241000000C0E5052F410000008018BA32410000004009062F410000000018BA3241000000A035062F41000000E013BA32410000006060062F41000000C009BA3241000000C081062F41000000E0FCB93241000000A0A8062F41000000A0F3B9324100000000C5062F41000000E0E9B93241000000A0E1062F41000000A0DAB93241000000C008072F4100000060CAB93241000000402E072F41000000E0BFB93241000000C044072F41000000A0B5B93241000000C05A072F41000000E0A3B93241000000A086072F41000000C095B9324100000000AA072F410000006087B93241000000A0CD072F41000000E076B9324100000060F3072F410000002067B932410000004019082F41000000405BB93241000000403A082F410000008050B93241000000A05C082F41000000A044B93241000000C08D082F41000000003AB93241000000C0C1082F41000000E031B9324100000040E6082F41000000802BB932410000006009092F410000004028B932410000004031092F41000000C025B93241000000405C092F41000000E01DB9324100000040A0092F410000000017B9324100000000E2092F410000002014B9324100000040340A2F41000000C014B93241000000A0870A2F41000000E016B9324100000040BB0A2F410000002019B9324100000040F00A2F41000000201AB9324100000040380B2F41000000801AB93241000000C07F0B2F41000000401BB9324100000040B80B2F41000000C01CB9324100000000F00B2F41000000C01EB93241000000C01B0C2F41000000001FB9324100000060630C2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('69','554.854989','ROAD3','PL2021','3333','3433','3332','3432','ROARING FORK RD',NULL,NULL,'3333','3332','3433','3432','Right','roadswest.dbf','0.11','40','0.1650','11.0970',NULL,'1',NULL,NULL,'ROARING FORK','RD',NULL,'01050000000100000001020000001A000000000000001FB9324100000060630C2F410000000027B9324100000000840C2F41000000E02AB93241000000C0B60C2F410000002032B9324100000040E50C2F41000000C03AB93241000000C0140D2F41000000A042B9324100000000490D2F41000000604CB9324100000000720D2F410000008058B9324100000000980D2F410000008065B9324100000060B50D2F410000000074B9324100000040D30D2F41000000007FB9324100000040ED0D2F41000000E089B9324100000040070E2F410000004099B93241000000A02D0E2F4100000020A9B9324100000040500E2F4100000020C0B93241000000C0730E2F41000000C0D1B93241000000A0970E2F41000000A0DBB9324100000000AF0E2F4100000020E1B93241000000A0E20E2F41000000C0DEB9324100000040190F2F41000000E0CDB93241000000A03D0F2F41000000E0C2B9324100000000520F2F41000000C0AAB9324100000040630F2F41000000C099B93241000000C06F0F2F41000000408AB93241000000C07A0F2F41000000407EB9324100000040910F2F41000000C075B93241000000C0C30F2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('70','4186.172949','ROAD3','PL2021','101','931','100','930','BIG SPRINGS RD',NULL,NULL,'101','100','931','930','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('71','3727.506906','ROAD3','PL2021','2025','2725','2024','2724','EAST BIG SPRINGS RD',NULL,NULL,'2025','2024','2725','2724','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('72','3850.600931','ROAD3','PL2021','933','1697','932','1696','BIG SPRINGS RD',NULL,NULL,'933','932','1697','1696','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('73','11.706449','ROAD3','PL2021','809','811','808','810','WILLIE WALKER RD',NULL,NULL,'809','808','811','810','Right','roadswest.dbf','0.00','40','0.0000','11.7064',NULL,'1',NULL,NULL,'WILLIE WALKER','RD',NULL,'010500000001000000010200000002000000539F567062BF324100000000A0D22E410000004060BF324100000000B7D22E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('74','1477.973732','ROAD3','PL2021','3733','4007','3732','4006','JOINES RD',NULL,NULL,'3733','3732','4007','4006','Right','roadswest.dbf','0.28','40','0.4200','10.7882',NULL,'1',NULL,NULL,'JOINES','RD',NULL,'01050000000100000001020000002F000000000000A03AA23241000000A031172F41000000E02BA232410000004062172F41000000601FA232410000004095172F410000000016A2324100000040CB172F41000000C010A232410000004004182F41000000A00EA232410000004048182F41000000600EA23241000000A08B182F41000000C00BA2324100000040F2182F41000000000DA23241000000005A192F410000000017A23241000000A0C2192F410000000028A2324100000040271A2F410000006037A2324100000000631A2F41000000A047A23241000000409C1A2F410000008056A2324100000040D51A2F410000004066A23241000000600E1B2F410000002080A23241000000C05D1B2F41000000E09BA2324100000040AA1B2F4100000000B2A2324100000040E41B2F41000000C0C8A23241000000401D1C2F4100000020DFA23241000000C0541C2F4100000080F5A23241000000608C1C2F41000000E00AA33241000000A0C11C2F410000002020A33241000000A0F61C2F41000000A03FA33241000000A0481D2F410000002061A33241000000C0981D2F410000004076A33241000000A0BF1D2F41000000C088A33241000000A0E51D2F41000000409AA33241000000A0221E2F41000000E0A6A33241000000C0661E2F4100000060ACA33241000000C08A1E2F41000000A0AFA3324100000040AE1E2F4100000040AFA3324100000000D31E2F4100000060ACA3324100000040F91E2F4100000080A8A33241000000001E1F2F41000000C0A1A33241000000403D1F2F410000004092A33241000000605B1F2F410000008080A3324100000040811F2F41000000A06EA33241000000C0A21F2F41000000405EA33241000000C0B71F2F41000000604CA3324100000040CC1F2F41000000A032A3324100000060EB1F2F410000002019A33241000000400C202F410000000003A33241000000402C202F4100000080EDA23241000000C04D202F4100000060DBA23241000000C06C202F4100000000CAA23241000000608E202F4100000040B6A2324100000000C0202F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('75','2014.962293','ROAD3','PL2021','3355','3731','3354','3730','JOINES RD',NULL,NULL,'3355','3354','3731','3730','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('76','1312.388326','ROAD3','PL2022','4009','4253','4008','4252','JOINES RD',NULL,NULL,'4009','4008','4253','4252','Right','roadswest.dbf','0.25','40','0.3750','10.7572',NULL,'1',NULL,NULL,'JOINES','RD',NULL,'01050000000100000001020000002F00000000000040B6A2324100000000C0202F4100000000AAA23241000000C0DE202F410000000091A23241000000C038212F41000000C084A232410000004086212F41000000E07AA2324100000040D3212F41000000C06BA23241000000402D222F41000000C05BA23241000000C087222F41000000E052A2324100000040BF222F41000000E048A2324100000040F3222F410000000037A23241000000C02C232F41000000A022A232410000004067232F410000006015A232410000004098232F410000004007A2324100000060C2232F41000000A0F9A13241000000A0D8232F41000000A0E9A13241000000A0EF232F4100000000D4A132410000000016242F4100000080C0A13241000000C041242F4100000060B3A132410000004071242F4100000000A8A1324100000000A0242F410000008098A1324100000000D1242F410000006089A13241000000C004252F41000000A07EA13241000000C03A252F410000008076A132410000004072252F410000008072A13241000000C09F252F41000000006FA13241000000C0CB252F41000000A069A13241000000C0F8252F410000002063A132410000004025262F41000000005DA13241000000404A262F41000000A055A13241000000A06B262F410000000049A13241000000608C262F41000000603AA1324100000040AF262F410000006029A13241000000A0E9262F41000000C019A13241000000C022272F41000000200AA132410000000051272F41000000E0F9A032410000000080272F41000000E0EDA03241000000A0A6272F4100000060E2A03241000000C0CD272F4100000000D4A032410000006005282F4100000060C8A03241000000A03F282F41000000E0C2A03241000000C067282F4100000060BFA032410000006091282F41000000A0BFA0324100000060BA282F4100000060C0A03241000000C0E0282F41000000A0BDA03241000000C019292F41000000A0B9A032410000000054292F41000000E0B4A03241000000C0B0292F41000000A0B2A03241000000C0EC292F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('77','1419.275549','ROAD3','PL2022','101','363','100','362','GREER TOWN RD',NULL,NULL,'101','100','363','362','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('78','4693.461731','ROAD3','PL2022','365','1239','364','1238','GREER TOWN RD',NULL,NULL,'365','364','1239','1238','Right','roadswest.dbf','0.89','40','1.3350','10.7402',NULL,'1',NULL,NULL,'GREER TOWN','RD',NULL,'0105000000010000000102000000CD000000000000803AA3324100000060602F2F41000000604AA33241000000404F2F2F410000006058A33241000000603C2F2F410000008065A33241000000602B2F2F41000000A07FA3324100000040142F2F41000000609BA33241000000C0022F2F41000000C0B0A3324100000060F82E2F4100000060C6A3324100000060F12E2F4100000060E2A3324100000040EE2E2F4100000020FFA3324100000000EE2E2F41000000600FA43241000000C0ED2E2F410000000020A4324100000000EE2E2F410000000020A4324100000000EE2E2F410000006030A4324100000040EC2E2F410000002047A4324100000060F52E2F41000000405AA43241000000C00D2F2F41000000A06BA4324100000000332F2F41000000E06CA43241000000605A2F2F410000000073A4324100000040EC2F2F41000000807AA43241000000607D302F41000000E07DA4324100000000A8302F41000000A07FA4324100000060D0302F41000000E07DA4324100000040F0302F41000000207AA432410000000010312F41000000A073A432410000000034312F41000000C06DA43241000000A066312F41000000206DA43241000000C09A312F410000000075A43241000000C0D1312F41000000E084A4324100000040FE312F410000004091A43241000000C01F322F41000000809FA432410000004040322F4100000020B3A43241000000A05D322F41000000A0D3A432410000004085322F41000000E0EBA43241000000A09C322F410000008005A53241000000A0A7322F410000008005A53241000000A0A7322F41000000A021A5324100000000A4322F41000000A033A53241000000C089322F41000000C03FA532410000006070322F41000000804AA53241000000C053322F41000000E058A53241000000401C322F41000000C065A53241000000A0E5312F410000006077A5324100000000AB312F41000000208CA532410000004077312F41000000C09AA53241000000A060312F41000000C0AAA532410000000047312F41000000E0B5A53241000000A029312F4100000000C0A532410000004010312F4100000060CCA53241000000C0FB302F4100000000DAA53241000000C0ED302F41000000E0F0A5324100000040E9302F41000000400DA6324100000000ED302F41000000601FA632410000000004312F410000000032A632410000000025312F41000000C040A63241000000C039312F41000000A04EA63241000000604D312F41000000205EA63241000000A067312F410000008070A63241000000607F312F41000000208CA632410000004085312F41000000208CA632410000004085312F4100000020B5A63241000000A076312F41000000C0C6A63241000000C05F312F41000000A0E0A63241000000A045312F41000000E0F7A63241000000603E312F41000000E010A732410000004043312F41000000C02AA73241000000C04F312F410000008042A732410000000064312F410000008057A73241000000406C312F41000000C06CA73241000000606E312F41000000C06CA73241000000606E312F410000002081A73241000000A06B312F41000000E094A73241000000C066312F4100000080ACA732410000004063312F4100000080C3A732410000006061312F4100000080F7A73241000000606D312F41000000602CA83241000000A080312F41000000C042A83241000000C085312F41000000C058A83241000000C08B312F410000000076A832410000000098312F41000000208DA83241000000C0B5312F41000000C0A2A83241000000C0DC312F41000000E0A7A83241000000A007322F4100000000AAA83241000000403D322F4100000080AEA83241000000C05C322F41000000A0B2A83241000000A079322F41000000C0B8A83241000000C0C6322F4100000020BEA832410000004016332F4100000060C4A832410000006050332F41000000C0CAA83241000000C081332F4100000020D2A83241000000C0B2332F4100000080DDA8324100000040EF332F4100000080EAA83241000000C029342F4100000080F5A83241000000A058342F41000000E001A932410000004086342F41000000400EA93241000000A0AD342F41000000C01CA93241000000C0D2342F41000000E02DA93241000000C0F3342F410000004041A93241000000C00F352F410000002058A93241000000C024352F41000000206FA93241000000C035352F41000000A085A93241000000A046352F41000000E09AA932410000004059352F4100000020A8A93241000000C068352F41000000E0BBA932410000000092352F41000000E0C4A93241000000C0AD352F41000000E0D0A9324100000040CA352F41000000C0DEA93241000000A0E3352F4100000000ECA93241000000A0F3352F4100000060F9A93241000000C000362F41000000600CAA3241000000C011362F41000000C020AA3241000000601F362F410000000039AA3241000000A024362F410000002050AA32410000004027362F410000006061AA3241000000002D362F41000000C072AA3241000000A034362F41000000808FAA32410000004047362F4100000040A4AA32410000006062362F4100000080B7AA3241000000A088362F41000000A0C1AA3241000000A0AB362F4100000060C6AA3241000000C0D5362F4100000040C6AA3241000000A005372F41000000C0C2AA32410000000025372F41000000C0BDAA3241000000C045372F4100000080B8AA3241000000C06A372F4100000060AFAA3241000000A092372F41000000E0A0AA324100000000C0372F410000002094AA324100000060E5372F41000000A086AA3241000000A0FD372F410000000077AA3241000000C013382F410000002069AA3241000000C027382F41000000005BAA3241000000403A382F41000000C043AA32410000006053382F41000000E02BAA32410000000062382F41000000601AAA3241000000A06E382F41000000A0FFA93241000000A08B382F41000000C0EDA93241000000A0AD382F41000000A0E8A93241000000C0CE382F41000000E0E7A93241000000C0EF382F4100000020E7A93241000000A025392F41000000A0E6A93241000000004C392F41000000C0E5A932410000004072392F41000000E0E3A93241000000A09B392F4100000040E1A93241000000A0C4392F41000000A0DDA93241000000A0EE392F4100000080DAA93241000000A0193A2F4100000080D8A93241000000C04A3A2F4100000080DAA93241000000407C3A2F41000000E0E0A93241000000A0A23A2F4100000020F7A9324100000000C63A2F41000000800CAA324100000040C73A2F41000000800CAA324100000040C73A2F41000000601FAA3241000000A0BC3A2F41000000602BAA324100000000A53A2F410000002034AA3241000000C08A3A2F410000006040AA3241000000C0683A2F41000000E04EAA324100000040523A2F41000000E062AA3241000000C0333A2F41000000A076AA3241000000A0263A2F410000004086AA324100000040293A2F4100000080A5AA324100000040363A2F4100000020BEAA3241000000A0493A2F4100000000CBAA3241000000A05B3A2F4100000020DBAA3241000000A0733A2F41000000E0E9AA3241000000C08D3A2F4100000020F7AA324100000060AB3A2F41000000C003AB324100000060CB3A2F410000004015AB3241000000A0F83A2F410000006022AB3241000000402C3B2F41000000E02EAB324100000040633B2F410000008039AB3241000000A0863B2F41000000E043AB3241000000A0A83B2F41000000804EAB324100000060CD3B2F410000000059AB3241000000A0F23B2F410000006062AB3241000000A0153C2F41000000E06BAB3241000000C0383C2F41000000E078AB324100000000673C2F410000008080AB3241000000C0A03C2F41000000A083AB3241000000C0DE3C2F410000008084AB324100000040053D2F41000000A084AB3241000000C02B3D2F41000000A083AB324100000060653D2F410000006082AB3241000000A09F3D2F410000004082AB3241000000C0C73D2F410000008082AB3241000000C0EF3D2F410000000083AB324100000040163E2F410000008087AB3241000000C0473E2F41000000808FAB3241000000A0773E2F41000000809BAB324100000060A63E2F4100000060A9AB324100000040D23E2F4100000000B6AB324100000060F93E2F4100000080C3AB3241000000A01F3F2F4100000040CFAB3241000000C03D3F2F41000000C0DBAB3241000000C05A3F2F4100000000F0AB3241000000A0843F2F4100000000FFAB324100000060A33F2F41000000C00FAC324100000060C03F2F41000000C01EAC324100000040D23F2F41000000A02EAC324100000060E03F2F410000006046AC3241000000A0EC3F2F41000000805EAC3241000000A0F23F2F41000000606FAC3241000000A0F43F2F41000000606FAC3241000000A0F43F2F41000000A080AC324100000040F43F2F410000006091AC3241000000C0EF3F2F4100000080ACAC324100000040EA3F2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('79','6352.283187','ROAD3','PL2022','485','1671','484','1670','JOHN ALLEY RD',NULL,NULL,'485','484','1671','1670','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('80','2669.677127','ROAD3','PL2022','1673','2173','1672','2172','JOHN ALLEY RD',NULL,NULL,'1673','1672','2173','2172','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('81','5311.767686','ROAD3','PL2022','1241','2231','1240','2230','GREER TOWN RD',NULL,NULL,'1241','1240','2231','2230','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('82','4094.645215','ROAD3','PL2022','2233','2997','2232','2996','GREER TOWN RD',NULL,NULL,'2233','2232','2997','2996','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('83','7723.656074','ROAD3','PL2022','101','1525','100','1524','FAIRVIEW CHURCH RD',NULL,NULL,'101','100','1525','1524','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('84','914.017367','ROAD3','PL2022','3473','3653','3472','3652','TUCKER RD',NULL,NULL,'3473','3472','3653','3652','Right','roadswest.dbf','0.17','40','0.2550','10.1558',NULL,'1',NULL,NULL,'TUCKER','RD',NULL,'01050000000100000001020000001000000000000000B0C43241000000C0C7572F4100000020AAC43241000000C085572F4100000060AAC43241000000A0BB562F41000000C0AAC432410000006003562F4100000020ADC432410000000039552F4100000060AEC43241000000A087542F41000000A0A7C4324100000060D6532F410000004097C43241000000A00B532F410000002097C432410000004050522F41000000C087C4324100000040BD512F41000000C079C43241000000408A512F41000000E067C43241000000405C512F410000008052C43241000000A034512F41000000403BC432410000000025512F410000004023C432410000004019512F41FFD9DFCE22C43241ADB3F86619512F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('85','809.378931','ROAD3','PL2022','1969','2117','1968','2116','COY HAM RD',NULL,NULL,'1969','1968','2117','2116','Right','roadswest.dbf','0.15','40','0.2250','10.9376',NULL,'1',NULL,NULL,'COY HAM','RD',NULL,'01050000000100000001020000001300000000000000B0C4324100000060124C2F4100000000A1C43241000000A03D4C2F41000000C071C43241000000A0C64C2F41000000E04DC4324100000040854D2F410000002040C4324100000040AE4D2F410000004024C43241000000A0434E2F41000000600FC43241000000C0974E2F41000000E002C4324100000040AA4E2F4100000060E2C33241000000A0C94E2F41000000C0CFC33241000000A0E64E2F4100000040A2C3324100000040554F2F41000000C08BC3324100000040AE4F2F41000000E09CC33241000000A01F502F4100000040AFC33241000000606B502F4100000040D5C3324100000000C5502F4100000060F0C3324100000040F1502F4100000000F8C33241000000A0FB502F410000000014C432410000004014512F41FED9DFCE22C43241ADB3F86619512F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('86','1939.365998','ROAD3','PL2022','501','863','500','862','ROCK FENCE RD',NULL,NULL,'501','500','863','862','Right','roadswest.dbf','0.37','40','0.5550','10.7148',NULL,'1',NULL,NULL,'ROCK FENCE','RD',NULL,'010500000001000000010200000029000000000000601FB1324100000000E06E2F41000000E009B13241000000A0BD6E2F4100000020F8B03241000000A0906E2F4100000020DFB03241000000004E6E2F41000000C0B6B03241000000401D6E2F41000000C07AB0324100000040F96D2F41000000A030B0324100000040EC6D2F4100000040E4AF3241000000A0D56D2F4100000040D5AF3241000000A0C36D2F41000000A0C6AF324100000040B16D2F4100000020B8AF3241000000C09D6D2F4100000060A8AF3241000000C06E6D2F4100000080A5AF3241000000A0376D2F4100000040B2AF3241000000C0906C2F4100000000B6AF324100000040716C2F41000000E0B5AF3241000000A04E6C2F41000000A0B1AF3241000000C02C6C2F41000000E0A9AF3241000000C00F6C2F41000000C09EAF3241000000A0F56B2F41000000C090AF3241000000A0E16B2F41000000C080AF324100000060D46B2F41000000C06FAF324100000040CF6B2F410000000011AF324100000040C66B2F41000000A0B0AE324100000000F86B2F410000000070AE3241000000A0226C2F41000000E036AE324100000040446C2F4100000020FDAD3241000000A0486C2F4100000020FDAD3241000000A0486C2F410000004096AD3241000000C0426C2F410000004026AD324100000000356C2F41000000609FAC3241000000A0056C2F41000000E08FAC3241000000C0FE6B2F410000000080AC324100000040006C2F41000000E070AC3241000000000A6C2F410000008063AC3241000000401B6C2F410000000059AC324100000060326C2F4100000080B2AB324100000040776D2F41000000C088AB3241000000A0D36D2F41000000806CAB3241000000C02C6E2F410000004061AB3241000000607E6E2F41000000A055AB324100000000E06E2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('87','1944.565656','ROAD3','PL2022','101','463','100','462','ROCK FENCE RD',NULL,NULL,'101','100','463','462','Right','roadswest.dbf','0.37','40','0.5550','10.7434',NULL,'1',NULL,NULL,'ROCK FENCE','RD',NULL,'010500000001000000010200000021000000000000001BB53241000000A0D8652F41000000C010B532410000000033662F41000000C00EB532410000006084662F41000000201BB532410000004048672F41000000C03EB532410000004070682F41000000404DB532410000004058692F41000000205AB53241000000A0226A2F41000000A04DB53241000000605E6A2F41000000E03CB53241000000C0826A2F410000004024B5324100000040876A2F410000004024B5324100000040876A2F4100000060F6B43241000000C0436A2F4100000000C4B4324100000040CE692F41000000E07EB432410000004057692F410000002063B432410000006049692F41000000A04FB43241000000A050692F4100000020FFB33241000000C0A6692F4100000020C4B3324100000040176A2F41000000E09DB33241000000003F6A2F410000008066B33241000000C0776A2F41000000C054B33241000000C08C6A2F410000004045B3324100000060A96A2F410000006038B3324100000040CF6A2F41000000C02DB3324100000040186B2F410000008009B33241000000A0486C2F4100000040F7B2324100000040E36C2F4100000020D9B23241000000608E6D2F4100000020CCB23241000000A0C66D2F4100000040BBB2324100000040FA6D2F4100000000A7B2324100000040286E2F41000000008FB23241000000C0506E2F41000000404CB2324100000040996E2F41000000C0D4B1324100000000E06E2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('88','873.229155','ROAD3','PL2022','4255','4417','4254','4416','JOINES RD',NULL,NULL,'4255','4254','4417','4416','Right','roadswest.dbf','0.17','40','0.2550','10.7806',NULL,'1',NULL,NULL,'JOINES','RD',NULL,'010500000001000000010200000024000000000000A0B2A03241000000C0EC292F41000000A0A2A0324100000040EC292F41000000C092A03241000000A0F8292F410000000086A03241000000C0092A2F41000000E068A03241000000003A2A2F41000000E04AA03241000000C0682A2F41000000202EA03241000000A08F2A2F41000000C010A0324100000060B32A2F41000000E0EF9F324100000040DA2A2F41000000C0CD9F3241000000C0FD2A2F41000000A0B89F324100000000102B2F4100000060A39F324100000040202B2F41000000808F9F3241000000402F2B2F41000000607A9F3241000000403A2B2F41000000A0689F3241000000A03C2B2F41000000A0689F3241000000A03C2B2F4100000080579F3241000000A03B2B2F41000000E0469F324100000040392B2F41000000C0359F3241000000A0332B2F41000000A0249F3241000000C0272B2F4100000020149F3241000000C0182B2F4100000080F39E324100000040EF2A2F4100000000D59E3241000000A0C12A2F4100000020BB9E3241000000A09D2A2F4100000000A19E3241000000407C2A2F4100000060889E324100000000632A2F41000000A06E9E3241000000604D2A2F41000000405D9E3241000000C0402A2F41000000A04C9E3241000000A0382A2F4100000000369E324100000000392A2F41000000A01E9E3241000000C0402A2F41000000C0059E3241000000604D2A2F4100000080ED9D3241000000A05D2A2F41000000C0D59D3241000000A0722A2F4100000000BC9D324100000000842A2F4100000000A09D3241000000A0862A2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('89','7404.560170','ROAD3','PL2023','1753','3141','1752','3140','WHENLIN RIDGE RD',NULL,NULL,'1753','1752','3141','3140','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('90','4236.392861','ROAD3','PL2023','865','1657','864','1656','ROCK FENCE RD',NULL,NULL,'865','864','1657','1656','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('91','192.686917','ROAD3','PL2023','465','499','464','498','ROCK FENCE RD',NULL,NULL,'465','464','499','498','Right','roadswest.dbf','0.04','40','0.0600','11.3346',NULL,'1',NULL,NULL,'ROCK FENCE','RD',NULL,'010500000001000000010200000008000000000000C0D4B1324100000000E06E2F41000000C08BB13241000000000E6F2F410000002078B1324100000000166F2F410000002064B13241000000C0176F2F410000002064B13241000000C0176F2F410000006050B13241000000C0136F2F41000000003DB13241000000C0096F2F41000000601FB1324100000000E06E2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('92','211.551936','ROAD3','PL2023','299','329','298','328','GANDER TOWN RD',NULL,NULL,'299','298','329','328','Right','roadswest.dbf','0.04','40','0.0600','14.1034',NULL,'1',NULL,NULL,'GANDER TOWN','RD',NULL,'01050000000100000001020000000700000000000000B0C43241000000403D7D2F41000000C099C43241000000A0367D2F41000000406BC43241000000A0347D2F410000004039C43241000000403F7D2F41000000E011C4324100000040387D2F4100000040EFC3324100000060287D2F4100000040DEC3324100000000237D2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('93','842.058932','ROAD3','PL2023','101','239','100','238','FARMERS STORE RD',NULL,NULL,'101','100','239','238','Right','roadswest.dbf','0.16','40','0.2400','12.2038',NULL,'1',NULL,NULL,'FARMERS STORE','RD',NULL,'010500000001000000010200000011000000000000204FC0324100000060E2B92F410000004036C0324100000000F5B92F41000000601CC032410000006001BA2F41000000A0EABF3241000000A00CBA2F4100000080DBBF32410000000012BA2F4100000080CCBF32410000004017BA2F4100000000A6BF3241000000402BBA2F410000006080BF32410000004045BA2F41000000005CBF3241000000C064BA2F4100000020D0BE32410000006008BB2F41000000E03ABE324100000040BCBB2F41000000C0ECBD3241000000C027BC2F4100000060CBBD3241000000A04FBC2F41000000E0B5BD32410000004070BC2F4100000040A2BD32410000006095BC2F410000000091BD3241000000C0BEBC2F41000000607DBD32410000000000BD2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('94','857.331198','ROAD3','PL2023','3143','3301','3142','3300','WHENLIN RIDGE RD',NULL,NULL,'3143','3142','3301','3300','Right','roadswest.dbf','0.16','40','0.2400','10.8522',NULL,'1',NULL,NULL,'WHENLIN RIDGE','RD',NULL,'01050000000100000001020000000F000000000000204FC0324100000060E2B92F41000000405EC03241000000A02EBA2F410000004076C03241000000A06ABA2F41000000C09DC03241000000C0C2BA2F41000000C0FCC03241000000C076BB2F41000000C01CC1324100000060B0BB2F410000002039C13241000000A0DBBB2F410000006057C13241000000A001BC2F410000000077C132410000006022BC2F410000000098C13241000000A03DBC2F4100000020BAC13241000000C052BC2F4100000000CEC13241000000605CBC2F41000000003BC23241000000A08ABC2F4100000080A7C2324100000040BFBC2F41000000001EC332410000000000BD2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('95','1295.186770','ROAD3','PL2023','1975','2217','1974','2216','FLATWOODS SCHOOL RD',NULL,NULL,'1975','1974','2217','2216','Right','roadswest.dbf','0.25','40','0.3750','10.7040',NULL,'1',NULL,NULL,'FLATWOODS SCHOOL','RD',NULL,'01050000000100000001020000002300000000000000A09D324100000000BB732F4100000060B69D3241000000C026742F4100000020C79D3241000000A070742F4100000020DB9D3241000000A0B9742F4100000000F29D324100000040FF742F41000000600B9E3241000000C040752F4100000060279E3241000000A081752F4100000040429E3241000000C0C8752F41000000605B9E32410000000016762F41000000C06D9E3241000000603A762F41000000408F9E3241000000C075762F4100000020B39E3241000000C0AC762F4100000020FF9E324100000040FF762F41000000E04A9F3241000000C068772F41000000806E9F324100000040A3772F41000000A0859F324100000040D2772F41000000809A9F32410000006005782F41000000E0AC9F3241000000C03C782F4100000060E19F3241000000C0E5782F4100000080F19F32410000004009792F41000000C003A032410000006027792F41000000E017A032410000004040792F41000000A02DA032410000000053792F410000004042A03241000000605E792F410000000050A03241000000A082792F410000002051A03241000000C0A7792F41000000A03DA03241000000C0037A2F410000008037A03241000000C0207A2F410000006031A03241000000C04B7A2F41000000802EA0324100000040787A2F41000000202FA0324100000040A57A2F41000000E032A0324100000060D17A2F41000000E03AA0324100000040107B2F410000008041A03241000000A0387B2F41000000604CA03241000000A0747B2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('96','719.528044','ROAD3','PL2023','1659','1793','1658','1792','ROCK FENCE RD',NULL,NULL,'1659','1658','1793','1792','Right','roadswest.dbf','0.14','40','0.2100','10.7392',NULL,'1',NULL,NULL,'ROCK FENCE','RD',NULL,'01050000000100000001020000000C000000000000604CA03241000000A0747B2F410000004016A03241000000A0A87B2F41000000E0F69F324100000000CC7B2F41000000C0919F3241000000A0247C2F41000000002F9F3241000000C06E7C2F41000000E0049F3241000000408F7C2F4100000020DA9E3241000000A0A97C2F4100000060AE9E3241000000C0BD7C2F4100000000829E3241000000C0CB7C2F41000000601C9E3241000000A0E57C2F4100000040DF9D3241000000C0F17C2F4100000000A09D324100000060057D2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('97','4355.928968','ROAD3','PL2024','241','963','240','962','FARMERS STORE RD',NULL,NULL,'241','240','963','962','Right','roadswest.dbf','0.82','40','1.2300','12.0662',NULL,'1',NULL,NULL,'FARMERS STORE','RD',NULL,'010500000001000000010200000049000000000000607DBD32410000000000BD2F41000000A04DBD324100000000C4BD2F41000000803FBD324100000060F1BD2F410000000034BD32410000006021BE2F41000000602BBD3241000000C053BE2F41000000A025BD3241000000A087BE2F41000000E022BD324100000040B9BE2F410000004027BD324100000040F4BE2F41000000A02EBD3241000000402DBF2F410000000039BD3241000000A064BF2F410000006046BD3241000000409BBF2F410000004083BD3241000000A0BDC02F41000000409EBD3241000000A064C12F41000000809BBD3241000000A091C12F41000000A095BD324100000000BEC12F41000000A08CBD324100000060E8C12F41000000A080BD3241000000A00FC22F410000002072BD32410000004032C22F410000000019BD324100000040F7C22F41000000C0BEBC3241000000C0C7C32F4100000040A8BC3241000000C0FBC32F410000004094BC32410000004033C42F41000000E082BC3241000000C06DC42F410000004074BC3241000000A0ABC42F410000006068BC3241000000A0EBC42F41000000C05EBC32410000004046C52F41000000005ABC32410000004097C52F410000002052BC324100000060E7C52F410000002047BC32410000004036C62F410000008037BC3241000000A08AC62F41000000002DBC3241000000C0CBC62F410000008025BC3241000000400EC72F410000000021BC3241000000C051C72F41000000801FBC3241000000C095C72F410000002021BC3241000000C0D9C72F41000000C026BC3241000000A036C82F410000004027BC3241000000C082C82F410000008024BC324100000040CEC82F410000008023BC324100000040F0C82F41000000E023BC3241000000A034C92F410000006027BC32410000004078C92F41000000002EBC3241000000C0BAC92F410000008037BC324100000040FCC92F41000000E043BC3241000000603BCA2F410000004053BC3241000000C078CA2F410000000060BC3241000000C0A8CA2F410000006070BC3241000000A0E6CA2F410000000096BC32410000000068CB2F4100000060BEBC324100000040E6CB2F4100000040E9BC3241000000A060CC2F41000000A016BD3241000000A0D7CC2F410000004046BD3241000000004ACD2F410000008051BD3241000000A05FCD2F41000000A074BD3241000000C09CCD2F41000000C099BD324100000060D5CD2F4100000080C0BD3241000000C008CE2F4100000000E9BD3241000000C036CE2F41000000E012BE3241000000605FCE2F41000000203EBE32410000004082CE2F41000000406ABE3241000000409FCE2F410000006098BE3241000000C0B6CE2F4100000000EABE3241000000A0F8CE2F41000000804EC03241000000A017D02F41000000E080C13241000000C013D12F41000000203EC23241000000C09DD12F41000000605DC2324100000000AAD12F410000008084C23241000000C0B3D12F41000000E0ABC2324100000060B7D12F41000000E0ABC2324100000060B7D12F4100000060D3C23241000000C0B4D12F4100000060FAC2324100000000ACD12F41000000801CC43241000000A02AD12F4100000000B0C43241000000A0F5D02F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('98','405.332240','ROAD3','PL2024','3303','3379','3302','3378','WHENLIN RIDGE RD',NULL,NULL,'3303','3302','3379','3378','Right','roadswest.dbf','0.08','40','0.1200','10.6666',NULL,'1',NULL,NULL,'WHENLIN RIDGE','RD',NULL,'010500000001000000010200000008000000000000001EC332410000000000BD2F41000000805EC33241000000C01CBD2F41000000209CC33241000000A031BD2F4100000020DAC33241000000C03FBD2F41000000A018C432410000004048BD2F41000000403AC43241000000004ABD2F41000000403AC43241000000004ABD2F4100000000B0C43241000000C038BD2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('99','8813.082501','ROAD3','PL2030','2113','3697','2112','3696','WEST MILL CREEK RD',NULL,NULL,'2113','2112','3697','3696','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('100','3602.186785','ROAD3','PL2030','3153','3821','3152','3820','RICH HILL RD',NULL,NULL,'3153','3152','3821','3820','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('101','726.545361','ROAD3','PL2030','101','237','100','236','WILLIE WALKER RD',NULL,NULL,'101','100','237','236','Right','roadswest.dbf','0.14','40','0.2100','10.6844',NULL,'1',NULL,NULL,'WILLIE WALKER','RD',NULL,'01050000000100000001020000001600000000000060B7C63241000000A05DBB2E4100000040A2C63241000000A06CBB2E41000000E090C63241000000C07ABB2E41000000C081C63241000000009BBB2E41000000E075C6324100000040BDBB2E410000002064C6324100000040EFBB2E410000002052C63241000000C01FBC2E41000000803BC632410000004054BC2E410000002023C632410000006083BC2E41000000C004C63241000000A0ACBC2E4100000060E4C5324100000060D4BC2E41000000C0C1C532410000000005BD2E4100000080A0C53241000000C039BD2E41000000A086C53241000000606DBD2E41000000006EC53241000000C0A0BD2E41000000804CC53241000000C0DCBD2E41000000002BC53241000000A01ABE2E410000000010C532410000004055BE2E4100000060F6C43241000000A091BE2E4100000020E4C43241000000C0C0BE2E41000000E0D1C43241000000A0EFBE2E4100000000B0C43241000000403EBF2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('102','3948.169242','ROAD3','PL2030','2559','3151','2558','3150','RICH HILL RD',NULL,NULL,'1825','1824','2557','2556','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('103','2849.737021','ROAD3','PL2030','2559','3151','2558','3150','RICH HILL RD',NULL,NULL,'101','100','657','656','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('104','646.912301','ROAD3','PL2030','101','223','100','222','ARNOLD JONES RD',NULL,NULL,'101','100','223','222','Right','roadswest.dbf','0.12','40','0.1800','10.6052',NULL,'1',NULL,NULL,'ARNOLD JONES','RD',NULL,'010500000001000000010200000011000000000000A0F9C53241000000C0358B2E41000000C0E1C5324100000040678B2E4100000000CFC53241000000A09F8B2E41000000A0B9C5324100000060E28B2E4100000060A4C5324100000040258C2E41000000E084C5324100000060828C2E410000004065C53241000000A0DF8C2E41000000204DC5324100000040278D2E410000002036C53241000000C0708D2E410000000023C5324100000000BF8D2E410000006010C53241000000600D8E2E41000000E004C53241000000C0368E2E4100000000F9C4324100000040618E2E41000000A0E2C4324100000040B88E2E4100000000CDC43241000000A00F8F2E41000000E0B6C43241000000406E8F2E4100000000B0C43241000000008A8F2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('105','435.533036','ROAD3','PL2030','1745','1823','1744','1822','RICH HILL RD',NULL,NULL,'1745','1744','1823','1822','Right','roadswest.dbf','0.08','40','0.1200','11.1676',NULL,'1',NULL,NULL,'RICH HILL','RD',NULL,'01050000000100000001020000001200000000000060B1C43241000000001B892E4100000080C5C43241000000C057892E4100000080DBC432410000006092892E4100000040F2C43241000000C0C6892E41000000800AC53241000000A0F7892E41000000C021C5324100000000248A2E41000000203CC53241000000A04A8A2E410000002052C53241000000605D8A2E410000008067C53241000000C06A8A2E41000000A07CC5324100000060728A2E41000000E08EC53241000000007C8A2E41000000A09BC53241000000408C8A2E4100000000A9C53241000000A0A18A2E41000000C0B6C53241000000C0B68A2E41000000C0C3C5324100000060CC8A2E41000000E0D6C5324100000000F18A2E41000000E0E9C53241000000A0178B2E41000000A0F9C53241000000C0358B2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('106','3191.284148','ROAD3','PL2030','2559','3151','2558','3150','RICH HILL RD',NULL,NULL,'2559','2558','3151','3150','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('107','4085.180597','ROAD3','PL2031','3699','4433','3698','4432','WEST MILL CREEK RD',NULL,NULL,'3699','3698','4433','4432','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('108','1421.890920','ROAD3','PL2031','101','365','100','364','ROARING BRANCH RD',NULL,NULL,'101','100','365','364','Right','roadswest.dbf','0.27','40','0.4050','10.7720',NULL,'1',NULL,NULL,'ROARING BRANCH','RD',NULL,'01050000000100000001020000002B00000000000040FEE63241000000C061E32E41000000800EE73241000000C068E32E41000000601EE73241000000A072E32E41000000C02DE73241000000A07EE32E41000000604CE732410000000093E32E41000000806AE7324100000040A4E32E410000008085E7324100000000ABE32E4100000060A2E7324100000060B4E32E4100000080C4E73241000000A0D4E32E41000000E0E3E7324100000000FAE32E41000000800EE83241000000A026E42E41000000A038E832410000000058E42E41000000A05DE83241000000A093E42E410000000081E8324100000000CFE42E41000000A0B3E83241000000400EE52E4100000060E6E832410000006052E52E41000000C00EE93241000000C0A5E52E410000006034E9324100000040FCE52E410000004048E932410000006027E62E410000008061E93241000000005EE62E41000000C090E93241000000C0B9E62E41000000E0B4E9324100000040F1E62E4100000060DAE93241000000C028E72E41000000C0F8E93241000000405FE72E410000002017EA32410000000091E72E41000000A02DEA3241000000A0ACE72E41000000804BEA3241000000C0C9E72E41000000A06DEA324100000040DCE72E41000000C091EA324100000060E9E72E4100000000B1EA3241000000C0F6E72E4100000000D0EA3241000000C000E82E41000000C0E3EA3241000000A003E82E4100000080F7EA3241000000C003E82E4100000080F7EA3241000000C003E82E410000004008EB3241000000C000E82E410000008019EB3241000000C0FCE72E41000000A02DEB3241000000A0F7E72E41000000C042EB324100000060F5E72E410000006059EB3241000000C0FCE72E41000000206FEB32410000006009E82E410000006090EB3241000000A023E82E4100000000B0EB32410000004045E82E4100000000C0EB3241000000A059E82E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('109','296.118451','ROAD3','PL2031','1005','1059','1004','1058','GREER HOLLOW RD',NULL,NULL,'1005','1004','1059','1058','Right','roadswest.dbf','0.06','40','0.0900','10.9674',NULL,'1',NULL,NULL,'GREER HOLLOW','RD',NULL,'01050000000100000001020000000C00000000000000C0EB3241000000A0040E2F4100000060A8EB3241000000C0270E2F410000006087EB3241000000C0410E2F410000000064EB324100000060590E2F41000000A045EB3241000000C0770E2F41000000C027EB3241000000C0940E2F41000000C00EEB3241000000C0A70E2F4100000040F5EA3241000000A0B50E2F41000000A0E1EA324100000000B90E2F4100000000CDEA324100000060BA0E2F41000000E0ABEA324100000000C00E2F41000000E0ABEA324100000000C00E2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('110','104.371721','ROAD4','PL2031','101','119','100','118','FOX MOUNTAIN RD',NULL,NULL,'101','100','119','118','Right','roadswest.dbf','0.02','40','0.0300','11.5968',NULL,'1',NULL,NULL,'FOX MOUNTAIN','RD',NULL,'0105000000010000000102000000050000000000006059EB3241000000C0FCE72E410000008080EB324100000040EEE72E4100000080A7EB3241000000A0DFE72E4100000040BBEB3241000000C0D8E72E4100000000C0EB3241000000C0D6E72E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('111','1783.536762','ROAD3','PL2031','101','335','100','334','WEST CALHOUN RD',NULL,NULL,'101','100','335','334','Right','roadswest.dbf','0.34','40','0.5100','15.2440',NULL,'1','W',NULL,'CALHOUN','RD',NULL,'01050000000100000001020000002F000000D27EFE63EACF3241BC36B12677112F41000000008FCF3241000000A09D112F410000002065CF3241000000A0B6112F41000000003ACF324100000060D1112F41000000200FCF324100000060ED112F41000000E0E7CE3241000000A00A122F4100000060C0CE3241000000A025122F41000000E09ACE3241000000C034122F410000006075CE3241000000A043122F41000000E04DCE3241000000405D122F410000008026CE3241000000A077122F41000000600CCE32410000006085122F4100000000F2CD32410000004092122F41000000A0C8CD324100000040A5122F41000000009FCD3241000000A0B4122F41000000E075CD324100000000BE122F41000000804CCD324100000040C4122F41000000802FCD3241000000A0C8122F410000008012CD3241000000C0CA122F41000000A0EACC324100000060C5122F41000000E0C2CC324100000060C0122F4100000080A7CC324100000000C2122F41000000608CCC324100000040C8122F41000000A06ECC324100000000D9122F41000000C051CC3241000000C0EF122F410000002035CC3241000000C00A132F41000000C018CC3241000000C027132F4100000080F2CB3241000000A04C132F41000000A0CBCB3241000000C06E132F41000000A0A4CB3241000000408E132F41000000A07CCB324100000060A4132F410000006061CB324100000040A8132F41000000C045CB324100000040A9132F41000000201BCB3241000000A0AC132F4100000060F0CA324100000060B0132F4100000080C8CA324100000040B4132F41000000E0A0CA3241000000C0BA132F410000006077CA324100000060C7132F41000000A04ECA324100000040DB132F41000000002BCA324100000000F8132F410000002008CA3241000000C019142F4100000060E1C932410000006045142F41000000A0B9C93241000000406A142F41000000409EC932410000000075142F410000004082C93241000000607C142F41000000205BC932410000000088142F410000000034C932410000006093142F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('112','2940.958157','ROAD3','PL2031','3823','4371','3822','4370','RICH HILL RD',NULL,NULL,'3823','3822','4371','4370','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('113','1358.132474','ROAD4','PL2031','101','359','100','358','WALLACE RD',NULL,NULL,'101','100','359','358','Right','roadswest.dbf','0.26','40','0.3900','10.5282',NULL,'1',NULL,NULL,'WALLACE','RD',NULL,'010500000001000000010200000036000000000000A0CED132410000000090102F41000000E0CDD13241000000406C102F4100000040C4D13241000000403D102F4100000040BAD13241000000C00E102F41000000A0AFD1324100000060E40F2F4100000060A5D1324100000060B80F2F41000000409ED13241000000008B0F2F410000004098D13241000000605D0F2F410000008090D13241000000A01B0F2F41000000A088D1324100000000DB0E2F41000000407FD13241000000A0A70E2F410000006077D1324100000040710E2F410000006076D13241000000A03D0E2F410000006077D13241000000A00B0E2F410000002077D1324100000040E10D2F410000000078D13241000000C0B50D2F41000000007CD1324100000000880D2F410000000081D13241000000A05B0D2F410000008085D1324100000040340D2F410000008089D13241000000C00C0D2F41000000208CD13241000000A0EE0C2F41000000C08DD13241000000C0D00C2F41000000008ED1324100000000AE0C2F41000000608BD13241000000A08E0C2F41000000E080D13241000000C06B0C2F41000000E071D13241000000404A0C2F41000000E05CD13241000000C01F0C2F41000000E046D13241000000A0F50B2F41000000802ED1324100000040BC0B2F410000000016D1324100000040860B2F4100000060F9D0324100000000570B2F4100000040DAD0324100000000300B2F41000000A0C7D03241000000C0200B2F4100000000B4D0324100000040100B2F41000000A09AD03241000000C0ED0A2F410000008083D0324100000000C70A2F41000000606FD03241000000A0A40A2F41000000A05CD03241000000A07E0A2F41000000404AD03241000000A04C0A2F41000000603BD0324100000040160A2F410000006030D03241000000C0CE092F41000000C028D032410000004086092F410000004023D03241000000005B092F41000000401ED03241000000402F092F41000000C017D03241000000A0F5082F41000000C015D03241000000C0B9082F41000000E018D03241000000409A082F41000000801DD03241000000607C082F410000006024D03241000000A059082F41000000402CD032410000004038082F410000008034D032410000006014082F41000000E03ED03241000000A0F1072F410000000049D0324100000000DB072F410000004075D03241000000C094072F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('114','3841.035589','ROAD3','PL2031','351','1071','350','1070','EAST BIG SPRINGS RD',NULL,NULL,'351','350','1071','1070','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('115','5081.424340','ROAD3','PL2031','1073','2023','1072','2022','EAST BIG SPRINGS RD',NULL,NULL,'1073','1072','2023','2022','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('116','1198.078488','ROAD3','PL2031','337','491','336','490','WEST CALHOUN RD',NULL,NULL,'337','336','491','490','Right','roadswest.dbf','0.23','40','0.3450','15.5594',NULL,'1','W',NULL,'CALHOUN','RD',NULL,'01050000000100000001020000001E0000000000000034C932410000006093142F41000000200FC932410000004095142F4100000060EAC83241000000A098142F41000000809CC83241000000C0B0142F41000000804FC83241000000C0D3142F41000000E0FDC73241000000A0FC142F4100000080ADC73241000000C02C152F410000002061C73241000000A068152F410000002015C73241000000A0A7152F4100000000D7C63241000000C0DC152F410000006097C632410000004004162F41000000C082C63241000000A008162F41000000206EC63241000000A00B162F410000008053C63241000000000F162F410000000039C632410000004011162F41000000C01FC63241000000C010162F410000008006C63241000000C00F162F4100000020F2C5324100000040F7152F4100000080DDC53241000000C0DF152F41000000E0BEC5324100000060C2152F41000000009FC53241000000A0AF152F41000000808DC5324100000040AE152F41000000E07BC5324100000040AF152F41000000605BC5324100000060B0152F41000000C03AC53241000000C0B1152F41000000402BC53241000000C0B1152F41000000A01BC53241000000C0B1152F41000000A0F5C43241000000C0B1152F41000000E0CFC43241000000A0B6152F4100000000B0C4324100000000C8152F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('117','4882.338688','ROAD3','PL2031','101','999','100','998','VIRGIL GREER RD',NULL,NULL,'101','100','999','998','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('118','6120.545451','ROAD3','PL2031','557','1707','556','1706','LEE OSBORNE RD',NULL,NULL,'557','556','1707','1706','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('119','3309.821904','ROAD3','PL2032','707','1335','706','1334','LITTLE HORSE CREEK RD',NULL,NULL,'707','706','1335','1334','Right','roadswest.dbf','0.63','40','0.9450','10.5408',NULL,'1',NULL,NULL,'LITTLE HORSE CREEK','RD',NULL,'01050000000100000001020000007800000000000000C0EB324100000040D42B2F41000000A09FEB324100000040012C2F41000000E07DEB3241000000402E2C2F410000000063EB3241000000C0482C2F410000000047EB324100000000612C2F410000000021EB3241000000A07D2C2F4100000040FAEA324100000000992C2F4100000000D6EA324100000000B72C2F4100000020B2EA324100000040D32C2F410000004091EA3241000000C0E52C2F41000000806FEA3241000000C0F92C2F410000000054EA324100000040112D2F41000000A039EA3241000000C0272D2F41000000C01DEA3241000000A0372D2F41000000E000EA3241000000A0482D2F41000000C0E9E93241000000405C2D2F41000000A0D3E93241000000A0732D2F41000000A0B6E93241000000C09A2D2F41000000E09CE93241000000A0CA2D2F41000000C090E9324100000000ED2D2F41000000E085E93241000000C00C2E2F410000004077E93241000000402B2E2F410000002067E93241000000A04A2E2F410000006058E93241000000006C2E2F41000000E049E93241000000608A2E2F410000004036E9324100000060A82E2F41000000E020E9324100000040C22E2F41000000800BE93241000000C0D62E2F4100000040F5E8324100000000E72E2F4100000040E0E83241000000A0F12E2F4100000040CAE83241000000A0FA2E2F4100000000AFE8324100000060072F2F410000000094E83241000000C0142F2F41000000C07DE83241000000A01F2F2F410000004067E83241000000C02D2F2F41000000204DE8324100000040482F2F410000000035E83241000000A0682F2F41000000C022E8324100000000862F2F41000000A011E8324100000040A62F2F410000004004E83241000000A0C52F2F4100000060F7E73241000000C0E12F2F41000000A0E9E7324100000060F72F2F4100000040DAE73241000000C00A302F4100000040CAE73241000000A01C302F4100000040BAE73241000000C029302F4100000040A8E732410000004030302F41000000C094E732410000000033302F41000000007CE732410000000036302F41000000007CE732410000000036302F41000000E063E73241000000A034302F41000000804FE73241000000C02D302F41000000403BE73241000000A023302F41000000C01DE73241000000000D302F410000004000E7324100000000F22F2F4100000020E5E6324100000040DA2F2F4100000020CAE63241000000A0C12F2F4100000060B3E6324100000060AB2F2F41000000009CE6324100000040952F2F410000008086E63241000000C0832F2F410000008071E6324100000040732F2F41000000A051E63241000000A0552F2F410000002031E63241000000A0372F2F410000000018E6324100000040242F2F4100000020FFE53241000000A0112F2F41000000A0E6E53241000000C0FD2E2F41000000E0CEE5324100000040E82E2F41000000C0B7E5324100000060CF2E2F4100000060A2E5324100000060B32E2F410000006090E53241000000A0932E2F41000000007FE5324100000040702E2F41000000E06FE5324100000000512E2F41000000C061E5324100000060312E2F41000000A052E53241000000A0082E2F41000000A041E5324100000060DF2D2F41000000602FE53241000000A0C22D2F41000000801CE53241000000A0A92D2F410000002006E53241000000C08D2D2F41000000C0EFE43241000000A0732D2F41000000E0D7E43241000000A0562D2F41000000C0BFE43241000000C0392D2F4100000080A5E43241000000A01D2D2F41000000C08BE43241000000A0012D2F410000004075E43241000000A0E62C2F41000000205FE4324100000040CA2C2F41000000A043E43241000000C0A42C2F41000000A028E43241000000A07D2C2F410000000014E43241000000A05F2C2F410000000001E43241000000A0402C2F41000000E0EAE3324100000000112C2F4100000060D6E3324100000040DD2B2F4100000060C2E3324100000060A62B2F4100000080AFE33241000000A06E2B2F41000000009AE33241000000C01B2B2F41000000407DE33241000000C0DA2A2F410000000070E3324100000040A22A2F410000000063E3324100000040742A2F410000000054E33241000000A0482A2F41000000C046E33241000000A02D2A2F410000006038E33241000000C0152A2F410000004029E33241000000A0022A2F41000000001AE3324100000040F1292F41000000E0E8E2324100000000BD292F4100000000B8E23241000000A089292F41000000009EE23241000000C06A292F41000000C083E23241000000A04B292F41000000E075E23241000000403B292F41000000A066E23241000000402C292F41000000E051E23241000000C020292F41000000A03CE23241000000601B292F410000002022E23241000000A01B292F410000004008E23241000000401F292F4100000060DBE132410000006024292F4100000080AEE13241000000A029292F410000002083E13241000000C02C292F41000000C057E13241000000602F292F410000006031E132410000000030292F41000000800AE13241000000A032292F4100000020EEE03241000000C038292F4100000040D2E032410000004040292F4100000080BDE03241000000C045292F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('120','3998.532730','ROAD3','PL2032','351','1135','350','1134','TUCKER RD',NULL,NULL,'351','350','1135','1134','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('121','1025.858584','ROAD3','PL2032','101','303','100','302','STIDHAMS RD',NULL,NULL,'101','100','303','302','Right','roadswest.dbf','0.19','40','0.2850','10.1570',NULL,'1',NULL,NULL,'STIDHAMS','RD',NULL,'01050000000100000001020000002A000000000000200FE63241000000A0D1672F41000000E012E63241000000A02B682F410000008012E632410000004054682F410000000009E63241000000008F682F41000000A0FBE53241000000A0B8682F4100000040EFE5324100000000E4682F4100000020EBE53241000000A006692F4100000080EAE53241000000C02A692F41000000C0EDE53241000000A052692F41000000E0F3E53241000000407B692F4100000020FAE53241000000A0A0692F410000004001E6324100000040C4692F410000004009E6324100000060E1692F410000002011E63241000000A0026A2F41000000A013E63241000000A02A6A2F41000000C014E63241000000004F6A2F41000000C01AE6324100000000816A2F410000000022E6324100000040B56A2F41000000A024E6324100000060D26A2F410000004034E6324100000040126B2F410000004044E63241000000003B6B2F41000000A050E63241000000A0676B2F41000000605CE63241000000A0926B2F41000000E068E63241000000A0BA6B2F410000002076E63241000000C0E16B2F410000000088E63241000000A0116C2F41000000609AE63241000000C0416C2F41000000A0AFE63241000000407E6C2F41000000C0C4E6324100000000BA6C2F4100000000D6E63241000000C0E56C2F4100000060E7E63241000000C0126D2F4100000000F5E63241000000A03C6D2F410000000002E73241000000C0656D2F410000002010E73241000000A08E6D2F41000000801EE7324100000040B76D2F41000000402EE7324100000040E26D2F41000000C03DE73241000000400E6E2F41000000404AE7324100000060366E2F410000004056E73241000000605E6E2F41000000C065E73241000000408F6E2F410000006074E7324100000040C26E2F41000000607AE7324100000000E06E2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('122','5087.852217','ROAD3','PL2032','471','1419','470','1418','COY HAM RD',NULL,NULL,'471','470','1419','1418','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('123','171.191873','ROAD3','PL2032','1421','1451','1420','1450','COY HAM RD',NULL,NULL,'1421','1420','1451','1450','Right','roadswest.dbf','0.03','40','0.0450','11.4128',NULL,'1',NULL,NULL,'COY HAM','RD',NULL,'010500000001000000010200000009000000000000A02CCA3241000000C0813B2F410000000015CA3241000000407B3B2F410000008000CA324100000040773B2F41000000A0EDC93241000000C0763B2F41000000E0D9C9324100000040763B2F4100000020CAC93241000000A0723B2F4100000080BAC93241000000406D3B2F4100000000A1C93241000000A05E3B2F410000004083C9324100000040643B2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('124','3825.553708','ROAD4','PL2032','231','1017','230','1016','FULBRIGHT FARM RD',NULL,NULL,'231','230','1017','1016','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('125','635.667411','ROAD4','PL2032','101','229','100','228','FULBRIGHT FARM RD',NULL,NULL,'101','100','229','228','Right','roadswest.dbf','0.12','40','0.1800','9.9324',NULL,'1',NULL,NULL,'FULBRIGHT FARM','RD',NULL,'01050000000100000001020000001000000000000060EFD93241000000A0683C2F41000000C0F3D93241000000A0253D2F41000000A0E9D93241000000A07A3D2F4100000000D1D93241000000A0B33D2F41000000C0CAD93241000000A0E03D2F4100000020A9D93241000000A0613E2F410000002099D93241000000008F3E2F41000000C083D9324100000040F73E2F41000000E077D93241000000A05F3F2F41000000A073D93241000000C0913F2F410000006060D9324100000040CD3F2F41000000004CD93241000000C0FF3F2F41000000A03CD932410000006042402F410000002026D9324100000040AC402F41000000A022D9324100000060CE402F41439002FE26D93241BCC2C59AF7402F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('126','1618.950501','ROAD3','PL2032','101','409','100','408','PENNINGTON HOLLOW RD',NULL,NULL,'101','100','409','408','Right','roadswest.dbf','0.31','40','0.4650','10.5126',NULL,'1',NULL,NULL,'PENNINGTON HOLLOW','RD',NULL,'0105000000010000000102000000230000000000002034DA324100000040D92F2F410000004033DA3241000000003D302F410000000032DA3241000000C0A0302F410000002030DA3241000000C0F6302F41000000602DDA3241000000A04C312F410000008027DA324100000040C3312F41000000E020DA3241000000C039322F41000000A01ADA3241000000C0B9322F410000000014DA3241000000A039332F41000000600BDA3241000000A0C1332F41000000C002DA32410000006049342F4100000060FCD9324100000040BA342F41000000E0F7D93241000000402B352F41000000C0F5D93241000000A097352F4100000080F8D932410000004003362F410000006002DA3241000000A055362F41000000600CDA324100000040A8362F41000000E00FDA3241000000C0FB362F410000004010DA3241000000C04F372F41000000400EDA324100000040B7372F410000004009DA3241000000401E382F41000000A003DA3241000000C06C382F41000000C0FCD9324100000060BB382F41000000A0F2D93241000000A018392F41000000E0E9D932410000004076392F4100000040E7D93241000000C0DC392F41000000E0E5D93241000000A0433A2F41000000A0E0D93241000000A09B3A2F4100000020DCD9324100000060F33A2F4100000060DCD93241000000C0433B2F41000000C0DED9324100000040943B2F4100000040E3D9324100000040EA3B2F4100000080E8D93241000000C03F3C2F4100000060EFD93241000000A0683C2F4100000060EFD93241000000A0683C2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('127','83.639130','ROAD3','PL2032','2457','2471','2456','2470','TUCKER RD',NULL,NULL,'2457','2456','2471','2470','Right','roadswest.dbf','0.02','40','0.0300','11.9484',NULL,'1',NULL,NULL,'TUCKER','RD',NULL,'01050000000100000001020000000800000000000080F6D1324100000000E06E2F4100000020EDD1324100000000D56E2F41000000E0E0D1324100000060CE6E2F4100000080D4D1324100000000CC6E2F4100000080C6D13241000000A0CE6E2F4100000020B9D1324100000060D46E2F4100000060A8D1324100000060DE6E2F41B76DDB16A6D1324100000000E06E2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('128','286.363431','ROAD3','PL2032','101','153','100','152','WHENLIN RIDGE RD',NULL,NULL,'101','100','153','152','Right','roadswest.dbf','0.05','40','0.0750','11.0140',NULL,'1',NULL,NULL,'WHENLIN RIDGE','RD',NULL,'01050000000100000001020000000A00000000000000A6CD3241000000C0E86D2F41000000C075CD324100000060276E2F41000000605ECD324100000040306E2F410000006044CD3241000000C0366E2F410000004029CD324100000060446E2F41000000A013CD324100000000506E2F4100000000FECC3241000000605F6E2F4100000080E3CC3241000000A07E6E2F4100000020CBCC3241000000A0A36E2F41000000E0AACC324100000000E06E2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('129','3740.783922','ROAD3','PL2032','2559','3293','2558','3292','TUCKER RD',NULL,NULL,'2559','2558','3293','3292','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('130','2768.430640','ROAD3','PL2032','1453','1967','1452','1966','COY HAM RD',NULL,NULL,'1453','1452','1967','1966','Right','roadswest.dbf','0.52','40','0.7800','10.7722',NULL,'1',NULL,NULL,'COY HAM','RD',NULL,'01050000000100000001020000006B0000000000004083C9324100000040643B2F41000000807AC93241000000407F3B2F410000008069C93241000000A08B3B2F410000002057C93241000000C0953B2F410000004045C93241000000409E3B2F41000000602CC93241000000A0A23B2F410000004012C93241000000A0A73B2F41000000A0F9C83241000000A0B13B2F4100000060E2C8324100000000C53B2F4100000060D6C83241000000A0D83B2F4100000040C7C8324100000000F73B2F4100000060BAC83241000000A0193C2F41000000E0B2C8324100000040333C2F41000000E0ACC83241000000604F3C2F4100000000A9C83241000000A0793C2F41000000C0A7C8324100000040A33C2F41000000A0A6C8324100000000C53C2F4100000020A6C8324100000000003D2F4100000000A3C83241000000A0293D2F410000006097C83241000000A0473D2F410000008084C83241000000A04E3D2F41000000C06EC8324100000000583D2F410000008059C8324100000040613D2F410000002046C83241000000A0673D2F410000008032C83241000000C06E3D2F41000000C01CC8324100000000793D2F410000008007C83241000000A08A3D2F41000000C0F7C7324100000060A73D2F4100000020EBC73241000000A0C83D2F4100000000E0C73241000000A0F03D2F4100000060D6C73241000000A0193E2F41000000A0C8C73241000000C05C3E2F41000000E0ACC7324100000000AB3E2F4100000000A0C73241000000C0BE3E2F410000002092C7324100000000D33E2F410000000084C73241000000C0E43E2F410000002071C7324100000040F63E2F41000000205DC7324100000000053F2F41000000804EC73241000000A00E3F2F41000000803FC7324100000040183F2F410000004022C73241000000402E3F2F41000000A005C7324100000060473F2F4100000080F0C63241000000405D3F2F4100000020DCC63241000000A0753F2F41000000C0C6C6324100000000923F2F41000000C0B2C6324100000000B23F2F41000000C09EC6324100000000D73F2F41000000208EC632410000004003402F410000008086C63241000000C031402F410000006083C63241000000C061402F41000000C084C63241000000C099402F41000000A088C6324100000000D0402F41000000808BC63241000000C019412F41000000C08FC63241000000C064412F410000000097C6324100000060AB412F41000000A09FC63241000000C0F0412F4100000040A8C63241000000402D422F41000000A0AFC632410000004069422F4100000060B3C6324100000040A6422F4100000020A5C6324100000000D0422F41000000C095C63241000000A0F9422F410000000087C632410000004025432F41000000E079C632410000000063432F41000000606EC63241000000A09F432F410000006060C63241000000A0D9432F410000004050C63241000000A00F442F41000000C037C63241000000C047442F41000000C01BC63241000000407B442F410000004000C63241000000A0A5442F41000000C0E3C5324100000040CF442F41000000E0CAC53241000000C0F3442F41000000A0B2C53241000000A01B452F41000000E09FC532410000000042452F41000000608EC53241000000606A452F41000000807AC53241000000009D452F410000002068C53241000000C0D1452F410000004059C5324100000040FE452F41000000004DC532410000004030462F41000000004BC53241000000C07D462F41000000204FC5324100000000CA462F410000004051C532410000006014472F410000008052C53241000000A05E472F410000004051C5324100000040A9472F41000000004DC53241000000C0F2472F41000000C045C532410000004031482F41000000203CC53241000000406F482F41000000C031C5324100000000A7482F410000006026C5324100000060DE482F410000002016C532410000000027492F410000004007C532410000006072492F4100000060FEC4324100000000C1492F4100000000F8C43241000000A00F4A2F41000000C0F2C43241000000A04C4A2F41000000C0EDC43241000000C0894A2F41000000C0EAC43241000000C09C4A2F41000000C0E9C43241000000A0B04A2F4100000040EAC4324100000000C94A2F4100000060EBC43241000000A0E14A2F4100000080EEC43241000000A00F4B2F41000000C0EEC43241000000003D4B2F41000000C0ECC43241000000604E4B2F41000000E0E9C43241000000605F4B2F41000000A0E0C4324100000060804B2F41000000C0D5C43241000000C09F4B2F4100000040BCC4324100000000EF4B2F4100000000B0C4324100000060124C2F4100000000B0C4324100000060124C2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('131','904.778796','ROAD3','PL2032','3295','3471','3294','3470','TUCKER RD',NULL,NULL,'3295','3294','3471','3470','Right','roadswest.dbf','0.17','40','0.2550','10.2816',NULL,'1',NULL,NULL,'TUCKER','RD',NULL,'01050000000100000001020000000D0000000000008000C63241000000C0335E2F4100000020D6C53241000000C0EC5D2F41000000C0AFC5324100000040A75D2F41000000809FC53241000000A0385D2F41000000C097C5324100000060F65C2F41000000E07DC53241000000A08D5C2F410000000060C53241000000C02C5C2F41000000E039C53241000000A0665B2F41000000E01EC53241000000A0BB5A2F41000000E001C53241000000A0135A2F4100000060DBC43241000000404D592F41000000C0BFC432410000004077582F4100000000B0C43241000000C0C7572F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('132','2058.334870','ROAD3','PL2032','101','483','100','482','JOHN ALLEY RD',NULL,NULL,'101','100','483','482','Right','roadswest.dbf','0.39','40','0.5850','10.7766',NULL,'1',NULL,NULL,'JOHN ALLEY','RD',NULL,'01050000000100000001020000005E0000000000004083C9324100000040643B2F410000006074C93241000000A0513B2F41000000A04FC93241000000404F3B2F410000008030C93241000000404C3B2F41000000C01CC9324100000060493B2F41000000A009C93241000000C0473B2F41000000E0F5C83241000000404A3B2F4100000080DEC83241000000A04D3B2F4100000000C6C83241000000A0553B2F41000000C0ABC83241000000C06E3B2F41000000A09AC83241000000C0873B2F41000000008AC83241000000C0B33B2F410000000082C83241000000A0D03B2F41000000A07AC83241000000C0EE3B2F410000008073C83241000000000F3C2F41000000406CC8324100000000303C2F41000000E063C8324100000040543C2F410000008060C8324100000060753C2F41000000604BC8324100000040963C2F41000000A032C8324100000040A73C2F410000006024C8324100000040B53C2F410000000014C8324100000000C03C2F4100000000F3C7324100000040C13C2F4100000060E1C73241000000A0C33C2F41000000E0CEC73241000000C0CA3C2F41000000E0CEC73241000000C0CA3C2F4100000000C0C7324100000000CA3C2F41000000A0A8C7324100000000B83C2F41000000609DC73241000000A0953C2F41000000009CC7324100000060623C2F4100000080A0C7324100000060453C2F4100000020ADC73241000000C0133C2F41000000A0BBC73241000000A0D93B2F4100000080CBC73241000000A09F3B2F4100000040D9C7324100000000763B2F4100000060E7C73241000000C04D3B2F4100000000F7C73241000000C0213B2F41000000C002C83241000000A0F13A2F41000000A00BC8324100000060BD3A2F410000006010C83241000000A0A03A2F410000008011C83241000000A06A3A2F410000008007C8324100000040413A2F4100000020F9C73241000000001A3A2F4100000020E1C7324100000060E0392F4100000060CDC73241000000C0BA392F41000000A0BFC73241000000609F392F4100000000B2C73241000000C082392F41000000E0A1C73241000000A055392F41000000A091C73241000000C02E392F410000008083C73241000000A01D392F410000006073C73241000000A00B392F41000000A05BC73241000000C0E9382F41000000A054C73241000000C0BB382F410000004051C73241000000C082382F410000000050C732410000000052382F410000000047C732410000000020382F41000000403FC7324100000040F6372F410000002032C73241000000A0DB372F410000004025C73241000000A0CA372F410000002014C7324100000040C4372F4100000020FEC6324100000060C7372F41000000A0E9C63241000000A0CE372F41000000A0D2C63241000000A0D9372F41000000A0BBC63241000000A0E1372F4100000020A5C63241000000C0E9372F41000000C087C63241000000C0F0372F41000000C087C63241000000C0F0372F41000000A076C6324100000060EF372F410000000064C63241000000C0EA372F410000008051C63241000000A0E2372F410000004043C63241000000C0D7372F41000000E024C63241000000C0C1372F410000004013C63241000000C0B6372F4100000020FAC53241000000C0A4372F4100000060E1C53241000000A091372F4100000040C8C53241000000007D372F4100000080BAC53241000000C06D372F41000000A0ADC53241000000405C372F4100000040A0C53241000000C044372F410000000095C53241000000C026372F41000000608BC53241000000C008372F41000000E079C53241000000C0DB362F41000000C06EC5324100000040BD362F41000000C063C53241000000A09D362F41000000605AC53241000000A07A362F410000004050C53241000000405E362F410000000044C53241000000604D362F410000006036C53241000000C03C362F410000002028C53241000000602C362F41000000400EC532410000004008362F41000000A0F4C43241000000C0E9352F4100000060DFC4324100000040DC352F4100000020D0C43241000000A0CF352F4100000000B0C4324100000040D6352F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('133','1334.295146','ROAD3','PL2032','101','349','100','348','EAST BIG SPRINGS RD',NULL,NULL,'101','100','349','348','Right','roadswest.dbf','0.25','40','0.3750','10.7604',NULL,'1','E',NULL,'BIG SPRINGS','RD',NULL,'01050000000100000001020000002C00000000000080BDE03241000000C045292F41000000C0B3E03241000000C002292F4100000020AFE0324100000060E5282F4100000060AAE03241000000C0C7282F4100000060A3E03241000000409D282F41000000209CE03241000000A072282F410000000090E03241000000002E282F410000006083E0324100000000EA272F410000008076E03241000000A0A2272F410000002068E03241000000405B272F41000000805CE03241000000C02D272F41000000C051E032410000006002272F410000000047E0324100000040BE262F41000000E03CE032410000006077262F41000000A034E03241000000C047262F41000000C02AE032410000006018262F41000000001DE03241000000A0EB252F41000000000DE0324100000040A6252F41000000A008E03241000000C087252F410000006001E03241000000A065252F41000000E0F8DF32410000004045252F4100000080EADF32410000000019252F4100000000DEDF3241000000A0F8242F41000000C0D0DF324100000060D9242F41000000E0C0DF324100000000B6242F41000000C0B2DF32410000004095242F4100000000A4DF3241000000C073242F41000000608CDF32410000004048242F410000008075DF3241000000001E242F41000000E05FDF3241000000C0EC232F41000000004BDF324100000060B9232F410000004031DF32410000006078232F410000002017DF3241000000A037232F4100000040FDDE324100000000FD222F4100000020E3DE3241000000C0C3222F4100000080CADE3241000000408E222F4100000080B1DE32410000004059222F41000000808EDE32410000000014222F41000000A06BDE324100000060CF212F41000000C050DE3241000000C095212F41000000E035DE3241000000C05B212F410000002020DE3241000000402D212F41000000000ADE324100000040FF202F4100000060E9DD324100000000C0202F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('134','1989.299705','ROAD3','PL2032','101','469','100','468','COY HAM RD',NULL,NULL,'101','100','469','468','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('135','6129.347203','ROAD3','PL2032','1137','2341','1136','2340','TUCKER RD',NULL,NULL,'1137','1136','2341','2340','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('136','2800.441165','ROAD3','PL2033','537','1093','536','1092','STIDHAMS RD',NULL,NULL,'537','536','1093','1092','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('137','2085.011132','ROAD3','PL2033','765','1161','764','1160','EAST WHENLIN RIDGE RD',NULL,NULL,'765','764','1161','1160','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('138','1170.823562','ROAD3','PL2033','305','535','304','534','STIDHAMS RD',NULL,NULL,'305','304','535','534','Right','roadswest.dbf','0.22','40','0.3300','10.1810',NULL,'1',NULL,NULL,'STIDHAMS','RD',NULL,'01050000000100000001020000002D000000000000607AE7324100000000E06E2F41000000E081E7324100000040036F2F41000000C08DE73241000000402A6F2F41000000409CE73241000000C0456F2F4100000060B6E73241000000C0536F2F4100000040D0E73241000000A0706F2F4100000000DBE73241000000C0A56F2F41000000C0DBE7324100000040E16F2F41000000C0D9E73241000000601A702F4100000080DCE73241000000404E702F4100000000E8E732410000000078702F4100000080F8E7324100000040A1702F410000000008E83241000000C0C8702F410000004018E83241000000A0EE702F41000000E02DE83241000000601B712F410000002044E83241000000C047712F410000006057E83241000000A06E712F41000000206AE83241000000A098712F41000000007DE83241000000A0D5712F41000000808EE83241000000A010722F41000000A098E832410000006028722F4100000060A3E832410000000046722F41000000C0A6E832410000006084722F4100000000A4E8324100000040C0722F4100000020A6E83241000000C0E6722F41000000A0A3E832410000004011732F410000004098E83241000000A02C732F41000000A086E83241000000A050732F410000008076E83241000000C058732F41000000604AE83241000000606E732F41000000E02CE83241000000C086732F410000002014E83241000000009F732F4100000060FBE73241000000A0B9732F41000000E0EAE7324100000040C9732F41000000A0DDE7324100000060DA732F4100000040D3E7324100000000F6732F4100000040CCE732410000006017742F4100000000C9E73241000000604F742F4100000080C6E73241000000A074742F4100000000C5E7324100000000B9742F4100000040BFE7324100000040FF742F4100000040ABE732410000006039752F410000006097E73241000000406D752F41000000808CE7324100000060A8752F410000004080E7324100000060EC752F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('139','14.554974','ROAD3','PL2033','2473','2473','2472','2472','TUCKER RD',NULL,NULL,'2473','2472','2473','2472','Right','roadswest.dbf','0.00','40','0.0000','0',NULL,'1',NULL,NULL,'TUCKER','RD',NULL,'010500000001000000010200000002000000B76DDB16A6D1324100000000E06E2F410000006098D13241000000C0E96E2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('140','392.089852','ROAD3','PL2033','2379','2455','2378','2454','TUCKER RD',NULL,NULL,'2379','2378','2455','2454','Right','roadswest.dbf','0.07','40','0.1050','10.3182',NULL,'1',NULL,NULL,'TUCKER','RD',NULL,'010500000001000000010200000015000000000000002DD33241000000602E702F410000002016D332410000000037702F41000000400DD33241000000C04E702F410000006000D33241000000C05F702F4100000020E2D23241000000C060702F4100000020E2D23241000000C060702F4100000040CED23241000000004C702F41000000E0BCD23241000000002B702F4100000000AFD23241000000A007702F41000000A09FD2324100000000E26F2F41000000E08CD2324100000060C66F2F41000000A079D2324100000040AF6F2F41000000C06CD23241000000609F6F2F41000000405FD2324100000000906F2F41000000E04CD23241000000A07F6F2F41000000C03CD23241000000006F6F2F41000000802DD23241000000C0516F2F41000000A01ED23241000000002F6F2F410000004011D2324100000040106F2F41000000A002D23241000000A0F26E2F4100000080F6D1324100000000E06E2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('141','424.540846','ROAD3','PL2033','2475','2557','2474','2556','TUCKER RD',NULL,NULL,'2475','2474','2557','2556','Right','roadswest.dbf','0.08','40','0.1200','10.3546',NULL,'1',NULL,NULL,'TUCKER','RD',NULL,'0105000000010000000102000000120000000000006098D13241000000C0E96E2F41000000007AD13241000000C0FE6E2F41000000A05BD1324100000040156F2F41000000C038D13241000000C0326F2F410000006016D13241000000A04F6F2F4100000060F8D0324100000000636F2F41000000A0D9D0324100000000766F2F41000000A0C3D0324100000040876F2F4100000060AED0324100000040946F2F410000008096D03241000000A0996F2F410000008096D03241000000A0996F2F41000000407FD0324100000040956F2F41000000406DD03241000000A0886F2F41000000405DD0324100000060756F2F41000000004FD03241000000A0546F2F410000004042D03241000000402C6F2F410000000038D03241000000C00A6F2F41000000202BD0324100000000E06E2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('142','177.861450','ROAD3','PL2033','2343','2377','2342','2376','TUCKER RD',NULL,NULL,'2343','2342','2377','2376','Right','roadswest.dbf','0.03','40','0.0450','10.4624',NULL,'1',NULL,NULL,'TUCKER','RD',NULL,'010500000001000000010200000004000000000000C002D3324100000000E06E2F41000000400DD33241000000603C6F2F41000000401BD332410000004012702F41000000002DD33241000000602E702F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('143','959.673708','ROAD3','PL2033','3415','3593','3414','3592','WHENLIN RIDGE RD',NULL,NULL,'3415','3414','3593','3592','Right','roadswest.dbf','0.18','40','0.2700','10.7828',NULL,'1',NULL,NULL,'WHENLIN RIDGE','RD',NULL,'01050000000100000001020000001B000000000000A066C532410000000000BD2F41000000008FC5324100000000E0BC2F41000000E0AEC53241000000A0C2BC2F41000000C0DDC532410000000096BC2F41000000800DC63241000000C06BBC2F410000006022C63241000000A05BBC2F410000004038C63241000000604DBC2F410000004064C63241000000C03FBC2F41000000E08FC632410000006038BC2F4100000080B7C63241000000C02BBC2F41000000C0DFC632410000004020BC2F4100000040F6C63241000000A01BBC2F41000000A00CC73241000000C017BC2F410000000036C732410000000013BC2F410000000060C73241000000A014BC2F41000000408CC73241000000A023BC2F4100000080B7C73241000000003ABC2F4100000020DDC732410000004053BC2F410000000002C83241000000A06ABC2F410000002023C83241000000C076BC2F410000000045C83241000000C080BC2F410000000067C832410000004089BC2F410000004089C832410000004097BC2F41000000A0A4C83241000000A0AFBC2F4100000020BEC8324100000000CABC2F4100000080EAC83241000000A0EDBC2F4100000000FFC832410000000000BD2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('144','1356.977604','ROAD3','PL2033','101','297','100','296','GANDER TOWN RD',NULL,NULL,'101','100','297','296','Right','roadswest.dbf','0.26','40','0.3900','13.8468',NULL,'1',NULL,NULL,'GANDER TOWN','RD',NULL,'0105000000010000000102000000280000000000002025C9324100000060E2792F41000000800EC9324100000060EB792F41000000C0F9C8324100000040F5792F41000000E0DAC8324100000040F2792F4100000060BCC8324100000000E4792F41000000809EC8324100000000C4792F410000004081C83241000000C0AE792F41000000A069C83241000000A0BD792F41000000C053C83241000000A0D9792F41000000C03CC8324100000040137A2F41000000002AC8324100000040567A2F41000000C013C83241000000409B7A2F4100000060FFC7324100000040E27A2F4100000020F2C73241000000C0217B2F4100000080E5C73241000000A0627B2F4100000020D6C73241000000A0B87B2F41000000E0BFC7324100000000027C2F4100000020A7C73241000000A01F7C2F41000000208BC7324100000040367C2F41000000607CC7324100000060417C2F41000000C06DC73241000000A04C7C2F410000008041C73241000000A07D7C2F41000000A016C73241000000C0B37C2F4100000080F4C6324100000000E27C2F4100000080D0C63241000000A0037D2F4100000080BFC63241000000A0067D2F4100000020AEC63241000000A0077D2F41000000C07BC6324100000040177D2F410000008049C63241000000A0287D2F410000002014C6324100000060307D2F41000000A0DEC5324100000040367D2F4100000080B0C53241000000C03D7D2F410000006082C5324100000040457D2F410000002060C53241000000C0497D2F410000002055C53241000000604B7D2F41000000E027C53241000000C04D7D2F41000000A0FFC43241000000A0487D2F4100000060D7C43241000000A0417D2F41000000C0C3C43241000000603F7D2F4100000000B0C43241000000403D7D2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('145','8514.383985','ROAD3','PL2033','155','1751','154','1750','WHENLIN RIDGE RD',NULL,NULL,'155','154','1751','1750','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('146','9632.465413','ROAD3','PL2033','1163','2993','1162','2992','EAST WHENLIN RIDGE RD',NULL,NULL,'1163','1162','2993','2992','Right','roadswest.dbf','1.82','40','2.7300','10.5272',NULL,'1','E',NULL,'WHENLIN RIDGE','RD',NULL,'010500000001000000010200000093010000000000E01FE532410000004097822F41000000C00AE532410000004074822F4100000040F5E43241000000A049822F4100000080DFE43241000000C01D822F4100000080D0E432410000004003822F4100000040C2E43241000000C0E8812F4100000060AFE43241000000C0BE812F41000000E0A4E43241000000A0A5812F41000000A09AE43241000000A08C812F41000000608EE43241000000606C812F410000002080E43241000000604D812F41000000206FE432410000000037812F41000000405CE432410000000027812F410000006045E432410000000022812F41000000602FE432410000004021812F41000000401CE43241000000C01D812F41000000A00AE432410000006017812F4100000040F8E33241000000C004812F4100000060E3E33241000000C0F0802F41000000C0C7E3324100000040EB802F4100000060ACE33241000000A0F2802F41000000A09AE33241000000C002812F41000000408BE332410000000011812F41000000E074E33241000000C017812F41000000E074E33241000000C017812F41000000405DE33241000000A016812F410000000047E33241000000C011812F41000000A033E33241000000A004812F410000008027E3324100000040F2802F41000000601DE3324100000040DA802F410000006013E3324100000000AE802F41000000000BE332410000000083802F410000002002E33241000000A057802F41000000C0FAE23241000000C039802F41000000A0F2E23241000000001D802F4100000040E8E2324100000040FD7F2F4100000040DEE23241000000A0DE7F2F4100000060D2E23241000000A0B07F2F4100000020C7E23241000000A0807F2F41000000A0BFE23241000000C0617F2F4100000040B7E23241000000C0427F2F4100000060ACE2324100000060267F2F4100000000A3E23241000000C00C7F2F41000000E09BE2324100000000E97E2F41000000C095E2324100000040C17E2F41000000808DE2324100000060947E2F410000008085E23241000000A0687E2F41000000C07FE23241000000A0427E2F410000006077E23241000000C01B7E2F410000006067E23241000000C0F67D2F41000000A052E23241000000C0DD7D2F410000002040E2324100000060D77D2F41000000402DE2324100000040DC7D2F41000000C01EE23241000000C0EF7D2F410000000013E2324100000040077E2F410000006001E2324100000040317E2F4100000040F2E13241000000405F7E2F4100000040E1E1324100000040A17E2F41000000C0D2E1324100000040E57E2F41000000C0C9E1324100000000107F2F41000000C0C0E13241000000C03A7F2F4100000000B3E1324100000040797F2F41000000A0A5E13241000000A0B87F2F41000000609BE13241000000A0F27F2F410000004092E13241000000A02D802F41000000208AE13241000000C07A802F41000000E07EE1324100000060C2802F41000000E075E13241000000A0E3802F41000000206BE13241000000C0FB802F41000000C05CE132410000006005812F41000000E049E13241000000A00B812F41000000E035E13241000000A015812F410000008022E13241000000A01F812F41000000200FE132410000006028812F41000000A0FBE03241000000A032812F4100000020E4E032410000004042812F4100000040CDE03241000000A057812F4100000080B9E032410000006077812F4100000080A7E032410000006099812F410000006093E03241000000A0C0812F41000000E07EE0324100000000E0812F410000006070E03241000000C0EA812F410000002060E0324100000040F4812F41000000204CE03241000000C0FD812F41000000C037E032410000000009822F41000000C01CE03241000000A01F822F410000002003E032410000004039822F4100000020ECDF32410000004050822F4100000060D5DF3241000000A069822F4100000060C3DF3241000000A080822F4100000040AEDF3241000000A095822F41000000A098DF3241000000A0AD822F41000000C081DF324100000040D6822F41000000C06EDF3241000000A004832F410000000065DF3241000000A021832F41000000C05CDF3241000000C040832F41000000A057DF3241000000C061832F410000004054DF32410000006083832F410000000052DF3241000000A0BC832F410000006052DF3241000000C0F5832F41000000A053DF3241000000C023842F410000000055DF32410000004051842F41000000E054DF3241000000C087842F410000002054DF3241000000A0BF842F41000000E053DF324100000040EC842F410000002052DF32410000006016852F41000000E04CDF32410000006039852F410000000046DF3241000000C05D852F41000000803ADF3241000000C0A0852F41000000E02EDF3241000000A0E3852F410000000022DF3241000000402B862F41000000A015DF32410000006073862F41000000000BDF324100000040B8862F410000006001DF324100000040FD862F4100000040F9DE3241000000C03B872F4100000040F3DE3241000000007C872F4100000040F2DE3241000000A0AB872F4100000060F1DE3241000000C0D8872F4100000040EEDE3241000000C002882F4100000020EADE3241000000C02D882F41000000C0E6DE3241000000A055882F41000000C0E2DE3241000000407C882F4100000040DCDE3241000000C0A9882F4100000060D3DE3241000000C0D3882F41000000E0C6DE3241000000A0F6882F4100000040B8DE3241000000A01A892F41000000C0A8DE32410000000048892F41000000E099DE32410000000075892F41000000C085DE324100000060AD892F410000008071DE324100000040E6892F41000000205EDE324100000040218A2F41000000404ADE3241000000C0588A2F41000000E031DE3241000000C08A8A2F410000004018DE3241000000C0BD8A2F41000000C002DE3241000000C0F48A2F41000000E0EDDD3241000000602C8B2F4100000000E0DD3241000000A0558B2F41000000C0D0DD3241000000A0748B2F41000000E0BCDD3241000000C0818B2F41000000E0BCDD3241000000C0818B2F4100000020A9DD324100000000808B2F41000000609ADD3241000000605A8B2F41000000C093DD324100000040358B2F41000000E08EDD3241000000C0158B2F41000000808BDD324100000040F78A2F41000000608ADD324100000000C78A2F41000000008BDD324100000060948A2F41000000C08ADD324100000000638A2F41000000C08ADD324100000040328A2F41000000C08BDD324100000040E4892F41000000A08DDD3241000000A096892F410000006090DD32410000004062892F410000008091DD3241000000C02B892F41000000008FDD32410000004000892F41000000A08CDD3241000000C0D0882F41000000A089DD324100000040A1882F410000004086DD32410000004073882F410000000080DD3241000000A045882F410000002076DD3241000000A01F882F41000000A069DD324100000040FD872F41000000405ADD324100000040DF872F41000000004ADD324100000040C4872F410000006035DD3241000000C0A5872F41000000E021DD3241000000A087872F410000000014DD3241000000A06A872F410000000005DD3241000000004C872F41000000E0F2DC3241000000A030872F41000000C0DFDC3241000000C018872F41000000E0D0DC32410000004009872F4100000020C2DC324100000040FA862F41000000A0B1DC3241000000A0E9862F4100000060A3DC324100000040D7862F410000002099DC3241000000A0C1862F410000006090DC3241000000C0A8862F410000002086DC3241000000407A862F41000000C07DDC3241000000A047862F410000002079DC32410000004029862F41000000E071DC3241000000A009862F410000002060DC324100000060EB852F41000000604BDC3241000000A0D7852F410000002038DC324100000040CD852F410000004025DC324100000040C6852F410000000008DC324100000000B8852F4100000060EBDB324100000040A7852F41000000E0CBDB3241000000408E852F41000000E0ACDB32410000000070852F41000000A091DB32410000006056852F41000000C074DB32410000004024852F410000006070DB324100000000F9842F410000002073DB324100000000DB842F410000008076DB324100000000B8842F41000000E07ADB3241000000C096842F41000000A084DB3241000000A069842F41000000A08FDB3241000000C03A842F41000000C098DB32410000004008842F4100000000A1DB324100000040D5832F4100000040ABDB3241000000C0A2832F41000000C0B6DB3241000000C071832F4100000040C1DB32410000004050832F4100000040CADB3241000000C029832F4100000040CCDB32410000006005832F4100000060CDDB3241000000C0E4822F4100000060CDDB3241000000C0C2822F4100000040C9DB32410000004093822F4100000020C4DB3241000000C065822F41000000A0C0DB32410000004032822F41000000C0BDDB3241000000C0FD812F41000000A0BBDB324100000040D3812F4100000080B9DB324100000000A9812F4100000000B8DB3241000000A068812F41000000A0B3DB32410000000027812F41000000A0A9DB324100000040F4802F41000000A09DDB3241000000C0C4802F410000002094DB3241000000409F802F41000000A088DB3241000000007A802F410000002077DB32410000006054802F41000000E062DB32410000000035802F41000000A051DB3241000000C021802F41000000C03FDB3241000000A012802F41000000E024DB324100000000FF7F2F410000006008DB324100000040F47F2F4100000080F2DA324100000060F67F2F41000000A0DDDA324100000000FD7F2F41000000C0C7DA32410000006005802F41000000C0B1DA3241000000A010802F410000004091DA32410000004028802F410000000072DA3241000000A044802F41000000A05DDA3241000000A059802F41000000A049DA3241000000C06F802F41000000E037DA32410000000086802F41000000C026DA3241000000A098802F410000004011DA324100000040A4802F4100000060FAD93241000000A0A9802F41000000E0E6D93241000000C0A9802F41000000E0E6D93241000000C0A9802F41000000A0D3D93241000000C0A5802F4100000020BFD93241000000009B802F41000000E0A9D93241000000008D802F41000000A08DD93241000000407D802F41000000A072D93241000000A06A802F41000000C05DD932410000004057802F410000002043D932410000006027802F41000000E03AD93241000000400C802F410000004032D93241000000C0EC7F2F41000000002BD9324100000040CD7F2F41000000A023D93241000000C09E7F2F41000000401DD93241000000406E7F2F41000000E016D93241000000A0427F2F410000008010D93241000000A0177F2F41000000E00AD9324100000000EF7E2F41000000A003D9324100000040C67E2F4100000000F8D83241000000409B7E2F41000000A0E9D8324100000040737E2F4100000080D8D83241000000C0507E2F4100000020C7D8324100000060317E2F41000000E0B8D8324100000040137E2F4100000000AAD83241000000C0F37D2F41000000209DD8324100000040DD7D2F410000000092D83241000000A0C77D2F41000000E084D83241000000A09B7D2F41000000E079D83241000000A0697D2F41000000A072D83241000000C0497D2F41000000006CD83241000000402A7D2F41000000A064D8324100000040047D2F41000000E05DD8324100000040DE7C2F410000006059D8324100000040BF7C2F41000000E053D83241000000C09E7C2F410000000049D83241000000A0787C2F41000000E03BD8324100000040567C2F41000000C02DD8324100000060377C2F41000000001DD83241000000601D7C2F41000000600BD83241000000400C7C2F4100000040F8D7324100000060047C2F41000000A0DFD73241000000C00D7C2F4100000040CDD7324100000040337C2F4100000000C8D7324100000040517C2F41000000E0C5D73241000000C06F7C2F4100000060C4D73241000000A09F7C2F4100000040C2D7324100000000C57C2F41000000C0B6D73241000000C0E87C2F41000000E0A1D7324100000040107D2F41000000E092D7324100000040227D2F410000000083D73241000000A0317D2F41000000E06CD73241000000A03F7D2F410000008056D7324100000040547D2F41000000404AD73241000000406E7D2F410000008041D73241000000408B7D2F41000000C03AD73241000000A0B57D2F41000000603AD7324100000060E17D2F41000000603DD7324100000040FF7D2F41000000C042D73241000000401C7E2F41000000E04CD73241000000A03D7E2F410000006059D73241000000A05C7E2F410000006068D7324100000060757E2F410000002074D73241000000C0A17E2F410000008069D73241000000A0C07E2F41000000205AD73241000000C0C77E2F41000000205AD73241000000C0C77E2F410000000049D7324100000040C77E2F41000000C031D73241000000A0BC7E2F410000006019D73241000000C0AE7E2F410000000008D7324100000040AA7E2F4100000000F7D63241000000C0A67E2F41000000E0E0D63241000000C0A37E2F4100000020CBD63241000000C0A07E2F4100000080B0D63241000000409A7E2F410000004095D6324100000040937E2F41000000807FD6324100000000917E2F41000000A06BD63241000000A08C7E2F41000000A054D63241000000A0797E2F41000000403CD6324100000040637E2F41000000A027D6324100000040567E2F410000004012D63241000000A04E7E2F410000002000D63241000000404F7E2F4100000080EDD5324100000040577E2F41000000C0DDD53241000000C0707E2F4100000040D1D5324100000000857E2F41000000A0BBD53241000000C08A7E2F41000000A0BBD53241000000C08A7E2F41000000C0A6D53241000000C0867E2F41000000A097D5324100000000637E2F41000000C08FD53241000000C0337E2F410000002090D5324100000000F97D2F410000006097D5324100000040BD7D2F41000000C09FD53241000000A08E7D2F4100000000ABD53241000000A0637D2F4100000040B7D53241000000A0447D2F4100000060C4D5324100000040227D2F41000000C0CED53241000000C0F47C2F41000000C0D5D53241000000A0C57C2F4100000020DBD53241000000C08F7C2F41000000C0DBD53241000000A0587C2F41000000A0D4D53241000000401F7C2F41000000C0C7D5324100000040EA7B2F4100000020B5D5324100000060BB7B2F41000000209FD53241000000C0927B2F410000008084D53241000000606C7B2F41000000C069D5324100000040497B2F410000000055D5324100000060287B2F41000000403FD5324100000000077B2F41000000C022D5324100000000E47A2F410000008006D53241000000A0C27A2F4100000080F6D4324100000040AD7A2F4100000060E6D43241000000C0967A2F4100000060D5D43241000000A0807A2F4100000080C6D43241000000C0697A2F4100000060B8D4324100000040437A2F4100000040A8D43241000000A0187A2F41000000C096D4324100000040017A2F41000000E086D4324100000060ED792F41000000C076D4324100000040CD792F41000000C065D43241000000C0A9792F41000000C050D43241000000C088792F41000000E03BD43241000000006A792F410000006022D43241000000C042792F41000000A00AD43241000000A019792F41000000E0F6D33241000000A0EA782F41000000A0E4D3324100000040B7782F4100000060D3D33241000000C083782F41000000E0C4D33241000000C04E782F4100000080BBD33241000000401B782F4100000080B4D3324100000040E5772F41000000C0AFD3324100000040B0772F41000000A0ABD33241000000A079772F41000000E0A6D33241000000C04D772F41000000C0A2D33241000000C022772F4100000040A0D332410000000001772F41000000609FD3324100000060E1762F4100000060A5D3324100000040B2762F4100000000AED33241000000C07E762F41000000E0B2D33241000000A032762F4100000000B7D33241000000A0E8752F4100000060BCD3324100000040B0752F4100000060C4D33241000000607C752F4100000020D8D332410000004044752F4100000020EFD332410000004009752F4100000060FCD33241000000A0D1742F410000002008D43241000000C099742F41000000800FD432410000000070742F41000000C018D43241000000604F742F41000000202ED43241000000A035742F410000008044D43241000000C027742F41000000205CD43241000000401B742F41000000806ED432410000000011742F410000002081D4324100000000DE732F41000000A074D43241000000A0AF732F410000006060D432410000006095732F41000000404ED43241000000C06C732F41000000003FD43241000000403C732F410000008032D43241000000000B732F41000000A026D43241000000A0D7722F410000002019D4324100000060A3722F41000000000BD432410000000070722F410000002000D43241000000604B722F4100000060F5D332410000006027722F41000000A0E6D33241000000C0EE712F41000000E0D6D3324100000000B6712F41000000C0C4D33241000000A082712F41000000C0B1D332410000004051712F41000000E090D33241000000C0FA702F41000000A06DD33241000000A0A7702F41000000A04DD33241000000C069702F41000000002DD33241000000602E702F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('147','13729.944066','ROAD3','PL2033','1483','4109','1482','4108','RIP SHIN RD',NULL,NULL,'1483','1482','4109','4108','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('148','9.691579','ROAD3','PL2034','4111','4111','4110','4110','RIP SHIN RD',NULL,NULL,'4111','4110','4111','4110','Right','roadswest.dbf','0.00','40','0.0000','0',NULL,'1',NULL,NULL,'RIP SHIN','RD',NULL,'0105000000010000000102000000020000005867057872CB32410000000000BD2F41000000C072CB32410000006013BD2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('149','1577.655466','ROAD3','PL2034','3663','3957','3662','3956','WHENLIN RIDGE RD',NULL,NULL,'3663','3662','3957','3956','Right','roadswest.dbf','0.30','40','0.4500','10.7324',NULL,'1',NULL,NULL,'WHENLIN RIDGE','RD',NULL,'01050000000100000001020000003900000000000080EDC9324100000060F8BE2F4100000080F0C932410000000023BF2F4100000060FFC93241000000A02FBF2F41000000E012CA32410000006033BF2F410000004027CA32410000004039BF2F41000000603BCA3241000000C040BF2F41000000E04ECA3241000000C051BF2F410000004062CA3241000000C062BF2F410000004078CA3241000000A06EBF2F41000000808ECA3241000000C073BF2F41000000808ECA3241000000C073BF2F4100000000B7CA3241000000005CBF2F41000000A0DFCA3241000000003BBF2F4100000040F2CA32410000000034BF2F410000002005CB3241000000402FBF2F41000000001ACB3241000000C02ABF2F41000000802ECB3241000000402CBF2F410000002049CB3241000000A043BF2F410000004062CB3241000000A065BF2F410000008080CB3241000000608DBF2F41000000609CCB324100000000BBBF2F41000000E0B3CB324100000040F9BF2F4100000000CBCB32410000006038C02F41000000C0F9CB32410000004085C02F41000000A02DCC324100000040C6C02F41000000C04FCC3241000000C0EFC02F410000002073CC3241000000A013C12F410000006093CC3241000000C02CC12F41000000C0B4CC3241000000C03CC12F4100000020C7CC3241000000403FC12F41000000A0D9CC3241000000A03FC12F41000000A0D9CC3241000000A03FC12F410000006003CD3241000000C038C12F41000000A02ACD3241000000403FC12F410000000041CD3241000000405CC12F410000004056CD3241000000C07FC12F41000000A074CD3241000000A0A6C12F41000000208ECD3241000000A0D4C12F41000000E097CD32410000004006C22F41000000E09ECD3241000000C03BC22F4100000000A8CD32410000004073C22F41000000E0B1CD324100000040AAC22F4100000040B9CD324100000060D3C22F4100000040C3CD3241000000A0F8C22F41000000A0D6CD3241000000A017C32F41000000C0EDCD3241000000602DC32F4100000040FECD32410000000036C32F41000000A00ECE3241000000C03EC32F41000000402ACE3241000000C063C32F410000004043CE3241000000A092C32F410000004064CE324100000000D3C32F410000002084CE32410000000016C42F41000000A092CE32410000004036C42F4100000040A2CE32410000006053C42F41000000C0B0CE32410000004065C42F4100000040C0CE32410000004071C42F41000000C0DACE3241000000A074C42F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('150','534.179631','ROAD3','PL2034','4113','4215','4112','4214','RIP SHIN RD',NULL,NULL,'4113','4112','4215','4214','Right','roadswest.dbf','0.10','40','0.1500','10.4742',NULL,'1',NULL,NULL,'RIP SHIN','RD',NULL,'010500000001000000010200000016000000000000C072CB32410000006013BD2F410000002075CB32410000006065BD2F41000000E071CB3241000000A0B1BD2F41000000E067CB3241000000A0E6BD2F410000004058CB32410000004014BE2F410000000049CB3241000000402CBE2F410000004037CB3241000000A040BE2F410000004016CB3241000000405ABE2F41000000E0F3CA32410000000076BE2F41000000A0DECA3241000000C092BE2F41000000C0CACA3241000000C0B3BE2F4100000000BCCA3241000000C0D8BE2F4100000060A2CA324100000060F8BE2F410000000093CA3241000000C0FABE2F41000000C07ECA324100000060FCBE2F41000000C07ECA324100000060FCBE2F41000000606ACA3241000000C0FBBE2F410000000050CA324100000040FABE2F41000000C038CA3241000000A0F5BE2F41000000C020CA3241000000C0F1BE2F41000000200DCA3241000000C0F2BE2F4100000080EDC9324100000060F8BE2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('151','361.188740','ROAD3','PL2034','3595','3661','3594','3660','WHENLIN RIDGE RD',NULL,NULL,'3595','3594','3661','3660','Right','roadswest.dbf','0.07','40','0.1050','10.9452',NULL,'1',NULL,NULL,'WHENLIN RIDGE','RD',NULL,'01050000000100000001020000000C00000000000000FFC832410000000000BD2F41000000E016C93241000000C015BD2F41000000A03DC932410000000049BD2F410000004061C932410000006083BD2F41000000007DC9324100000040B7BD2F410000002096C9324100000040F0BD2F41000000A0AAC93241000000C02ABE2F4100000020BBC93241000000A06ABE2F4100000080C1C932410000006097BE2F41000000E0C7C9324100000040C0BE2F4100000040D2C9324100000060E5BE2F4100000080EDC9324100000060F8BE2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('152','185.421409','ROAD3','PL2034','3381','3413','3380','3412','WHENLIN RIDGE RD',NULL,NULL,'3381','3380','3413','3412','Right','roadswest.dbf','0.04','40','0.0600','11.5888',NULL,'1',NULL,NULL,'WHENLIN RIDGE','RD',NULL,'01050000000100000001020000000600000000000000B0C43241000000C038BD2F4100000080C9C43241000000A035BD2F4100000060FDC43241000000002CBD2F410000004030C53241000000C01DBD2F41000000E04FC53241000000600EBD2F41000000A066C532410000000000BD2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('153','2657.772930','ROAD3','PL2034','965','1407','964','1406','FARMERS STORE RD',NULL,NULL,'965','964','1407','1406','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('154','397.739245','ROAD4','PL2040','101','171','100','170','MEADOW VIEW LN',NULL,NULL,'101','100','171','170','Right','roadswest.dbf','0.08','40','0.1200','11.3640',NULL,'1',NULL,NULL,'MEADOW VIEW','LN',NULL,'01050000000100000001020000001000000084DB1542CC113341818A5D79F88A2E4100000040CE11334100000040F88A2E4100000020D611334100000040EB8A2E4100000040DD113341000000A0D48A2E41000000C0E011334100000040BD8A2E4100000080E311334100000000A18A2E41000000A0EC113341000000C0608A2E4100000080F511334100000060228A2E41000000E0FD113341000000A0CC892E41000000C0081233410000000076892E410000002017123341000000A035892E41000000002912334100000040F9882E41000000A03D12334100000000C3882E410000004055123341000000A091882E41000000006A1233410000004070882E41000000207F1233410000004051882E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('155','474.656579','ROAD4','PL2040','101','191','100','190','WESTWOOD DR',NULL,NULL,'101','100','191','190','Right','roadswest.dbf','0.09','40','0.1350','10.5480',NULL,'1',NULL,NULL,'WESTWOOD','DR',NULL,'01050000000100000001020000000E000000000000004710334100000040EB882E4100000080571033410000004019892E41000000A074103341000000603D892E41000000809C103341000000006E892E41000000A0CF103341000000A0A6892E41000000A00211334100000000E2892E410000002032113341000000A0268A2E410000000060113341000000606E8A2E41000000E07F11334100000040A38A2E4100000060A011334100000040D58A2E4100000020AC11334100000040E68A2E4100000080B7113341000000C0F28A2E4100000040C411334100000060F98A2E4184DB1542CC113341818A5D79F88A2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('156','590.839351','ROAD3','PL2040','203','329','202','328','MILLER DR',NULL,NULL,'203','202','329','328','Right','roadswest.dbf','0.11','40','0.1650','9.3784',NULL,'1',NULL,NULL,'MILLER','DR',NULL,'010500000001000000010200000015000000000000E09A0A334100000000D3CE2E41000000408C0A3341000000A0FECE2E41000000407B0A33410000004027CF2E41000000C05F0A3341000000A05ECF2E4100000000420A3341000000C090CF2E4100000080210A334100000060BFCF2E4100000020000A3341000000A0EBCF2E41000000A0D7093341000000401FD02E4100000020B2093341000000C058D02E41000000009A0933410000004096D02E41000000808309334100000000D7D02E41000000806E093341000000000FD12E41000000C057093341000000A043D12E41000000004B093341000000A05ED12E41000000803C0933410000006072D12E4100000040320933410000000076D12E4100000080270933410000000076D12E4100000020100933410000006066D12E4100000060FA083341000000A04AD12E4100000000EF083341000000C038D12E4100000000E40833410000004026D12E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('157','478.227019','ROAD3','PL2040','101','201','100','200','MILLER DR',NULL,NULL,'101','100','201','200','Right','roadswest.dbf','0.09','40','0.1350','9.5646',NULL,'1',NULL,NULL,'MILLER','DR',NULL,'01050000000100000001020000000F00000000000060670C33410000006015CE2E4100000080400C3341000000A021CE2E41000000A0190C3341000000A02ECE2E4100000020F90B3341000000603CCE2E41000000A0D80B33410000000049CE2E4100000080B70B3341000000C050CE2E4100000020960B3341000000A055CE2E4100000080720B33410000004056CE2E41000000C04E0B33410000004056CE2E41000000C02C0B3341000000C056CE2E41000000800B0B3341000000405ECE2E4100000040EF0A33410000004071CE2E4100000040D40A3341000000C08ACE2E4100000040B70A3341000000A0ADCE2E41000000E09A0A334100000000D3CE2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('158','289.646503','ROAD3','PL2040','2515','2567','2514','2566','LONG BRANCH RD',NULL,NULL,'2515','2514','2567','2566','Right','roadswest.dbf','0.05','40','0.0750','11.1402',NULL,'1',NULL,NULL,'LONG BRANCH','RD',NULL,'01050000000100000001020000000800000000000000D01233410000004059C32E4100000040BE123341000000A03CC32E41000000009712334100000000FFC22E41000000806C12334100000040CAC22E41000000204112334100000040ABC22E41000000A013123341000000C0A1C22E4100000060EF11334100000060B6C22E4100000020CE113341000000C0D8C22E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('159','891.876338','ROAD3','PL2040','101','269','100','268','MONROE MILLER RD',NULL,NULL,'101','100','269','268','Right','roadswest.dbf','0.17','40','0.2550','10.6176',NULL,'1',NULL,NULL,'MONROE MILLER','RD',NULL,'01050000000100000001020000001200000000000020CE113341000000C0D8C22E4100000040A8113341000000A016C32E410000002087113341000000C05DC32E41000000E064113341000000C0ABC32E410000002046113341000000C000C42E41000000E032113341000000C04DC42E410000002021113341000000409AC42E41000000400A11334100000000F0C42E4100000000F0103341000000C03DC52E41000000C0D71033410000000069C52E41000000E0C6103341000000C086C52E41000000809810334100000060CAC52E41000000006B1033410000004010C62E41000000C03D1033410000004057C62E41000000000A103341000000C0B5C62E4100000040D60F33410000004010C72E41000000E09A0F3341000000C05EC72E41000000405D0F334100000060A9C72E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('160','565.965414','ROAD3','PL2040','2209','2307','2208','2306','GLENN MILLER RD',NULL,NULL,'2209','2208','2307','2306','Right','roadswest.dbf','0.11','40','0.1650','11.5504',NULL,'1',NULL,NULL,'GLENN MILLER','RD',NULL,'01050000000100000001020000001B000000000000C0CEF43241000000A0EDCB2E4100000000CAF4324100000000EDCB2E4100000040C5F43241000000A0ECCB2E41000000C0A9F4324100000040F1CB2E41000000608EF43241000000A0FBCB2E41000000A06EF43241000000600CCC2E41000000E04EF43241000000C01CCC2E41000000802FF432410000006024CC2E41000000E00FF432410000000029CC2E4100000000FAF33241000000A02CCC2E4100000000E4F33241000000402FCC2E4100000080D8F332410000004030CC2E4100000020CDF33241000000A030CC2E41000000C0BAF33241000000402ECC2E4100000080A8F332410000004029CC2E41000000009AF332410000004022CC2E41000000A08BF33241000000001CCC2E410000002077F33241000000A01BCC2E41000000A062F33241000000C01FCC2E410000006047F33241000000A029CC2E41000000602CF33241000000C036CC2E410000002010F332410000006047CC2E41000000E0F3F232410000004057CC2E4100000020D8F23241000000A060CC2E4100000020BCF232410000000068CC2E4100000060A1F23241000000A06ECC2E4100000060A1F23241000000A06ECC2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('161','1755.543513','ROAD3','PL2040','271','605','270','604','MONROE MILLER RD',NULL,NULL,'271','270','605','604','Right','roadswest.dbf','0.33','40','0.4950','10.5122',NULL,'1',NULL,NULL,'MONROE MILLER','RD',NULL,'010500000001000000010200000023000000000000405D0F334100000060A9C72E41000000E0020F33410000006026C82E4100000000E20E3341000000404DC82E41000000E0AD0E3341000000408CC82E41000000607A0E334100000040CDC82E41000000E0470E3341000000A011C92E41000000C01E0E3341000000404CC92E41000000A0F70D3341000000608DC92E4100000080D90D3341000000C0D2C92E41000000C0BD0D3341000000401ACA2E4100000060990D3341000000A072CA2E4100000000750D3341000000A0CBCA2E41000000E0560D3341000000C015CB2E4100000080390D3341000000A061CB2E41000000401B0D3341000000C0BACB2E4100000040FE0C3341000000C014CC2E4100000000DE0C33410000000076CC2E4100000080BE0C334100000000D9CC2E4100000080A50C33410000000030CD2E41000000808D0C3341000000A087CD2E4100000060670C33410000006015CE2E41000000E04D0C33410000004076CE2E4100000020340C3341000000A0D9CE2E41000000A01A0C3341000000403DCF2E4100000020070C33410000004088CF2E41000000C0F40B334100000040D5CF2E4100000080E40B33410000004029D02E4100000080D70B3341000000A07FD02E4100000080D00B3341000000A0C5D02E4100000000CB0B3341000000400BD12E4100000080C50B3341000000C055D12E41000000E0C00B3341000000C0A0D12E4100000080BD0B334100000000F0D12E41000000E0B90B3341000000403ED22E4100000060B20B334100000000A0D22E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('162','1026.310282','ROAD3','PL2040','1075','1259','1074','1258','STAGGS CREEK RD',NULL,NULL,'1075','1074','1259','1258','Right','roadswest.dbf','0.19','40','0.2850','11.1556',NULL,'1',NULL,NULL,'STAGGS CREEK','RD',NULL,'010500000001000000010200000014000000000000E0001233410000000080842E4100000000E8113341000000C0AA842E41000000E0B711334100000060FE842E4100000060881133410000000054852E41000000605411334100000040B9852E41000000E022113341000000C023862E4100000000FA103341000000408A862E41000000C0D3103341000000A0F4862E4100000020B1103341000000405E872E41000000809010334100000060CA872E410000000071103341000000C038882E410000004054103341000000A0AA882E41000000004710334100000040EB882E41000000203E103341000000C015892E41000000A02A103341000000A082892E41000000401810334100000060F4892E41000000E007103341000000C0668A2E4100000080FD0F334100000040A88A2E4100000060F70F334100000040ED8A2E4100000080FC0F3341000000402B8B2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('163','1389.487332','ROAD3','PL2040','1737','1987','1736','1986','SUGAR TREE RD',NULL,NULL,'1737','1736','1987','1986','Right','roadswest.dbf','0.26','40','0.3900','11.1158',NULL,'1',NULL,NULL,'SUGAR TREE','RD',NULL,'01050000000100000001020000002D0000000000000096F232410000006037AD2E41000000E0A9F23241000000A025AD2E41000000E0C0F23241000000A0F9AC2E4100000060DCF23241000000A0CFAC2E41000000A0F6F23241000000A0A4AC2E41000000C026F33241000000404DAC2E410000002054F3324100000040F0AB2E41000000A070F33241000000C0ADAB2E41000000E08CF33241000000C069AB2E4100000000A6F33241000000402FAB2E4100000040BFF33241000000C0F4AA2E4100000020D7F33241000000A0BEAA2E4100000000EFF33241000000A088AA2E41000000C005F432410000006053AA2E41000000001DF43241000000A01EAA2E410000002035F43241000000A0E9A92E41000000404FF43241000000A0B7A92E41000000006DF43241000000A08BA92E41000000C08CF432410000000066A92E4100000080A8F43241000000A04CA92E41000000C0C4F43241000000C036A92E41000000C0D9F432410000006027A92E4100000020EFF432410000004019A92E41000000C009F53241000000000BA92E41000000C023F53241000000C0FCA82E41000000C03BF5324100000040EDA82E41000000C051F5324100000000D9A82E410000006063F53241000000C0BEA82E410000006072F53241000000C09FA82E410000004082F532410000000065A82E410000002090F53241000000C022A82E41000000609FF53241000000A0E7A72E4100000060B1F5324100000000AFA72E4100000080C7F532410000004080A72E4100000060DFF53241000000A056A72E4100000080F8F53241000000A02CA72E410000004014F63241000000C007A72E41000000C028F63241000000C0F4A62E41000000603DF63241000000C0E5A62E41000000604DF63241000000C0DAA62E41000000605EF6324100000000D2A62E41000000C06EF6324100000040CEA62E410000006087F6324100000000CDA62E41000000409CF63241000000C0D3A62E4100000000B1F63241000000C0E9A62E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('164','537.312721','ROAD3','PL2040','101','195','100','194','GLENN MILLER RD',NULL,NULL,'101','100','195','194','Right','roadswest.dbf','0.10','40','0.1500','11.4322',NULL,'1',NULL,NULL,'GLENN MILLER','RD',NULL,'01050000000100000001020000000F00000000000080FC0F3341000000402B8B2E4100000080D40F3341000000404B8B2E4100000080C00F3341000000C05C8B2E41000000E0AD0F3341000000C0688B2E41000000E0AD0F3341000000C0688B2E4100000020910F334100000040668B2E4100000000730F3341000000C0578B2E41000000C0460F3341000000A0388B2E41000000E01A0F3341000000A0128B2E41000000E0EE0E334100000000EC8A2E4100000020C10E3341000000C0CC8A2E41000000C0950E334100000060C28A2E41000000206A0E3341000000A0C38A2E4100000000330E3341000000A0D98A2E41000000C0FA0D334100000040F98A2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('165','1484.679989','ROAD3','PL2040','197','459','196','458','GLENN MILLER RD',NULL,NULL,'197','196','459','458','Right','roadswest.dbf','0.28','40','0.4200','11.3334',NULL,'1',NULL,NULL,'GLENN MILLER','RD',NULL,'010500000001000000010200000024000000000000C0FA0D334100000040F98A2E41000000E0DC0D334100000040128B2E4100000080C60D3341000000C02C8B2E4100000040A50D3341000000C0608B2E4100000000830D3341000000C0A38B2E4100000020650D334100000060EE8B2E41000000E04C0D3341000000403C8C2E4100000060390D3341000000008F8C2E41000000A02B0D334100000040DF8C2E41000000C0210D334100000040328D2E41000000E01E0D3341000000A08A8D2E41000000201A0D3341000000A0DE8D2E4100000000110D334100000060108E2E4100000040050D3341000000C0418E2E4100000060F20C334100000040868E2E4100000080DB0C3341000000A0C28E2E4100000040BD0C334100000040F68E2E41000000A09A0C3341000000401E8F2E41000000A0780C3341000000C0338F2E41000000E0540C334100000040498F2E4100000060330C3341000000606A8F2E4100000060140C3341000000A0948F2E41000000E0F70B3341000000C0D78F2E4100000020DD0B3341000000A018902E41000000C0BA0B3341000000A046902E4100000060950B3341000000C072902E4100000080720B334100000000A2902E4100000020520B334100000060D8902E41000000A0350B3341000000A02A912E41000000A01D0B33410000006081912E41000000E0F70A334100000040FD912E4100000020D20A3341000000A079922E41000000C0B80A3341000000C0D1922E41000000C09D0A33410000006026932E41000000607F0A33410000000071932E4100000040730A3341000000008A932E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('166','4769.931002','ROAD3','PL2040','101','967','100','966','WEST STAGGS CREEK RD',NULL,NULL,'101','100','967','966','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('167','1668.968041','ROAD3','PL2040','1313','1617','1312','1616','WEST STAGGS CREEK RD',NULL,NULL,'1313','1312','1617','1616','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('168','6524.191327','ROAD3','PL2040','563','1735','562','1734','SUGAR TREE RD',NULL,NULL,'563','562','1735','1734','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('169','1892.900786','ROAD3','PL2040','969','1311','968','1310','WEST STAGGS CREEK RD',NULL,NULL,'969','968','1311','1310','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('170','2154.615666','ROAD3','PL2040','1727','2111','1726','2110','WEST MILL CREEK RD',NULL,NULL,'1727','1726','2111','2110','Right','roadswest.dbf','0.41','40','0.6150','11.2220',NULL,'1','W',NULL,'MILL CREEK','RD',NULL,'01050000000100000001020000001D000000000000A091EF32410000000080842E410000004084EF3241000000C09F842E410000002072EF324100000040CC842E410000006061EF3241000000C0F8842E410000004047EF32410000000059852E41000000C02FEF3241000000C0BE852E410000002028EF324100000000DD852E410000006001EF32410000004076862E4100000080D3EE3241000000A02D872E41000000A09CEE32410000004012882E410000000066EE3241000000A0F7882E410000008019EE3241000000A02C8A2E41000000E0EBED3241000000A0E48A2E410000006072ED3241000000C0D18C2E41000000403BED3241000000A0C38D2E410000002001ED3241000000C0B28E2E41000000A0EFEC3241000000A0F38E2E4100000060DDEC324100000000338F2E41000000C0C9EC324100000060718F2E4100000080B4EC3241000000A0AE8F2E41000000A090EC324100000040FF8F2E41000000406DEC3241000000004E902E410000000054EC3241000000C093902E41000000403DEC324100000000DD902E41000000C02BEC32410000000023912E41000000E01BEC3241000000606B912E41000000C0FEEB324100000040FC912E4100000020E4EB3241000000C08E922E4100000000C0EB3241000000C06B932E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('171','7653.584683','ROAD3','PL2040','101','1485','100','1484','EAST STAGGS CREEK RD',NULL,NULL,'101','100','1485','1484','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('172','9812.958820','ROAD3','PL2040','461','2207','460','2206','GLENN MILLER RD',NULL,NULL,'461','460','2207','2206','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('173','1086.333318','ROAD3','PL2041','101','305','100','304','BRENNA LN',NULL,NULL,'101','100','305','304','Right','roadswest.dbf','0.21','40','0.3150','10.6504',NULL,'1',NULL,NULL,'BRENNA','LN',NULL,'01050000000100000001020000001F000000000000A06DFA3241000000605DEE2E41000000607DFA3241000000C0FDED2E41000000A08EFA3241000000609FED2E41000000E09BFA3241000000C065ED2E4100000000A9FA3241000000C02BED2E41000000C0B1FA324100000040FDEC2E4100000080B9FA3241000000C0CDEC2E4100000060BFFA3241000000C09DEC2E41000000E0C5FA3241000000406EEC2E41000000A0CEFA32410000000044EC2E41000000C0D8FA3241000000401BEC2E4100000000E3FA3241000000C0F7EB2E4100000080EDFA3241000000C0D4EB2E4100000060FBFA324100000040A5EB2E410000006008FB3241000000C074EB2E41000000A013FB32410000000044EB2E41000000E01DFB32410000004012EB2E410000008028FB324100000040D9EA2E410000006032FB3241000000C09FEA2E41000000C03DFB3241000000405AEA2E410000002048FB3241000000C013EA2E410000002052FB3241000000A0BFE92E41000000E05BFB3241000000006BE92E41000000E068FB3241000000000EE92E410000002076FB324100000040B1E82E410000002082FB3241000000C053E82E41000000A08DFB324100000000F6E72E41000000E098FB3241000000C095E72E4100000020A4FB3241000000A035E72E4100000040B2FB324100000000C6E62E41000000E0C0FB3241000000A056E62E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('174','472.481481','ROAD3','PL2041','187','277','186','276','BRENNA LN',NULL,NULL,'187','186','277','276','Right','roadswest.dbf','0.09','40','0.1350','10.4996',NULL,'1',NULL,NULL,'BRENNA','LN',NULL,'010500000001000000010200000013000000000000E0C0FB3241000000A056E62E4100000020C9FB3241000000C00CE62E4100000080D1FB324100000040C3E52E41000000E0D8FB3241000000A081E52E41000000C0E0FB32410000004040E52E4100000000EAFB32410000004001E52E4100000000F4FB3241000000C0C2E42E4100000000FEFB3241000000A084E42E410000006008FC32410000004046E42E410000006014FC324100000040FCE32E410000008021FC3241000000C0B2E32E41000000A02AFC32410000006084E32E41000000A035FC3241000000C057E32E41000000803FFC3241000000C037E32E41000000C04BFC3241000000A01CE32E41000000C056FC3241000000C00FE32E410000000063FC3241000000A006E32E41000000C066FC32410000004004E32E41000000A06AFC32410000004002E32E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('175','476.177292','ROAD3','PL2041','607','699','606','698','MONROE MILLER RD',NULL,NULL,'607','606','699','698','Right','roadswest.dbf','0.09','40','0.1350','10.3516',NULL,'1',NULL,NULL,'MONROE MILLER','RD',NULL,'01050000000100000001020000001000000000000060B20B334100000000A0D22E4100000060AD0B334100000000D6D22E4100000000A60B33410000004014D32E41000000E09E0B3341000000C053D32E41000000C09A0B3341000000C086D32E41000000C0970B3341000000A0BAD32E41000000E0960B334100000060F4D32E4100000080970B3341000000002ED42E4100000040990B3341000000006AD42E41000000A09A0B3341000000C0A4D42E41000000E0990B3341000000A0D5D42E41000000E0970B33410000004006D52E4100000020920B3341000000A047D52E41000000208B0B3341000000008AD52E41000000E0820B3341000000C0EBD52E41000000007B0B3341000000A04DD62E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('176','3955.340651','ROAD3','PL2041','627','1369','626','1368','JACK JONES RD',NULL,NULL,'627','626','1369','1368','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('177','1839.195182','ROAD3','PL2041','101','411','100','410','SWANSIE SHEPHERD RD',NULL,NULL,'101','100','411','410','Right','roadswest.dbf','0.35','40','0.5250','11.8658',NULL,'1',NULL,NULL,'SWANSIE SHEPHERD','RD',NULL,'0105000000010000000102000000320000000000008003FD3241000000405CFB2E41000000E015FD3241000000C066FB2E41000000E015FD3241000000C066FB2E41000000E023FD3241000000A055FB2E41000000E02FFD3241000000C03EFB2E410000000039FD32410000006023FB2E41000000E04FFD324100000000D7FA2E410000002066FD3241000000A08AFA2E41000000007AFD32410000004036FA2E41000000E090FD324100000040E4F92E4100000080ABFD324100000040AAF92E4100000020C8FD3241000000C074F92E41000000E0E8FD3241000000C038F92E410000004008FE324100000060FBF82E410000002029FE324100000040A8F82E410000002048FE3241000000C050F82E41000000805DFE3241000000C016F82E410000004072FE3241000000A0DCF72E41000000408FFE3241000000C082F72E41000000C0AAFE32410000000027F72E4100000000C3FE324100000040CEF62E4100000080DBFE3241000000C074F62E41000000E0F3FE32410000004022F62E41000000200EFF3241000000C0D1F52E410000006027FF3241000000408EF52E410000008041FF3241000000A04CF52E410000002057FF32410000004014F52E41000000A06EFF3241000000A0DDF42E41000000408BFF324100000040ACF42E41000000A0A9FF3241000000607FF42E41000000E0CAFF32410000006050F42E41000000C0EDFF32410000004026F42E41000000801A003341000000A0FDF32E41000000204900334100000040DEF32E41000000E07800334100000040C9F32E41000000C0A8003341000000A0B8F32E41000000E0D300334100000040A6F32E4100000020FF003341000000A094F32E410000008025013341000000C083F32E41000000804C013341000000A07AF32E41000000C06B013341000000A080F32E41000000408A013341000000A08DF32E41000000A09F013341000000A099F32E4100000040BB013341000000A0A7F32E41000000E0D6013341000000C0B2F32E41000000C0F8013341000000C0BAF32E41000000E01A023341000000C0BCF32E41000000E01A023341000000C0BCF32E410000006035023341000000A0B8F32E41000000405002334100000040B2F32E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('178','762.927559','ROAD3','PL2041','483','625','482','624','JACK JONES RD',NULL,NULL,'483','482','625','624','Right','roadswest.dbf','0.14','40','0.2100','10.7454',NULL,'1',NULL,NULL,'JACK JONES','RD',NULL,'01050000000100000001020000001A0000000000006042FC3241000000C0AC002F410000006033FC3241000000C077002F41000000C029FC3241000000A04A002F41000000401CFC3241000000A0FFFF2E41000000C011FC3241000000A0B2FF2E41000000800CFC32410000006086FF2E410000000009FC3241000000A05AFF2E410000006009FC3241000000A022FF2E41000000200DFC3241000000A0EAFE2E410000002017FC3241000000409CFE2E41000000C026FC32410000004052FE2E410000004038FC3241000000A01CFE2E41000000404BFC324100000040E6FD2E41000000605BFC3241000000C0A9FD2E41000000206AFC3241000000406DFD2E41000000807BFC3241000000602CFD2E41000000E08AFC3241000000A0E8FC2E410000002091FC324100000040BAFC2E41000000A096FC3241000000008DFC2E41000000E09EFC32410000000053FC2E4100000080A9FC3241000000A01CFC2E4100000020BBFC324100000040E6FB2E41000000A0D0FC324100000060B4FB2E4100000080EAFC3241000000C08AFB2E41000000E0F5FC3241000000A075FB2E410000008003FD3241000000405CFB2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('179','5456.593909','ROAD3','PL2041','777','1797','776','1796','JOE HAMPTON RD',NULL,NULL,'777','776','1797','1796','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('180','3926.004587','ROAD3','PL2041','101','825','100','824','GREER HOLLOW RD',NULL,NULL,'101','100','825','824','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('181','2038.118771','ROAD3','PL2041','101','481','100','480','JACK JONES RD',NULL,NULL,'101','100','481','480','Right','roadswest.dbf','0.39','40','0.5850','10.7270',NULL,'1',NULL,NULL,'JACK JONES','RD',NULL,'0105000000010000000102000000360000000000002001003341000000C06C0D2F41000000A0F2FF324100000040160D2F4100000020E6FF324100000060D70C2F41000000A0DCFF324100000060990C2F4100000000DBFF3241000000C05B0C2F41000000A0DCFF3241000000C01B0C2F41000000C0DFFF3241000000C0CA0B2F41000000E0E4FF3241000000407A0B2F4100000060EDFF324100000000180B2F41000000E0F7FF3241000000A0B60A2F41000000200200334100000040690A2F41000000200C003341000000A01B0A2F41000000601500334100000040D5092F410000000019003341000000C08C092F41000000600E003341000000404B092F41000000A0FEFF3241000000000E092F4100000080EAFF3241000000C0C8082F4100000020D5FF3241000000A085082F4100000080BDFF32410000004036082F4100000040A5FF324100000060E7072F410000006092FF3241000000C0AB072F41000000007EFF3241000000A071072F41000000A065FF3241000000C03A072F41000000C04CFF3241000000A006072F410000000034FF324100000040CD062F41000000201AFF3241000000C093062F4100000080FBFE3241000000A05E062F41000000A0DEFE32410000004029062F41000000C0C7FE324100000040EA052F4100000000B3FE324100000060A6052F41000000809EFE3241000000C05F052F41000000808BFE32410000000018052F41000000807BFE3241000000C0D1042F41000000806BFE3241000000408B042F41000000005DFE3241000000004A042F41000000604AFE3241000000000C042F41000000202DFE3241000000C0DB032F41000000800DFE324100000040B3032F41000000A0EFFD3241000000608A032F41000000E0D2FD32410000004060032F4100000000B9FD32410000004032032F4100000000A0FD32410000004001032F410000008081FD3241000000C0C1022F410000002062FD3241000000C082022F410000002046FD3241000000A052022F41000000A028FD3241000000A025022F41000000A005FD324100000040FA012F41000000E0E2FC324100000000D0012F4100000040C5FC324100000040A6012F4100000080A8FC3241000000007A012F410000008087FC3241000000A043012F41000000A068FC32410000006009012F410000002052FC3241000000C0D7002F410000006042FC3241000000C0AC002F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('182','3872.081186','ROAD3','PL2041','0','0','0','0',NULL,NULL,NULL,'0','0','0','0','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('183','1136.102629','ROAD3','PL2041','0','0','0','0',NULL,NULL,NULL,'0','0','0','0','Right','roadswest.dbf','0.22','40','0.3300','0',NULL,'0',NULL,NULL,NULL,NULL,NULL,'010500000001000000010200000016000000000000E0DB0733410000004007E92E4100000020E107334100000060FFE82E41000000E0E307334100000040F2E82E41000000A0EC073341000000A0C9E82E41000000A008083341000000A00DE82E41000000A01D083341000000A03EE72E410000000022083341000000A091E62E41000000601D083341000000A05DE62E41000000600C083341000000A01AE62E41000000A0F607334100000060FDE52E4100000000CD073341000000C0EFE52E41000000409A073341000000C0F1E52E41000000604907334100000040F5E52E4100000020A8063341000000A021E62E41000000A070063341000000A035E62E4100000060320633410000006052E62E4100000000CB053341000000A05FE62E4100000080A1053341000000A054E62E41000000208D0533410000000036E62E41000000207A0533410000000008E62E41000000205905334100000000E2E52E41000000604805334100000060BFE52E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('184','1705.920798','ROAD3','PL2041','3579','3901','3578','3900','EAST LITTLE HORSE CREEK RD',NULL,NULL,'3579','3578','3901','3900','Right','roadswest.dbf','0.32','40','0.4800','10.5958',NULL,'1','E',NULL,'LITTLE HORSE CREEK','RD',NULL,'01050000000100000001020000001C00000000000000D012334100000040561B2F4100000060B9123341000000A00F1B2F41000000E09F12334100000060E51A2F41000000A08212334100000000C71A2F410000008050123341000000A0B91A2F41000000E01912334100000040BE1A2F41000000A0D811334100000060C31A2F41000000009711334100000040CA1A2F41000000405A113341000000A0CB1A2F41000000405A113341000000A0CB1A2F41000000401D11334100000040C81A2F4100000040E6103341000000C0BD1A2F4100000060AF10334100000000B01A2F41000000207B103341000000609C1A2F41000000E048103341000000C0931A2F41000000601A103341000000A0A41A2F41000000A0EF0F334100000040C71A2F41000000C0C00F3341000000C01F1B2F4100000080960F3341000000A08E1B2F41000000A0680F3341000000C0FB1B2F41000000403B0F3341000000A0691C2F41000000A0F20E3341000000C0611D2F4100000060A90E3341000000405D1E2F41000000C0830E334100000060E51E2F41000000205C0E3341000000A06C1F2F4100000020320E3341000000A0E51F2F4100000080060E3341000000C05B202F4100000020E00D334100000000C0202F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('185','4890.454975','ROAD3','PL2041','101','1021','100','1020','STANSBERRY RD',NULL,NULL,'101','100','1021','1020','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('186','2865.641369','ROAD4','PL2041','121','689','120','688','FOX MOUNTAIN RD',NULL,NULL,'121','120','689','688','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('187','958.133709','ROAD3','PL2041','827','1003','826','1002','GREER HOLLOW RD',NULL,NULL,'827','826','1003','1002','Right','roadswest.dbf','0.18','40','0.2700','10.8878',NULL,'1',NULL,NULL,'GREER HOLLOW','RD',NULL,'0105000000010000000102000000230000000000000053EF324100000000950D2F41000000603FEF3241000000C0950D2F41000000C02BEF3241000000A0960D2F410000002000EF3241000000C09C0D2F4100000040D5EE3241000000A09E0D2F4100000040D5EE3241000000A09E0D2F41000000A0B4EE324100000060990D2F410000006096EE3241000000408B0D2F41000000C07BEE324100000060670D2F41000000E05EEE3241000000C0410D2F41000000404AEE324100000040380D2F41000000E035EE324100000040330D2F410000002017EE324100000040300D2F4100000080F8ED324100000040300D2F4100000080F8ED324100000040300D2F4100000080D6ED3241000000002F0D2F41000000C0B4ED3241000000602D0D2F41000000408EED3241000000C0230D2F410000000067ED3241000000C0240D2F41000000E04DED3241000000A03C0D2F41000000E036ED324100000060550D2F41000000201BED3241000000A0650D2F4100000060FEEC3241000000606F0D2F4100000000D7EC324100000040720D2F4100000000D7EC324100000040720D2F41000000C0AEEC3241000000406F0D2F41000000A092EC3241000000C06E0D2F41000000E076EC3241000000A06D0D2F41000000405CEC3241000000A0670D2F410000008040EC324100000060680D2F410000002026EC324100000060840D2F41000000600EEC3241000000C0A50D2F41000000C0F4EB3241000000A0BF0D2F4100000060DAEB3241000000A0DB0D2F4100000000C0EB3241000000A0040E2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('188','2432.662690','ROAD3','PL2041','101','555','100','554','LEE OSBORNE RD',NULL,NULL,'101','100','555','554','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('189','2625.737632','ROAD3','PL2041','367','857','366','856','ROARING BRANCH RD',NULL,NULL,'367','366','857','856','Right','roadswest.dbf','0.50','40','0.7500','10.7172',NULL,'1',NULL,NULL,'ROARING BRANCH','RD',NULL,'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');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('190','241.494063','ROAD3','PL2042','347','393','346','392','HART RD',NULL,NULL,'347','346','393','392','Right','roadswest.dbf','0.05','40','0.0750','10.4998',NULL,'1',NULL,NULL,'HART','RD',NULL,'010500000001000000010200000008000000000000A0EA09334100000060DE682F4100000000D40933410000004017692F4100000060BC0933410000000063692F4100000080A6093341000000A0B2692F41000000009409334100000040F4692F41000000C08209334100000040366A2F41000000807A093341000000C05A6A2F410000008072093341000000C07F6A2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('191','1294.350188','ROAD3','PL2042','101','345','100','344','HART RD',NULL,NULL,'101','100','345','344','Right','roadswest.dbf','0.25','40','0.3750','10.6094',NULL,'1',NULL,NULL,'HART','RD',NULL,'010500000001000000010200000020000000000000E09C0B3341000000009E5F2F4100000060980B33410000004026602F4100000020950B3341000000A05B602F4100000060910B33410000004091602F4100000040890B334100000060E0602F4100000040800B3341000000602E612F4100000040770B3341000000A083612F41000000E06C0B3341000000C0D8612F41000000E05E0B3341000000402D622F41000000004F0B33410000004080622F41000000403C0B334100000000D4622F41000000802B0B3341000000C026632F4100000040200B33410000006087632F41000000C0180B3341000000C0EA632F41000000C0130B3341000000C04C642F41000000400F0B3341000000C0AF642F4100000060090B3341000000C011652F4100000060000B3341000000A073652F4100000060F20A334100000040C8652F4100000000E30A3341000000601A662F41000000C0D60A3341000000606F662F4100000080C70A334100000000C4662F41000000A0B50A3341000000C001672F41000000A0A10A3341000000403C672F41000000408B0A3341000000C075672F4100000040740A3341000000A0AD672F41000000605D0A3341000000A0E8672F4100000040450A33410000004023682F4100000000240A33410000004066682F41000000E0020A3341000000C0A7682F4100000000F509334100000000C7682F41000000A0EA09334100000060DE682F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('192','569.911390','ROAD3','PL2042','2135','2239','2134','2238','JONT MOUNTAIN RD',NULL,NULL,'2135','2134','2239','2238','Right','roadswest.dbf','0.11','40','0.1650','10.9598',NULL,'1',NULL,NULL,'JONT MOUNTAIN','RD',NULL,'010500000001000000010200000013000000000000A0B4F4324100000060876A2F41000000C0BEF43241000000408F6A2F4100000080DCF4324100000040AA6A2F41000000E0F3F4324100000060D76A2F410000006009F53241000000000A6B2F410000006024F53241000000C0446B2F41000000A040F53241000000407C6B2F41000000405DF5324100000000A96B2F41000000C07BF5324100000040D06B2F41000000E094F53241000000C0E66B2F4100000080ADF53241000000C0FE6B2F4100000040CAF53241000000C0336C2F4100000080E6F53241000000406A6C2F41000000A00AF6324100000040906C2F410000000030F63241000000A0B26C2F410000004048F63241000000A0CC6C2F41000000005FF6324100000040EA6C2F41000000E06CF6324100000000056D2F41000000007AF63241000000A0216D2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('193','334.826295','ROAD3','PL2042','1109','1167','1108','1166','JONT MOUNTAIN RD',NULL,NULL,'1109','1108','1167','1166','Right','roadswest.dbf','0.06','40','0.0900','11.5458',NULL,'1',NULL,NULL,'JONT MOUNTAIN','RD',NULL,'010500000001000000010200000005000000000000605EEF3241000000008E562F41406BF5AB12EF324162AA15E838572F41C6FD22CAFCEE32416BAD97C0FD572F419FD1519D1DEF3241C70499FB80582F41000000A045EF324100000040B0582F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('194','1397.464557','ROAD3','PL2042','857','1107','856','1106','JONT MOUNTAIN RD',NULL,NULL,'857','856','1107','1106','Right','roadswest.dbf','0.26','40','0.3900','11.1798',NULL,'1',NULL,NULL,'JONT MOUNTAIN','RD',NULL,'0105000000010000000102000000210000000000006076EF3241000000406C4D2F41000000407AEF3241000000C0824D2F41000000407EEF324100000000994D2F41000000C089EF324100000000BD4D2F41000000C090EF324100000040E04D2F41000000208BEF324100000040FD4D2F410000002081EF3241000000A0174E2F41000000005CEF3241000000C0384E2F41000000C02FEF324100000060494E2F41000000C00FEF3241000000A05A4E2F41000000C0F3EE3241000000A0734E2F4100000060D9EE324100000000DD4E2F4100000060D8EE3241000000C05B4F2F4100000060EDEE3241000000C0B64F2F41000000E00BEF3241000000400E502F410000000037EF3241000000407B502F41000000A059EF3241000000A0ED502F410000004060EF3241000000A03B512F41000000A062EF3241000000008C512F41000000C064EF3241000000C008522F410000000064EF3241000000C085522F41000000605CEF3241000000A006532F41000000E05CEF32410000004083532F41000000C070EF324100000060E0532F41000000408CEF3241000000C038542F41000000C0A8EF32410000004081542F41000000C0C0EF3241000000C0CB542F41000000C0CAEF32410000004034552F4100000020C4EF3241000000609C552F41000000A0AFEF324100000060E4552F41000000C093EF32410000004026562F41000000A079EF3241000000405B562F41000000605EEF3241000000008E562F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('195','5338.508072','ROAD3','PL2042','1169','2133','1168','2132','JONT MOUNTAIN RD',NULL,NULL,'1169','1168','2133','2132','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('196','695.893022','ROAD3','PL2042','285','413','284','412','LEE WOODIE RD',NULL,NULL,'285','284','413','412','Right','roadswest.dbf','0.13','40','0.1950','10.8734',NULL,'1',NULL,NULL,'LEE WOODIE','RD',NULL,'0105000000010000000102000000110000000000000080F53241000000C055472F410000000066F5324100000040AE472F410000002049F53241000000A001482F410000000025F53241000000C04C482F4100000000FBF43241000000C086482F41000000E0CFF43241000000A0A2482F4100000080A2F4324100000040AC482F41000000E07BF43241000000009F482F410000008055F432410000000093482F410000008027F43241000000C0A6482F4100000040FAF3324100000040C8482F4100000000CDF33241000000C0EB482F41000000E09FF332410000004010492F41000000C085F33241000000A024492F41000000406BF332410000006034492F41000000E046F33241000000A038492F41000000E021F332410000004036492F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('197','8505.037811','ROAD3','PL2042','3903','5523','3902','5522','EAST LITTLE HORSE CREEK RD',NULL,NULL,'3903','3902','5523','5522','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('198','1284.751283','ROAD3','PL2042','1023','1263','1022','1262','STANSBERRY RD',NULL,NULL,'1023','1022','1263','1262','Right','roadswest.dbf','0.24','40','0.3600','10.7062',NULL,'1',NULL,NULL,'STANSBERRY','RD',NULL,'010500000001000000010200000025000000000000C032F0324100000000C0202F41000000C011F03241000000C00D212F4100000000ECEF32410000006066212F41000000A0C5EF324100000040BD212F41000000A094EF32410000004026222F41000000A063EF3241000000C08E222F41000000C03EEF324100000000DB222F41000000A01DEF3241000000C02E232F41000000E00DEF3241000000C06A232F410000000003EF324100000040AB232F41000000A000EF324100000040EF232F410000006002EF3241000000C031242F41000000E004EF3241000000608D242F41000000800CEF324100000000E9242F410000000018EF3241000000602B252F410000006026EF3241000000C06A252F41000000403AEF3241000000C0B2252F41000000004FEF324100000000F9252F410000000061EF3241000000A036262F41000000A06EEF32410000006073262F41000000A072EF3241000000C0AD262F410000006074EF3241000000A0ED262F410000006078EF3241000000A039272F41000000007EEF3241000000C085272F410000004088EF324100000040CD272F410000002091EF32410000004012282F410000008094EF3241000000603C282F410000008093EF32410000006061282F410000008085EF3241000000C089282F410000008076EF32410000004091282F410000008076EF32410000004091282F410000000063EF3241000000A080282F410000008055EF3241000000C05F282F410000004047EF3241000000A032282F410000006037EF3241000000400B282F41000000C029EF324100000000FD272F41000000E018EF324100000040ED272F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('199','521.675173','ROAD3','PL2042','1265','1361','1264','1360','STANSBERRY RD',NULL,NULL,'1265','1264','1361','1360','Right','roadswest.dbf','0.10','40','0.1500','10.8682',NULL,'1',NULL,NULL,'STANSBERRY','RD',NULL,'010500000001000000010200000015000000000000E018EF324100000040ED272F410000006000EF3241000000C0DD272F41000000C0E4EE3241000000C0D6272F4100000020D5EE3241000000A0D3272F4100000000C5EE3241000000C0D1272F4100000040B4EE3241000000A0D2272F4100000060A4EE3241000000A0D4272F4100000060A4EE3241000000A0D4272F41000000008CEE3241000000C0D3272F410000002072EE324100000060DA272F41000000A05CEE3241000000A0F2272F41000000C04AEE32410000000012282F41000000A03AEE3241000000A038282F41000000602DEE32410000006063282F410000000022EE32410000000099282F410000008018EE324100000000CE282F41000000A006EE32410000004020292F4100000040F5ED3241000000A074292F41000000A0EAED324100000040B6292F41000000E0E0ED324100000040F7292F4100000020D2ED3241000000C03D2A2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('200','633.667694','ROAD3','PL2042','477','595','476','594','LITTLE HORSE CREEK RD',NULL,NULL,'477','476','595','594','Right','roadswest.dbf','0.12','40','0.1800','10.7402',NULL,'1',NULL,NULL,'LITTLE HORSE CREEK','RD',NULL,'010500000001000000010200000016000000000000C080EF324100000000C92D2F41000000A069EF324100000040932D2F410000004053EF3241000000C05C2D2F41000000003AEF3241000000A0162D2F410000008021EF324100000040CE2C2F41000000A010EF3241000000C09A2C2F4100000000FFEE324100000060672C2F4100000060F2EE324100000000472C2F4100000060E6EE3241000000A0272C2F4100000020D9EE3241000000C0FD2B2F4100000040CBEE3241000000C0D22B2F41000000E0B9EE3241000000C0A42B2F4100000080A6EE324100000060792B2F41000000E08FEE3241000000C0512B2F410000008079EE3241000000C02C2B2F410000002069EE3241000000400C2B2F410000008057EE3241000000C0EA2A2F41000000803CEE324100000000C32A2F41000000E020EE3241000000409F2A2F41000000E008EE324100000060802A2F41000000E0F0ED324100000000622A2F4100000020D2ED3241000000C03D2A2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('201','1975.504679','ROAD3','PL2042','101','475','100','474','LITTLE HORSE CREEK RD',NULL,NULL,'101','100','475','474','Right','roadswest.dbf','0.37','40','0.5550','10.5642',NULL,'1',NULL,NULL,'LITTLE HORSE CREEK','RD',NULL,'01050000000100000001020000002C00000000000060E7F53241000000A042352F4100000080D7F53241000000402F352F4100000040BAF532410000000012352F410000002088F53241000000C0D9342F41000000406BF5324100000040B8342F41000000405FF53241000000609F342F410000000055F53241000000C081342F41000000204CF532410000006068342F41000000403CF53241000000C035342F41000000A02BF53241000000C002342F41000000E012F53241000000C0BD332F4100000000F6F43241000000A07E332F4100000040D7F43241000000C052332F4100000040B7F43241000000C02D332F41000000E0A6F43241000000C020332F4100000060D5F23241000000C095312F4100000080C3F23241000000A089312F41000000809CF23241000000607B312F410000006075F232410000004074312F41000000004DF232410000006073312F410000004025F232410000000075312F410000004025F232410000000075312F41000000E0F9F132410000004074312F41000000E0CEF13241000000606F312F41000000A0A6F132410000004066312F410000006080F13241000000C053312F410000004062F13241000000A038312F41000000E047F13241000000C013312F410000008036F1324100000040EB302F41000000C026F13241000000C0BB302F410000004015F13241000000A081302F410000000008F13241000000A053302F41000000A0F1F03241000000A00A302F4100000060DCF0324100000000D22F2F4100000000C4F03241000000C0A72F2F4100000020AAF0324100000040832F2F41000000E093F03241000000C0662F2F41000000607DF03241000000004C2F2F41000000205AF0324100000040212F2F410000006037F0324100000040F52E2F410000008016F03241000000C0C82E2F41000000C0F6EF3241000000A09A2E2F4100000080BAEF3241000000A0332E2F41000000C080EF324100000000C92D2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('202','4171.302172','ROAD3','PL2042','101','855','100','854','JONT MOUNTAIN RD',NULL,NULL,'101','100','855','854','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('203','1008.284351','ROAD3','PL2042','101','285','100','284','LEE WOODIE RD',NULL,NULL,'101','100','285','284','Right','roadswest.dbf','0.19','40','0.2850','10.9596',NULL,'1',NULL,NULL,'LEE WOODIE','RD',NULL,'010500000001000000010200000018000000000000A04BF63241000000C0E1412F41000000405FF632410000000019422F41000000C072F632410000004050422F41000000C087F63241000000C08C422F41000000C09CF63241000000A0C9422F4100000060C0F63241000000A02B432F4100000020E3F63241000000C08E432F410000006000F7324100000040E8432F410000002019F73241000000C045442F410000002029F73241000000A08F442F41000000802DF73241000000A0CE442F41000000C008F7324100000000E7442F4100000080D4F6324100000040EF442F41000000E0ACF63241000000A002452F41000000408AF632410000000023452F41000000C074F63241000000A075452F410000002062F6324100000000D1452F410000000037F63241000000A021462F41000000A004F63241000000A065462F4100000080E4F53241000000608D462F4100000040C5F5324100000040B7462F41000000A0A9F5324100000040E7462F41000000A091F53241000000A01D472F410000000080F53241000000C055472F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('204','12112.917367','ROAD3','PL2042','1607','3929','1606','3928','BIG WINDFALL RD',NULL,NULL,'1607','1606','3929','3928','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('205','1269.796758','ROAD3','PL2042','101','349','100','348','TUCKER RD',NULL,NULL,'101','100','349','348','Right','roadswest.dbf','0.24','40','0.3600','10.2402',NULL,'1',NULL,NULL,'TUCKER','RD',NULL,'010500000001000000010200000017000000000000E075EF3241000000406D4D2F41000000604BEF324100000040BA4D2F410000004019EF3241000000C0E94D2F4100000020E8EE3241000000C0014E2F4100000060BDEE3241000000C0104E2F41000000C082EE324100000040144E2F41000000C082EE324100000040144E2F41000000E03FEE3241000000C00F4E2F410000006004EE3241000000600E4E2F4100000080C3ED3241000000A0EF4D2F41000000C094ED3241000000A0E54D2F410000000084ED324100000040DF4D2F41000000005FED3241000000A0DF4D2F41000000E035ED324100000040064E2F41000000C01CED3241000000C0574E2F41000000C00AED324100000000C74E2F41000000C0EAEC3241000000004C4F2F41000000E0C9EC3241000000C0F24F2F4100000040A0EC3241000000C07A502F410000002064EC3241000000A010512F41000000A032EC32410000006077512F4100000000F2EB3241000000A0E8512F4100000000C0EB3241000000C031522F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('206','1367.452995','ROAD4','PL2043','279','547','278','546','HONEYSUCKLE LN',NULL,NULL,'279','278','547','546','Right','roadswest.dbf','0.26','40','0.3900','10.2048',NULL,'1',NULL,NULL,'HONEYSUCKLE','LN',NULL,'01050000000100000001020000002B00000000000080B5043341000000A0ED7E2F41000000A0C9043341000000C0DF7E2F4100000040E5043341000000C0DE7E2F410000006007053341000000C0F17E2F41000000602905334100000060067F2F41000000805105334100000060007F2F41000000A078053341000000A0EA7E2F4100000000A505334100000040BC7E2F4100000060CF05334100000060837E2F4100000020F5053341000000A0567E2F41000000001806334100000040237E2F41000000E032063341000000A0E27D2F41000000604A063341000000A09B7D2F41000000E05C06334100000040627D2F41000000806D063341000000C0267D2F41000000407B06334100000040E87C2F41000000C087063341000000A0A87C2F41000000809306334100000060707C2F41000000209F06334100000040387C2F4100000080AD063341000000A0F37B2F41000000A0B9063341000000C0AD7B2F4100000060BF063341000000406D7B2F41000000E0C2063341000000402B7B2F4100000020C6063341000000C0E77A2F4100000020C906334100000040A47A2F4100000000CF063341000000005F7A2F4100000080D1063341000000601A7A2F4100000000CD06334100000000E6792F4100000000C406334100000040B4792F41000000A0B4063341000000A08B792F41000000C0A40633410000004063792F410000000098063341000000602F792F41000000209206334100000060F9782F41000000A09B06334100000060C8782F4100000060A30633410000004098782F41000000C09D063341000000C071782F41000000A092063341000000C053782F41000000A07B063341000000A04D782F4100000000610633410000000057782F410000006049063341000000605F782F410000004032063341000000606B782F4100000040110633410000004082782F41000000C0F0053341000000009C782F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('207','914.803631','ROAD4','PL2043','101','277','100','276','HONEYSUCKLE LN',NULL,NULL,'101','100','277','276','Right','roadswest.dbf','0.17','40','0.2550','10.3954',NULL,'1',NULL,NULL,'HONEYSUCKLE','LN',NULL,'01050000000100000001020000001C00000000000000CE033341000000A036822F4100000020D30333410000000028822F41000000C0D8033341000000601B822F4100000040EE033341000000A014822F41000000E006043341000000C01C822F41000000402B043341000000C028822F41000000604F043341000000A038822F41000000607B043341000000004B822F41000000A0A7043341000000405A822F41000000C0D1043341000000A063822F4100000020FB043341000000C060822F4100000080230533410000004047822F410000006048053341000000C01C822F410000006065053341000000C0E8812F41000000007C05334100000040AA812F41000000C087053341000000406F812F41000000208D053341000000A030812F41000000008A053341000000C0ED802F41000000008005334100000000AD802F41000000A06A0533410000004063802F41000000E04D053341000000A022802F41000000A045053341000000C016802F41000000402D053341000000A0F37F2F41000000000B05334100000040C77F2F4100000000E9043341000000C0937F2F4100000020CC04334100000000587F2F4100000060BA043341000000601E7F2F4100000080B5043341000000A0ED7E2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('208','3542.411023','ROAD3','PL2043','5587','6257','5586','6256','BIG HORSE CREEK RD',NULL,NULL,'5587','5586','6257','6256','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('209','2570.748765','ROAD3','PL2043','101','591','100','590','RIP SHIN RD',NULL,NULL,'101','100','591','590','Right','roadswest.dbf','0.49','40','0.7350','10.4928',NULL,'1',NULL,NULL,'RIP SHIN','RD',NULL,'01050000000100000001020000003300000000000020D9FB32410000004008AE2F41000000C0A8FB324100000000D6AD2F410000002086FB3241000000A0C9AD2F41000000E062FB324100000000C9AD2F41000000A02FFB3241000000C0E8AD2F41000000C0F9FA3241000000C00EAE2F4100000080D4FA32410000000017AE2F4100000080D4FA32410000000017AE2F4100000060AFFA3241000000C015AE2F41000000E07AFA324100000040FCAD2F410000006049FA3241000000A0D0AD2F41000000C01DFA3241000000009BAD2F4100000060F4F93241000000605FAD2F4100000080C3F932410000000018AD2F410000000093F9324100000060CFAC2F410000004051F93241000000C06CAC2F41000000C00EF93241000000C00DAC2F4100000000D5F8324100000040C5AB2F41000000C09AF83241000000607CAB2F410000004069F83241000000C037AB2F41000000A038F8324100000000F1AA2F410000002004F83241000000A09FAA2F41000000C0D0F73241000000404CAA2F4100000020A1F7324100000000FFA92F41000000E072F73241000000A0ADA92F41000000E049F73241000000C057A92F410000006023F73241000000C0FDA82F4100000080F8F63241000000C08DA82F41000000C0CFF63241000000001BA82F4100000020ACF63241000000A0B8A72F41000000E08AF632410000006052A72F41000000E077F63241000000A00CA72F41000000A066F63241000000A0C4A62F41000000605BF632410000004081A62F41000000404EF63241000000004AA62F41000000E01FF63241000000C010A62F410000000002F6324100000060FAA52F4100000000C9F5324100000040E7A52F41000000808DF5324100000060D5A52F410000004066F5324100000060B7A52F410000002041F53241000000A093A52F41000000E015F53241000000C064A52F41000000A0EDF43241000000A02BA52F4100000060CCF4324100000000E5A42F4100000020B1F43241000000A094A42F41000000409EF43241000000C038A42F41000000C08EF4324100000060DBA32F410000000082F43241000000A08EA32F41000000C070F43241000000404EA32F41000000205AF432410000004028A32F410000004036F432410000008017A32F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('210','4208.113128','ROAD3','PL2043','4787','5585','4786','5584','BIG HORSE CREEK RD',NULL,NULL,'4787','4786','5585','5584','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('211','5718.918258','ROAD3','PL2043','4385','5483','4384','5482','BIG WINDFALL RD',NULL,NULL,'4385','4384','5483','5482','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('212','11575.896065','ROAD3','PL2043','901','3127','900','3126','LITTLE WINDFALL RD',NULL,NULL,'901','900','3127','3126','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('213','121.667930','ROAD3','PL2043','4363','4383','4362','4382','BIG WINDFALL RD',NULL,NULL,'4363','4362','4383','4382','Right','roadswest.dbf','0.02','40','0.0300','12.1668',NULL,'1',NULL,NULL,'BIG WINDFALL','RD',NULL,'010500000001000000010200000007000000000000601AF63241000000A0FF7D2F41000000E00BF63241000000A01E7E2F4100000020FCF5324100000040367E2F41000000C0E9F53241000000A0427E2F41000000C0D6F5324100000040577E2F41000000E0CBF5324100000040797E2F4100000080C5F53241000000409E7E2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('214','2251.166433','ROAD3','PL2043','3931','4361','3930','4360','BIG WINDFALL RD',NULL,NULL,'3931','3930','4361','4360','Right','roadswest.dbf','0.43','40','0.6450','10.4706',NULL,'1',NULL,NULL,'BIG WINDFALL','RD',NULL,'01050000000100000001020000003A000000000000A0D6F3324100000000E06E2F4100000020CDF3324100000000236F2F4100000040C3F3324100000040646F2F4100000040A1F33241000000409F6F2F410000000082F33241000000A0D16F2F410000008074F332410000000000702F41000000E06CF33241000000A031702F41000000A06FF33241000000A070702F41000000A07BF33241000000C0A8702F410000004097F33241000000C0D4702F41000000E0BBF3324100000000FD702F4100000080E2F33241000000402F712F410000006006F432410000006069712F41000000601AF43241000000409D712F41000000C02BF4324100000000D3712F41000000E042F432410000000026722F41000000A059F432410000006077722F410000008072F4324100000040BE722F41000000C08CF432410000004004732F41000000209EF43241000000C02F732F4100000060AEF43241000000A061732F4100000000B6F43241000000A0A1732F4100000060BCF4324100000060D9732F4100000060CEF432410000006012742F4100000080E6F43241000000C045742F410000000005F532410000000073742F41000000A026F53241000000409B742F410000008044F53241000000A0B8742F410000002061F5324100000060E0742F410000006071F53241000000401B752F410000006078F53241000000005D752F41000000406FF5324100000040A0752F41000000A062F53241000000A0DC752F41000000005AF53241000000A023762F41000000A056F532410000004069762F41000000405EF5324100000040B0762F41000000C069F53241000000C0FB762F410000008071F53241000000604D772F410000004078F53241000000409E772F41000000407FF5324100000060F3772F410000000087F532410000000047782F410000006091F53241000000A093782F41000000009CF5324100000040E1782F4100000000A6F53241000000002F792F41000000C0A9F532410000004081792F41000000809DF5324100000000C7792F41000000808EF5324100000060067A2F41000000807FF53241000000A05A7A2F41000000C075F53241000000A0AF7A2F410000008074F5324100000040EF7A2F410000000077F53241000000402F7B2F410000008082F5324100000000927B2F410000006094F53241000000C0F27B2F4100000020ACF53241000000A0577C2F41000000E0C6F5324100000040BA7C2F4100000000EAF53241000000C02E7D2F41000000400BF6324100000000A87D2F41000000601AF63241000000A0FF7D2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('215','2767.250407','ROAD3','PL2043','3243','3781','3242','3780','BEAR WALLOW RD',NULL,NULL,'3243','3242','3781','3780','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('216','2447.083799','ROAD3','PL2043','101','589','100','588','MUD CREEK RD',NULL,NULL,'101','100','589','588','Right','roadswest.dbf','0.46','40','0.6900','10.0290',NULL,'1',NULL,NULL,'MUD CREEK','RD',NULL,'010500000001000000010200000029000000000000601F0633410000000077AB2F41000000A02506334100000040B4AB2F41000000002B063341000000A0D6AB2F410000002044063341000000601FAC2F41000000A061063341000000C05EAC2F41000000A07E06334100000040AAAC2F41000000809B063341000000C0F6AC2F41000000E0C0063341000000C05AAD2F4100000000E4063341000000A0C0AD2F4100000000FE063341000000A017AE2F4100000040160733410000004071AE2F41000000E03407334100000000ECAE2F41000000204E073341000000A069AF2F41000000005C07334100000060E3AF2F410000004069073341000000C060B02F41000000007E07334100000040E6B02F4100000060990733410000004067B12F41000000E0BC07334100000040D2B12F41000000A0E1073341000000C038B22F410000006002083341000000A0A8B22F410000006020083341000000C01BB32F41000000C03F08334100000040A5B32F41000000605B083341000000A031B42F41000000606F08334100000000B4B42F41000000E083083341000000A037B52F410000002096083341000000A09CB52F4100000020AD083341000000C0FEB52F4100000040CE0833410000004052B62F41000000C0EC08334100000040A1B62F410000000005093341000000A020B72F410000004011093341000000A0A9B72F41000000E011093341000000C03AB82F41000000E00809334100000040CCB82F4100000080F5083341000000A059B92F4100000040E2083341000000A0EAB92F4100000040DE0833410000000083BA2F4100000000DF083341000000401ABB2F4100000060DF083341000000C094BB2F41000000E0DC083341000000A00CBC2F4100000040CD083341000000C08EBC2F41BCA26925C10833410000000000BD2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('217','3498.104472','ROAD3','PL2043','101','763','100','762','EAST WHENLIN RIDGE RD',NULL,NULL,'101','100','763','762','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('218','4647.414283','ROAD3','PL2043','593','1481','592','1480','RIP SHIN RD',NULL,NULL,'593','592','1481','1480','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('219','10.865023','ROAD3','PL2044','591','591','590','590','MUD CREEK RD',NULL,NULL,'591','590','591','590','Right','roadswest.dbf','0.00','40','0.0000','0',NULL,'1',NULL,NULL,'MUD CREEK','RD',NULL,'010500000001000000010200000002000000BCA26925C10833410000000000BD2F41000000E0BE0833410000004015BD2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('220','837.080275','ROAD3','PL2044','663','829','662','828','MUD CREEK RD',NULL,NULL,'663','662','829','828','Right','roadswest.dbf','0.16','40','0.2400','10.0854',NULL,'1',NULL,NULL,'MUD CREEK','RD',NULL,'010500000001000000010200000016000000000000601D09334100000020ADBF2F41000000402B093341000000A0F1BF2F4100000080400933410000004055C02F41000000605A09334100000060ADC02F41000000C06D093341000000A002C12F410000008070093341000000A05EC12F41000000206A093341000000A0BEC12F41000000205C093341000000401DC22F41000000604C093341000000407EC22F410000000040093341000000A0DDC22F41000000803D093341000000A040C32F41000000804F093341000000C086C32F410000000061093341000000A0C6C32F41000000206809334100000040F8C32F41000000605D0933410000000031C42F41000000404D093341000000C040C42F41000000E0310933410000000045C42F41000000A0110933410000004049C42F4100000000EF083341000000A079C42F4100000000D508334100000040BCC42F4100000060C8083341000000C018C52F41FBA71A5FC6083341B291F9E330C52F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('221','1411.903585','ROAD3','PL2044','0','0','0','0',NULL,NULL,NULL,'0','0','0','0','Right','roadswest.dbf','0.27','40','0.4050','0',NULL,'0',NULL,NULL,NULL,NULL,NULL,'01050000000100000001020000001D00000000000040C4063341000000C02FCF2F41000000A0DE063341000000A0CFCE2F4100000040F20633410000006073CE2F4100000040040733410000006015CE2F410000006013073341000000C0B8CD2F410000006024073341000000A05BCD2F41000000C03C073341000000C000CD2F410000002056073341000000C0A8CC2F41000000E069073341000000405CCC2F41000000C07B073341000000600ECC2F41000000C08C07334100000060ADCB2F41000000409B0733410000006049CB2F4100000060AB073341000000C0DFCA2F41000000A0B50733410000000078CA2F4100000020B3073341000000C021CA2F4100000040B0073341000000A0C5C92F4100000000BF073341000000A048C92F4100000000D2073341000000A0D0C82F41000000E0DB073341000000A061C82F4100000080E707334100000040F1C72F41000000A0F5073341000000A092C72F41000000000A083341000000C037C72F41000000002D083341000000C0E4C62F410000008054083341000000409BC62F41000000C079083341000000005BC62F41000000809A083341000000C018C62F4100000060B008334100000040CAC52F41000000C0C0083341000000A074C52F41FBA71A5FC6083341B291F9E330C52F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('222','49.848310','ROAD3','PL2044','653','661','652','660','MUD CREEK RD',NULL,NULL,'653','652','661','660','Right','roadswest.dbf','0.01','40','0.0150','12.4620',NULL,'1',NULL,NULL,'MUD CREEK','RD',NULL,'010500000001000000010200000003000000000000A00A093341000000C050BF2F410000004017093341000000C08EBF2F41000000601D09334100000020ADBF2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('223','300.122593','ROAD3','PL2044','593','651','592','650','MUD CREEK RD',NULL,NULL,'593','592','651','650','Right','roadswest.dbf','0.06','40','0.0900','10.3490',NULL,'1',NULL,NULL,'MUD CREEK','RD',NULL,'010500000001000000010200000006000000000000E0BE0833410000004015BD2F41000000A0BF083341000000409CBD2F4100000040CA083341000000A020BE2F4100000040DB083341000000C08CBE2F4100000020F2083341000000C0F3BE2F41000000A00A093341000000C050BF2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('224','811.635383','ROAD3','PL2044','3783','3941','3782','3940','BEAR WALLOW RD',NULL,NULL,'3783','3782','3941','3940','Right','roadswest.dbf','0.15','40','0.2250','10.2738',NULL,'1',NULL,NULL,'BEAR WALLOW','RD',NULL,'01050000000100000001020000001300000000000020AC0B33410000000000BD2F41000000A07D0B3341000000C039BD2F41000000A0540B3341000000A071BD2F41000000002D0B3341000000C0ACBD2F41000000E0030B334100000040F2BD2F4100000020DB0A3341000000A03ABE2F41000000A0CC0A3341000000A052BE2F41000000C0B20A3341000000407DBE2F4100000000A10A3341000000A09DBE2F41000000408D0A334100000060C1BE2F41000000606B0A3341000000C01DBF2F41000000E0460A3341000000C07ABF2F41000000401A0A334100000040C4BF2F41000000C0E7093341000000A0F9BF2F4100000020B80933410000004011C02F4100000040870933410000004011C02F4100000040870933410000004011C02F41000000E054093341000000A0E7BF2F41000000601D09334100000020ADBF2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('225','289.262899','ROAD4','PL2050','1007','1103','1006','1102','WAGON RD',NULL,NULL,'1007','1006','1103','1102','Right','roadswest.dbf','0.05','40','0.0750','6.0264',NULL,'1',NULL,NULL,'WAGON','RD',NULL,'010500000001000000010200000005000000000000808E1A3341000000A083B32E4100000040DC1A3341000000408DB32E41000000002B1B334100000060B3B32E41000000808E1B3341000000C0DFB32E415E6253E3AA1B3341904DE766DEB32E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('226','332.564246','ROAD4','PL2050','895','1005','894','1004','WAGON RD',NULL,NULL,'895','894','1005','1004','Right','roadswest.dbf','0.06','40','0.0900','6.0466',NULL,'1',NULL,NULL,'WAGON','RD',NULL,'0105000000010000000102000000080000000000002042193341000000608DB32E410000002071193341000000408EB32E4100000060A21933410000004090B32E41000000A0D3193341000000A092B32E41000000C00E1A3341000000C08FB32E41000000E0491A3341000000C08AB32E41000000406C1A33410000004087B32E41000000808E1A3341000000A083B32E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('227','1646.950093','ROAD4','PL2050','737','895','736','894','WAGON RD',NULL,NULL,'737','736','895','894','Right','roadswest.dbf','0.31','40','0.4650','20.8474',NULL,'1',NULL,NULL,'WAGON','RD',NULL,'010500000001000000010200000035000000000000808418334100000000A6AC2E41000000807318334100000040DBAC2E41000000A06A1833410000004017AD2E41000000206C1833410000004050AD2E410000008081183341000000A07DAD2E4100000020A0183341000000C098AD2E41000000C0B91833410000000095AD2E4100000060D3183341000000A091AD2E4100000020EC183341000000A0AFAD2E410000004003193341000000C0D7AD2E41000000201F193341000000A0FDAD2E41000000E0381933410000004027AE2E41000000404E1933410000004055AE2E41000000005B193341000000C088AE2E410000002059193341000000A0B3AE2E410000008051193341000000A0DCAE2E410000008038193341000000C008AF2E41000000C01B193341000000A031AF2E4100000020081933410000004062AF2E41000000E0FA183341000000A098AF2E4100000040F918334100000040CDAF2E4100000000FC183341000000C003B02E41000000E0FF183341000000C03AB02E41000000A004193341000000C071B02E41000000000C19334100000000C1B02E41000000E00D193341000000600FB12E41000000E008193341000000A040B12E4100000020FF183341000000A06DB12E41000000E0EA183341000000C092B12E4100000000D3183341000000A0B2B12E4100000080B818334100000000D7B12E41000000E09F183341000000C0FEB12E41000000808B1833410000006035B22E41000000C07A183341000000A071B22E41000000C06E18334100000040B3B22E41000000406018334100000060F0B22E41000000204C1833410000004017B32E410000004034183341000000A036B32E41000000601A183341000000604CB32E410000002000183341000000C060B32E41000000C0E3173341000000407AB32E4100000060D2173341000000C099B32E4100000040DA173341000000A0BEB32E4100000060EA173341000000A0E2B32E41000000600E183341000000C007B42E410000004038183341000000A01CB42E41000000C0591833410000004031B42E41000000E07A183341000000A039B42E4100000060A3183341000000C017B42E41000000C0CA18334100000060E4B32E4100000000EF18334100000040BAB32E4100000060141933410000004098B32E410000002042193341000000608DB32E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('228','225.966756','ROAD4','PL2050','101','205','100','204','WOODDUCK RD',NULL,NULL,'101','100','205','204','Right','roadswest.dbf','0.04','40','0.0600','4.3456',NULL,'1',NULL,NULL,'WOODDUCK','RD',NULL,'010500000001000000010200000006000000C386303B3A193341E2485B408FB32E41840FBE47531933414095A9B03CB32E414708891E661933412228BAF707B32E415BE7FF428419334103BBCA3ED3B22E41018763C7BC193341CFA99A758FB22E418878F974E2193341451C33DD78B22E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('229','1165.082195','ROAD3','PL2050','945','1163','944','1162','LONG BRANCH RD',NULL,NULL,'945','944','1163','1162','Right','roadswest.dbf','0.22','40','0.3300','10.6888',NULL,'1',NULL,NULL,'LONG BRANCH','RD',NULL,'01050000000100000001020000001500000000000040872F334100000000A0D22E41000000607A2F3341000000C070D22E4100000060632F33410000004010D22E41000000A0512F334100000060B2D12E41000000603A2F33410000004058D12E41000000601F2F33410000004021D12E4100000060FF2E3341000000C0F5D02E4100000040D22E334100000000E5D02E4100000060C32E3341000000A0DFD02E41000000E0852E334100000060DFD02E41000000003C2E3341000000A0D5D02E41000000A0F12D334100000000CDD02E4100000000A72D334100000060C6D02E41000000005D2D3341000000A0BCD02E41000000E01A2D334100000040ABD02E41000000C0D82C33410000004095D02E41000000808E2C3341000000007CD02E4100000080462C3341000000C058D02E4100000080092C33410000004029D02E4100000060CE2B3341000000C0EECF2E4100000040912B334100000040A2CF2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('230','508.375783','ROAD3','PL2050','101','201','100','200','WELCH RD',NULL,NULL,'101','100','201','200','Right','roadswest.dbf','0.10','40','0.1500','10.1676',NULL,'1',NULL,NULL,'WELCH','RD',NULL,'01050000000100000001020000000E00000000000040912B334100000040A2CF2E4100000040722B334100000040A9CF2E41000000E0532B334100000040B4CF2E4100000000312B3341000000C0CCCF2E4100000000112B3341000000C0F0CF2E4100000020F52A33410000000022D02E4100000080DF2A3341000000A05DD02E41000000E0D52A3341000000C09DD02E4100000080CF2A334100000000E2D02E4100000060C32A3341000000403AD12E41000000E0B62A33410000006092D12E4100000020A82A334100000060FCD12E41000000009B2A33410000000067D22E4100000000962A334100000000A0D22E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('231','7111.305160','ROAD3','PL2050','1165','2513','1164','2512','LONG BRANCH RD',NULL,NULL,'1165','1164','2513','2512','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('232','704.617344','ROAD3','PL2050','705','829','704','828','CAMPBELL RD',NULL,NULL,'705','704','829','828','Right','roadswest.dbf','0.13','40','0.1950','11.3648',NULL,'1',NULL,NULL,'CAMPBELL','RD',NULL,'01050000000100000001020000001200000000000000E0393341000000005F872E41000000C0C93933410000000059872E41000000C09B393341000000A041872E410000000080393341000000A02A872E410000000065393341000000A011872E41000000403E393341000000A0F1862E410000008017393341000000C0CF862E4100000040F138334100000040A9862E41000000E0CB383341000000C07F862E4100000020A83833410000000055862E410000002085383341000000A028862E41000000E057383341000000A0EE852E41000000802B383341000000C0B1852E41000000A006383341000000A07B852E41000000C0E3373341000000C03F852E41000000C0C5373341000000C0FC842E4100000080AA373341000000A0B5842E4100000040973733410000000080842E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('233','3127.477693','ROAD3','PL2050','949','1509','948','1508','CAMPBELL RD',NULL,NULL,'949','948','1509','1508','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('234','138.228881','ROAD3','PL2050','879','903','878','902','TEABERRY RD',NULL,NULL,'879','878','903','902','Right','roadswest.dbf','0.03','40','0.0450','11.5190',NULL,'1',NULL,NULL,'TEABERRY','RD',NULL,'010500000001000000010200000004000000000000C0062433410000000080842E4100000040F4233341000000A0B2842E4100000020D2233341000000A007852E4100000080B4233341000000005E852E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('235','1105.942332','ROAD3','PL2050','519','717','518','716','SAWYERS RD',NULL,NULL,'519','518','717','716','Right','roadswest.dbf','0.21','40','0.3150','11.1712',NULL,'1',NULL,NULL,'SAWYERS','RD',NULL,'010500000001000000010200000019000000000000E0262033410000000080842E41000000603720334100000040AC842E41000000A05A2033410000006017852E41000000E07E203341000000607E852E4100000060AB203341000000C0E1852E4100000040DD2033410000004037862E41000000400B213341000000A06B862E41000000203D2133410000000098862E41000000207121334100000040C8862E4100000000A421334100000000E2862E4100000000A421334100000000E2862E41000000C0D1213341000000C0D4862E41000000E0FD213341000000A0B0862E410000006022223341000000A076862E410000008044223341000000C02F862E410000008064223341000000C0E4852E41000000A087223341000000609D852E41000000C0AC223341000000606E852E4100000080D5223341000000C04D852E410000004004233341000000C044852E410000008032233341000000C047852E410000000055233341000000C048852E410000008077233341000000A04A852E41000000C09C233341000000004E852E4100000080B4233341000000005E852E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('236','2410.738376','ROAD3','PL2050','905','1333','904','1332','TEABERRY RD',NULL,NULL,'905','904','1333','1332','Right','roadswest.dbf','0.46','40','0.6900','11.2652',NULL,'1',NULL,NULL,'TEABERRY','RD',NULL,'01050000000100000001020000002400000000000080B4233341000000005E852E41000000A0A223334100000060B5852E4100000080972333410000000011862E4100000060962333410000000081862E41000000209B233341000000C0F4862E4100000060A12333410000004079872E4100000020A523334100000000FF872E41000000809F2333410000000080882E41000000E09523334100000040FF882E41000000408A233341000000C07E892E41000000607D23334100000000FE892E41000000C06E233341000000608A8A2E410000002060233341000000A0168B2E41000000605323334100000040998B2E410000006046233341000000401C8C2E410000006037233341000000A0A08C2E41000000402823334100000060248D2E41000000C017233341000000C0C68D2E410000006007233341000000C0698E2E4100000060F7223341000000C0F88E2E4100000000E7223341000000A0878F2E4100000060D4223341000000C027902E41000000C0C2223341000000A0C8902E4100000080B2223341000000C064912E41000000C0A72233410000000001922E4100000060A62233410000004083922E4100000080AB2233410000006004932E41000000A0BD22334100000040A1932E4100000020D7223341000000003C942E4100000080F8223341000000C0E6942E41000000201C2333410000004091952E41000000A033233341000000C009962E41000000804A233341000000C082962E41000000A05D23334100000040ED962E410000006072233341000000C059972E41000000C086233341000000C0A3972E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('237','4010.926163','ROAD3','PL2050','101','831','100','830','ROBERT FAW RD',NULL,NULL,'101','100','831','830','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('238','4243.843969','ROAD3','PL2050','1335','2091','1334','2090','TEABERRY RD',NULL,NULL,'1335','1334','2091','2090','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('239','2921.017100','ROAD3','PL2050','691','1239','690','1238','POUNDING MILL RD',NULL,NULL,'691','690','1239','1238','Right','roadswest.dbf','0.55','40','0.8250','10.6606',NULL,'1',NULL,NULL,'POUNDING MILL','RD',NULL,'01050000000100000001020000003500000000000000E039334100000040F09A2E41000000C0C2393341000000C0099B2E41000000208039334100000040449B2E410000000042393341000000A07A9B2E41000000A00339334100000040B09B2E4100000080C738334100000040E29B2E41000000E0B238334100000060F39B2E41000000808B383341000000A0149C2E41000000805A383341000000403F9C2E41000000E029383341000000406B9C2E41000000E0F5373341000000C09D9C2E4100000060C2373341000000A0D29C2E410000004085373341000000A0159D2E410000006048373341000000405A9D2E410000004012373341000000C0969D2E4100000020DC36334100000040D39D2E410000002094363341000000C0229E2E41000000004C363341000000C0719E2E41000000003C36334100000000849E2E41000000A013363341000000C0BA9E2E4100000040F435334100000060DC9E2E41000000A0BA353341000000001B9F2E410000008083353341000000C0589F2E41000000004D353341000000A0979F2E41000000E017353341000000A0D39F2E41000000E0E33433410000006014A02E4100000080B9343341000000A054A02E41000000C091343341000000609BA02E41000000A06634334100000000FDA02E41000000803E3433410000000063A12E410000004018343341000000C0C1A12E4100000060F23333410000004021A22E41000000E0CA333341000000C080A22E4100000020A4333341000000A0E2A22E4100000080803333410000004048A32E41000000205E33334100000040AFA32E410000006039333341000000001FA42E41000000A013333341000000408DA42E41000000A0F3323341000000C0E4A42E4100000000D1323341000000C035A52E4100000080A2323341000000007FA52E410000002071323341000000C0C5A52E41000000A048323341000000A009A62E4100000040223233410000004052A62E4100000060F9313341000000C0B6A62E4100000000D53133410000000022A72E4100000060B7313341000000C083A72E41000000A09A31334100000040E6A72E4100000060823133410000000037A82E4100000040683133410000006084A82E41000000E059313341000000C0A8A82E41000000404A31334100000040CAA82E41000000003631334100000040EBA82E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('240','705.448354','ROAD3','PL2050','2547','2671','2546','2670','TEABERRY RD',NULL,NULL,'2547','2546','2671','2670','Right','roadswest.dbf','0.13','40','0.1950','11.3782',NULL,'1',NULL,NULL,'TEABERRY','RD',NULL,'01050000000100000001020000001C000000000000E03F37334100000000C6B02E410000000053373341000000C0CDB02E41000000E064373341000000A0D1B02E41000000E064373341000000A0D1B02E41000000E07337334100000040CDB02E41000000C08337334100000000C5B02E41000000C09637334100000060BAB02E4100000060AE373341000000A0A8B02E4100000020C6373341000000C094B02E41000000E0E9373341000000C078B02E41000000800D383341000000A05CB02E410000004033383341000000403EB02E410000002058383341000000C01DB02E41000000E074383341000000C0FDAF2E410000008092383341000000A0DEAF2E41000000C0AE383341000000C0C6AF2E4100000000CC38334100000040B5AF2E4100000040E638334100000060ADAF2E41000000C000393341000000C0ABAF2E41000000001A39334100000000B1AF2E410000000033393341000000A0BBAF2E41000000204B39334100000060CDAF2E41000000E061393341000000A0DDAF2E41000000A07C39334100000060E5AF2E410000004098393341000000C0E7AF2E410000004098393341000000C0E7AF2E4100000080B6393341000000C0E5AF2E4100000000E039334100000040DFAF2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('241','550.008386','ROAD4','PL2050','101','201','100','200','HIGHLAND LN',NULL,NULL,'101','100','201','200','Right','roadswest.dbf','0.10','40','0.1500','11.0002',NULL,'1',NULL,NULL,'HIGHLAND','LN',NULL,'01050000000100000001020000000F00000000000040B13033410000004072A82E41000000809E303341000000009EA82E41000000208B303341000000A0C8A82E41000000207430334100000040F6A82E41000000A05B303341000000C01FA92E4100000040433033410000006045A92E410000002029303341000000C05EA92E41000000200C303341000000005AA92E41000000E0ED2F3341000000C04CA92E4100000040CC2F33410000004047A92E41000000C0AA2F3341000000C048A92E4100000000842F33410000004059A92E41000000E05E2F3341000000A075A92E41000000203B2F334100000040A2A92E418BB918D4E02E334189BB01063EAA2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('242','944.737977','ROAD4','PL2050','101','267','100','266','CAUDILL LN',NULL,NULL,'101','100','267','266','Right','roadswest.dbf','0.18','40','0.2700','11.3824',NULL,'1',NULL,NULL,'CAUDILL','LN',NULL,'01050000000100000001020000002B000000000000E0B238334100000060F39B2E4100000040B4383341000000A00D9C2E41000000C0B5383341000000C0279C2E4100000060B9383341000000C0579C2E4100000020BD38334100000000889C2E41000000E0BE383341000000A0B19C2E41000000C0C038334100000000DB9C2E4100000080C638334100000000199D2E4100000040CC383341000000C0569D2E4100000020CE38334100000040919D2E4100000040D1383341000000C0CA9D2E4100000020DA383341000000A0079E2E4100000000E738334100000040419E2E41000000A0F1383341000000C0669E2E4100000080FE38334100000060899E2E410000008013393341000000C0A99E2E41000000802939334100000060C89E2E41000000E03A39334100000000E89E2E41000000C049393341000000C00B9F2E41000000204E393341000000401A9F2E41000000A05139334100000040299F2E410000002051393341000000A0509F2E41000000604C39334100000040799F2E410000008048393341000000C0AF9F2E41000000E044393341000000A0E69F2E410000002042393341000000001FA02E41000000803F393341000000C057A02E41000000E03B393341000000409BA02E41000000C038393341000000A0DEA02E41000000C037393341000000A02EA12E41000000E035393341000000607EA12E410000000033393341000000A0A8A12E41000000C02E39334100000040D2A12E41000000802739334100000060FBA12E41000000E01F393341000000A024A22E41000000A01C393341000000004AA22E410000000017393341000000C06CA22E4100000060133933410000000077A22E41000000200F393341000000C07FA22E41000000C0033933410000000088A22E41000000C0F6383341000000C089A22E41000000A0EB383341000000C088A22E4100000080E0383341000000A086A22E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('243','192.606688','ROAD4','PL2050','127','161','126','160','CHANDLER RD',NULL,NULL,'127','126','161','160','Right','roadswest.dbf','0.04','40','0.0600','11.3298',NULL,'1',NULL,NULL,'CHANDLER','RD',NULL,'01050000000100000001020000000900000000000000E03933410000004006882E4100000080D63933410000004027882E41000000E0CE3933410000006050882E4100000000C8393341000000C082882E41000000C0C439334100000040B6882E4100000080C5393341000000A0EA882E4100000080CA393341000000A01D892E4100000080D73933410000004058892E4100000000E0393341000000C071892E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('244','706.583545','ROAD4','PL2050','101','227','100','226','DEER RUN RD',NULL,NULL,'101','100','227','226','Right','roadswest.dbf','0.13','40','0.1950','11.2156',NULL,'1',NULL,NULL,'DEER RUN','RD',NULL,'01050000000100000001020000001B00000000000020531A3341000000C061AB2E41000000C0511A3341000000A079AB2E41000000A0501A33410000004091AB2E4100000000521A3341000000C0BFAB2E4100000020541A3341000000A0EEAB2E4100000020531A3341000000C033AC2E41000000804F1A3341000000A078AC2E41000000A04A1A3341000000C0B1AC2E41000000C0441A3341000000A0EAAC2E41000000A03F1A3341000000C01CAD2E41000000C0391A3341000000A04EAD2E41000000202F1A33410000006090AD2E41000000C0231A334100000000D2AD2E41000000201A1A3341000000C0FBAD2E4100000040171A33410000006020AE2E41000000A0231A33410000004035AE2E41000000A0331A3341000000A03EAE2E4100000020431A3341000000602AAE2E4100000060521A3341000000A00AAE2E41000000806B1A334100000000E9AD2E4100000020861A3341000000C0CBAD2E4100000060A91A334100000060ADAD2E41000000C0CD1A3341000000A093AD2E41000000C0EB1A3341000000C07AAD2E41000000000A1B3341000000A06CAD2E41000000C02B1B3341000000407FAD2E41000000804D1B3341000000409EAD2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('245','599.920679','ROAD3','PL2050','359','467','358','466','HARTSOE RD',NULL,NULL,'359','358','467','466','Right','roadswest.dbf','0.11','40','0.1650','11.1096',NULL,'1',NULL,NULL,'HARTSOE','RD',NULL,'010500000001000000010200000013000000000000A0241A33410000004041892E41000000C03D1A3341000000C064892E4100000000571A33410000000088892E41000000207F1A334100000040BE892E4100000000A91A334100000060ED892E41000000A0CB1A3341000000C0098A2E4100000080EF1A3341000000401D8A2E41000000001F1B3341000000C01F8A2E41000000204F1B3341000000A0168A2E4100000060751B3341000000000E8A2E41000000A09B1B334100000040048A2E41000000A0BF1B334100000000FB892E41000000A0E31B3341000000C0F5892E41000000E0FD1B3341000000C0F7892E41000000C0171C334100000000FE892E4100000060311C3341000000400D8A2E41000000204B1C3341000000C01A8A2E4100000040531C3341000000401C8A2E41000000605B1C3341000000401D8A2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('246','1376.213862','ROAD4','PL2050','101','375','100','374','WEAVER RD',NULL,NULL,'101','100','375','374','Right','roadswest.dbf','0.26','40','0.3900','10.0454',NULL,'1',NULL,NULL,'WEAVER','RD',NULL,'01050000000100000001020000002F00000000000040A72B3341000000A02BA12E41000000009C2B3341000000403AA12E4100000080902B3341000000C047A12E4100000020882B3341000000A050A12E41000000807F2B3341000000C057A12E41000000C0622B3341000000405FA12E4100000020452B33410000000060A12E41000000A0252B3341000000A064A12E4100000020082B33410000004072A12E4100000000F02A3341000000C09FA12E41000000E0D72A334100000040CAA12E41000000A0B82A334100000040D1A12E41000000E0982A334100000040C4A12E41000000607E2A3341000000C0A1A12E4100000060652A33410000004077A12E41000000C0482A3341000000004DA12E41000000E02A2A33410000004027A12E41000000C0052A3341000000A008A12E4100000060DF29334100000040EFA02E4100000060B829334100000040D3A02E41000000C090293341000000A0BCA02E410000004071293341000000C0AFA02E410000006052293341000000C0AEA02E41000000803529334100000040C5A02E41000000601A29334100000040E7A02E41000000A0052933410000006006A12E4100000000F2283341000000A028A12E4100000020DF2833410000004057A12E4100000020CA283341000000007EA12E4100000080B92833410000006089A12E4100000000A8283341000000408EA12E4100000060862833410000006072A12E41000000E065283341000000C05CA12E41000000E0542833410000004069A12E410000006048283341000000A07EA12E410000004047283341000000C09BA12E41000000A04A28334100000060BCA12E410000008053283341000000A0F3A12E41000000E060283341000000A027A22E41000000A0772833410000006063A22E41000000C08E283341000000A09EA22E41000000C0A028334100000040E6A22E41000000A0AE2833410000004031A32E4100000000BB283341000000408CA32E4100000020C128334100000040E9A32E41000000C0C1283341000000602CA42E41000000C0BC283341000000C06DA42E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('247','806.566156','ROAD3','PL2050','211','357','210','356','HARTSOE RD',NULL,NULL,'211','210','357','356','Right','roadswest.dbf','0.15','40','0.2250','11.0488',NULL,'1',NULL,NULL,'HARTSOE','RD',NULL,'010500000001000000010200000013000000000000A03B1833410000004084842E41000000E05E183341000000C0FE842E410000004082183341000000C06B852E4100000060A618334100000060D7852E4100000060C3183341000000C02F862E41000000C0DF1833410000004088862E4100000020F618334100000040D8862E41000000E00F193341000000A025872E4100000060351933410000000067872E41000000405E193341000000C09E872E41000000A08919334100000060D5872E41000000C0B5193341000000A009882E4100000040D81933410000004030882E41000000E0F7193341000000405B882E4100000040041A33410000006072882E41000000200F1A3341000000C08B882E41000000C01A1A3341000000C0B4882E4100000080221A334100000060E0882E41000000A0241A33410000004041892E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('248','576.496652','ROAD4','PL2050','203','309','202','308','HIGHLAND LN',NULL,NULL,'203','202','309','308','Right','roadswest.dbf','0.11','40','0.1650','10.8772',NULL,'1',NULL,NULL,'HIGHLAND','LN',NULL,'0105000000010000000102000000020000008BB918D4E02E334189BB01063EAA2E41F34FA9B7EA2D33417F4969AB50AE2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('249','325.000000','ROAD4','PL2050','101','165','100','164','LUTHER TESTERMAN RD',NULL,NULL,'101','100','165','164','Right','roadswest.dbf','0.06','40','0.0900','10.1562',NULL,'1',NULL,NULL,'LUTHER TESTERMAN','RD',NULL,'01050000000100000001020000000B000000000000401531334100000000FEA82E410000004016313341000000C03BA92E41000000C016313341000000A079A92E41000000E01931334100000040CBA92E41000000A0133133410000000014AA2E41000000E0013133410000000034AA2E4100000040ED303341000000A051AA2E4100000000D53033410000004082AA2E4100000060C030334100000060B8AA2E41000000A0B0303341000000C0FDAA2E41BF635F05A8303341DAB9645836AB2E41');
END;
BEGIN;
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('250','988.786138','ROAD4','PL2050','377','575','376','574','WEAVER RD',NULL,NULL,'377','376','575','574','Right','roadswest.dbf','0.19','40','0.2850','9.9878',NULL,'1',NULL,NULL,'WEAVER','RD',NULL,'01050000000100000001020000001B000000000000C0BC283341000000C06DA42E4100000040B2283341000000009AA42E41000000C0A628334100000000C6A42E41000000C0A0283341000000C012A52E4100000000972833410000004058A52E41000000007F2833410000006083A52E4100000000642833410000000098A52E410000000049283341000000A069A52E41000000E02E283341000000C020A52E41000000200D283341000000C0E4A42E41000000A0E727334100000060B6A42E41000000E0BD27334100000040A0A42E410000008092273341000000609EA42E41000000206E27334100000060ACA42E41000000E04D27334100000040CCA42E41000000403D273341000000C0F7A42E41000000E02D2733410000000028A52E41000000A019273341000000405BA52E41000000A002273341000000A07CA52E4100000020E72633410000004072A52E4100000020CC263341000000A053A52E41000000A0B02633410000000016A52E41000000609A263341000000C0CBA42E41000000A082263341000000C071A42E41000000C069263341000000001AA42E41000000E04326334100000040C0A32E4195A657961B2633417F0312257AA32E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('251','776.528765','ROAD4','PL2050','101','641','100','640','WAGON RD',NULL,NULL,'101','100','641','640','Right','roadswest.dbf','0.15','40','0.2250','2.8760',NULL,'1',NULL,NULL,'WAGON','RD',NULL,'010500000001000000010200000013000000000000407C1C33410000006031A72E41000000C0751C3341000000A050A72E41000000406E1C3341000000406EA72E41000000805C1C3341000000A092A72E4100000020481C3341000000C0B2A72E41000000C01F1C3341000000A0F6A72E41000000E0F61B3341000000A039A82E4100000020D41B3341000000C074A82E4100000040B11B3341000000A0AFA82E41000000E0891B3341000000A0ECA82E4100000000621B3341000000A028A92E4100000000381B3341000000C065A92E4100000020101B334100000060A7A92E41000000E0F11A334100000040ECA92E4100000080D51A3341000000C034AA2E4100000020B51A3341000000C085AA2E4100000020941A334100000000D6AA2E4100000020761A33410000004023AB2E4100000020531A3341000000C061AB2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('252','513.311756','ROAD4','PL2050','641','737','640','736','WAGON RD',NULL,NULL,'641','640','737','736','Right','roadswest.dbf','0.10','40','0.1500','10.6940',NULL,'1',NULL,NULL,'WAGON','RD',NULL,'01050000000100000001020000001000000000000020531A3341000000C061AB2E41000000003F1A33410000004074AB2E41000000002A1A3341000000C07DAB2E41000000600D1A3341000000406BAB2E4100000060F01933410000006053AB2E4100000040CC1933410000004055AB2E41000000C0A8193341000000C067AB2E4100000060981933410000004077AB2E4100000020881933410000004088AB2E41000000E05719334100000000B5AB2E410000002027193341000000C0DFAB2E410000002000193341000000C0FFAB2E4100000000DA183341000000C022AC2E4100000020B91833410000006049AC2E41000000409B183341000000A077AC2E41000000808418334100000000A6AC2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('253','14.726212','ROAD3','PL2050','1511','1513','1510','1512','CAMPBELL RD',NULL,NULL,'1511','1510','1513','1512','Right','roadswest.dbf','0.00','40','0.0000','14.7262',NULL,'1',NULL,NULL,'CAMPBELL','RD',NULL,'01050000000100000001020000000200000000000000442E3341000000409A842E418D976E523D2E33410000000080842E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('254','2536.987860','ROAD3','PL2050','2093','2545','2092','2544','TEABERRY RD',NULL,NULL,'2093','2092','2545','2544','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('255','1205.359312','ROAD4','PL2050','101','331','100','330','STAMPER DR',NULL,NULL,'101','100','331','330','Right','roadswest.dbf','0.23','40','0.3450','10.4814',NULL,'1',NULL,NULL,'STAMPER','DR',NULL,'01050000000100000001020000001F000000000000A0173433410000000070AD2E41000000A005343341000000609EAD2E4100000000F6333341000000C0CEAD2E41000000A0EB333341000000000FAE2E4100000040E53333410000004052AE2E4100000000DC333341000000A0D7AE2E4100000040DA333341000000C05DAF2E4100000020E1333341000000A0D5AF2E4100000000EA333341000000404DB02E41000000A0F2333341000000A0C9B02E4100000080F23333410000006043B12E4100000080DD33334100000040A3B12E41000000A0C7333341000000A003B22E41000000E0C3333341000000C047B22E4100000080C0333341000000A08CB22E41000000A0B8333341000000C0E8B22E41000000C0A5333341000000002FB32E410000000089333341000000C03BB32E41000000C067333341000000003BB32E410000004041333341000000A02FB32E41000000C01D333341000000C02EB32E41000000E0FE3233410000006069B32E41000000E0E332334100000000B8B32E41000000E0CE323341000000C0F0B32E4100000060B7323341000000C016B42E41000000E09B323341000000400EB42E41000000E08132334100000000F0B32E41000000A071323341000000A0BDB32E410000000064323341000000C083B32E41000000405C323341000000C06DB32E4100000040543233410000004058B32E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('256','2253.671120','ROAD3','PL2051','517','943','516','942','LONG BRANCH RD',NULL,NULL,'517','516','943','942','Right','roadswest.dbf','0.43','40','0.6450','10.5806',NULL,'1',NULL,NULL,'LONG BRANCH','RD',NULL,'010500000001000000010200000025000000000000A0A43633410000004092DB2E41000000C098363341000000C050DB2E41000000408C3633410000006011DB2E41000000C078363341000000C0A6DA2E410000002063363341000000003DDA2E41000000204836334100000040CFD92E41000000A024363341000000C06BD92E4100000040F4353341000000C027D92E4100000040BF35334100000040F3D82E41000000C078353341000000C0BCD82E410000002033353341000000C088D82E4100000020F4343341000000C044D82E4100000080B5343341000000C0FAD72E41000000406F34334100000040AAD72E41000000A028343341000000605AD72E41000000E0E6333341000000A013D72E4100000020A4333341000000A0CFD62E41000000405C333341000000008BD62E41000000C012333341000000004DD62E41000000E0CC323341000000401DD62E41000000208632334100000040F4D52E41000000E03B323341000000A0CFD52E4100000000F131334100000000B0D52E4100000040AF3133410000000099D52E41000000206E313341000000C080D52E41000000C02F3133410000004064D52E4100000020F3303341000000403FD52E4100000060BE303341000000C011D52E41000000608C30334100000060DAD42E41000000207030334100000040B0D42E410000000058303341000000408CD42E4100000020273033410000004033D42E41000000E0FF2F3341000000A0E1D32E41000000E0DA2F3341000000608BD32E41000000A0B52F3341000000C02ED32E41000000E0932F334100000060CED22E4100000040872F334100000000A0D22E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('257','2192.625353','ROAD3','PL2051','101','515','100','514','LONG BRANCH RD',NULL,NULL,'101','100','515','514','Right','roadswest.dbf','0.42','40','0.6300','10.5924',NULL,'1',NULL,NULL,'LONG BRANCH','RD',NULL,'010500000001000000010200000036000000000000C0193633410000004059EA2E41000000801E363341000000A0D3E92E41000000202236334100000000A2E92E4100000020253633410000004078E92E410000000023363341000000C038E92E41000000001E36334100000060FBE82E410000004016363341000000A0A6E82E41000000600E3633410000004052E82E41000000E006363341000000A0E8E72E410000002003363341000000007FE72E41000000A003363341000000601DE72E41000000400B363341000000A0C1E62E41000000E020363341000000C06CE62E41000000A03D363341000000C01AE62E41000000C05E36334100000040C5E52E41000000A081363341000000A071E52E4100000060AF3633410000000002E52E4100000000DD3633410000000092E42E4100000000F9363341000000004CE42E410000004015373341000000A006E42E410000004035373341000000C0B9E32E410000008054373341000000606CE32E41000000C0733733410000004018E32E41000000C09037334100000040C1E22E4100000020AC3733410000000063E22E4100000020C43733410000006001E22E4100000000D637334100000000A6E12E4100000080E43733410000000048E12E4100000040EC373341000000A007E12E4100000060F237334100000040C6E02E41000000E0F73733410000004072E02E4100000040FB373341000000401DE02E4100000040FD373341000000A0C8DF2E41000000E0FC3733410000000074DF2E4100000000FB373341000000A034DF2E4100000060F637334100000000F7DE2E4100000060EE373341000000C0BFDE2E4100000040E3373341000000A08ADE2E4100000020D5373341000000A057DE2E4100000000C4373341000000A029DE2E4100000060B03733410000000004DE2E41000000209A373341000000C0E3DD2E41000000E08337334100000040CCDD2E41000000406C373341000000C0B6DD2E41000000A04E373341000000A09EDD2E410000000031373341000000A082DD2E41000000C018373341000000C061DD2E41000000C002373341000000C03ADD2E41000000C0EF3633410000004009DD2E4100000000E036334100000060D3DC2E4100000040CF363341000000A084DC2E4100000060C1363341000000A034DC2E41000000E0B2363341000000A0E3DB2E41000000A0A43633410000004092DB2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('258','10978.401817','ROAD3','PL2051','307','2395','306','2394','EAST LITTLE HORSE CREEK RD',NULL,NULL,'307','306','2395','2394','Right','roadswest.dbf','2.08','40','3.1200','10.5158',NULL,'1','E',NULL,'LITTLE HORSE CREEK','RD',NULL,'0105000000010000000102000000D4000000000000C0193633410000004059EA2E41000000E003363341000000004DEA2E4100000060D9353341000000A029EA2E41000000C0B2353341000000A0E1E92E41000000E094353341000000A089E92E41000000E07E353341000000C017E92E41000000406F353341000000C0A1E82E41000000A05D353341000000C02CE82E41000000404C353341000000A0B6E72E410000004040353341000000A054E72E41000000803035334100000060F8E62E41000000801F35334100000000B9E62E41000000A00A353341000000008AE62E4100000080E4343341000000C075E62E4100000060B63433410000006076E62E410000000083343341000000A07AE62E410000004053343341000000C08FE62E410000004025343341000000C0C6E62E41000000A0FA333341000000C00FE72E41000000A0CE333341000000406BE72E4100000080B133334100000040ADE72E4100000000A433334100000060CBE72E41000000007A333341000000602FE82E41000000A0483333410000004081E82E41000000001D333341000000009DE82E4100000060EF323341000000A0A2E82E4100000060EF323341000000A0A2E82E41000000A0B93233410000006075E82E4100000020883233410000006033E82E41000000A05432334100000000F4E72E41000000E020323341000000A0B7E72E4100000020F1313341000000408FE72E41000000E0C0313341000000C062E72E41000000408E313341000000A018E72E41000000C05E31334100000060C6E62E41000000E038313341000000C075E62E4100000060123133410000004042E62E4100000000F43033410000006041E62E4100000040D83033410000004054E62E41000000C0C5303341000000C086E62E41000000E0B930334100000040CCE62E4100000000B5303341000000C031E72E4100000060B9303341000000A09CE72E41000000E0C2303341000000001BE82E41000000E0D0303341000000A098E82E4100000040DF303341000000A0FEE82E41000000C0EB3033410000004067E92E41000000A0F1303341000000C0E7E92E4100000040EE3033410000006068EA2E4100000060E330334100000060CEEA2E41000000E0D1303341000000A030EB2E41000000C0B2303341000000609EEB2E41000000A08B303341000000A002EC2E41000000005C3033410000004052EC2E41000000E03130334100000040A2EC2E41000000A01D303341000000A0EEEC2E410000004011303341000000A041ED2E41000000601130334100000060B0ED2E41000000E01A303341000000A023EE2E41000000A028303341000000C0A2EE2E41000000A036303341000000C023EF2E41000000E03D303341000000A0A2EF2E4100000080413033410000004021F02E4100000080433033410000006096F02E41000000603F303341000000000BF12E410000008038303341000000A05BF12E41000000002830334100000040A5F12E41000000000230334100000000CBF12E4100000020D72F334100000040D8F12E4100000020D72F334100000040D8F12E4100000000A92F334100000040D1F12E41000000C07B2F334100000000BFF12E41000000803B2F3341000000A0A7F12E4100000040FB2E3341000000408EF12E4100000060C92E3341000000A077F12E4100000020982E3341000000C068F12E4100000080622E3341000000C066F12E41000000E0322E3341000000C07EF12E41000000E0182E334100000040A7F12E4100000080062E334100000040DBF12E41000000A0022E3341000000A015F22E4100000040052E3341000000C057F22E41000000200E2E334100000040B7F22E41000000E01A2E33410000004017F32E41000000A0252E3341000000406FF32E4100000060302E3341000000A0C7F32E41000000403D2E3341000000603EF42E4100000020492E334100000040B5F42E41000000A0552E33410000004021F52E41000000005D2E3341000000C08FF52E4100000060572E3341000000C0FFF52E41000000A0482E3341000000006CF62E41000000A0382E334100000060BBF62E4100000020232E33410000006006F72E41000000A0012E3341000000C04FF72E41000000A0DC2D33410000004091F72E41000000A0B12D334100000060DAF72E4100000080872D3341000000A023F82E41000000A0682D33410000004062F82E41000000804A2D334100000000A2F82E41000000802C2D3341000000A0EAF82E4100000000092D3341000000C028F92E4100000080DE2C33410000004041F92E4100000060B22C3341000000A042F92E4100000060B22C3341000000A042F92E41000000E0872C3341000000C02BF92E41000000E05F2C3341000000C005F92E41000000403C2C3341000000C0D7F82E41000000801A2C334100000040A8F82E41000000A0F22B3341000000A07EF82E4100000080CB2B3341000000404DF82E41000000A0A92B334100000040FEF72E41000000C08E2B3341000000C0A4F72E4100000000852B3341000000A075F72E41000000207D2B3341000000404FF72E41000000006B2B334100000060FEF62E4100000040522B3341000000A0B6F62E4100000020342B3341000000A082F62E4100000040122B3341000000A06FF62E4100000020EF2A33410000000072F62E4100000020CD2A33410000004095F62E4100000020AE2A3341000000C0CCF62E4100000080912A3341000000C01AF72E4100000020762A3341000000C070F72E4100000060502A3341000000C0CAF72E41000000C0272A3341000000401FF82E4100000080FD2933410000004069F82E4100000000D3293341000000C0B0F82E41000000209F293341000000C012F92E41000000206C293341000000C077F92E41000000803A293341000000A0DAF92E41000000000A293341000000C03EFA2E41000000A0CF283341000000C0BDFA2E41000000C0972833410000006040FB2E41000000805628334100000040F0FB2E41000000A017283341000000A0A4FC2E4100000000E4273341000000A035FD2E4100000020B1273341000000A0C6FD2E41000000E07D2733410000000066FE2E410000000046273341000000A000FF2E4100000060082733410000006070FF2E41000000A0CD26334100000060DFFF2E41000000C0A7263341000000C04C002F41000000C086263341000000C0C2002F41000000206C263341000000A03A012F41000000205126334100000000B4012F410000004039263341000000400B022F41000000801E263341000000405F022F41000000400326334100000000A0022F4100000060EA253341000000C0DE022F4100000080D5253341000000C03E032F41000000C0C2253341000000A0A5032F4100000040AB253341000000C007042F41000000A08F2533410000004065042F41000000007125334100000040B2042F41000000604D25334100000060F7042F410000002017253341000000C036052F4100000000E0243341000000606E052F41000000E0B424334100000060AA052F41000000C08824334100000060E6052F41000000A05C243341000000401E062F41000000602C2433410000006042062F41000000602C2433410000006042062F4100000060F5233341000000C026062F4100000040DC233341000000600E062F4100000040C123334100000040F4052F410000008096233341000000A0CA052F41000000C06C23334100000060AA052F41000000C03823334100000000A9052F410000002001233341000000A0AE052F410000002001233341000000A0AE052F4100000060D7223341000000A0A6052F4100000000AE223341000000A095052F410000002076223341000000C05D052F410000006041223341000000401D052F410000002011223341000000A0ED042F4100000040E0213341000000C0C1042F41000000E0A921334100000040A0042F4100000080752133410000006071042F410000006052213341000000A020042F410000002036213341000000C0C5032F41000000E01B2133410000004069032F41000000A001213341000000A00E032F4100000000D7203341000000609F022F4100000000A72033410000004039022F41000000807720334100000060E9012F410000008046203341000000A099012F41000000A017203341000000C03C012F41000000E0EA1F334100000060DD002F4100000020C71F3341000000A095002F4100000020BC1F3341000000407F002F4100000040911F3341000000A018002F41000000A0721F33410000004090FF2E4100000080571F33410000006007FF2E41000000603B1F334100000040A2FE2E41000000001B1F33410000006043FE2E4100000020021F33410000006010FE2E4100000020ED1E334100000040E5FD2E41000000A0BA1E3341000000608CFD2E41000000A08E1E3341000000A03EFD2E4100000000631E3341000000A0EFFC2E41000000E0321E3341000000408DFC2E4100000000041E3341000000A029FC2E4100000080DA1D3341000000A0D5FB2E4100000060B11D3341000000A07EFB2E4100000080991D33410000006039FB2E4100000060801D3341000000A007FB2E4100000060681D3341000000A0FBFA2E41000000804D1D334100000040FBFA2E4100000020281D3341000000A011FB2E4100000040031D33410000004037FB2E4100000000E01C3341000000A062FB2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('259','233.102923','ROAD3','PL2051','717','759','716','758','SOUTH BIG HORSE CREEK RD',NULL,NULL,'717','716','759','758','Right','roadswest.dbf','0.04','40','0.0600','11.1002',NULL,'1','S',NULL,'BIG HORSE CREEK','RD',NULL,'01050000000100000001020000000600000000000000E0393341000000A0EEE62E41000000E0D1393341000000A00DE72E4100000020B8393341000000C04BE72E41000000A097393341000000A0A5E72E41000000207A393341000000A003E82E41000000C05D393341000000406FE82E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('260','2147.675938','ROAD3','PL2051','101','499','100','498','FLEM OSBORN RD',NULL,NULL,'101','100','499','498','Right','roadswest.dbf','0.41','40','0.6150','10.7924',NULL,'1',NULL,NULL,'FLEM OSBORN','RD',NULL,'0105000000010000000102000000310000000000002087193341000000406FF22E41000000405F193341000000C006F22E410000000050193341000000C0DDF12E410000000035193341000000009DF12E41000000A01A193341000000605DF12E410000008003193341000000A010F12E41000000E0E718334100000040C8F02E4100000080C0183341000000A09FF02E41000000E097183341000000C080F02E41000000E0691833410000004051F02E41000000C03C183341000000601DF02E41000000E00B183341000000C0DDEF2E4100000060DB173341000000C09BEF2E41000000E0B21733410000004068EF2E41000000E08A173341000000A034EF2E41000000A065173341000000A001EF2E41000000004117334100000040CCEE2E41000000E025173341000000C0A5EE2E41000000600F173341000000407CEE2E4100000060031733410000006047EE2E4100000080F7163341000000A00BEE2E4100000080E416334100000040D5ED2E4100000040CF16334100000060A3ED2E4100000080AE163341000000C064ED2E41000000A08E163341000000C027ED2E41000000C07116334100000060DCEC2E41000000E057163341000000C08BEC2E41000000A03F163341000000C02FEC2E41000000802616334100000000D3EB2E410000000000163341000000A06CEB2E4100000080D6153341000000400CEB2E41000000A0AF15334100000040B0EA2E4100000060851533410000004059EA2E410000004050153341000000A00CEA2E41000000401915334100000040C6E92E4100000040ED143341000000008EE92E41000000A0C51433410000004050E92E4100000020AA143341000000A002E92E41000000A08E143341000000C0AEE82E41000000606A1433410000006067E82E41000000A0461433410000004022E82E41000000C033143341000000A0F5E72E410000004022143341000000C0C6E72E410000004016143341000000A09CE72E41000000E008143341000000C071E72E41000000E0F31333410000006043E72E41000000C0D9133341000000A021E72E4100000000BD133341000000C01EE72E4100000000A1133341000000A025E72E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('261','1084.185027','ROAD3','PL2051','101','305','100','304','EAST LITTLE HORSE CREEK RD',NULL,NULL,'101','100','305','304','Right','roadswest.dbf','0.21','40','0.3150','10.6292',NULL,'1','E',NULL,'LITTLE HORSE CREEK','RD',NULL,'010500000001000000010200000023000000000000C05D393341000000406FE82E410000004040393341000000A060E82E4100000060FA383341000000402FE82E41000000C0CB383341000000600EE82E4100000080B438334100000000FEE72E41000000609138334100000060E4E72E41000000A06D383341000000C0CCE72E41000000604D38334100000040BBE72E41000000602C38334100000060AFE72E41000000A00D383341000000A0ABE72E41000000C0EE373341000000C0B0E72E4100000060CD373341000000C0C4E72E41000000C0AE373341000000C0E5E72E4100000000943733410000004017E82E41000000807E373341000000A051E82E41000000A06F3733410000004089E82E41000000C063373341000000A0C3E82E4100000040583733410000006013E92E41000000204F373341000000A063E92E4100000080493733410000004094E92E410000006043373341000000C0C3E92E41000000C03B373341000000A0F1E92E410000006032373341000000401DEA2E41000000C028373341000000603FEA2E41000000801D373341000000605EEA2E41000000A00F373341000000A079EA2E41000000E0FF363341000000A090EA2E4100000020E6363341000000C0A7EA2E4100000000D2363341000000A0ADEA2E4100000060BC363341000000A0AFEA2E4100000060BC363341000000A0AFEA2E41000000C080363341000000A098EA2E410000002058363341000000407FEA2E41000000802F3633410000004065EA2E41000000C0193633410000004059EA2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('262','2020.053120','ROAD3','PL2051','761','1143','760','1142','SOUTH BIG HORSE CREEK RD',NULL,NULL,'761','760','1143','1142','Right','roadswest.dbf','0.38','40','0.5700','10.5762',NULL,'1','S',NULL,'BIG HORSE CREEK','RD',NULL,'010500000001000000010200000026000000000000C05D393341000000406FE82E41000000804C393341000000C0B5E82E410000002036393341000000A00FE92E410000000021393341000000A06AE92E41000000C00B39334100000040D3E92E4100000080F9383341000000403EEA2E4100000080EC38334100000060A1EA2E4100000060E2383341000000A005EB2E41000000E0DA383341000000A067EB2E4100000060D538334100000040CAEB2E41000000C0D03833410000000048EC2E41000000C0CE38334100000040C6EC2E4100000080D0383341000000A04AED2E41000000C0D238334100000000CEED2E4100000080D2383341000000603CEE2E4100000000D1383341000000A0AAEE2E4100000020CC383341000000A03AEF2E41000000C0C5383341000000C0CAEF2E4100000060BF383341000000C05FF02E4100000020B838334100000060F4F02E41000000C0B13833410000004069F12E41000000C0A938334100000040DDF12E4100000020A13833410000006042F22E41000000A095383341000000A0A5F22E4100000080863833410000004003F32E41000000E072383341000000C05CF32E41000000805E383341000000A0A2F32E41000000804638334100000040E3F32E41000000E026383341000000C022F42E410000008003383341000000405CF42E41000000A0DC373341000000A092F42E4100000000B4373341000000C0C3F42E41000000408437334100000060F6F42E4100000040533733410000000026F52E41000000E023373341000000A054F52E4100000060F43633410000004082F52E4100000060C4363341000000C0AEF52E410000004094363341000000C0DAF52E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('263','1499.427005','ROAD3','PL2051','101','379','100','378','JOE HAMPTON RD',NULL,NULL,'101','100','379','378','Right','roadswest.dbf','0.28','40','0.4200','10.7872',NULL,'1',NULL,NULL,'JOE HAMPTON','RD',NULL,'01050000000100000001020000001A00000000000000E01C3341000000A062FB2E41000000C0D31C33410000004031FB2E41000000A0C61C334100000040EEFA2E4100000060B91C334100000040ABFA2E4100000060A01C3341000000A02FFA2E4100000000871C334100000040B4F92E41000000206D1C3341000000C035F92E4100000060531C3341000000A0B7F82E41000000E0331C33410000004014F82E4100000080111C33410000006072F72E4100000020F31B3341000000A0FBF62E41000000E0D01B3341000000C088F62E4100000000A91B3341000000001EF62E41000000007E1B3341000000A0B8F52E4100000060451B3341000000403EF52E41000000200B1B334100000060C7F42E41000000C0D81A3341000000A060F42E4100000040A61A334100000000FAF32E41000000806D1A3341000000C084F32E4100000000351A3341000000000FF32E41000000C01A1A334100000060D6F22E4100000080FF193341000000409FF22E4100000020ED193341000000C079F22E41000000C0D6193341000000A059F22E4100000020B4193341000000604EF22E410000002087193341000000406FF22E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('264','766.624217','ROAD3','PL2051','203','357','202','356','WELCH RD',NULL,NULL,'203','202','357','356','Right','roadswest.dbf','0.15','40','0.2250','9.9562',NULL,'1',NULL,NULL,'WELCH','RD',NULL,'01050000000100000001020000001300000000000000962A334100000000A0D22E4100000040922A334100000040CAD22E41000000E08A2A3341000000002ED32E4100000060852A3341000000A07FD32E41000000E07E2A3341000000A0D0D32E41000000E0712A33410000004035D42E41000000A0612A33410000004098D42E41000000A0512A334100000040EBD42E4100000040402A3341000000C03CD52E41000000E02C2A3341000000A091D52E41000000A0182A3341000000C0E5D52E4100000020052A33410000006038D62E4100000020F0293341000000A089D62E41000000A0D829334100000040D9D62E41000000A0BD2933410000006023D72E41000000809F293341000000405DD72E41000000A07F2933410000006094D72E410000002060293341000000C0CFD72E41CEEA690F5529334101F463F8E5D72E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('265','6438.847563','ROAD3','PL2051','1145','2367','1144','2366','SOUTH BIG HORSE CREEK RD',NULL,NULL,'1145','1144','2367','2366','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('266','6200.081546','ROAD3','PL2051','2397','3577','2396','3576','EAST LITTLE HORSE CREEK RD',NULL,NULL,'2397','2396','3577','3576','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('267','2119.747595','ROAD3','PL2051','381','775','380','774','JOE HAMPTON RD',NULL,NULL,'381','380','775','774','Right','roadswest.dbf','0.40','40','0.6000','10.7602',NULL,'1',NULL,NULL,'JOE HAMPTON','RD',NULL,'01050000000100000001020000001D0000000000002087193341000000406FF22E41000000A0731933410000004094F22E41000000C05D19334100000060DDF22E410000002046193341000000A059F32E41000000003019334100000040D1F32E41000000A0091933410000004036F42E4100000080DB183341000000A091F42E41000000208E1833410000006004F52E41000000A039183341000000A065F52E41000000A0E017334100000040BCF52E410000000085173341000000000AF62E410000004032173341000000004BF62E4100000060DF163341000000A08CF62E41000000209E16334100000040C5F62E41000000E05D163341000000C002F72E41000000A016163341000000A053F72E4100000040D115334100000000AAF72E41000000008C153341000000A006F82E410000006047153341000000A063F82E4100000040F7143341000000C0C7F82E4100000080A6143341000000A02BF92E41000000005B143341000000008CF92E41000000800F14334100000060ECF92E41000000A0C5133341000000A047FA2E41000000008F133341000000008CFA2E41000000E07B13334100000000A4FA2E41000000A031133341000000C006FB2E41000000C0E7123341000000606AFB2E4100000000D0123341000000A089FB2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('268','2281.602782','ROAD3','PL2052','219','605','218','604','POWERS HOLLOW RD',NULL,NULL,'219','218','605','604','Right','roadswest.dbf','0.43','40','0.6450','11.8218',NULL,'1',NULL,NULL,'POWERS HOLLOW','RD',NULL,'0105000000010000000102000000350000000000004067343341000000A01A582F41000000E079343341000000C034582F41000000208C3433410000004050582F41000000E09E343341000000A06F582F4100000080B03433410000006091582F4100000020BF34334100000000B7582F41000000E0CD34334100000040DC582F4100000040DB343341000000C0F3582F4100000060E9343341000000400A592F4100000000FD343341000000A024592F41000000600E353341000000A042592F410000000016353341000000605C592F41000000801B353341000000A078592F41000000201F353341000000C0BE592F41000000001A35334100000040065A2F410000008009353341000000C05B5A2F4100000080F3343341000000A0AE5A2F41000000C0E334334100000040F25A2F4100000080D1343341000000C0325B2F4100000040BF343341000000A05F5B2F4100000080AB343341000000408A5B2F41000000808534334100000040CF5B2F41000000A06334334100000040195C2F41000000C04D343341000000A0725C2F410000006044343341000000A0D25C2F41000000C04834334100000000165D2F41000000405334334100000000585D2F41000000A064343341000000C0985D2F41000000C07734334100000060D85D2F410000002093343341000000C0455E2F41000000C0A334334100000040B75E2F4100000020A034334100000000215F2F410000004092343341000000008A5F2F41000000607C34334100000040E95F2F41000000C0653433410000004048602F41000000405634334100000040D1602F41000000604C343341000000A05D612F41000000C0393433410000004032622F41000000402F343341000000A007632F410000004035343341000000A0AF632F41000000603D3433410000004058642F41000000803F343341000000C0D4642F41000000003E3433410000004051652F41000000603234334100000040B3652F41000000E030343341000000A00C662F41000000604A343341000000A042662F41000000006B343341000000C073662F41000000C08B343341000000A0B3662F4100000000AA343341000000A0F7662F4100000040C4343341000000A044672F41000000C0DB343341000000A095672F4100000040E7343341000000A0BF672F41000000A0F2343341000000C0E9672F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('269','1795.203786','ROAD3','PL2052','2369','2711','2368','2710','SOUTH BIG HORSE CREEK RD',NULL,NULL,'2369','2368','2711','2710','Right','roadswest.dbf','0.34','40','0.5100','10.4982',NULL,'1','S',NULL,'BIG HORSE CREEK','RD',NULL,'010500000001000000010200000018000000000000A0112C334100000000C0202F41000000C0012C334100000040E0202F41000000A0C42B3341000000C060212F41000000C08A2B3341000000A0DF212F41000000C0512B33410000004060222F41000000A0242B3341000000A0C7222F4100000060F82A33410000006031232F4100000060CC2A3341000000C0A7232F41000000A0A12A3341000000601F242F41000000A04D2A3341000000A06F252F4100000000242A33410000000004262F4100000060F6293341000000C094262F4100000020BE293341000000A016272F410000006083293341000000C091272F410000008045293341000000A01F282F41000000E00529334100000000AC282F4100000000C8283341000000C026292F41000000E087283341000000A09D292F41000000C04A283341000000C0002A2F410000000012283341000000C0682A2F41000000E0ED273341000000C0BC2A2F41000000A0D527334100000040152B2F4100000080D3273341000000C0842B2F4100000080D7273341000000A0A52B2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('270','1550.444876','ROAD3','PL2052','101','393','100','392','BIG HORSE CREEK RD',NULL,NULL,'101','100','393','392','Right','roadswest.dbf','0.29','40','0.4350','10.6194',NULL,'1',NULL,NULL,'BIG HORSE CREEK','RD',NULL,'01050000000100000001020000001B00000000000080D7273341000000A0A52B2F41000000A0E127334100000040F82B2F41000000200528334100000060732C2F41000000A03428334100000060E92C2F41000000006028334100000060652D2F41000000609128334100000060C82D2F4100000000C228334100000000F62D2F4100000000F7283341000000A00A2E2F4100000000F7283341000000A00A2E2F41000000202129334100000000012E2F41000000A04C29334100000060EA2D2F410000008089293341000000C0C02D2F4100000000C629334100000040902D2F4100000060062A3341000000A05E2D2F4100000020462A3341000000602C2D2F41000000608A2A334100000040EF2C2F4100000020D12A3341000000A0BC2C2F4100000000152B334100000040A62C2F4100000020592B334100000040AA2C2F4100000040942B3341000000C0CE2C2F4100000040CA2B3341000000400B2D2F4100000040F82B3341000000A05F2D2F41000000001E2C334100000040C32D2F41000000003C2C3341000000602E2E2F4100000000512C334100000040A12E2F41000000605D2C3341000000A0082F2F41000000405D2C3341000000005D2F2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('271','4142.240398','ROAD3','PL2052','395','1179','394','1178','BIG HORSE CREEK RD',NULL,NULL,'395','394','1179','1178','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('272','271.123405','ROAD3','PL2052','1333','1385','1332','1384','ANDERSON HILL RD',NULL,NULL,'1333','1332','1385','1384','Right','roadswest.dbf','0.05','40','0.0750','10.4278',NULL,'1',NULL,NULL,'ANDERSON HILL','RD',NULL,'01050000000100000001020000000700000000000000BC2C33410000000045312F4100000080A22C33410000004096302F4100000060892C334100000000E72F2F4100000040822C3341000000C0B42F2F41000000407F2C334100000040972F2F4100000000742C3341000000006E2F2F41000000405D2C3341000000005D2F2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('273','3803.585654','ROAD3','PL2052','611','1331','610','1330','ANDERSON HILL RD',NULL,NULL,'611','610','1331','1330','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('274','2377.809154','ROAD3','PL2052','1377','1831','1376','1830','BEE TREE RD',NULL,NULL,'1377','1376','1831','1830','Right','roadswest.dbf','0.45','40','0.6750','10.4750',NULL,'1',NULL,NULL,'BEE TREE','RD',NULL,'01050000000100000001020000002D000000000000E0B8343341000000A01A532F41000000A09F34334100000040F2522F41000000407A343341000000C089522F41000000C059343341000000601D522F410000006039343341000000A0C4512F41000000E015343341000000C072512F4100000000EF3333410000004032512F41000000A0C4333341000000A0FA502F41000000608F333341000000C0C9502F41000000E0573333410000006099502F41000000E01D3333410000004050502F41000000A0E63233410000000000502F4100000040C332334100000040C84F2F41000000A09F32334100000040934F2F41000000C08E323341000000C07B4F2F41000000007F323341000000406C4F2F41000000A068323341000000C06A4F2F41000000004F32334100000040724F2F410000004033323341000000007A4F2F41000000C01632334100000000824F2F41000000A0C3313341000000C0834F2F41000000A0C3313341000000C0834F2F410000002071313341000000A07A4F2F410000004029313341000000C0784F2F4100000000E1303341000000C06B4F2F4100000020A230334100000040454F2F410000008065303341000000A0154F2F410000008026303341000000C0E34E2F41000000E0E72F3341000000C0B24E2F41000000609C2F3341000000C0814E2F41000000C0502F3341000000A04D4E2F41000000801B2F3341000000A01E4E2F4100000080E72E3341000000A0EA4D2F4100000000A72E3341000000C09E4D2F4100000040682E3341000000A04D4D2F41000000A02E2E334100000000004D2F4100000040F52D334100000000B24C2F4100000040BB2D3341000000C05F4C2F41000000C07F2D3341000000401A4C2F41000000C04C2D3341000000C0F64B2F41000000A0172D334100000040DF4B2F4100000080F02C3341000000C0DB4B2F41000000C0C72C334100000040D04B2F4100000020B62C334100000040BF4B2F41000000E09B2C3341000000A09F4B2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('275','443.076108','ROAD3','PL2052','1293','1375','1292','1374','BEE TREE RD',NULL,NULL,'1293','1292','1375','1374','Right','roadswest.dbf','0.08','40','0.1200','10.8068',NULL,'1',NULL,NULL,'BEE TREE','RD',NULL,'01050000000100000001020000000A000000000000E026363341000000C008552F41000000400C363341000000C0D6542F41000000A0E2353341000000C092542F4100000080B8353341000000A050542F4100000040923533410000004019542F41000000206B35334100000000E5532F41000000403735334100000000AA532F41000000A0023533410000000070532F41000000A0CF343341000000C036532F41000000E0B8343341000000A01A532F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('276','1018.781955','ROAD3','PL2052','1099','1291','1098','1290','BEE TREE RD',NULL,NULL,'1099','1098','1291','1290','Right','roadswest.dbf','0.19','40','0.2850','10.6124',NULL,'1',NULL,NULL,'BEE TREE','RD',NULL,'01050000000100000001020000002F00000000000000E0393341000000C0BE552F41000000A0BE393341000000A0B3552F41000000E0A9393341000000A0B3552F41000000E095393341000000A0B9552F41000000A082393341000000C0C0552F41000000806D393341000000C0C5552F41000000C058393341000000C0C6552F41000000C058393341000000C0C6552F41000000A046393341000000A0C0552F41000000E03339334100000040B7552F41000000E01A393341000000C0AA552F410000000002393341000000A09D552F4100000040E8383341000000C08F552F4100000060CE3833410000000083552F4100000040BC383341000000007B552F41000000E0A9383341000000A074552F41000000A097383341000000006F552F41000000C084383341000000606D552F410000000073383341000000A072552F41000000A061383341000000A07D552F41000000604B383341000000A09B552F41000000A037383341000000C0BD552F410000002025383341000000C0D9552F41000000201238334100000040F3552F41000000E0FE373341000000A007562F4100000000EB373341000000C016562F41000000E0D5373341000000401E562F41000000A0BF3733410000004021562F4100000080A83733410000006023562F4100000080A83733410000006023562F41000000E091373341000000A021562F41000000807D3733410000000019562F41000000E068373341000000400D562F41000000E053373341000000A0FF552F41000000403E373341000000A0F2552F41000000002B373341000000A0EB552F41000000A017373341000000C0E6552F41000000400137334100000060E4552F41000000A0EB36334100000040E1552F4100000020D7363341000000C0D8552F41000000E0C2363341000000A0CC552F4100000060AE363341000000C0BB552F41000000209A36334100000040A8552F41000000E080363341000000408E552F41000000E068363341000000C071552F410000006047363341000000403F552F41000000E026363341000000C008552F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('277','692.277665','ROAD3','PL2052','101','217','100','216','POWERS HOLLOW RD',NULL,NULL,'101','100','217','216','Right','roadswest.dbf','0.13','40','0.1950','11.9358',NULL,'1',NULL,NULL,'POWERS HOLLOW','RD',NULL,'01050000000100000001020000000E000000000000E0B8343341000000A01A532F41000000009A3433410000004050532F41000000A079343341000000A093532F41000000805B34334100000040DC532F410000002045343341000000002D542F4100000020353433410000000084542F41000000602E34334100000040F3542F41000000202F343341000000C062552F41000000E031343341000000A0D0552F410000008037343341000000003E562F41000000004134334100000040BC562F41000000E04C343341000000A039572F41000000005B343341000000A0AA572F410000004067343341000000A01A582F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('278','2143.744614','ROAD3','PL2052','101','513','100','512','IRA POWERS RD',NULL,NULL,'101','100','513','512','Right','roadswest.dbf','0.41','40','0.6150','10.4066',NULL,'1',NULL,NULL,'IRA POWERS','RD',NULL,'010500000001000000010200000031000000000000E01E2A3341000000A00F262F4100000040062A334100000040EB252F4100000040062A334100000040EB252F4100000080F0293341000000A0CB252F4100000040DA293341000000C0AC252F4100000060B82933410000004085252F41000000E0952933410000000060252F41000000806F2933410000004038252F41000000004A293341000000600F252F41000000A02C29334100000000E6242F41000000A00D29334100000060BD242F4100000000DF2833410000006097242F41000000A0AE283341000000C07C242F41000000607A2833410000006068242F41000000A045283341000000C05B242F41000000E0092833410000004055242F4100000020CE2733410000000056242F41000000E092273341000000C05A242F410000000058273341000000C069242F41000000A018273341000000408D242F41000000E0DB26334100000040C0242F4100000020B1263341000000C0F5242F410000004087263341000000C027252F41000000A0652633410000000041252F41000000C042263341000000A052252F41000000E01C263341000000A05A252F4100000000F7253341000000C058252F4100000040C4253341000000A041252F410000006090253341000000C022252F41000000E05D253341000000C00E252F41000000602B25334100000040FE242F41000000E0FE243341000000C0F0242F4100000000D2243341000000A0E5242F4100000020AA243341000000A0DE242F41000000608224334100000040D8242F410000008057243341000000C0CF242F41000000C02C24334100000060C6242F41000000600024334100000060BA242F41000000A0D4233341000000A0AB242F4100000020A42333410000006092242F41000000C072233341000000C07B242F41000000004F2333410000000073242F41000000C02A233341000000C072242F41000000E003233341000000A087242F41000000A0DE223341000000C0A0242F4100000080AE22334100000060B8242F41000000E07E223341000000C0C2242F41000000C051223341000000C0B3242F410000006023223341000000609B242F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('279','9396.346230','ROAD3','PL2052','1181','2965','1180','2964','BIG HORSE CREEK RD',NULL,NULL,'1181','1180','2965','2964','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('280','7849.239456','ROAD3','PL2052','101','1605','100','1604','BIG WINDFALL RD',NULL,NULL,'101','100','1605','1604','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('281','476.241460','ROAD4','PL2053','273','369','272','368','PERRY GRAHAM RD',NULL,NULL,'273','272','369','368','Right','roadswest.dbf','0.09','40','0.1350','9.9216',NULL,'1',NULL,NULL,'PERRY GRAHAM','RD',NULL,'010500000001000000010200000018000000000000A09827334100000040E57F2F41000000609927334100000040EB7F2F410000006099273341000000A0F07F2F41000000209C273341000000C012802F4100000060A12733410000004034802F4100000020AA273341000000A055802F41000000C0B3273341000000A076802F41000000C0BD27334100000000A1802F4100000060C6273341000000A0CC802F4100000000CC273341000000A0F4802F4100000000D1273341000000401D812F41000000A0D8273341000000A052812F4100000020DF2733410000004088812F4100000020E3273341000000A0C4812F4100000060E5273341000000A001822F4100000080E6273341000000403B822F4100000040E7273341000000A074822F4100000020E827334100000060AD822F4100000000EA27334100000000E6822F41000000C0EA273341000000400D832F41000000A0EF273341000000402F832F4100000020F9273341000000A03D832F410000006004283341000000004A832F412E315181122833415D4E1C755A832F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('282','670.592588','ROAD4','PL2053','101','233','100','232','PERRY GRAHAM RD',NULL,NULL,'101','100','233','232','Right','roadswest.dbf','0.13','40','0.1950','10.1604',NULL,'1',NULL,NULL,'PERRY GRAHAM','RD',NULL,'01050000000100000001020000001E000000634162C331253341E5F7FD56697E2F41000000E033253341000000606A7E2F41000000C03125334100000060697E2F410000000054253341000000407A7E2F41000000A063253341000000A0847E2F410000004073253341000000C08F7E2F41000000608825334100000040A37E2F41000000E09C253341000000C0B47E2F41000000A0BD25334100000060C67E2F4100000060DF253341000000C0CE7E2F4100000040FB253341000000C0D07E2F410000006015263341000000A0C97E2F41000000202F263341000000A0B07E2F410000002046263341000000408C7E2F41000000604A263341000000A0817E2F410000002055263341000000C0667E2F410000000064263341000000A03E7E2F41000000C074263341000000C0147E2F41000000208926334100000000F27D2F41000000C0A626334100000000E67D2F4100000040C526334100000060EA7D2F4100000040DC263341000000C0F57D2F4100000080F226334100000000067E2F41000000A00C273341000000401F7E2F410000000026273341000000C0327E2F410000006037273341000000A0347E2F41000000404A27334100000060357E2F41000000005D273341000000C0387E2F41000000A06F27334100000060437E2F410000006083273341000000A0727E2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('283','188.165952','ROAD4','PL2053','235','271','234','270','PERRY GRAHAM RD',NULL,NULL,'235','234','271','270','Right','roadswest.dbf','0.04','40','0.0600','10.4536',NULL,'1',NULL,NULL,'PERRY GRAHAM','RD',NULL,'0105000000010000000102000000080000000000006083273341000000A0727E2F41000000E08E27334100000040AE7E2F410000006094273341000000C0E27E2F41000000C096273341000000A0187F2F410000002098273341000000C04E7F2F41000000809827334100000040857F2F41000000A09827334100000040B57F2F41000000A09827334100000040E57F2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('284','1356.667914','ROAD4','PL2053','101','395','100','394','RAINBOW END LN',NULL,NULL,'101','100','395','394','Right','roadswest.dbf','0.26','40','0.3900','9.2290',NULL,'1',NULL,NULL,'RAINBOW END','LN',NULL,'01050000000100000001020000002F00000000000020E22033410000004097862F4100000040DE203341000000409B862F41000000C0D6203341000000A0A2862F41000000C0CF20334100000040A8862F41000000A0C820334100000040AB862F4100000040C1203341000000C0AC862F4100000020A720334100000040B0862F41000000208D20334100000060AD862F41000000406D203341000000A09E862F41000000604D203341000000A08D862F41000000402A2033410000004084862F4100000000072033410000004080862F41000000A0E01F3341000000A081862F41000000A0BA1F33410000006089862F4100000040961F33410000000097862F4100000000731F334100000060AC862F4100000020571F334100000040C6862F41000000E03C1F334100000040E6862F41000000001D1F3341000000401A872F41000000A0001F33410000004056872F41000000C0E81E3341000000A096872F4100000020D31E334100000060DA872F4100000060BD1E33410000006023882F4100000080A71E3341000000406C882F41000000A0971E3341000000C094882F41000000A08A1E3341000000A0BF882F4100000000881E3341000000A0D5882F4100000020861E334100000060EC882F4100000080841E3341000000A004892F4100000060821E3341000000A01C892F41000000407F1E3341000000A034892F41000000007B1E3341000000004C892F4100000040651E3341000000C086892F41000000A04C1E334100000000BF892F41000000803D1E3341000000A0F4892F41000000E02F1E3341000000C02B8A2F41000000A0161E3341000000A0958A2F41000000C0001E334100000040028B2F4100000020F11D334100000060688B2F41000000E0E31D334100000040D08B2F4100000080DC1D3341000000401B8C2F4100000040D21D334100000060638C2F4100000080C21D3341000000A0978C2F41000000C0B01D334100000000CA8C2F4100000000A71D3341000000C0EA8C2F41000000E09C1D3341000000400B8D2F4100000020941D334100000040258D2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('285','5415.298443','ROAD3','PL2053','787','1817','786','1816','JOE WEAVER RD',NULL,NULL,'787','786','1817','1816','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('286','1073.719626','ROAD3','PL2053','581','785','580','784','JOE WEAVER RD',NULL,NULL,'581','580','785','784','Right','roadswest.dbf','0.20','40','0.3000','10.5266',NULL,'1',NULL,NULL,'JOE WEAVER','RD',NULL,'01050000000100000001020000002700000000000040D93933410000004016982F41000000C0C6393341000000C024982F41000000A0B5393341000000A039982F4100000060A6393341000000C055982F4100000040993933410000000075982F41000000208F393341000000A091982F41000000408539334100000040AD982F41000000407B393341000000C0C5982F41000000A07039334100000000DB982F41000000206239334100000040ED982F41000000E051393341000000A0FB982F410000002041393341000000A005992F41000000602F393341000000A00F992F41000000201F393341000000401C992F41000000800F393341000000A02B992F4100000000FF383341000000A041992F4100000000F0383341000000405D992F4100000080E1383341000000A08F992F41000000E0D7383341000000C0C5992F41000000E0D038334100000040FA992F41000000E0CA383341000000A02E9A2F41000000C0C4383341000000605E9A2F4100000060BD383341000000A08C9A2F4100000020B5383341000000C0B49A2F4100000020AB383341000000C0DA9A2F41000000409C38334100000000059B2F41000000808B383341000000602E9B2F41000000C07A38334100000060599B2F41000000806938334100000040829B2F41000000C051383341000000C0B09B2F41000000A038383341000000A0DD9B2F41000000C017383341000000A0159C2F4100000060F6373341000000A04C9C2F41000000E0CB373341000000C0939C2F4100000000A2373341000000A0DC9C2F41000000C07C373341000000A0229D2F410000006058373341000000406A9D2F410000002034373341000000A0B39D2F41000000200F373341000000A0FF9D2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('287','7152.263427','ROAD3','PL2053','101','1493','100','1492','BEAR WALLOW RD',NULL,NULL,'101','100','1493','1492','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('288','287.142468','ROAD3','PL2053','3675','3727','3674','3726','BIG HORSE CREEK RD',NULL,NULL,'3675','3674','3727','3726','Right','roadswest.dbf','0.05','40','0.0750','11.0440',NULL,'1',NULL,NULL,'BIG HORSE CREEK','RD',NULL,'010500000001000000010200000008000000000000A01E223341000000C083882F41000000E0FE213341000000C08F882F41000000A0D52133410000004097882F41000000A0D52133410000004097882F4100000020AC2133410000004096882F410000000083213341000000408D882F41000000805B213341000000407B882F41000000E002213341000000A05B882F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('289','599.801672','ROAD3','PL2053','1305','1415','1304','1414','JERD BRANCH RD',NULL,NULL,'1305','1304','1415','1414','Right','roadswest.dbf','0.11','40','0.1650','10.9054',NULL,'1',NULL,NULL,'JERD BRANCH','RD',NULL,'01050000000100000001020000001100000000000060C43633410000004011842F41000000C09D363341000000401D842F41000000C077363341000000002C842F410000006057363341000000403E842F410000000038363341000000A055842F41000000A022363341000000406B842F41000000A00D363341000000A083842F41000000A0ED35334100000040AA842F4100000060CF35334100000060D4842F4100000000B9353341000000A0FC842F4100000080A1353341000000C024852F41000000C08C353341000000C03E852F41000000E077353341000000A056852F410000002043353341000000A094852F41000000A00F35334100000040D5852F4100000000E7343341000000A010862F41000000E0BE343341000000404E862F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('290','847.438781','ROAD3','PL2053','1149','1303','1148','1302','JERD BRANCH RD',NULL,NULL,'1149','1148','1303','1302','Right','roadswest.dbf','0.16','40','0.2400','11.0056',NULL,'1',NULL,NULL,'JERD BRANCH','RD',NULL,'01050000000100000001020000001800000000000000E0393341000000A030822F4100000020BA3933410000004030822F41000000A094393341000000002E822F410000008075393341000000002C822F41000000405A393341000000002A822F41000000203F393341000000C029822F410000006027393341000000A02C822F41000000E00F3933410000004032822F4100000000EA3833410000000045822F4100000080C4383341000000405E822F41000000C0993833410000004080822F41000000606E383341000000A0A2822F41000000A040383341000000C0BD822F410000008013383341000000C0D8822F41000000A0EC37334100000000F6822F41000000A0C63733410000006017832F4100000080A73733410000000038832F410000006089373341000000C05B832F41000000A069373341000000C089832F41000000C04837334100000040B7832F41000000E022373341000000C0DC832F4100000060FB363341000000C0F9832F41000000E0DF363341000000A006842F4100000060C43633410000004011842F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('291','1544.468805','ROAD3','PL2053','3381','3673','3380','3672','BIG HORSE CREEK RD',NULL,NULL,'3381','3380','3673','3672','Right','roadswest.dbf','0.29','40','0.4350','10.5786',NULL,'1',NULL,NULL,'BIG HORSE CREEK','RD',NULL,'010500000001000000010200000011000000000000A02825334100000000827E2F41000000E001253341000000C0EA7E2F41000000C0DD243341000000A0577F2F4100000080BC243341000000C0C77F2F41000000209E243341000000403B802F41000000A082243341000000A0B1802F41000000E04E233341000000606A862F41000000203F23334100000040B7862F41000000C02B233341000000A000872F41000000C014233341000000A045872F4100000080FA223341000000A085872F4100000020DD22334100000040C0872F4100000000BD223341000000C0F4872F41000000809A223341000000A022882F41000000E0752233410000006049882F41000000604F223341000000A068882F41000000A01E223341000000C083882F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('292','2186.933167','ROAD3','PL2053','2967','3379','2966','3378','BIG HORSE CREEK RD',NULL,NULL,'2967','2966','3379','3378','Right','roadswest.dbf','0.41','40','0.6150','10.6162',NULL,'1',NULL,NULL,'BIG HORSE CREEK','RD',NULL,'01050000000100000001020000002200000000000060A127334100000000E06E2F41000000409D27334100000040026F2F41000000C09227334100000060816F2F41000000208A273341000000A011702F41000000008427334100000000A3702F41000000607E273341000000403B712F410000002079273341000000A0D3712F41000000A0722733410000004078722F41000000006C273341000000A01C732F410000004065273341000000C0CD732F41000000E05E273341000000007F742F41000000205A273341000000C01D752F41000000C057273341000000A06F752F410000008055273341000000C0BC752F41000000A04F273341000000A06C762F410000006048273341000000401C772F41000000E040273341000000A0A8772F4100000000382733410000004034782F41000000802D273341000000A0DA782F41000000401C273341000000407F792F410000004005273341000000C0F9792F41000000E0E7263341000000C06E7A2F41000000E0C926334100000000CB7A2F41000000A0A8263341000000A0227B2F41000000A07E263341000000A0827B2F410000000054263341000000C0DF7B2F41000000603126334100000040347C2F41000000600D26334100000040887C2F41000000C0E2253341000000A0D97C2F4100000060B8253341000000A0287D2F41000000008F253341000000A07E7D2F410000002068253341000000A0D87D2F41000000C03125334100000060697E2F41000000A02825334100000000827E2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('293','431.404301','ROAD3','PL2053','2089','2171','2088','2170','BEAR WALLOW RD',NULL,NULL,'2089','2088','2171','2170','Right','roadswest.dbf','0.08','40','0.1200','10.5220',NULL,'1',NULL,NULL,'BEAR WALLOW','RD',NULL,'01050000000100000001020000000F000000000000E0D22333410000000000BD2F4100000020C523334100000040E5BC2F4100000020A5233341000000C0AABC2F410000002089233341000000C07EBC2F41000000E069233341000000605CBC2F41000000E056233341000000C052BC2F41000000E043233341000000A04DBC2F41000000E026233341000000C04BBC2F41000000200A2333410000006050BC2F4100000040F8223341000000A054BC2F41000000C0E5223341000000405CBC2F4100000000C92233410000000078BC2F4100000060AE223341000000C099BC2F41000000E083223341000000A0D2BC2F41000000A058223341000000C002BD2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('294','1026.101567','ROAD3','PL2053','1495','1693','1494','1692','BEAR WALLOW RD',NULL,NULL,'1495','1494','1693','1692','Right','roadswest.dbf','0.19','40','0.2850','10.3646',NULL,'1',NULL,NULL,'BEAR WALLOW','RD',NULL,'01050000000100000001020000002A000000000000E008293341000000C0B2B52F4100000000F6283341000000C038B62F4100000000EF283341000000A058B62F4100000040E8283341000000A092B62F4100000060E428334100000040CCB62F4100000020E0283341000000C0F4B62F41000000A0DC283341000000A01FB72F41000000C0DB283341000000A050B72F4100000060DC283341000000A080B72F4100000020DD283341000000C0B3B72F4100000080DE28334100000040E7B72F4100000020E1283341000000402EB82F4100000040E52833410000004075B82F4100000080E8283341000000C0A3B82F41000000A0ED283341000000A0D2B82F41000000E0F6283341000000C001B92F41000000A002293341000000A02EB92F410000004015293341000000C063B92F41000000E02A2933410000004094B92F41000000404029334100000000BBB92F41000000005429334100000060E3B92F41000000E05D293341000000A0FEB92F410000004064293341000000601ABA2F4100000080642933410000004053BA2F41000000605C293341000000C079BA2F41000000E052293341000000C092BA2F41000000C047293341000000A0ABBA2F41000000A037293341000000A0D0BA2F41000000C027293341000000C0F6BA2F41000000A01B293341000000A017BB2F41000000C010293341000000C039BB2F410000008007293341000000405CBB2F41000000A000293341000000A081BB2F4100000080FE283341000000C0ACBB2F4100000080FF28334100000040D7BB2F41000000C0012933410000006002BC2F41000000A006293341000000C02DBC2F410000002010293341000000C058BC2F41000000C01A293341000000A080BC2F410000008024293341000000C0ABBC2F41000000802E293341000000C0D7BC2F410F0F0F4F382933410000000000BD2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('295','1156.568071','ROAD3','PL2053','2469','2685','2468','2684','HELTON CREEK RD',NULL,NULL,'2469','2468','2685','2684','Right','roadswest.dbf','0.22','40','0.3300','10.7090',NULL,'1',NULL,NULL,'HELTON CREEK','RD',NULL,'01050000000100000001020000001600000000000000E03933414169365DE6BA2F4100000060A838334100000060E2B92F41000000408138334100000040C7B92F41000000E05838334100000040B4B92F41000000E02F38334100000040A9B92F410000006006383341000000C0A6B92F4100000020DD37334100000000ADB92F4100000060B4373341000000A0BBB92F41000000808C37334100000040D2B92F410000000066373341000000C0F0B92F4100000060413733410000004017BA2F41000000C01E3733410000000045BA2F4100000040003733410000006077BA2F4100000040E3363341000000A0B5BA2F4100000000C836334100000060FBBA2F4100000000B0363341000000C045BB2F41000000609B3633410000000094BB2F41000000608A363341000000C0E5BB2F41000000207D363341000000403ABC2F41000000A073363341000000A090BC2F41000000206E36334100000040D3BC2F41000000C0673633410000000000BD2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('296','5127.720759','ROAD3','PL2053','2243','3241','2242','3240','BEAR WALLOW RD',NULL,NULL,'2243','2242','3241','3240','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('297','4165.226855','ROAD3','PL2053','101','899','100','898','LITTLE WINDFALL RD',NULL,NULL,'101','100','899','898','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('298','5572.355979','ROAD3','PL2053','3729','4785','3728','4784','BIG HORSE CREEK RD',NULL,NULL,'3729','3728','4785','4784','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('299','10.707370','ROAD3','PL2054','1695','1695','1694','1694','BEAR WALLOW RD',NULL,NULL,'1695','1694','1695','1694','Right','roadswest.dbf','0.00','40','0.0000','0',NULL,'1',NULL,NULL,'BEAR WALLOW','RD',NULL,'0105000000010000000102000000020000000F0F0F4F382933410000000000BD2F41000000003D2933410000004013BD2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('300','365.305270','ROAD3','PL2054','2173','2241','2172','2240','BEAR WALLOW RD',NULL,NULL,'2173','2172','2241','2240','Right','roadswest.dbf','0.07','40','0.1050','10.7442',NULL,'1',NULL,NULL,'BEAR WALLOW','RD',NULL,'010500000001000000010200000013000000000000A058223341000000C002BD2F410000008040223341000000C012BD2F410000002027223341000000A01EBD2F41000000E00D223341000000C025BD2F4100000020F4213341000000402ABD2F4100000040DE213341000000C02BBD2F4100000020C8213341000000C02CBD2F41000000C0B2213341000000602DBD2F41000000209D213341000000A02EBD2F41000000A0882133410000004031BD2F410000004074213341000000A034BD2F41000000A05F213341000000003ABD2F41000000E04B213341000000403DBD2F41000000E04B213341000000403DBD2F41000000003C213341000000A03BBD2F41000000E02C213341000000A036BD2F41000000A01B2133410000004029BD2F41000000200A2133410000004017BD2F41000000A0F42033410000000000BD2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('301','2001.967524','ROAD3','PL2054','1697','2087','1696','2086','BEAR WALLOW RD',NULL,NULL,'1697','1696','2087','2086','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('302','1314.249263','ROAD3','PL2054','2687','2937','2686','2936','HELTON CREEK RD',NULL,NULL,'2687','2686','2937','2936','Right','roadswest.dbf','0.25','40','0.3750','10.5140',NULL,'1',NULL,NULL,'HELTON CREEK','RD',NULL,'010500000001000000010200000015000000000000C0673633410000000000BD2F41000000C0573633410000006052BD2F410000004047363341000000408DBD2F410000006033363341000000C0C3BD2F41000000801C363341000000A0F5BD2F410000000003363341000000A021BE2F4100000000C53533410000006090BE2F41000000608A3533410000006006BF2F4100000080533533410000004083BF2F4100000060203533410000006006C02F4100000000CD343341000000C0DAC02F41000000607D343341000000A0B4C12F41000000A031343341000000C093C22F41000000A0E93333410000004078C32F4100000040CA333341000000C0DFC32F41000000E0B6333341000000001DC42F41000000A09F333341000000A054C42F410000000085333341000000A085C42F41000000606733334100000060AFC42F41000000404733334100000000D1C42F41000000A035333341000000C0E7C42F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('303','609.440799','ROAD3','PL2060','623','729','622','728','JOE BADGER RD',NULL,NULL,'623','622','729','728','Right','roadswest.dbf','0.12','40','0.1800','11.4988',NULL,'1',NULL,NULL,'JOE BADGER','RD',NULL,'01050000000100000001020000001100000000000000DB473341000000C02F852E41000000E0DD473341000000403A852E4100000080F0473341000000C074852E41000000401F48334100000060E4852E410000006052483341000000404F862E41000000C06B4833410000004087862E410000002085483341000000C0BE862E4100000020A64833410000004006872E4100000000C7483341000000C04D872E4100000040E4483341000000008E872E41000000200149334100000040CF872E41000000801F4933410000004019882E41000000402C4933410000006039882E41000000E046493341000000C08F882E41000000804D493341000000A0A5882E41000000A054493341000000C0C5882E41000000005A49334100000040DD882E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('304','96.420758','ROAD3','PL2060','605','621','604','620','JOE BADGER RD',NULL,NULL,'605','604','621','620','Right','roadswest.dbf','0.02','40','0.0300','12.0526',NULL,'1',NULL,NULL,'JOE BADGER','RD',NULL,'010500000001000000010200000004000000000000C0B34733410000000080842E41000000E0BE47334100000060BD842E4100000020CD47334100000000FD842E4100000000DB473341000000C02F852E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('305','121.361011','ROAD4','PL2060','101','121','100','120','E ST',NULL,NULL,'101','100','121','120','Right','roadswest.dbf','0.02','40','0.0300','12.1362',NULL,'1',NULL,NULL,'E','ST',NULL,'0105000000010000000102000000020000006964ED6F4D4133418686F16112D22E4100000000B041334100000000A0D22E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('306','186.543074','ROAD4','PL2060','0','0','0','0',NULL,NULL,NULL,'0','0','0','0','Right','roadswest.dbf','0.04','40','0.0600','0',NULL,'0',NULL,NULL,NULL,NULL,NULL,'010500000001000000010200000002000000000000E09942334100000040EBD02E41EEDD74CDF8413341947F080F2FD02E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('307','1364.261769','ROAD4','PL2060','101','331','100','330','H ST',NULL,NULL,'101','100','331','330','Right','roadswest.dbf','0.26','40','0.3900','11.8632',NULL,'1',NULL,NULL,'H','ST',NULL,'010500000001000000010200000030000000000000005F4333410000004050CA2E41000000205B433341000000A050CA2E41000000E054433341000000C054CA2E41000000004F433341000000C059CA2E41000000C0494333410000000062CA2E410000008042433341000000C06CCA2E41000000A039433341000000C080CA2E41000000C02D433341000000409ACA2E41000000A019433341000000A0C4CA2E4100000040FC4233410000006000CB2E4100000040DE423341000000C03ACB2E4100000000BE423341000000A076CB2E41000000009D423341000000A0B0CB2E41000000C07742334100000040EECB2E410000002052423341000000602ACC2E41000000C027423341000000C06FCC2E41000000E0FC413341000000C0B4CC2E41000000C0D441334100000040F1CC2E4100000060AD413341000000A02ECD2E41000000008F4133410000004062CD2E41000000E071413341000000A098CD2E410000004058413341000000C0CCCD2E410000004040413341000000C003CE2E41000000C02B413341000000403CCE2E410000008017413341000000C075CE2E4100000080FC403341000000A0BACE2E41000000A0DF40334100000040FCCE2E4100000040CA403341000000A026CF2E4100000020B4403341000000C04ECF2E4100000040A3403341000000606ECF2E41000000C090403341000000408BCF2E41000000407E403341000000009FCF2E41000000806A403341000000A0ACCF2E41000000A056403341000000C0B1CF2E41000000C04240334100000040AFCF2E410000008032403341000000C0A4CF2E410000006023403341000000C096CF2E41000000200D403341000000407FCF2E41000000C0F73F3341000000A063CF2E4100000000DF3F3341000000A03BCF2E4100000020C73F3341000000A012CF2E41000000C0AF3F3341000000A0EECE2E4100000040983F3341000000A0CACE2E4100000000833F3341000000C0ABCE2E41000000806F3F3341000000C087CE2E41000000A0683F33410000004072CE2E41000000A0643F3341000000C065CE2E41000000005F3F3341000000A049CE2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('308','805.021497','ROAD4','PL2060','333','469','332','468','H ST',NULL,NULL,'333','332','469','468','Right','roadswest.dbf','0.15','40','0.2250','11.8386',NULL,'1',NULL,NULL,'H','ST',NULL,'010500000001000000010200000034000000000000005F3F3341000000A049CE2E41000000205D3F33410000006040CE2E41000000E05A3F33410000004018CE2E41000000A05B3F334100000040F0CD2E41000000205E3F3341000000A0C1CD2E41000000A0623F3341000000A093CD2E41000000A0693F3341000000405ACD2E41000000C0743F3341000000C023CD2E41000000E0813F3341000000C0F6CC2E41000000C0943F3341000000C0D5CC2E4100000000A03F334100000060CFCC2E4100000060AB3F334100000000CFCC2E4100000020B53F334100000000D7CC2E4100000060BD3F334100000060E3CC2E4100000080C43F334100000060F6CC2E4100000000CA3F3341000000600ACD2E41000000E0D73F3341000000C03DCD2E4100000040E53F3341000000A071CD2E41000000C0F23F3341000000C0A0CD2E410000006001403341000000A0CECD2E41000000A00D403341000000A0F2CD2E41000000401B403341000000A012CE2E41000000A0254033410000000024CE2E41000000E030403341000000C030CE2E41000000E03B403341000000C035CE2E41000000A047403341000000C035CE2E41000000E04E4033410000004033CE2E41000000A055403341000000602ECE2E41000000205C4033410000000026CE2E410000008060403341000000C01BCE2E410000006062403341000000400FCE2E41000000C062403341000000C0FFCD2E41000000806140334100000000F0CD2E41000000405F40334100000040E0CD2E41000000E05940334100000040C8CD2E410000006053403341000000C0AFCD2E41000000E04A403341000000408ECD2E410000008042403341000000A06CCD2E41000000A0384033410000006044CD2E41000000602F403341000000C01BCD2E41000000E02440334100000000EECC2E41000000801D403341000000A0BDCC2E41000000401C40334100000040A1CC2E41000000401D403341000000C084CC2E410000002021403341000000006BCC2E410000000027403341000000C052CC2E41000000802D4033410000004041CC2E41000000A0344033410000000031CC2E41000000A03B403341000000A023CC2E410000008042403341000000A016CC2E41000000C048403341000000400ACC2E41000000404D4033410000006001CC2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('309','567.792324','ROAD3','PL2060','263','367','262','366','ELLER DALE ACRES',NULL,NULL,'263','262','367','366','Right','roadswest.dbf','0.11','40','0.1650','10.9190',NULL,'1',NULL,NULL,'ELLER DALE','ACRE',NULL,'0105000000010000000102000000170000000000000074503341000000C079B32E410000006078503341000000A08BB32E41000000A094503341000000A0D9B32E41000000609F503341000000C007B42E4100000060AD5033410000004035B42E41000000E0BC5033410000004060B42E4100000060D2503341000000408CB42E4100000040E8503341000000A0B7B42E41000000E0FA50334100000040E3B42E41000000400B5133410000000012B52E4100000040175133410000006047B52E410000008022513341000000C07DB52E41000000C02A513341000000A0A0B52E41000000403551334100000000BFB52E41000000804951334100000060D7B52E41000000E06051334100000040E3B52E41000000807B513341000000C0DFB52E41000000C09551334100000060D0B52E41000000C0AD51334100000040B2B52E4100000020C65133410000004098B52E414078DA4FDA5133413721F23C93B52E413C48D7C1EA513341C0F889899FB52E41000000E0FE513341000000409DB52E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('310','635.420111','ROAD4','PL2060','101','223','100','222','EASY ST',NULL,NULL,'101','100','223','222','Right','roadswest.dbf','0.12','40','0.1800','10.4168',NULL,'1',NULL,NULL,'EASY','ST',NULL,'0105000000010000000102000000270000000000006013483341000000A088C02E41000000201B48334100000040A2C02E410000006023483341000000A0BBC02E41000000E02E48334100000040D9C02E41000000A03B483341000000C0F4C02E41000000004B483341000000000FC12E41000000A05B4833410000004026C12E41000000C070483341000000C03DC12E4100000000874833410000004050C12E41000000409F483341000000405DC12E4100000020B8483341000000C061C12E41000000E0CC483341000000A05CC12E4100000080E14833410000004053C12E4100000020F1483341000000A04AC12E41000000E000493341000000A044C12E41000000E0144933410000004046C12E41000000C0274933410000006051C12E41000000C0334933410000006062C12E41000000E03E4933410000004077C12E410000008048493341000000408BC12E410000004052493341000000A09EC12E41000000006149334100000000B2C12E41000000E06F49334100000040C5C12E41000000E07C493341000000C0D9C12E41000000808749334100000040F2C12E41000000C08D493341000000A00AC22E41000000A08F493341000000C023C22E41000000208C4933410000004033C22E41000000A0864933410000000041C22E41000000207B493341000000604FC22E41000000E06D493341000000C059C22E41000000E05E493341000000A066C22E410000002050493341000000C073C22E4100000040404933410000004087C22E410000004031493341000000409DC22E41000000A024493341000000A0B4C22E410000000018493341000000A0CBC22E41000000401249334100000040D3C22E41000000800C493341000000C0DAC22E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('311','484.637214','ROAD4','PL2060','0','0','0','0',NULL,NULL,NULL,'0','0','0','0','Right','roadswest.dbf','0.09','40','0.1350','0',NULL,'0',NULL,NULL,NULL,NULL,NULL,'01050000000100000001020000002300000000000080A53F3341000000A0FEC82E41000000A0AC3F3341000000A019C92E4100000000B13F3341000000A034C92E4100000040AC3F3341000000C053C92E41000000C0A33F3341000000C072C92E41000000C0993F3341000000C098C92E41000000A0913F334100000040C0C92E41000000A0903F3341000000C0CCC92E41000000A08F3F3341000000C0D9C92E41000000808C3F3341000000A0F5C92E41000000208A3F33410000004011CA2E41000000E08B3F3341000000A037CA2E4100000020903F3341000000A05DCA2E4100000000943F33410000006081CA2E4100000020993F334100000040A4CA2E4100000080A13F334100000000C8CA2E4100000000AC3F3341000000A0E9CA2E41000000A0B73F33410000004006CB2E4100000020C43F33410000000021CB2E4100000060CF3F3341000000A037CB2E41000000C0DA3F3341000000004ECB2E4100000020E53F33410000000064CB2E4100000020EF3F3341000000C07ACB2E41000000A0F93F33410000000097CB2E41000000600340334100000060B4CB2E410000002009403341000000C0C7CB2E41000000E00E40334100000040DBCB2E41000000801740334100000000F4CB2E41000000A01E403341000000000ECC2E41000000A020403341000000A01ECC2E410000008022403341000000402FCC2E4100000000254033410000006039CC2E410000000027403341000000C043CC2E410000004027403341000000404BCC2E410000000027403341000000C052CC2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('312','1283.646325','ROAD4','PL2060','101','329','100','328','PATTON RD',NULL,NULL,'101','100','329','328','Right','roadswest.dbf','0.24','40','0.3600','11.2600',NULL,'1',NULL,NULL,'PATTON','RD',NULL,'01050000000100000001020000002D000000000000A00B453341000000C072C22E4100000080034533410000004061C22E4100000000FE4433410000006053C22E4100000020F74433410000004046C22E4100000040EF443341000000A02EC22E41000000C0E9443341000000A017C22E4100000080E8443341000000A0EFC12E4100000020E8443341000000A0C6C12E4100000040EA443341000000A096C12E41000000C0EE4433410000004067C12E41000000E0F7443341000000A02EC12E41000000C00245334100000000F8C02E41000000000D453341000000A0BBC02E410000006019453341000000A07FC02E41000000C028453341000000604DC02E410000008039453341000000A01DC02E410000008051453341000000A0DABF2E41000000C0694533410000004098BF2E41000000A083453341000000C04FBF2E41000000A09D4533410000006007BF2E4100000060B945334100000000BBBE2E4100000080D64533410000004070BE2E4100000000F5453341000000002ABE2E41000000C01546334100000060E8BD2E410000006030463341000000C0B5BD2E41000000E04E463341000000008EBD2E410000002070463341000000A080BD2E41000000A0914633410000006086BD2E4100000020B0463341000000C0A7BD2E4100000040CA46334100000060D6BD2E41000000C0DF463341000000A006BE2E4100000020F3463341000000C039BE2E41000000A009473341000000C078BE2E41000000E01F473341000000C0B7BE2E410000008034473341000000C0EEBE2E41000000204A4733410000006024BF2E41000000A05E473341000000A053BF2E410000002075473341000000007EBF2E410000002083473341000000A095BF2E410000006090473341000000C0A1BF2E41000000E09947334100000000A0BF2E41000000209F473341000000A09BBF2E4100000060A7473341000000A08ABF2E41000000A0A9473341000000C07FBF2E4100000080C74733410000006035BF2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('313','1026.693653','ROAD2','PL2060','9159','9353','9158','9352','NC HWY 194 NORTH',NULL,NULL,'9159','9158','9353','9352','Right','roadswest.dbf','0.19','40','0.2850','10.5844',NULL,'1',NULL,NULL,'NC HWY 194',NULL,'N','01050000000100000001020000000800000000000020774333410000004023CC2E41000000E051433341000000C085CC2E41000000802343334100000000FCCC2E4100000080F7423341000000A071CD2E41000000C0CB42334100000060E7CD2E4100000000094233410000006001D02E41000000E048413341000000401FD22E41000000801B41334100000000A0D22E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('314','632.276095','ROAD4','PL2060','101','215','100','214','B ST',NULL,NULL,'101','100','215','214','Right','roadswest.dbf','0.12','40','0.1800','11.0926',NULL,'1',NULL,NULL,'B','ST',NULL,'01050000000100000001020000000F000000000000007643334100000000AECE2E41000000C06A43334100000000C9CE2E41000000605F43334100000000E4CE2E41000000604B4333410000006015CF2E410000000038433341000000A047CF2E41000000A01F433341000000408CCF2E41000000600743334100000000D1CF2E4100000020E4423341000000C02AD02E4100000080C04233410000004084D02E41000000E09942334100000040EBD02E41000000E0734233410000004053D12E41000000A05442334100000040ACD12E4100000020354233410000000005D22E410000002014423341000000C05BD22E41000000E0F941334100000000A0D22E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('315','881.156537','ROAD4','PL2060','101','267','100','266','A ST',NULL,NULL,'101','100','267','266','Right','roadswest.dbf','0.17','40','0.2550','10.6164',NULL,'1',NULL,NULL,'A','ST',NULL,'010500000001000000010200000026000000000000E079433341000000C01BCC2E41000000E08A433341000000A083CC2E410000000099433341000000C0BBCC2E41000000C0A643334100000060F4CC2E41000000C0AE433341000000C014CD2E41000000C0B5433341000000A036CD2E41000000A0B8433341000000604BCD2E4100000060BA433341000000C060CD2E4100000000BA433341000000C074CD2E4100000060B84333410000000088CD2E41000000E0B4433341000000C0A0CD2E4100000060B043334100000000B9CD2E41000000809C4333410000006009CE2E410000008087433341000000A057CE2E41000000807A433341000000C095CE2E41000000007643334100000000AECE2E41000000C06E433341000000A0D5CE2E41000000E066433341000000C004CF2E41000000805F433341000000A034CF2E410000006058433341000000A064CF2E41000000E0504333410000000095CF2E410000004046433341000000A0CCCF2E41000000203B433341000000A003D02E41000000E02F433341000000603CD02E4100000060254333410000006075D02E41000000A01C433341000000C0ABD02E410000000015433341000000C0E2D02E41000000400F4333410000000016D12E41000000000B4333410000006049D12E41000000E008433341000000C079D12E41000000E00743334100000000ABD12E410000004007433341000000A0D1D12E41000000A007433341000000A0F7D12E410000000009433341000000C018D22E41000000400B433341000000C039D22E41000000200F4333410000006064D22E410000004014433341000000408ED22E41000000601743334100000000A0D22E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('316','2035.285407','ROAD3','PL2060','215','605','214','604','PINEY CREEK RD',NULL,NULL,'215','214','605','604','Right','roadswest.dbf','0.39','40','0.5850','10.4374',NULL,'1',NULL,NULL,'PINEY CREEK','RD',NULL,'01050000000100000001020000002B000000000000A0B948334100000000A0D22E4100000020C8483341000000007BD22E41000000A0E34833410000004032D22E41000000E002493341000000C0E1D12E41000000A0234933410000004096D12E41000000A04A4933410000004051D12E4100000080744933410000000012D12E4100000060A2493341000000C0D3D02E4100000000D2493341000000A09AD02E4100000060FE4933410000006069D02E41000000C02B4A3341000000C03DD02E41000000C0574A3341000000601CD02E4100000000854A33410000000001D02E4100000060B04A334100000060ECCF2E4100000040DC4A334100000040DDCF2E4100000040084B334100000000D4CF2E41000000A0344B3341000000C0CECF2E41000000A0614B334100000040CCCF2E41000000207E4B3341000000C0CBCF2E41000000C08E4B3341000000C0CBCF2E4100000080B74B3341000000A0CBCF2E4100000000E04B3341000000A0CDCF2E41000000A0094C334100000040D2CF2E41000000A0324C3341000000A0DBCF2E41000000E05B4C334100000060EDCF2E41000000C0844C3341000000C004D02E41000000C0B64C3341000000C027D02E41000000C0E74C3341000000A050D02E4100000040154D3341000000407DD02E41000000C0424D334100000060ABD02E4100000040794D334100000040DED02E4100000060B04D3341000000400ED12E4100000000E44D3341000000C036D12E4100000060184E3341000000405BD12E4100000020464E33410000000076D12E4100000020744E3341000000408ED12E4100000020A94E334100000000A8D12E41000000A0DD4E334100000040C2D12E4100000040154F3341000000C0E1D12E41000000004C4F3341000000C005D22E4100000080814F3341000000A031D22E4100000000B64F33410000006063D22E4100000080ED4F334100000000A0D22E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('317','2925.793934','ROAD3','PL2060','981','1541','980','1540','PINEY CREEK RD',NULL,NULL,'981','980','1541','1540','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('318','1068.053525','ROAD4','PL2060','0','0','0','0',NULL,NULL,NULL,'0','0','0','0','Right','roadswest.dbf','0.20','40','0.3000','0',NULL,'0',NULL,NULL,NULL,NULL,NULL,'01050000000100000001020000003200000000000000E039334100000040F0CA2E4100000000E439334100000040F5CA2E4100000080F2393341000000C00BCB2E4100000020003A33410000006024CB2E41000000600C3A3341000000C03DCB2E4100000040183A33410000004058CB2E41000000002A3A3341000000607ECB2E41000000E03B3A3341000000A0A4CB2E41000000A04D3A334100000000CCCB2E41000000E05F3A3341000000A0F2CB2E41000000406D3A3341000000C00DCC2E41000000407B3A33410000006027CC2E41000000E08E3A3341000000A043CC2E4100000020A33A3341000000405ECC2E4100000060B73A3341000000C07BCC2E4100000060CB3A3341000000409ACC2E41000000E0DB3A3341000000C0B5CC2E4100000080EC3A334100000040D1CC2E4100000060013B3341000000C0EFCC2E4100000020173B3341000000600BCD2E41000000E02A3B33410000004020CD2E41000000603F3B33410000004031CD2E41000000604E3B33410000006039CD2E41000000A05D3B3341000000C03FCD2E4100000040753B3341000000C048CD2E41000000E08C3B33410000000052CD2E4100000040AB3B3341000000C062CD2E4100000040C93B3341000000A075CD2E41000000A0E23B3341000000C085CD2E4100000040FC3B33410000004095CD2E41000000E0173C3341000000C0A0CD2E4100000060333C334100000040ADCD2E41000000C0493C3341000000C0BBCD2E41000000E05F3C3341000000C0CBCD2E4100000000793C3341000000A0DCCD2E41000000C0913C334100000040EFCD2E4100000000AE3C3341000000000CCE2E4100000000CA3C33410000006029CE2E4100000060E03C3341000000003DCE2E4100000040F73C3341000000604DCE2E4100000000153D3341000000A05BCE2E4100000060333D33410000004060CE2E4100000060483D3341000000A05DCE2E41000000205C3D3341000000A052CE2E41000000A0653D3341000000A045CE2E41000000C06E3D3341000000C036CE2E4100000000743D3341000000A030CE2E4100000060783D33410000006029CE2E41000000607A3D33410000000022CE2E41000000E07B3D3341000000401ACE2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('319','2568.309397','ROAD4','PL2060','0','0','0','0',NULL,NULL,NULL,'0','0','0','0','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('320','645.254563','ROAD4','PL2060','0','0','0','0',NULL,NULL,NULL,'0','0','0','0','Right','roadswest.dbf','0.12','40','0.1800','0',NULL,'0',NULL,NULL,NULL,NULL,NULL,'01050000000100000001020000002700000000000000823F3341000000A06CC72E41000000C0763F33410000006062C72E41000000806B3F33410000004058C72E41000000005A3F3341000000C048C72E4100000040483F3341000000403AC72E41000000C0383F3341000000A02EC72E4100000020293F3341000000C023C72E4100000020133F3341000000A018C72E4100000040FD3E3341000000000DC72E4100000020EB3E33410000006000C72E4100000040D93E3341000000C0F1C62E4100000020C43E3341000000A0DEC62E4100000080B03E3341000000C0C6C62E4100000040A03E334100000040A7C62E4100000080913E3341000000C083C62E4100000020873E33410000004066C62E41000000C07B3E3341000000404BC62E41000000806C3E3341000000A038C62E41000000C05B3E3341000000A029C62E41000000C0403E3341000000C013C62E4100000060253E334100000060FFC52E41000000600F3E334100000040EAC52E4100000000F93D3341000000A0D6C52E4100000040E33D3341000000C0C9C52E41000000E0CC3D3341000000C0C0C52E4100000060B83D3341000000A0BBC52E41000000C0A33D334100000060BAC52E4100000040963D334100000060BBC52E4100000060893D334100000000C1C52E41000000A0823D3341000000C0C7C52E41000000A07C3D3341000000C0D0C52E41000000E0753D3341000000C0E5C52E4100000020723D334100000060FEC52E4100000000713D3341000000A00FC62E41000000C0703D3341000000C020C62E4100000000713D3341000000A02EC62E41000000C0713D3341000000003CC62E41000000A0723D33410000006045C62E4100000080733D3341000000C04EC62E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('321','7730.201743','ROAD3','PL2060','101','1491','100','1490','MCNEIL RD',NULL,NULL,'101','100','1491','1490','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('322','1514.980099','ROAD3','PL2060','1493','1767','1492','1766','MCNEIL RD',NULL,NULL,'1493','1492','1767','1766','Right','roadswest.dbf','0.29','40','0.4350','11.0582',NULL,'1',NULL,NULL,'MCNEIL','RD',NULL,'01050000000100000001020000003A000000000000E04B5433410000004057AA2E41000000803E543341000000C081AA2E410000000039543341000000409DAA2E41000000A031543341000000C0C2AA2E410000000029543341000000C0E8AA2E41000000601D543341000000000BAB2E410000002010543341000000C029AB2E410000002001543341000000A045AB2E4100000080F0533341000000C05DAB2E41000000A0DE533341000000406FAB2E4100000080CC533341000000C07CAB2E4100000040B6533341000000408DAB2E41000000209F533341000000409AAB2E410000002083533341000000C0A2AB2E41000000E06653334100000060A4AB2E41000000E06653334100000060A4AB2E41000000805153334100000040A0AB2E41000000803C533341000000A098AB2E410000000024533341000000A08CAB2E41000000000C533341000000C07EAB2E4100000080F25233410000004070AB2E4100000020D95233410000006061AB2E4100000000BC523341000000C050AB2E41000000C09E523341000000A041AB2E4100000020875233410000004036AB2E41000000806F523341000000602CAB2E41000000C04E523341000000A023AB2E41000000602D523341000000001DAB2E41000000000D5233410000004015AB2E41000000C0EC513341000000C00EAB2E4100000080D0513341000000C00CAB2E41000000C0B3513341000000400BAB2E41000000E095513341000000C006AB2E4100000020785133410000006001AB2E41000000205A513341000000A0FBAA2E41000000003C513341000000C0F3AA2E41000000202051334100000040EAAA2E41000000400451334100000060DDAA2E4100000020EA503341000000C0CCAA2E4100000080D0503341000000A0B9AA2E4100000020B5503341000000C0A2AA2E41000000209A503341000000408CAA2E4100000060785033410000006074AA2E410000002056503341000000A05CAA2E41000000003B503341000000A047AA2E4100000000205033410000000032AA2E410000004006503341000000601DAA2E41000000A0EC4F33410000004009AA2E4100000000D04F334100000060F4A92E4100000020B34F334100000040E0A92E4100000040954F334100000000CAA92E4100000080774F3341000000C0B5A92E41000000A05B4F334100000060A7A92E41000000203F4F3341000000C09AA92E4100000040164F33410000000090A92E4100000020FD4E3341000000A087A92E41000000E0E84E33410000004084A92E41000000C0D54E3341000000C081A92E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('323','2247.707443','ROAD2','PL2060','6701','7131','6700','7130','NC HWY 194 NORTH',NULL,NULL,'6701','6700','7131','7130','Right','roadswest.dbf','0.43','40','0.6450','10.4544',NULL,'1',NULL,NULL,'NC HWY 194',NULL,'N','01050000000100000001020000002400000000000040674633410000000080842E41000000E07F46334100000040F2842E41000000A096463341000000A05F852E4100000000AF46334100000040CC852E4100000000C6463341000000A023862E4100000040DF463341000000A078862E41000000C01E473341000000A023872E41000000E06347334100000040C5872E41000000E082473341000000C00E882E4100000000A3473341000000A057882E41000000C0C8473341000000C0A2882E41000000E0EE473341000000A0EC882E4100000060124833410000006032892E41000000A034483341000000C079892E41000000E05748334100000000CC892E41000000407848334100000040228A2E41000000A093483341000000C07A8A2E4100000020AB483341000000A0D78A2E41000000C0BF48334100000040408B2E4100000060CF48334100000060AC8B2E41000000A0DA483341000000C0278C2E4100000080DF483341000000C0A48C2E4100000080DD483341000000C02E8D2E4100000020D3483341000000C0B68D2E4100000040C4483341000000001C8E2E41000000C0AE483341000000A0848E2E41000000209C483341000000A0D28E2E410000002089483341000000A0148F2E41000000C07448334100000000598F2E41000000405C483341000000409A8F2E41000000A047483341000000C0D48F2E41000000002E483341000000A015902E41000000001D4833410000000042902E41000000E0DD473341000000C0DA902E41000000801447334100000060DD922E4100000000EF4633410000004042932E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('324','1358.283389','ROAD2','PL2060','7129','7389','7128','7388','NC HWY 194 NORTH',NULL,NULL,'7129','7128','7389','7388','Right','roadswest.dbf','0.26','40','0.3900','10.4484',NULL,'1',NULL,NULL,'NC HWY 194',NULL,'N','01050000000100000001020000001700000000000000EF4633410000004042932E4100000000B1463341000000C0E8932E41000000C0A24633410000000013942E41000000E08E463341000000404E942E41000000806B463341000000A0BA942E4100000040494633410000006028952E41000000C02A463341000000408F952E41000000C00D46334100000000F8952E4100000080F0453341000000A06D962E41000000E0D4453341000000A0E4962E4100000020B94533410000006061972E41000000209F453341000000C0DF972E41000000208A453341000000A051982E41000000E07645334100000040C4982E410000006065453341000000A037992E41000000005545334100000040AB992E41000000C043453341000000A0299A2E41000000C03345334100000000A99A2E41000000C024453341000000402B9B2E41000000C018453341000000A0AE9B2E41000000A011453341000000C0239C2E41000000600E453341000000C0999C2E41000000400F453341000000C0019D2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('325','3211.845666','ROAD2','PL2060','7387','8003','7386','8002','NC HWY 194 NORTH',NULL,NULL,'7387','7386','8003','8002','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('326','311.882019','ROAD2','PL2060','8007','8067','8006','8066','NC HWY 194 NORTH',NULL,NULL,'8007','8006','8067','8066','Right','roadswest.dbf','0.06','40','0.0900','10.3960',NULL,'1',NULL,NULL,'NC HWY 194',NULL,'N','010500000001000000010200000004000000000000C0D54E3341000000C081A92E4100000040E34E334100000040EEA92E4100000020134F3341000000A059AB2E41000000401F4F3341000000A0DFAB2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('327','541.282665','ROAD4','PL2060','101','217','100','216','ELLER DR',NULL,NULL,'101','100','217','216','Right','roadswest.dbf','0.10','40','0.1500','9.3324',NULL,'1',NULL,NULL,'ELLER','DR',NULL,'01050000000100000001020000001E000000000000C0E9413341000000C0B79B2E41000000C0E5413341000000A0BB9B2E41000000A0DA41334100000040C69B2E41000000E0CF413341000000C0D19B2E4100000000C441334100000060E49B2E41000000A0B8413341000000A0F89B2E41000000C0AB413341000000C00C9C2E41000000E09E413341000000A0219C2E410000000091413341000000A03B9C2E410000006083413341000000A0569C2E41000000007341334100000040799C2E410000002062413341000000A09A9C2E41000000405141334100000040B39C2E41000000C03F413341000000A0CA9C2E41000000E032413341000000A0DF9C2E41000000002541334100000040F09C2E41000000A016413341000000C0F39C2E41000000A00741334100000040F39C2E4100000000F640334100000040F29C2E4100000080E440334100000000F19C2E4100000080D240334100000040F09C2E4100000040C1403341000000C0F49C2E41000000E0B040334100000060069D2E4100000020A3403341000000C01F9D2E410000004097403341000000C04C9D2E41000000808F403341000000C07F9D2E41000000008840334100000060B19D2E41000000A081403341000000A0E39D2E41000000407D40334100000040129E2E41000000E07740334100000040409E2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('328','1154.828015','ROAD3','PL2060','101','317','100','316','WEST DEEP FORD RD',NULL,NULL,'101','100','317','316','Right','roadswest.dbf','0.22','40','0.3300','10.6928',NULL,'1','W',NULL,'DEEP FORD','RD',NULL,'010500000001000000010200000014000000000000401F4F3341000000A0DFAB2E41000000C02E4F3341000000A0D9AB2E41000000803E4F334100000000D7AB2E4100000020524F3341000000C0D2AB2E41000000E0654F334100000000CFAB2E41000000C0864F3341000000C0CCAB2E41000000A0A74F3341000000C0CCAB2E4100000020C04F3341000000A0CDAB2E4100000080D84F3341000000A0CEAB2E41000000801950334100000040F1AB2E41000000A059503341000000A016AC2E4100000060AE503341000000C055AC2E410000000002513341000000409CAC2E41000000004F513341000000C0E0AC2E41000000C09B5133410000004027AD2E4100000000015233410000006081AD2E41000000A06652334100000040DAAD2E41000000E0C0523341000000A026AE2E41000000E01A533341000000C072AE2E41000000A058533341000000A0A9AE2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('329','1419.850642','ROAD3','PL2060','2509','2847','2508','2846','PARKER ELLER RD',NULL,NULL,'2509','2508','2847','2846','Right','roadswest.dbf','0.27','40','0.4050','8.4014',NULL,'1',NULL,NULL,'PARKER ELLER','RD',NULL,'01050000000100000001020000001600000000000040AF603341000000A0729A2E41000000809860334100000040999A2E410000004061603341000000A0F49A2E410000008039603341000000A0379B2E41000000801160334100000040799B2E41000000C0E75F3341000000C0B69B2E4100000000BE5F3341000000A0F69B2E41000000A0915F3341000000C0489C2E4100000000675F3341000000A09E9C2E4100000080345F334100000040079D2E41000000E0015F3341000000406F9D2E4100000080D05E3341000000A0CC9D2E41000000009E5E334100000040289E2E4100000060645E3341000000408D9E2E41000000202A5E3341000000C0F09E2E41000000A0FE5D3341000000C0399F2E41000000E0D25D3341000000A0829F2E41000000A0A65D3341000000A0CC9F2E41000000607A5D3341000000A016A02E41000000E04C5D33410000006061A02E41000000401F5D334100000000ACA02E41F39603CB925C334189D97CECDDA12E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('330','85.264311','ROAD3','PL2060','2493','2509','2492','2508','PARKER ELLER RD',NULL,NULL,'2493','2492','2509','2508','Right','roadswest.dbf','0.02','40','0.0300','10.6580',NULL,'1',NULL,NULL,'PARKER ELLER','RD',NULL,'010500000001000000010200000004000000000000A0EE603341000000A0009A2E41000000E0CE603341000000A03C9A2E4100000040AF603341000000A0729A2E4100000040AF603341000000A0729A2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('331','0.000000','ROAD2','PL2060','8213','8213','8212','8212','NC HWY 194 NORTH',NULL,NULL,'8213','8212','8213','8212','Right','roadswest.dbf','0.00','40','0.0000','0',NULL,'1',NULL,NULL,'NC HWY 194',NULL,'N','01050000000100000001020000000200000000000000BE4D3341000000C0FFB02E4100000000BE4D3341000000C0FFB02E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('332','446.734569','ROAD2','PL2060','8065','8151','8064','8150','NC HWY 194 NORTH',NULL,NULL,'8065','8064','8151','8150','Right','roadswest.dbf','0.08','40','0.1200','10.3892',NULL,'1',NULL,NULL,'NC HWY 194',NULL,'N','01050000000100000001020000000E000000000000401F4F3341000000A0DFAB2E4100000080224F33410000000009AC2E4100000080244F3341000000402EAC2E4100000040244F33410000004068AC2E41000000401F4F334100000060BCAC2E4100000020174F3341000000C010AD2E41000000A00C4F33410000004049AD2E4100000000004F3341000000C07EAD2E4100000080F24E334100000040AEAD2E41000000C0E34E3341000000A0DBAD2E4100000080D74E3341000000A0FCAD2E4100000040CB4E3341000000A01CAE2E41000000209F4E3341000000A095AE2E41000000207A4E3341000000C0FBAE2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('333','319.312494','ROAD2','PL2060','8153','8215','8152','8214','NC HWY 194 NORTH',NULL,NULL,'8153','8152','8215','8214','Right','roadswest.dbf','0.06','40','0.0900','10.3004',NULL,'1',NULL,NULL,'NC HWY 194',NULL,'N','010500000001000000010200000006000000000000207A4E3341000000C0FBAE2E41000000A0454E3341000000C089AF2E4100000060184E3341000000A004B02E4100000040F44D33410000006069B02E4100000020D04D3341000000A0CEB02E4100000000BE4D3341000000C0FFB02E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('334','1794.377995','ROAD4','PL2060','101','441','100','440','BOBBY RASH RD',NULL,NULL,'101','100','441','440','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('335','182.264443','ROAD4','PL2060','101','133','100','132','SWINDLERS RIDGE RD',NULL,NULL,'101','100','133','132','Right','roadswest.dbf','0.03','40','0.0450','11.3916',NULL,'1',NULL,NULL,'SWINDLERS RIDGE','RD',NULL,'01050000000100000001020000000A00000000000000DB473341000000C02F852E4100000080EA4733410000000025852E4100000000FA473341000000C019852E410000006010483341000000A006852E410000002026483341000000C0F0842E41000000603D48334100000040D6842E41000000E053483341000000C0B8842E41000000C064483341000000C09F842E4100000060754833410000004086842E4100000060794833410000000080842E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('336','134.567486','ROAD4','PL2060','101','125','100','124','CHANDLER RD',NULL,NULL,'101','100','125','124','Right','roadswest.dbf','0.03','40','0.0450','11.2140',NULL,'1',NULL,NULL,'CHANDLER','RD',NULL,'01050000000100000001020000000A000000000000C0463A33410000000065872E41000000A0433A33410000004077872E41000000A03F3A3341000000C087872E4100000000333A3341000000409C872E4100000080233A3341000000C0AB872E4100000080143A334100000000BA872E41000000C0053A3341000000C0C8872E4100000000F239334100000060E2872E4100000040E1393341000000C001882E4100000000E03933410000004006882E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('337','701.538171','ROAD4','PL2060','163','293','162','292','CHANDLER RD',NULL,NULL,'163','162','293','292','Right','roadswest.dbf','0.13','40','0.1950','10.7928',NULL,'1',NULL,NULL,'CHANDLER','RD',NULL,'01050000000100000001020000001C00000000000000E0393341000000C071892E4100000060E9393341000000408E892E41000000A0033A3341000000C0C3892E41000000801E3A3341000000A0F8892E41000000E02F3A3341000000A02B8A2E4100000060403A334100000000608A2E4100000000523A334100000060928A2E4100000060643A3341000000A0C38A2E41000000A07C3A334100000040008B2E41000000E0963A3341000000C0388B2E4100000020AF3A334100000040628B2E4100000060C83A334100000040898B2E4100000020E53A334100000060B58B2E41000000C0023B3341000000C0DE8B2E41000000801B3B3341000000C0F78B2E41000000E0323B334100000040148C2E41000000603F3B3341000000402D8C2E41000000204A3B334100000040498C2E4100000040543B3341000000C06E8C2E41000000C05B3B334100000000978C2E41000000E0603B3341000000A0C18C2E41000000A0633B334100000040ED8C2E41000000C0643B3341000000C00D8D2E4100000080633B3341000000C02D8D2E41000000405E3B3341000000604F8D2E4100000000553B3341000000C06C8D2E41000000204A3B3341000000A07D8D2E41000000003E3B3341000000A08C8D2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('338','967.904366','ROAD3','PL2060','531','703','530','702','CAMPBELL RD',NULL,NULL,'531','530','703','702','Right','roadswest.dbf','0.18','40','0.2700','11.2548',NULL,'1',NULL,NULL,'CAMPBELL','RD',NULL,'01050000000100000001020000001B000000000000407D3C33410000000080842E41000000E0893C334100000040A1842E41000000A0C53C3341000000C00C852E41000000C0CD3C3341000000C029852E4100000000CE3C3341000000C049852E4100000080CB3C3341000000C067852E4100000000C33C3341000000A089852E41000000A0B73C334100000060A7852E4100000040A03C3341000000A0D0852E41000000A08F3C334100000060E6852E4100000080633C3341000000601A862E4100000040403C3341000000403F862E4100000080103C3341000000A074862E4100000040E03B334100000000A9862E4100000040B43B334100000040D5862E4100000060873B3341000000C0FD862E41000000E0563B3341000000C025872E41000000C0243B3341000000C045872E4100000020F23A33410000000057872E4100000020BF3A3341000000C05F872E41000000008E3A3341000000C062872E41000000405D3A33410000004063872E41000000C0463A33410000000065872E41000000202B3A33410000004067872E41000000202B3A33410000004067872E41000000C0F8393341000000A065872E4100000000E0393341000000005F872E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('339','3151.285784','ROAD3','PL2060','101','689','100','688','POUNDING MILL RD',NULL,NULL,'101','100','689','688','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('340','5630.849295','ROAD3','PL2060','101','1175','100','1174','CHARLIE KING RD',NULL,NULL,'101','100','1175','1174','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('341','5224.237684','ROAD3','PL2060','2779','3711','2778','3710','TEABERRY RD',NULL,NULL,'2779','2778','3711','3710','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('342','4939.181422','ROAD2','PL2060','8213','9157','8212','9156','NC HWY 194 NORTH',NULL,NULL,'8213','8212','9157','9156','Right','roadswest.dbf','0.94','40','1.4100','10.4644',NULL,'1',NULL,NULL,'NC HWY 194',NULL,'N','01050000000100000001020000005200000000000000BE4D3341000000C0FFB02E41000000E09C4D33410000004059B12E41000000E06B4D3341000000A0E5B12E4100000080474D3341000000405AB22E4100000000274D3341000000A0D2B22E41000000A01C4D33410000004002B32E41000000C0104D33410000006039B32E4100000060FD4C334100000040A3B32E4100000040E94C33410000004028B42E41000000E0D94C334100000040AFB42E4100000040D14C3341000000001DB52E41000000A0CB4C3341000000A08BB52E4100000020C94C33410000006001B62E41000000E0C84C3341000000C077B62E4100000040CA4C3341000000A002B72E4100000040CB4C3341000000008EB72E41000000C0C94C33410000000002B82E41000000C0C54C3341000000C075B82E4100000040BD4C3341000000A0F3B82E4100000020B04C33410000000070B92E41000000409A4C334100000040F7B92E41000000A0844C3341000000C05BBA2E41000000207E4C3341000000C079BA2E41000000A0624C334100000040DFBA2E4100000080444C33410000004041BB2E41000000201B4C3341000000C0BEBB2E4100000020F04B3341000000C039BC2E4100000040CB4B334100000000A2BC2E41000000E0A54B33410000004009BD2E41000000A0854B3341000000A061BD2E4100000020644B3341000000C0B8BD2E41000000403B4B33410000004019BE2E41000000A00F4B33410000000075BE2E41000000A0E54A3341000000C0C1BE2E4100000080B94A3341000000A009BF2E41000000C07A4A3341000000C062BF2E41000000A0384A3341000000C0B1BF2E4100000040F749334100000040F1BF2E41000000A0B34933410000004026C02E410000008073493341000000C04EC02E410000000032493341000000C06DC02E4100000040F9483341000000607FC02E4100000020C0483341000000408AC02E410000008086483341000000A08EC02E410000008086483341000000A08EC02E41000000E04C483341000000A08DC02E410000006013483341000000A088C02E4100000000DA473341000000C080C02E410000008099473341000000C075C02E410000004059473341000000C06AC02E41000000E0114733410000006061C02E4100000000CB463341000000605FC02E41000000E0834633410000004069C02E41000000603E4633410000004082C02E4100000080FF453341000000C0ACC02E41000000E0C3453341000000A0E7C02E4100000060934533410000004029C12E410000006067453341000000A075C12E410000000038453341000000C0E1C12E410000000011453341000000405AC22E41000000E0F2443341000000A0E5C22E41000000A0DB4433410000006079C32E4100000000CC44334100000000ECC32E4100000040BE4433410000004060C42E41000000A0B5443341000000C0AFC42E41000000C0AB4433410000000000C52E41000000C095443341000000A0ADC52E41000000A08C44334100000040F6C52E41000000E06D443341000000C0ECC62E41000000005A4433410000006094C72E410000006046443341000000003CC82E41000000C03744334100000040B7C82E4100000080284433410000004032C92E410000004019443341000000C0A3C92E4100000000084433410000004014CA2E4100000040F74333410000004072CA2E41000000A0E3433341000000A0CDCA2E41000000C0D743334100000000F8CA2E41000000C0CD433341000000001CCB2E4100000080B54333410000004069CB2E41000000C09A433341000000C0BCCB2E4100000020774333410000004023CC2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('343','4606.275919','ROAD3','PL2060','319','1191','318','1190','WEST DEEP FORD RD',NULL,NULL,'319','318','1191','1190','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('344','881.763824','ROAD3','PL2060','101','261','100','260','ELLER DALE ACRES',NULL,NULL,'101','100','261','260','Right','roadswest.dbf','0.17','40','0.2550','11.0220',NULL,'1',NULL,NULL,'ELLER DALE','ACRE',NULL,'01050000000100000001020000002F000000000000207A4E3341000000C0FBAE2E4100000000A34E3341000000A02DAF2E4100000000C64E3341000000404EAF2E41000000E0E94E3341000000C071AF2E41000000600D4F3341000000C095AF2E41000000402C4F3341000000A0B4AF2E41000000E04A4F3341000000A0D4AF2E41000000205E4F334100000040EAAF2E41000000C0704F33410000006001B02E4100000040744F33410000000006B02E41000000C0774F3341000000400BB02E41000000E07D4F3341000000A015B02E4100000040834F3341000000A020B02E41000000408A4F3341000000A02FB02E41000000E0904F33410000000042B02E4100000060954F3341000000C05FB02E4100000000964F3341000000607EB02E4100000040944F3341000000C094B02E4100000020914F334100000040AAB02E41000000608A4F334100000040C8B02E4100000040824F334100000060E4B02E4100000040774F3341000000A003B12E41000000A06C4F3341000000C021B12E4100000020644F3341000000A03DB12E41000000205E4F33410000004059B12E41000000A05B4F33410000004071B12E41000000005C4F3341000000C087B12E41000000605F4F3341000000A099B12E41000000C0644F334100000000ABB12E41000000606F4F334100000040C2B12E41000000407C4F3341000000C0D7B12E41000000E0894F3341000000A0EDB12E41000000E0974F33410000004002B22E4100000060A94F3341000000C01AB22E4100000040BB4F33410000000033B22E4100000020D04F33410000000051B22E41000000E0E44F3341000000006FB22E4100000040F74F33410000004089B22E410000008009503341000000C0A3B22E41000000401850334100000060BAB22E41000000A026503341000000C0D2B22E410000002034503341000000A0EFB22E41000000A040503341000000400DB32E41000000804B503341000000A027B32E410000002056503341000000C040B32E41000000C064503341000000A05DB32E410000000074503341000000C079B32E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('345','593.172542','ROAD3','PL2060','2673','2777','2672','2776','TEABERRY RD',NULL,NULL,'2673','2672','2777','2776','Right','roadswest.dbf','0.11','40','0.1650','11.4072',NULL,'1',NULL,NULL,'TEABERRY','RD',NULL,'01050000000100000001020000001600000000000000E039334100000040DFAF2E4100000060F4393341000000A0DBAF2E4100000080133A334100000000D5AF2E4100000080423A3341000000A0C8AF2E41000000C0713A334100000000BCAF2E41000000409B3A334100000000B4AF2E41000000A0C43A334100000040ADAF2E4100000080E73A3341000000A0A7AF2E41000000A00A3B334100000040A3AF2E4100000040203B3341000000A0A1AF2E41000000E0353B334100000040A1AF2E41000000E04E3B3341000000C0A2AF2E41000000C0613B334100000040A9AF2E4100000040783B334100000060C4AF2E4100000080813B334100000000E5AF2E4100000060873B3341000000C00DB02E41000000A0893B3341000000C02BB02E41000000808A3B3341000000404AB02E4100000000893B3341000000C080B02E41000000A0873B334100000040A7B02E41000000C08E3B3341000000C0EBB02E4100000060993B3341000000001EB12E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('346','470.603334','ROAD4','PL2061','101','183','100','182','DAVIS GENTRY RD',NULL,NULL,'101','100','183','182','Right','roadswest.dbf','0.09','40','0.1350','11.4782',NULL,'1',NULL,NULL,'DAVIS GENTRY','RD',NULL,'010500000001000000010200000013000000000000E0314833410000004089DD2E4100000040364833410000004089DD2E4100000080424833410000004089DD2E41000000A04E483341000000C087DD2E41000000205F483341000000407EDD2E41000000806F4833410000000072DD2E41000000608C4833410000004061DD2E41000000C0A9483341000000C054DD2E41B09DD822C5483341819DA72B62DD2E418F6AC29BD9483341D84C83D06FDD2E4114444C48E6483341205B7D687FDD2E41192DF007F0483341552000A59CDD2E4143324E0EEF4833416BA3BFC7BDDD2E41DAF9FE61E2483341D9D55A8FECDD2E4119D627CFD1483341EE84CF8A13DE2E41FFBEF06FB948334183AF56A95BDE2E41AB5D6C2A9D483341BD826CD4A1DE2E41810146EB7F48334126304C6C24DF2E410B6DAB1E78483341CBFBB4976ADF2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('347','82.072223','ROAD4','PL2061','0','0','0','0',NULL,NULL,NULL,'0','0','0','0','Right','roadswest.dbf','0.02','40','0.0300','0',NULL,'0',NULL,NULL,NULL,NULL,NULL,'0105000000010000000102000000020000002C1DF2E1804333412427478B35D62E41883DA5938E43334112045FB393D52E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('348','857.143025','ROAD4','PL2061','123','277','122','276','E ST',NULL,NULL,'123','122','277','276','Right','roadswest.dbf','0.16','40','0.2400','11.1318',NULL,'1',NULL,NULL,'E','ST',NULL,'01050000000100000001020000001100000000000000B041334100000000A0D22E413036FE5AF2413341E423CBF30CD32E41ED33E45D0C4233410C50FB0943D32E41A27C2F4C244233416E75C83F96D32E416B6DE5F44E42334121515ADCF3D32E41D0C04640704233418376271247D42E41F75A0FC77D423341B77F09F45DD42E4118F64927A142334154FF9B3398D42E41259F26BBC94233415F7EE9C4DAD42E412B93683AF042334181BA5E9D0AD52E419CD9992B22433341B5C6042F4DD52E41AFC0AB5059433341D212BFC976D52E411952422D894333417A6F03D591D52E414D95E747BF43334163B2DB8DA4D52E41ED2A7CD4004433412E48D1C1C3D52E415F71ADC532443341BFE7ED85F1D52E41C9563FDA664433414C49CF6B34D62E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('349','636.130858','ROAD4','PL2061','101','221','100','220','G ST',NULL,NULL,'101','100','221','220','Right','roadswest.dbf','0.12','40','0.1800','10.6022',NULL,'1',NULL,NULL,'G','ST',NULL,'01050000000100000001020000001F000000000000408A3F3341000000C0E7D72E4100000080913F3341000000A0EFD72E41000000C0983F3341000000C0F6D72E41000000C0A73F334100000000FFD72E4100000040B73F33410000006004D82E4100000040D03F3341000000C00CD82E4100000040E93F3341000000A015D82E4100000080FC3F33410000004020D82E41000000C00F4033410000006029D82E41000000C0284033410000000030D82E410000006040403341000000402BD82E41000000A052403341000000A012D82E410000008062403341000000A0F0D72E410000000071403341000000C0C8D72E41000000207D403341000000C09DD72E410000000088403341000000C06CD72E410000000091403341000000A03AD72E41000000A0974033410000004014D72E41000000409D40334100000040EDD62E4100000060A1403341000000C0B4D62E4100000000A6403341000000A07CD62E4100000000AC403341000000C053D62E4100000000B5403341000000C02DD62E4100000000C2403341000000C00DD62E4100000060D240334100000000F7D52E41000000A0E440334100000000F2D52E4100000000F8403341000000C0F3D52E41000000A00B413341000000A0F5D52E41000000601F41334100000040F8D52E41000000003541334100000040FAD52E41000000A04A41334100000040FCD52E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('350','1656.975244','ROAD2','PL2061','9365','9685','9364','9684','NC HWY 194 NORTH',NULL,NULL,'9365','9364','9685','9684','Right','roadswest.dbf','0.31','40','0.4650','10.3560',NULL,'1',NULL,NULL,'NC HWY 194',NULL,'N','010500000001000000010200000028000000000000A0F8403341000000C002D32E41000000801D4133410000000048D32E41000000803C4133410000004079D32E41000000605B413341000000A0AAD32E41000000E084413341000000C0EDD32E4100000060AE4133410000006031D42E41000000C0E2413341000000C085D42E41000000401742334100000060D9D42E41000000A0474233410000004028D52E41000000A079423341000000A073D52E4100000060A342334100000040A9D52E41000000A0CE423341000000C0D8D52E4100000040EE423341000000A0F6D52E41000000C00E433341000000C00FD62E4100000060334333410000000025D62E410000000059433341000000C032D62E41000000C07A433341000000C035D62E41000000C07A433341000000C035D62E41000000409C433341000000A034D62E4100000080C5433341000000A031D62E4100000060EE433341000000C02ED62E41000000601D4433410000006032D62E41000000004D443341000000C035D62E41000000004D443341000000C035D62E4100000080824433410000000033D62E41000000C0B7443341000000602AD62E41000000C0C7443341000000A025D62E4100000060EF443341000000C019D62E410000008026453341000000A002D62E41000000406A453341000000C0DAD52E410000004082453341000000C0CBD52E4100000040AD45334100000040B1D52E41000000A0DA453341000000609AD52E41000000A0084633410000004085D52E410000006034463341000000C070D52E4100000020604633410000000060D52E41000000E0804633410000006057D52E4100000080A14633410000000054D52E41000000C0BF4633410000004058D52E4100000020DF463341000000A063D52E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('351','2427.437068','ROAD2','PL2061','9689','10161','9688','10160','NC HWY 194 NORTH',NULL,NULL,'9689','9688','10161','10160','Right','roadswest.dbf','0.46','40','0.6900','10.2858',NULL,'1',NULL,NULL,'NC HWY 194',NULL,'N','01050000000100000001020000003300000000000020DF463341000000A063D52E41000000E0FA463341000000A073D52E41000000C016473341000000608AD52E41000000E02E47334100000040A5D52E41000000C045473341000000C0C4D52E41000000205647334100000060DFD52E41000000406547334100000000FCD52E41000000807A473341000000A030D62E41000000608C473341000000606AD62E41000000A09D473341000000C0B4D62E4100000020AC473341000000C001D72E41000000A0E047334100000000BCD82E41000000A0F9473341000000A00ADA2E41000000A0024833410000006083DA2E41000000C011483341000000C01ADB2E41000000C016483341000000404FDB2E41000000402048334100000000B2DB2E41000000802B483341000000402BDC2E410000002034483341000000A0A4DC2E41000000C03648334100000060EDDC2E41000000C037483341000000A036DD2E4100000040364833410000004089DD2E41000000A03448334100000040BADD2E410000004031483341000000A0F9DD2E41000000E02C483341000000A038DE2E410000004025483341000000A08CDE2E41000000401D483341000000C0E0DE2E4100000060164833410000004039DF2E41000000A010483341000000C091DF2E41000000000B483341000000400DE02E41000000E006483341000000A088E02E410000008001483341000000603AE12E41000000E0FC47334100000040ECE12E4100000020FA473341000000A045E22E4100000040F84733410000004084E22E41000000C0F5473341000000401CE32E41000000A0F5473341000000C072E32E4100000040F8473341000000A0C9E32E41000000C0FD473341000000400BE42E41000000A005483341000000C04BE42E410000000011483341000000608DE42E41000000601E48334100000040CDE42E41000000402E483341000000400FE52E41000000A03E4833410000006050E52E41000000C04F483341000000A094E52E41000000605F483341000000A0D9E52E41000000406C483341000000601DE62E4100000040744833410000006061E62E41000000807448334100000060A3E62E41000000406E483341000000C0E3E62E41000000A060483341000000203CE72E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('352','4288.783083','ROAD2','PL2061','10159','10975','10158','10974','NC HWY 194 NORTH',NULL,NULL,'10159','10158','10975','10974','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('353','1119.655323','ROAD4','PL2061','101','301','100','300','J B SEXTON RD',NULL,NULL,'101','100','301','300','Right','roadswest.dbf','0.21','40','0.3150','11.1966',NULL,'1',NULL,NULL,'J B SEXTON','RD',NULL,'01050000000100000001020000003000000000000000D045334100000060E21A2F41000000C0C8453341000000A0DC1A2F4100000060C1453341000000A0D61A2F4100000060B345334100000040CB1A2F4100000020A5453341000000A0C01A2F410000002093453341000000A0B71A2F410000000081453341000000C0AE1A2F41000000606E453341000000C09F1A2F41000000E05B453341000000C0961A2F41000000404B453341000000A09C1A2F41000000603C45334100000060AB1A2F41000000E03145334100000040C91A2F41000000E02845334100000040EB1A2F41000000401A453341000000000D1B2F41000000C00A453341000000A02D1B2F4100000040FA44334100000040531B2F41000000A0E9443341000000C0781B2F41000000E0D644334100000060A21B2F4100000020C3443341000000A0C91B2F4100000020B1443341000000C0E61B2F41000000409E44334100000060011C2F41000000C085443341000000601B1C2F41000000C06D443341000000C0361C2F41000000C05B443341000000C0581C2F41000000804A443341000000A07C1C2F410000002031443341000000A0A81C2F41000000601644334100000040D11C2F41000000C0FA433341000000C0F31C2F4100000060DE43334100000040141D2F4100000060C443334100000040301D2F41000000C0AA433341000000A04D1D2F41000000C09243334100000000711D2F41000000A07A433341000000A0941D2F41000000606643334100000060AD1D2F410000006051433341000000C0C31D2F41000000003643334100000040DA1D2F41000000401A433341000000C0EE1D2F410000006003433341000000C0011E2F4100000080EC423341000000C0131E2F4100000080D5423341000000C0241E2F4100000000BE423341000000C0311E2F4100000080A0423341000000C0371E2F410000002083423341000000A0331E2F41000000C06C423341000000A0261E2F41000000E05642334100000040151E2F41000000604342334100000040041E2F41000000C02F42334100000040F31D2F41000000801D42334100000040E61D2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('354','1949.197312','ROAD3','PL2061','607','979','606','978','PINEY CREEK RD',NULL,NULL,'607','606','979','978','Right','roadswest.dbf','0.37','40','0.5550','10.4796',NULL,'1',NULL,NULL,'PINEY CREEK','RD',NULL,'01050000000100000001020000002C00000000000080ED4F334100000000A0D22E410000008010503341000000A0C8D22E41000000403B50334100000060FCD22E4100000000665033410000004031D32E410000002097503341000000006ED32E4100000080C850334100000040AAD32E410000008007513341000000C0F5D32E41000000E047513341000000C03CD42E41000000E07B513341000000A06CD42E4100000020BC51334100000040A6D42E41000000A0D151334100000000BBD42E4100000000F4513341000000A0DAD42E41000000201352334100000040F3D42E41000000A0325233410000000009D52E410000006054523341000000A01DD52E410000008076523341000000602FD52E410000000093523341000000A03BD52E4100000080AF5233410000004046D52E4100000060EF523341000000A05CD52E41000000A02F533341000000C070D52E41000000A0AA5333410000004093D52E41000000E02554334100000060B1D52E41000000006454334100000000C2D52E41000000A0A254334100000040CED52E4100000040BE54334100000040D0D52E4100000040BE54334100000040D0D52E41000000C0D9543341000000C0CFD52E4100000080EF543341000000A0CDD52E410000004005553341000000C0C8D52E41000000C01C553341000000A0C0D52E41000000E03355334100000040B3D52E41000000C04A553341000000A09DD52E410000002060553341000000C083D52E410000000079553341000000A063D52E41000000A090553341000000A03FD52E4100000040A7553341000000C014D52E4100000000BC55334100000040E7D42E41000000E0CD553341000000C0BBD42E41000000A0DE553341000000608ED42E41000000C0F1553341000000C051D42E41000000A0035633410000000014D42E41000000E02156334100000040A7D32E41000000203F563341000000A039D32E41000000606756334100000000A0D22E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('355','598.109075','ROAD3','PL2061','101','213','100','212','PINEY CREEK RD',NULL,NULL,'101','100','213','212','Right','roadswest.dbf','0.11','40','0.1650','10.6806',NULL,'1',NULL,NULL,'PINEY CREEK','RD',NULL,'01050000000100000001020000001400000000000020DF463341000000A063D52E41000000E0EA463341000000A047D52E4100000020034733410000004032D52E4100000060144733410000000027D52E41000000A02E473341000000C00DD52E41000000203E47334100000000F9D42E41000000C04C47334100000060E2D42E41000000206747334100000000B4D42E410000000081473341000000C086D42E41000000C098473341000000C064D42E4100000080B1473341000000A044D42E4100000020D04733410000006020D42E4100000040EF473341000000C0FCD32E41000000801248334100000040D4D32E410000000035483341000000C0A7D32E4100000020554833410000006074D32E410000004073483341000000C03CD32E410000004090483341000000A001D32E41000000E0AB48334100000040C3D22E41000000A0B948334100000000A0D22E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('356','2161.273717','ROAD3','PL2061','2749','3203','2748','3202','BIG PINEY CREEK RD',NULL,NULL,'2749','2748','3203','3202','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('357','3598.094949','ROAD3','PL2061','101','783','100','782','DON ADAMS RD',NULL,NULL,'101','100','783','782','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('358','4272.332491','ROAD3','PL2061','1851','2747','1850','2746','BIG PINEY CREEK RD',NULL,NULL,'1851','1850','2747','2746','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('359','5600.703436','ROAD3','PL2061','101','1169','100','1168','GLENN KING RD',NULL,NULL,'101','100','1169','1168','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('360','1404.501765','ROAD3','PL2061','1557','1851','1556','1850','BIG PINEY CREEK RD',NULL,NULL,'1557','1556','1851','1850','Right','roadswest.dbf','0.27','40','0.4050','9.5544',NULL,'1',NULL,NULL,'BIG PINEY CREEK','RD',NULL,'010500000001000000010200000022000000000000A0BF5633410000006031142F41000000A0CB563341000000601B142F4100000020DE563341000000C0F9132F4100000020F8563341000000C0C4132F41000000A00F573341000000A08C132F41000000A023573341000000A04D132F410000004034573341000000400A132F41000000004257334100000040BC122F41000000204D573341000000406B122F410000006058573341000000C00F122F41000000A062573341000000A0B3112F41000000806F573341000000C040112F41000000A07C57334100000060CE102F41000000C08D5733410000006041102F41000000209F573341000000A0B40F2F41000000A0AD57334100000000440F2F4100000000BB57334100000060D30E2F4100000080C4573341000000C0790E2F4100000000CB573341000000A0200E2F4100000000CC57334100000060D60D2F4100000020CA573341000000C08B0D2F41000000E0C5573341000000C0470D2F4100000000C0573341000000A0030D2F4100000000B7573341000000A0AF0C2F4100000060AE573341000000605A0C2F4100000020A9573341000000A0130C2F4100000060A657334100000000CC0B2F4100000080A6573341000000A0A10B2F4100000000A8573341000000A0760B2F41000000A0AE573341000000403B0B2F4100000020B7573341000000A0010B2F41000000C0C9573341000000A0860A2F4100000040DE573341000000600C0A2F41000000A0E957334100000000CC092F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('361','1456.725957','ROAD3','PL2061','101','381','100','380','BALDWIN JONES RD',NULL,NULL,'101','100','381','380','Right','roadswest.dbf','0.28','40','0.4200','10.4052',NULL,'1',NULL,NULL,'BALDWIN JONES','RD',NULL,'010500000001000000010200000036000000000000A0F9473341000000A00ADA2E41000000C0FD473341000000A005DA2E41000000E001483341000000C000DA2E41000000601048334100000060F2D92E41000000201F483341000000A0E4D92E410000000035483341000000A0CBD92E41000000204B48334100000040B4D92E410000006061483341000000A0A1D92E4100000040784833410000000098D92E41000000C089483341000000409DD92E41000000409B48334100000040A7D92E4100000000B148334100000060B6D92E41000000C0C6483341000000C0C5D92E4100000000E6483341000000C0D3D92E41000000E00549334100000040DDD92E41000000E025493341000000A0E1D92E410000000046493341000000A0E3D92E41000000606A49334100000040E4D92E41000000C08E493341000000A0E4D92E4100000000B5493341000000A0E5D92E4100000040DB49334100000060E8D92E41000000E0FA49334100000000EDD92E41000000801A4A3341000000C0F3D92E41000000C0354A3341000000A0FBD92E41000000C0504A3341000000A004DA2E4100000060744A3341000000A011DA2E41000000A0974A33410000004020DA2E4100000040B84A3341000000A030DA2E41000000C0D84A33410000004042DA2E4100000080FA4A33410000006055DA2E41000000201C4B33410000006069DA2E41000000E0364B33410000004079DA2E4100000080514B3341000000408ADA2E41000000A06E4B3341000000A09EDA2E41000000A08A4B334100000000B7DA2E41000000C0A34B334100000000D6DA2E41000000A0BB4B334100000040F9DA2E41000000C0CF4B33410000000019DB2E41000000E0E24B3341000000403BDB2E41000000C0F74B3341000000C064DB2E4100000040FD4B3341000000A073DB2E41000000E0084C33410000004093DB2E41000000A0114C334100000000C3DB2E41000000A0174C3341000000A0F5DB2E41000000001D4C3341000000C033DC2E4100000080224C33410000006072DC2E41000000202B4C3341000000C0B0DC2E41000000C0364C334100000000EDDC2E41000000E0414C33410000004018DD2E41000000E04E4C33410000000041DD2E41000000A0624C3341000000A070DD2E4100000020794C3341000000609BDD2E41000000408E4C334100000060BBDD2E41000000E0A34C3341000000A0DADD2E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('362','772.943749','ROAD4','PL2061','267','415','266','414','A ST',NULL,NULL,'267','266','415','414','Right','roadswest.dbf','0.15','40','0.2250','10.4452',NULL,'1',NULL,NULL,'A','ST',NULL,'010500000001000000010200000021000000000000601743334100000000A0D22E41000000601A433341000000A0B1D22E41000000402143334100000040D5D22E41000000C0294333410000004000D32E410000000033433341000000402AD32E41000000003B433341000000C04AD32E41000000E043433341000000406AD32E41000000004C433341000000C081D32E41000000E054433341000000A097D32E41000000006143334100000040AED32E41000000406E43334100000040C3D32E41000000408543334100000060E4D32E41000000809C4333410000004006D42E4100000080B0433341000000C029D42E4100000000C4433341000000604DD42E4100000020D34333410000000068D42E41000000C0E2433341000000A081D42E41000000E0F0433341000000C096D42E4100000060FF43334100000060A9D42E410000000011443341000000C0B8D42E41000000A02344334100000060C6D42E41000000804944334100000060E2D42E41000000806F443341000000C0FDD42E410000008090443341000000A015D52E4100000080B1443341000000402FD52E41000000C0D34433410000004050D52E4100000060F54433410000004070D52E41000000401B453341000000608BD52E41000000C04145334100000060A4D52E41000000C04145334100000060A4D52E41000000005E453341000000C0B4D52E41000000E072453341000000C0C1D52E41000000A08345334100000000CBD52E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('363','497.497223','ROAD4','PL2061','101','197','100','196','J ST',NULL,NULL,'101','100','197','196','Right','roadswest.dbf','0.09','40','0.1350','10.3646',NULL,'1',NULL,NULL,'J','ST',NULL,'01050000000100000001020000001C000000000000C0C7443341000000A025D62E4100000080C7443341000000A036D62E4100000020C74433410000006047D62E4100000080C64433410000000067D62E4100000020C74433410000006086D62E41000000E0CA44334100000060AAD62E41000000E0D144334100000000CCD62E4100000020DD443341000000C0E6D62E41000000A0E94433410000006000D72E41000000E0F3443341000000401BD72E4100000080FD443341000000A036D72E41000000200B453341000000405BD72E4100000020164533410000000082D72E41000000201B45334100000000B0D72E41000000401D453341000000C0DFD72E41000000601F453341000000C018D82E4100000080214533410000000052D82E410000002026453341000000C083D82E41000000C029453341000000C0B5D82E410000008029453341000000C0CBD82E410000006029453341000000C0E1D82E41000000402B453341000000A0FBD82E41000000202E453341000000C014D92E410000004030453341000000C024D92E410000004032453341000000C034D92E41000000A038453341000000A068D92E41000000C03B453341000000A09CD92E414739A0263A4533410ED7F8CBCFD92E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('364','295.787418','ROAD4','PL2061','0','0','0','0',NULL,NULL,NULL,'0','0','0','0','Right','roadswest.dbf','0.06','40','0.0900','0',NULL,'0',NULL,NULL,NULL,NULL,NULL,'010500000001000000010200000015000000000000A052403341000000A012D82E410000004055403341000000A022D82E410000008058403341000000C031D82E4100000020644033410000000048D82E410000006071403341000000405CD82E41000000C07B4033410000004074D82E41000000E084403341000000408ED82E41000000A08C40334100000040B3D82E41000000409440334100000060D8D82E41000000009E403341000000C0F3D82E4100000000A9403341000000A00DD92E41000000A0B4403341000000C027D92E4100000080C04033410000006041D92E4100000060CA4033410000006058D92E41000000A0D4403341000000A06ED92E4100000020E24033410000000086D92E4100000020F0403341000000A09CD92E41000000E0F9403341000000C0ABD92E41000000A00241334100000000BDD92E41000000400641334100000000CAD92E410000008009413341000000A0D7D92E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('365','60.449617','ROAD2','PL2061','9355','9367','9354','9366','NC HWY 194 NORTH',NULL,NULL,'9355','9354','9367','9366','Right','roadswest.dbf','0.01','40','0.0150','10.0750',NULL,'1',NULL,NULL,'NC HWY 194',NULL,'N','010500000001000000010200000002000000000000801B41334100000000A0D22E41000000A0F8403341000000C002D32E41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('366','2374.597072','ROAD3','PL2061','1055','1559','1054','1558','BIG PINEY CREEK RD',NULL,NULL,'1055','1054','1559','1558','Right','roadswest.dbf','0.45','40','0.6750','9.4230',NULL,'1',NULL,NULL,'BIG PINEY CREEK','RD',NULL,'01050000000100000001020000003300000000000000AF50334100000000C0202F4100000040D9503341000000A073202F41000000201A5133410000004008202F410000008064513341000000608E1F2F41000000C0AF51334100000000171F2F41000000E0ED51334100000040B11E2F41000000C02E523341000000C0511E2F410000000047523341000000A0331E2F41000000606052334100000040181E2F41000000C07852334100000000051E2F41000000609152334100000040F51D2F4100000000AE523341000000A0E51D2F4100000000CB52334100000000D81D2F410000004013533341000000C0C11D2F41000000605B533341000000C0AF1D2F41000000A09253334100000060A11D2F41000000A0C7533341000000408A1D2F4100000080E553334100000000731D2F41000000A00154334100000040551D2F41000000601C543341000000C02C1D2F41000000203454334100000060FD1C2F41000000204854334100000040C81C2F410000004059543341000000408E1C2F410000004068543341000000C0511C2F41000000207354334100000060131C2F41000000A076543341000000C0E81B2F41000000207A543341000000409E1B2F41000000A07B543341000000C05D1B2F41000000607D543341000000601C1B2F41000000408154334100000040D81A2F41000000A088543341000000A0941A2F410000006094543341000000C05B1A2F4100000080A2543341000000C0251A2F41000000E0B554334100000000E6192F4100000020CA54334100000000A8192F41000000402155334100000060C0182F41000000803E553341000000C06E182F41000000605B553341000000001D182F410000008074553341000000C0D2172F41000000408D5533410000000088172F4100000040A95533410000000030172F4100000040C5553341000000A0D7162F4100000000E5553341000000A074162F41000000C0045633410000000012162F41000000801F563341000000A0BB152F41000000203B563341000000A065152F41000000C054563341000000401C152F41000000207056334100000060D5142F41000000C087563341000000A09E142F41000000A0A0563341000000C069142F41000000A0BF5633410000006031142F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('367','1885.843940','ROAD3','PL2061','2197','2595','2196','2594','PARSONS HILL RD',NULL,NULL,'2197','2196','2595','2594','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('368','3994.633890','ROAD2','PL2061','10975','11739','10974','11738','NC HWY 194 NORTH',NULL,NULL,'10975','10974','11739','11738','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('369','3241.377825','ROAD3','PL2061','101','715','100','714','SOUTH BIG HORSE CREEK RD',NULL,NULL,'101','100','715','714','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('370','727.536941','ROAD2','PL2062','11741','11881','11740','11880','NC HWY 194 NORTH',NULL,NULL,'11741','11740','11881','11880','Right','roadswest.dbf','0.14','40','0.2100','10.3934',NULL,'1',NULL,NULL,'NC HWY 194',NULL,'N','010500000001000000010200000010000000000000603B45334100000000C0202F41000000E0264533410000006095212F41000000801B453341000000600C222F4100000020114533410000006083222F41000000400C453341000000C0C5222F41000000E007453341000000A008232F410000002003453341000000C067232F4100000000FF443341000000A0C7232F4100000060FB443341000000A023242F41000000E0F7443341000000C07F242F41000000E0F4443341000000A0C8242F4100000040F14433410000004011252F4100000080EB443341000000A067252F4100000040E444334100000040BD252F4100000060DC443341000000C00D262F41000000C0D3443341000000A05E262F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('371','2325.995676','ROAD2','PL2062','11879','12323','11878','12322','NC HWY 194 NORTH',NULL,NULL,'11879','11878','12323','12322','Right','roadswest.dbf','0.44','40','0.6600','10.4774',NULL,'1',NULL,NULL,'NC HWY 194',NULL,'N','010500000001000000010200000026000000000000C0D3443341000000A05E262F4100000040BB443341000000C033272F41000000E0A1443341000000A008282F41000000E090443341000000C09A282F41000000208A443341000000C0D4282F41000000807244334100000040A1292F41000000C05F44334100000060462A2F41000000A04C443341000000A0EB2A2F410000008037443341000000C09A2B2F41000000A021443341000000C0492C2F41000000200E443341000000C0DE2C2F41000000E0F943334100000040732D2F4100000080E843334100000040F02D2F4100000040DB433341000000C0472E2F41000000C0D5433341000000A06C2E2F4100000080C243334100000060DB2E2F4100000040AE43334100000040492F2F41000000E09343334100000040CE2F2F41000000A079433341000000C052302F410000004065433341000000A0BE302F410000006052433341000000402B312F410000008040433341000000C0A7312F41000000E03743334100000040EC312F41000000402E433341000000C04D322F41000000402643334100000000B0322F41000000401D433341000000003A332F410000006015433341000000A0C4332F41000000600D433341000000A046342F41000000A00543334100000040C8342F41000000E0FF423341000000A03D352F4100000020F942334100000040B3352F41000000C0F1423341000000A010362F4100000080E8423341000000406D362F4100000060DE42334100000060BF362F4100000080D2423341000000C010372F41000000A0C5423341000000C058372F4100000000B842334100000000A0372F4100000060A7423341000000A0F4372F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('372','255.886335','ROAD2','PL2062','12325','12373','12324','12372','NC HWY 194 NORTH',NULL,NULL,'12325','12324','12373','12372','Right','roadswest.dbf','0.05','40','0.0750','10.6620',NULL,'1',NULL,NULL,'NC HWY 194',NULL,'N','01050000000100000001020000000A00000000000060A7423341000000A0F4372F41000000C09F423341000000401F382F4100000080974233410000000064382F41000000C09242334100000000AA382F41000000609242334100000040DE382F410000002094423341000000A012392F410000008098423341000000C048392F41000000E09E423341000000A07E392F4100000000A742334100000000B3392F4100000000B042334100000060E7392F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('373','6372.968239','ROAD2','PL2062','12373','13589','12372','13588','NC HWY 194 NORTH',NULL,NULL,'12373','12372','13589','13588','Right','roadswest.dbf','1.21','40','1.8150','10.4818',NULL,'1',NULL,NULL,'NC HWY 194',NULL,'N','01050000000100000001020000008100000000000000B042334100000060E7392F41000000E0C4423341000000605C3A2F41000000E0DA423341000000A0D03A2F4100000000E6423341000000C00A3B2F41000000A0F142334100000040483B2F41000000400A43334100000000BD3B2F41000000A026433341000000C0293C2F41000000E04443334100000060953C2F41000000006243334100000000FD3C2F41000000207F433341000000C0643D2F41000000C0A1433341000000A0E63D2F4100000080C4433341000000A0673E2F41000000A0E143334100000060CE3E2F410000004000443341000000C0323F2F410000000018443341000000A0793F2F410000004031443341000000C0BD3F2F41000000204B443341000000C0FA3F2F41000000C05B443341000000401F402F41000000C077443341000000C055402F41000000C094443341000000608A402F4100000040CB443341000000C0E7402F41000000E002453341000000C043412F41000000403E45334100000040A7412F41000000C079453341000000600A422F4100000000B5453341000000606B422F4100000000F045334100000040CD422F41000000C0204633410000004020432F4100000080504633410000004075432F41000000207446334100000040B4432F410000004095463341000000A0F9432F4100000020A6463341000000C028442F41000000A0B4463341000000C05A442F4100000060BF463341000000A08F442F4100000060C7463341000000C0C5442F4100000040CD463341000000A0FF442F4100000060D1463341000000C039452F4100000080D4463341000000C08D452F4100000080D646334100000040E1452F41000000E0D8463341000000C02D462F41000000C0DC463341000000A079462F41000000A0E146334100000000AE462F4100000000E8463341000000C0E1462F4100000020F1463341000000001B472F4100000060FB4633410000004054472F410000002009473341000000409E472F41000000C016473341000000A0E8472F41000000A0214733410000000027482F41000000202B473341000000C066482F410000002031473341000000009E482F410000008035473341000000A0D5482F410000004039473341000000C015492F41000000603B473341000000C056492F41000000C03B47334100000040A3492F41000000E03A473341000000A0EF492F41000000203947334100000040514A2F410000000037473341000000C0B24A2F41000000603547334100000000134B2F41000000803447334100000000734B2F41000000C03447334100000040C44B2F41000000003647334100000000154C2F41000000603A473341000000608E4C2F410000000041473341000000A0074D2F410000002049473341000000A07B4D2F410000006053473341000000A0EE4D2F41000000E06147334100000060694E2F41000000207247334100000000E44E2F410000002083473341000000A0634F2F41000000E09247334100000040E44F2F41000000809B4733410000004034502F41000000E0A14733410000006085502F4100000020A447334100000040C6502F4100000040A34733410000004007512F41000000A09E473341000000C03B512F410000002098473341000000006F512F41000000808C473341000000C0B9512F41000000C07E4733410000004003522F41000000E063473341000000A080522F41000000805D473341000000609B522F410000000047473341000000A0FB522F41000000802A473341000000C075532F41000000E00D47334100000040F0532F4100000040F0463341000000C06E542F41000000C0E346334100000040A6542F41000000A0D3463341000000C0ED542F41000000C0B9463341000000C06D552F4100000020A146334100000000EF552F41000000E085463341000000A07D562F41000000006C463341000000A00C572F410000006052463341000000C0A6572F41000000A03A4633410000004042582F41000000602646334100000000C6582F410000004016463341000000A04A592F41000000E00F463341000000C0A3592F41000000000D463341000000C0FD592F41000000E00D463341000000404A5A2F410000004011463341000000A0965A2F410000008017463341000000A0E65A2F41000000601F46334100000060365B2F41000000C02E463341000000C0C15B2F41000000403F463341000000C04C5C2F410000006051463341000000A0EB5C2F410000004063463341000000408A5D2F41000000E07146334100000040105E2F41000000608046334100000040965E2F410000006092463341000000C03C5F2F4100000040A4463341000000A0E35F2F4100000040B0463341000000405B602F41000000A0BC463341000000A0D2602F4100000040C9463341000000A04A612F4100000020D5463341000000C0C2612F41000000A0DC463341000000A013622F41000000E0E24633410000000065622F41000000E0E546334100000060A2622F4100000020E846334100000060DF622F4100000060EA463341000000C01E632F4100000060EC463341000000405E632F4100000080EE46334100000040A6632F4100000020F1463341000000C0ED632F4100000020F54633410000004040642F41000000C0FA463341000000A091642F410000006002473341000000C0DA642F41000000000B4733410000006024652F4100000060174733410000004093652F410000000024473341000000C001662F4100000060314733410000004079662F41000000204047334100000040EF662F410000008048473341000000A028672F41000000A051473341000000C061672F41000000605B473341000000609C672F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('374','3782.925916','ROAD3','PL2062','1397','2195','1396','2194','PARSONS HILL RD',NULL,NULL,'1397','1396','2195','2194','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('375','2429.433489','ROAD3','PL2062','537','1051','536','1050','BIG PINEY CREEK RD',NULL,NULL,'537','536','1051','1050','Right','roadswest.dbf','0.46','40','0.6900','9.4530',NULL,'1',NULL,NULL,'BIG PINEY CREEK','RD',NULL,'01050000000100000001020000002900000000000040DC4A334100000000DF2E2F41000000A0EC4A3341000000C0C22E2F41000000402F4B3341000000A0742E2F4100000060AF4B334100000060E12D2F41000000E02E4C3341000000C04C2D2F4100000040524C3341000000A0232D2F4100000020874C334100000040E62C2F4100000020DE4C3341000000407C2C2F41000000201B4D3341000000C02C2C2F4100000060564D3341000000C0D82B2F4100000060784D3341000000A0A22B2F41000000E0984D3341000000A0692B2F4100000040B94D334100000060262B2F41000000C0D84D3341000000C0DF2A2F4100000080044E3341000000407C2A2F41000000202F4E334100000000172A2F4100000080664E33410000006088292F41000000A09C4E334100000040F7282F4100000000D24E3341000000A06A282F4100000080054F3341000000C0DB272F41000000802A4F3341000000606B272F41000000204D4F334100000040F8262F4100000020664F3341000000A09B262F41000000007D4F3341000000603D262F41000000A0924F334100000060D1252F4100000080A64F33410000004063252F41000000E0B94F334100000000F6242F4100000060CC4F3341000000A088242F41000000E0DC4F3341000000001D242F4100000080E24F334100000040F8232F4100000080F84F33410000000067232F4100000020FF4F3341000000A03D232F41000000600C50334100000040EB222F41000000A021503341000000A070222F4100000080315033410000004017222F41000000804450334100000060BF212F410000002058503341000000A07E212F41000000806E503341000000A041212F41000000007D503341000000C021212F41000000C09A503341000000C0E4202F4100000000AF50334100000000C0202F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('376','1689.202429','ROAD3','PL2062','101','455','100','454','BIG PINEY CREEK RD',NULL,NULL,'101','100','455','454','Right','roadswest.dbf','0.32','40','0.4800','9.5436',NULL,'1',NULL,NULL,'BIG PINEY CREEK','RD',NULL,'010500000001000000010200000025000000000000C0D3443341000000A05E262F4100000060F6443341000000C083262F41000000805245334100000060D9262F4100000020AD4533410000004035272F4100000000CE453341000000005A272F41000000E0ED4533410000006083272F410000008004463341000000C0A8272F41000000201946334100000060D2272F410000004028463341000000A0F7272F41000000A035463341000000401F282F41000000A041463341000000404C282F41000000C04B463341000000C07A282F41000000C05546334100000060B5282F41000000A05E463341000000C0EF282F41000000406F4633410000004052292F41000000808146334100000040B3292F41000000008F46334100000040F3292F41000000C09D46334100000040322A2F41000000A0AF463341000000A0782A2F4100000080C346334100000040BC2A2F41000000A0D246334100000040E92A2F41000000E0E246334100000000152B2F41000000E0F646334100000060452B2F41000000E00B47334100000000742B2F41000000403347334100000040C12B2F41000000405C473341000000C00B2C2F41000000A09847334100000060782C2F4100000020D547334100000000E52C2F41000000600948334100000060472D2F41000000A03D48334100000060A92D2F41000000A071483341000000A0082E2F4100000080A648334100000040662E2F4100000060CC483341000000C0A92E2F4100000080F348334100000000E72E2F41000000001749334100000040102F2F41000000A03C493341000000A0342F2F41000000806349334100000080552F2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('377','394.468208','ROAD3','PL2062','457','539','456','538','BIG PINEY CREEK RD',NULL,NULL,'457','456','539','538','Right','roadswest.dbf','0.07','40','0.1050','9.6212',NULL,'1',NULL,NULL,'BIG PINEY CREEK','RD',NULL,'01050000000100000001020000000E000000000000806349334100000080552F2F41000000007C493341000000A0662F2F41000000009E493341000000C0742F2F41000000E0C0493341000000A07C2F2F4100000000DE493341000000407E2F2F4100000000DE493341000000407E2F2F4100000040FB493341000000007C2F2F4100000000164A3341000000C0762F2F4100000080304A3341000000C06D2F2F41000000E04C4A3341000000405F2F2F41000000A0684A3341000000404C2F2F4100000020894A3341000000C02E2F2F4100000020A94A3341000000C00D2F2F4100000040DC4A334100000000DF2E2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('378','2198.419505','ROAD3','PL2062','101','509','100','508','HENRY POWERS RD',NULL,NULL,'101','100','509','508','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('379','1755.402566','ROAD3','PL2062','101','435','100','434','RICHARDSON HOLLOW RD',NULL,NULL,'101','100','435','434','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('380','384.881496','ROAD3','PL2062','459','531','458','530','JOHN GRIFFITH RD',NULL,NULL,'459','458','531','530','Right','roadswest.dbf','0.07','40','0.1050','10.6912',NULL,'1',NULL,NULL,'JOHN GRIFFITH','RD',NULL,'01050000000100000001020000001000000000000000F0603341000000C07E5D2F41000000A0E160334100000060635D2F41000000E0C7603341000000A0275D2F41000000C0AF603341000000A0E85C2F41000000E09E603341000000C0B55C2F41000000208D60334100000040835C2F41000000E080603341000000C0645C2F41000000E072603341000000C0485C2F410000004062603341000000A0325C2F41000000C05060334100000000215C2F41000000C039603341000000A00F5C2F410000002022603341000000C0015C2F410000002003603341000000A0F45B2F41000000C0E45F3341000000A0E35B2F4100000020D55F3341000000C0D75B2F4100000020C65F334100000040CA5B2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('381','1007.976257','ROAD3','PL2062','533','723','532','722','JOHN GRIFFITH RD',NULL,NULL,'533','532','723','722','Right','roadswest.dbf','0.19','40','0.2850','10.6102',NULL,'1',NULL,NULL,'JOHN GRIFFITH','RD',NULL,'01050000000100000001020000002600000000000020C65F334100000040CA5B2F4100000020C65F334100000040CA5B2F4100000080B55F3341000000C0B85B2F41000000A0A65F334100000040A05B2F41000000409F5F3341000000607B5B2F41000000409B5F3341000000A0565B2F4100000080955F3341000000402D5B2F41000000C08F5F3341000000A0035B2F41000000808A5F334100000060DE5A2F4100000000855F3341000000A0B95A2F41000000607C5F3341000000608A5A2F4100000000735F3341000000A05B5A2F41000000206A5F334100000040325A2F41000000A0605F334100000060095A2F4100000020575F334100000060E3592F41000000004D5F334100000000BE592F41000000203F5F3341000000608D592F41000000802F5F33410000004060592F41000000601E5F3341000000C03B592F41000000800B5F3341000000C019592F4100000080F65E334100000040F7582F41000000C0E05E3341000000C0D6582F41000000E0C75E334100000060B6582F4100000060AE5E3341000000C095582F41000000A0945E3341000000C06F582F41000000007B5E3341000000404B582F41000000C0635E3341000000A02E582F41000000004C5E3341000000C011582F4100000000335E3341000000A0EF572F41000000801A5E334100000040CC572F4100000040F85D3341000000409B572F4100000060D65D33410000004069572F4100000080B45D3341000000C035572F4100000020935D33410000004001572F41000000C0745D3341000000A0CF562F41000000E0565D3341000000C09C562F41000000A03E5D33410000004071562F41000000C0265D3341000000A045562F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('382','490.524450','ROAD3','PL2062','725','817','724','816','JOHN GRIFFITH RD',NULL,NULL,'725','724','817','816','Right','roadswest.dbf','0.09','40','0.1350','10.6636',NULL,'1',NULL,NULL,'JOHN GRIFFITH','RD',NULL,'010500000001000000010200000017000000000000C0265D3341000000A045562F4100000060165D3341000000402B562F4100000060055D33410000004013562F41000000C0F65C33410000004003562F4100000060E75C3341000000A0F6552F41000000A0D75C334100000000EE552F4100000080C75C334100000000E8552F4100000020B55C3341000000C0E3552F41000000A0A25C3341000000A0E1552F4100000060875C3341000000C0DF552F41000000206C5C3341000000C0DE552F4100000000505C334100000000DF552F4100000000505C334100000000DF552F41000000A0335C3341000000A0DC552F41000000801C5C334100000060D5552F41000000E0055C3341000000C0CA552F41000000E0ED5B334100000040BC552F4100000060D65B3341000000A0A8552F4100000000BE5B3341000000A08A552F4100000020A75B3341000000A068552F41000000408F5B33410000006042552F4100000000785B3341000000401A552F41035AE7356A5B3341F244CB2300552F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('383','3658.335643','ROAD4','PL2062','0','0','0','0',NULL,NULL,NULL,'0','0','0','0','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('384','452.008448','ROAD2','PL2062','15063','15147','15062','15146','NC HWY 194 NORTH',NULL,NULL,'15063','15062','15147','15146','Right','roadswest.dbf','0.09','40','0.1350','10.7622',NULL,'1',NULL,NULL,'NC HWY 194',NULL,'N','01050000000100000001020000000A000000000000E02960334100000000E06E2F41000000C033603341000000A0B16E2F410000000048603341000000405A6E2F41000000A061603341000000A0F16D2F41000000A07B603341000000A0896D2F41000000609760334100000040156D2F41000000A0B3603341000000A0A06C2F41000000A0CE603341000000A0386C2F4100000020E9603341000000C0D06B2F4100000000F0603341000000A0B36B2F41');
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('385','3030.198605','ROAD2','PL2062','13591','14169','13590','14168','NC HWY 194 NORTH',NULL,NULL,'13591','13590','14169','14168','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('386','2115.702679','ROAD3','PL2062','101','487','100','486','JERD BRANCH RD',NULL,NULL,'101','100','487','486','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg_name","l_f_add","l_t_add","r_f_add","r_t_add","name","type","suffix","fraddl","fraddr","toaddl","toaddr","even","sourcethm","miles","speedlimit","minutes","lot_width","direction","namedd","pre_dir","pre_type","street_nam","street_typ","suf_dir","the_geom") VALUES ('387','5233.590207','ROAD3','PL2062','101','1097','100','1096','BEE TREE RD',NULL,NULL,'101','100','1097','1096','Right','roadswest.dbf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
INSERT INTO "roads" (gid,"length","acad_layer","dwg